/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.View;
import java.io.File;

final class GetCommand {
    GetCommand() {
    }

    static boolean doCommand(View view, String parameters) {
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (!st.hasMoreTokens()) {
            return CommandHandler.noParameters(view, "get");
        }
        boolean prompt = false;
        String fileEncoding = null;
        String token = st.nextToken();
        if ("prompt".equalsIgnoreCase(token)) {
            prompt = true;
            String string = token = st.hasMoreTokens() ? st.nextToken() : null;
        }
        if ("encoding".equalsIgnoreCase(token) || "enc".equalsIgnoreCase(token)) {
            if (prompt) {
                return CommandHandler.invalidParameter(view, "prompt encoding", "get");
            }
            if (!st.hasMoreTokens()) {
                return CommandHandler.incomplete(view, "get");
            }
            fileEncoding = st.nextToken();
            if ("\"\"".equalsIgnoreCase(fileEncoding)) {
                fileEncoding = "";
            } else if (!LpexNls.isValidEncoding(fileEncoding)) {
                return CommandHandler.invalidParameter(view, fileEncoding, "get");
            }
            if (!st.hasMoreTokens()) {
                return CommandHandler.incomplete(view, "get");
            }
            token = st.nextToken();
        }
        if (LpexStringTokenizer.isInvalidQuotedString(token)) {
            return CommandHandler.invalidQuotedParameter(view, token, "get");
        }
        String fileName = LpexStringTokenizer.trimQuotes(token);
        if (st.hasMoreTokens()) {
            return CommandHandler.invalidParameter(view, st.nextToken(), "get");
        }
        if (view != null) {
            File fileToGet;
            String documentFileName = view.document().name();
            if (prompt) {
                if (fileName == null || fileName.length() == 0) {
                    fileName = documentFileName;
                }
                fileName = LpexUtilities.fileDialog(view, LpexResources.message("fileDialog.get"), false, fileName);
            } else if (fileName != null && fileName.length() != 0 && !(fileToGet = new File(fileName)).isAbsolute()) {
                try {
                    File currentFile = new File(documentFileName);
                    fileToGet = new File(currentFile.getParent(), fileToGet.getPath());
                    fileName = fileToGet.getCanonicalPath();
                }
                catch (Exception e) {
                    LpexLog.log(e);
                }
            }
            if (fileName != null) {
                view.get(fileName, fileEncoding);
            }
        }
        return true;
    }
}

