/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.BeepParameter;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.PrefixAreaTextParameter;
import com.ibm.lpex.core.View;

final class Element {
    Element _next;
    Element _prev;
    private String _text;
    private Document _document;
    private int _flags;
    boolean _partOfList;
    int _ordinal;
    private int _nonShowOrdinal;
    ElementView _firstElementView;
    private int _sequenceNumber;
    private String _sequenceText;
    private static final int TABS = 1;
    private static final int RECORDED = 2;
    private static final int RECORDED_DELETE = 4;
    private static final int RECORDED_CHANGE = 8;
    private static final int RECORDED_INSERT = 16;
    private static final int RECORDED_NEXT = 32;
    private static final int SHOW = 64;
    private static final int DELETE_PENDING = 128;
    private static final int HAS_BIDI_SET = 1024;
    private static final int HAS_BIDI = 2048;
    private static final int TAG = Integer.MIN_VALUE;
    static final int EOL_DEFAULT = 0;
    static final int EOL_CR = 256;
    static final int EOL_LF = 512;
    static final int EOL_CRLF = 768;

    Element(Document document) {
        this._document = document;
    }

    Element(Document document, String text) {
        this._document = document;
        this._text = text;
        if (this._text != null && this._text.indexOf(9) != -1) {
            this._flags = 1;
        }
    }

    Element(View view) {
        this._document = view.document();
        this._flags = 64;
        this._firstElementView = new ElementView(this, view, true);
    }

    Element next() {
        return this._next;
    }

    Element prev() {
        return this._prev;
    }

    boolean setText(View view, String text) {
        return this.setText(view, text, true, false);
    }

    boolean setText(View view, String text, boolean maintainSequenceText) {
        return this.setText(view, text, maintainSequenceText, false);
    }

    boolean setText(View view, String text, boolean maintainSequenceText, boolean undoElement) {
        boolean tabs;
        this._text = text;
        ElementView elementView = this._firstElementView;
        while (elementView != null) {
            elementView.resetDisplayText();
            elementView.view().setLastVisibleCharCountElementInvalid();
            elementView = elementView._next;
        }
        boolean bl = this._text != null ? this._text.indexOf(9) != -1 : (tabs = false);
        this._flags = tabs ? (this._flags |= 1) : (this._flags &= 0xFFFFFFFE);
        this._flags &= 0xFFFFFBFF;
        if (!this.show() && this._partOfList) {
            int parsePendingFlags = 1;
            if (undoElement) {
                parsePendingFlags |= 0x40;
            }
            this._document.addParsePending(this, parsePendingFlags);
            ElementList elementList = this._document.elementList();
            int textLimit = elementList.textLimit();
            if (textLimit > 0 && this._text != null && view != null) {
                if (elementList.saveLength(this) > textLimit) {
                    view.screen().setMessageKey("textLimit.overflow");
                    BeepParameter.getParameter().setValue(true);
                } else {
                    view.screen().clearMessageKey("textLimit.overflow");
                }
            }
            if (maintainSequenceText && elementList.maintainSequenceNumbers()) {
                return this.setSequenceText(elementList.sequenceDefaultText());
            }
        }
        return false;
    }

    void setWidthsInvalid() {
        ElementView elementView = this._firstElementView;
        while (elementView != null) {
            elementView.setWidthInvalid();
            elementView = elementView._next;
        }
    }

    void setPrefixAreaWidthsInvalid() {
        ElementView elementView = this._firstElementView;
        while (elementView != null) {
            elementView.setPrefixAreaWidthInvalid();
            elementView = elementView._next;
        }
    }

    String text() {
        return this._text == null ? "" : this._text;
    }

    int end() {
        return this._text != null ? this._text.length() + 1 : 1;
    }

    int length() {
        return this._text != null ? this._text.length() : 0;
    }

    void setRecorded(boolean recorded) {
        this._flags = recorded ? (this._flags |= 2) : (this._flags &= 0xFFFFFFFD);
    }

    boolean recorded() {
        return (this._flags & 2) != 0;
    }

    void setRecordedDelete(boolean recordedDelete) {
        this._flags = recordedDelete ? (this._flags |= 4) : (this._flags &= 0xFFFFFFFB);
    }

    boolean recordedDelete() {
        return (this._flags & 4) != 0;
    }

    void setRecordedChange(boolean recordedChange) {
        this._flags = recordedChange ? (this._flags |= 8) : (this._flags &= 0xFFFFFFF7);
    }

    boolean recordedChange() {
        return (this._flags & 8) != 0;
    }

    void setRecordedInsert(boolean recordedInsert) {
        this._flags = recordedInsert ? (this._flags |= 0x10) : (this._flags &= 0xFFFFFFEF);
    }

    boolean recordedInsert() {
        return (this._flags & 0x10) != 0;
    }

    void setRecordedNext(boolean recordedNext) {
        this._flags = recordedNext ? (this._flags |= 0x20) : (this._flags &= 0xFFFFFFDF);
    }

    boolean recordedNext() {
        return (this._flags & 0x20) != 0;
    }

    void clearRecordedInfo() {
        this._flags &= 0xFFFFFFC1;
    }

    boolean show() {
        return (this._flags & 0x40) != 0;
    }

    View showView() {
        ElementView elementView = this._firstElementView;
        while (elementView != null) {
            if (elementView.show()) {
                return elementView.view();
            }
            elementView = elementView._next;
        }
        return null;
    }

    void setDefaults(View view) {
        ElementView elementView = this.elementView(view);
        elementView.setStyle(null);
        elementView.setClasses(1L);
    }

    boolean visible(View view) {
        return this.elementView(view).visible();
    }

    Element nextVisible(View view) {
        Element element = this.next();
        while (element != null && !element.visible(view)) {
            element = element.next();
        }
        return element;
    }

    Element nextVisible(View view, boolean wrap) {
        Element element = this.next();
        while (element != null && !element.visible(view)) {
            element = element.next();
        }
        if (element == null && wrap && !(element = this._document.elementList().first()).visible(view)) {
            element = element.nextVisible(view, false);
        }
        return element;
    }

    Element nextVisibleNonShow(View view) {
        return this.nextVisibleNonShow(view, false);
    }

    Element nextVisibleNonShow(View view, boolean wrap) {
        Element element = this;
        while ((element = element.nextVisible(view)) != null && element.show()) {
        }
        if (element == null && wrap && (!(element = this._document.elementList().first()).visible(view) || element.show())) {
            element = element.nextVisibleNonShow(view, false);
        }
        return element;
    }

    Element nextNonShow() {
        Element element = this;
        while ((element = element.next()) != null && element.show()) {
        }
        return element;
    }

    Element prevVisible(View view) {
        return this.prevVisible(view, false);
    }

    Element prevVisible(View view, boolean wrap) {
        Element element = this.prev();
        while (element != null && !element.visible(view)) {
            element = element.prev();
        }
        if (element == null && wrap && !(element = this._document.elementList().last()).visible(view)) {
            element = element.prevVisible(view, false);
        }
        return element;
    }

    Element prevVisibleNonShow(View view) {
        return this.prevVisibleNonShow(view, false);
    }

    Element prevVisibleNonShow(View view, boolean wrap) {
        Element element = this;
        while ((element = element.prevVisible(view)) != null && element.show()) {
        }
        if (element == null && wrap && (!(element = this._document.elementList().last()).visible(view) || element.show())) {
            element = element.prevVisibleNonShow(view, false);
        }
        return element;
    }

    Element prevNonShow() {
        Element element = this;
        while ((element = element.prev()) != null && element.show()) {
        }
        return element;
    }

    ElementView elementView(View view) {
        ElementView elementView = this._firstElementView;
        while (elementView != null) {
            if (elementView.view() == view) {
                return elementView;
            }
            elementView = elementView._next;
        }
        elementView = new ElementView(this, view);
        elementView._next = this._firstElementView;
        this._firstElementView = elementView;
        return elementView;
    }

    void disposeView(View view) {
        ElementView prevElementView = null;
        ElementView elementView = this._firstElementView;
        while (elementView != null && elementView.view() != view) {
            prevElementView = elementView;
            elementView = elementView._next;
        }
        if (elementView != null) {
            if (prevElementView == null) {
                this._firstElementView = elementView._next;
            } else {
                prevElementView._next = elementView._next;
            }
        }
    }

    boolean tabs() {
        return (this._flags & 1) != 0;
    }

    void setTag() {
        this._flags |= Integer.MIN_VALUE;
    }

    void clearTag() {
        this._flags &= Integer.MAX_VALUE;
    }

    boolean tagged() {
        return (this._flags & Integer.MIN_VALUE) != 0;
    }

    void setEOL(int eol) {
        this._flags |= eol;
    }

    int nonShowOrdinal() {
        return this._nonShowOrdinal;
    }

    void setNonShowOrdinal(int nonShowOrdinal) {
        if (nonShowOrdinal != this._nonShowOrdinal) {
            ElementView elementView = this._firstElementView;
            while (elementView != null) {
                elementView.setPrefixAreaWidthInvalid();
                elementView = elementView._next;
            }
            this._nonShowOrdinal = nonShowOrdinal;
        }
    }

    int sequenceNumber() {
        return this._sequenceNumber;
    }

    boolean setSequenceNumber(int sequenceNumber) {
        if (sequenceNumber != this._sequenceNumber) {
            this._sequenceNumber = sequenceNumber;
            if (this._document.elementList().sequenceNumbersWidth() > 0) {
                ElementView elementView = this._firstElementView;
                while (elementView != null) {
                    View view = elementView.view();
                    if (PrefixAreaTextParameter.getParameter().currentValue(view) == 2) {
                        elementView.setPrefixAreaWidthInvalid();
                    }
                    elementView = elementView._next;
                }
                return true;
            }
        }
        return false;
    }

    String sequenceText() {
        return this._sequenceText == null ? "" : this._sequenceText;
    }

    boolean setSequenceText(String sequenceText) {
        StringBuilder sequenceTextSb = new StringBuilder();
        int sequenceNumbersTextWidth = this._document.elementList().sequenceNumbersTextWidth();
        if (sequenceNumbersTextWidth > 0) {
            if (sequenceText == null) {
                sequenceTextSb.append(" ");
            } else {
                sequenceTextSb.append(sequenceText);
            }
            if (sequenceTextSb.length() > sequenceNumbersTextWidth) {
                sequenceTextSb.delete(sequenceNumbersTextWidth + 1, sequenceTextSb.length());
            }
            while (sequenceTextSb.length() < sequenceNumbersTextWidth) {
                sequenceTextSb.append(' ');
            }
            if (!sequenceTextSb.toString().equals(this._sequenceText)) {
                this._sequenceText = sequenceTextSb.toString();
                ElementView elementView = this._firstElementView;
                while (elementView != null) {
                    View view = elementView.view();
                    if (PrefixAreaTextParameter.getParameter().currentValue(view) == 2) {
                        elementView.setPrefixAreaWidthInvalid();
                    }
                    elementView = elementView._next;
                }
                return true;
            }
        }
        return false;
    }

    void quickSetSequenceText(String sequenceText) {
        this._sequenceText = sequenceText;
    }

    void disposeSequenceText() {
        this._sequenceText = null;
    }

    String fullText() {
        return this._document.elementList().fullText(this);
    }

    void setDeletePending(boolean deletePending) {
        this._flags = deletePending ? (this._flags |= 0x80) : (this._flags &= 0xFFFFFF7F);
    }

    boolean deletePending() {
        return (this._flags & 0x80) != 0;
    }

    boolean hasBidi() {
        if ((this._flags & 0x400) == 0) {
            this._flags = LpexNls.hasBidi(this._text) ? (this._flags |= 0x800) : (this._flags &= 0xFFFFF7FF);
            this._flags |= 0x400;
        }
        return (this._flags & 0x800) != 0;
    }

    public Document getDocument() {
        return this._document;
    }
}

