/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.ActionHandler;
import com.ibm.lpex.core.ActionUtilities;
import com.ibm.lpex.core.CommandLine;
import com.ibm.lpex.core.DisplayTextLayout;
import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.View;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class EditLine
extends Composite {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HEX = "0123456789abcdefABCDEF";
    private static final String CONTROL_STYLE = "100 100 200 230 230 255 outline";
    private static final String CONTROL_STYLE_RO = "100 100 200 215 215 240 outline";
    private static final String[] noShowEncodings = new String[]{"UTF-16", "UnicodeBig", "UnicodeBigUnmarked"};
    protected CommandLine _commandLine;
    protected Label[] _label;
    protected EditField[] _editField;
    protected boolean[] _showEditField;
    private boolean _visible;
    private int _currentElement;
    private String _highlightCurrentLine;
    private Map<Integer, Integer> _hexSubs = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> _hexSubsReverse = new HashMap<Integer, Integer>();
    private static final String editLineKeyActions = "a-backSpace.secondary undo a-i blockLowerCase a-k blockUpperCase a-l selectAll a-u blockUnmark backSpace backSpace c-a selectAll c-backSpace deleteLine c-c copy c-delete truncate c-end end c-home top c-insert.secondary copy c-j findLastChange c-n findNext c-pageDown pageRight c-pageUp pageLeft c-s-z.secondary redo c-u findUp c-v paste c-x cut c-y redo c-z undo decimal enterDecimalSeparator delete delete down down end end enter enter escape esc f1 help home home insert toggleInsert left left numpadEnter enter right right s-delete.secondary cut s-enter nullAction s-insert.secondary paste s-tab backTab tab tab up up ";
    private static final String editLineMouseActions = "1-dragged cursorToMouse 1-pressed.1 cursorToMouse a-1-pressed.1 cursorToMouse a-c-1-pressed.1 blockUnmark a-c-pressed.1 blockUnmark a-c-s-1-pressed.1 blockUnmark a-c-s-pressed.1 blockUnmark a-pressed.1 cursorToMouse c-1-pressed.1 cursorToMouse c-1-pressed.2 selectAll c-pressed.1 cursorToMouse c-pressed.2 selectAll dragged cursorToMouse " + ActionHandler.LPEX_POPUP_DEFINITION + " popupAtMouse pressed.1 cursorToMouse ";

    EditLine(CommandLine commandLine) {
        super((Composite)commandLine, 0);
        this._commandLine = commandLine;
        this.genHexMap(this._commandLine._lpexWindow.getLpexView()._view.getHexSubstitutes());
        this._label = new Label[4];
        this._editField = new EditField[4];
        this._showEditField = new boolean[]{true, true, true, true};
        this._label[0] = new Label((Composite)this, 0);
        this._label[0].setText(LpexResources.message("text"));
        this._commandLine.listenToTraverseMnemonic((Control)this._label[0]);
        this._editField[0] = new EditField(0);
        this._editField[0].setEditId("editLine_text");
        this._label[1] = new Label((Composite)this, 0);
        this._label[1].setText(LpexResources.message("unicode"));
        this._commandLine.listenToTraverseMnemonic((Control)this._label[1]);
        this._editField[1] = new EditFieldUnicodeHex(1);
        this._editField[1].setEditId("editLine_unicode");
        this._label[2] = new Label((Composite)this, 0);
        this._commandLine.listenToTraverseMnemonic((Control)this._label[2]);
        this._editField[2] = new EditFieldAsciiHex(2);
        this._label[3] = new Label((Composite)this, 0);
        this._commandLine.listenToTraverseMnemonic((Control)this._label[3]);
        this._editField[3] = new EditFieldAsciiHex(3);
        this._editField[3].setEditId("editLine_source");
        this._editField[0]._lpexView.setBlockInstance(this._editField[0]._lpexView);
        this._editField[1]._lpexView.setBlockInstance(this._editField[0]._lpexView);
        this._editField[2]._lpexView.setBlockInstance(this._editField[0]._lpexView);
        this._editField[3]._lpexView.setBlockInstance(this._editField[0]._lpexView);
        this.setLayout(new EditLineLayout());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                int i = 0;
                while (i <= 3) {
                    EditLine.this._editField[i].dispose();
                    ++i;
                }
            }
        });
    }

    private void genHexMap(String hexSubstitutes) {
        this._hexSubs.clear();
        this._hexSubsReverse.clear();
        if (hexSubstitutes != null) {
            StringTokenizer st = new StringTokenizer(hexSubstitutes);
            while (st.hasMoreElements()) {
                String hexSource = st.nextToken();
                String uniClient = st.nextToken();
                int source = Integer.parseInt(hexSource, 16);
                int unicode = Integer.parseInt(uniClient, 16);
                this._hexSubs.put(unicode, source);
                this._hexSubsReverse.put(source, unicode);
            }
        }
    }

    void setEditLine() {
        int i;
        boolean showSourceEncoding;
        LpexView lpexView = this._commandLine._lpexWindow.getLpexView();
        String nativeEncoding = LpexNls.getNativeEncoding();
        String fileEncoding = lpexView._view.document().fileEncoding();
        String sourceEncoding = lpexView.nls().getSourceEncoding();
        boolean showFileEncoding = true;
        if (fileEncoding == null) {
            showSourceEncoding = !sourceEncoding.equals(nativeEncoding);
            this._showEditField[2] = true;
            this._label[2].setVisible(true);
            this._label[2].setText(LpexResources.message("nativeEncoding") + " " + nativeEncoding);
            this._editField[2].setVisible(true);
            this._editField[2].setEncoding(nativeEncoding);
            this._editField[2].setEditId("editLine_native");
        } else {
            showSourceEncoding = !sourceEncoding.equals(fileEncoding);
            i = 0;
            while (i < noShowEncodings.length) {
                if (fileEncoding.equals(noShowEncodings[i])) {
                    showFileEncoding = false;
                    break;
                }
                ++i;
            }
            if (showFileEncoding) {
                this._showEditField[2] = true;
                this._label[2].setVisible(true);
                this._label[2].setText(LpexResources.message("fileEncoding") + " " + fileEncoding);
                this._editField[2].setVisible(true);
                this._editField[2].setEncoding(fileEncoding);
                this._editField[2].setEditId("editLine_file");
            } else {
                this._showEditField[2] = false;
                this._label[2].setVisible(false);
                this._editField[2].setVisible(false);
            }
        }
        if (showSourceEncoding && lpexView.nls().isShapedLigatures()) {
            showSourceEncoding = false;
        }
        if (showSourceEncoding) {
            i = 0;
            while (i < noShowEncodings.length) {
                if (sourceEncoding.equals(noShowEncodings[i])) {
                    showSourceEncoding = false;
                    break;
                }
                ++i;
            }
        }
        if (showSourceEncoding) {
            this._showEditField[3] = true;
            this._label[3].setVisible(true);
            this._label[3].setText(LpexResources.message("sourceEncoding") + " " + sourceEncoding);
            this._editField[3].setVisible(true);
            if (sourceEncoding.equals("UnicodeLittle")) {
                sourceEncoding = "UnicodeLittleUnmarked";
            }
            this._editField[3].setEncoding(sourceEncoding);
        } else {
            this._showEditField[3] = false;
            this._label[3].setVisible(false);
            this._editField[3].setVisible(false);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        LpexView lpexView = this._commandLine._lpexWindow.getLpexView();
        if (visible) {
            if (!this._visible) {
                this._highlightCurrentLine = lpexView.query("highlightCurrentLine");
                lpexView.doCommand("set highlightCurrentLine on");
                this.initializeFields();
            }
        } else if (this._visible && lpexView != null) {
            lpexView.doCommand("set highlightCurrentLine " + this._highlightCurrentLine);
        }
        this._visible = visible;
    }

    private void initializeFields() {
        Composite tw;
        LpexView lpexView = this._commandLine._lpexWindow.getLpexView();
        this._currentElement = lpexView.currentElement();
        this.genHexMap(lpexView._view.getHexSubstitutes());
        this._editField[0].cmd("set tabs " + lpexView.query("current.tabs"));
        String currentFontData = lpexView.query("current.font.fontData");
        boolean setFont = currentFontData != null && !currentFontData.equals(this._editField[0]._lpexView.query("current.font.fontData"));
        boolean editable = !lpexView.show(this._currentElement) && !lpexView._view.readonly() && !lpexView._view.markList().protect(lpexView._view.documentPosition().element());
        String text = lpexView.elementText(this._currentElement);
        int i = 0;
        while (i < this._editField.length) {
            if (this._showEditField[i]) {
                this._editField[i].setEditText(text);
                this._editField[i].cmd("set scroll 0");
                this._editField[i].cmd("undo clear");
                this._editField[i].setEditable(editable);
                if (setFont) {
                    this._editField[i].cmd("set font.fontData " + currentFontData);
                }
            }
            ++i;
        }
        this._editField[0].cmd("block clear");
        this._editField[0].setPopup();
        this._editField[0].setEditPosition(lpexView.currentPosition());
        this._editField[0]._position = 0;
        LpexWindow lw = this._editField[0]._lpexWindow;
        Composite composite = tw = lw == null ? null : lw.textWindow();
        if (tw != null && !tw.isDisposed()) {
            tw.setFocus();
        }
    }

    protected void handleOk() {
        LpexView lpexView = this._commandLine._lpexWindow.getLpexView();
        if (!lpexView.elementText(this._currentElement).equals(this._editField[0].getText())) {
            lpexView.jump(this._currentElement, 1);
            lpexView.doDefaultCommand("undo check");
            lpexView.setElementText(this._currentElement, this._editField[0].getText());
            lpexView.jump(this._currentElement, this._editField[0]._lpexView.currentPosition());
            lpexView.doDefaultCommand("parse");
        } else {
            lpexView.jump(this._currentElement, this._editField[0]._lpexView.currentPosition());
        }
        this._commandLine._lpexWindow.textWindowRequestFocus();
    }

    protected String hexUnicode(String s) {
        StringBuilder u = new StringBuilder(s.length() * 4);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            u.append(hexDigit[c >> 12 & 0xF]).append(hexDigit[c >> 8 & 0xF]).append(hexDigit[c >> 4 & 0xF]).append(hexDigit[c & 0xF]);
            ++i;
        }
        return u.toString();
    }

    protected String stringFromHexUnicode(String u) {
        int len = u.length();
        if (len % 4 != 0) {
            return null;
        }
        StringBuilder s = new StringBuilder(len / 4);
        int i = 0;
        while (i + 4 <= len) {
            s.append((char)Integer.parseInt(u.substring(i, i + 4), 16));
            i += 4;
        }
        return s.toString();
    }

    protected String hexAscii(String s, String encoding, boolean mapHex) {
        try {
            if (mapHex && this._hexSubs.size() > 0) {
                StringBuilder a = new StringBuilder();
                char[] aforeChars = new char[]{' ', ' '};
                int i = 0;
                while (i < s.length()) {
                    char c = s.charAt(i);
                    if (this._hexSubs.containsKey(c)) {
                        byte b = (byte)this._hexSubs.get(c).intValue();
                        a.append(hexDigit[b >> 4 & 0xF]);
                        a.append(hexDigit[b & 0xF]);
                    } else {
                        byte[] convout = ("" + c).getBytes(encoding);
                        int j = 0;
                        while (j < convout.length) {
                            byte b = convout[j];
                            if (hexDigit[b >> 4 & 0xF] == '0' && hexDigit[b & 0xF] == 'e' && aforeChars[0] == '0' && aforeChars[1] == 'f') {
                                a.delete(a.length() - 2, a.length());
                                a.getChars(a.length() - 2, a.length(), aforeChars, 0);
                            } else {
                                a.append(hexDigit[b >> 4 & 0xF]);
                                a.append(hexDigit[b & 0xF]);
                                aforeChars[0] = hexDigit[b >> 4 & 0xF];
                                aforeChars[1] = hexDigit[b & 0xF];
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                return a.toString();
            }
            byte[] convout = s.getBytes(encoding);
            StringBuilder a = new StringBuilder(convout.length * 2);
            int i = 0;
            while (i < convout.length) {
                byte b = convout[i];
                a.append(hexDigit[b >> 4 & 0xF]);
                a.append(hexDigit[b & 0xF]);
                ++i;
            }
            return a.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    protected String setSosiStyle(String hex) {
        int len = hex.length();
        StringBuilder style = new StringBuilder(len);
        boolean allDefault = true;
        boolean dbcs = false;
        int i = 0;
        while (i < len - 1) {
            if (hex.charAt(i) == '0' && hex.charAt(i + 1) == 'e') {
                dbcs = true;
                style.append('s').append('s');
                allDefault = false;
            } else if (hex.charAt(i) == '0' && hex.charAt(i + 1) == 'f') {
                dbcs = false;
                style.append('s').append('s');
                allDefault = false;
            } else {
                style.append('!').append('!');
                if (dbcs && (i += 2) < len - 1) {
                    style.append('!').append('!');
                }
            }
            i += 2;
        }
        if (allDefault) {
            return "";
        }
        if (style.length() < len) {
            style.append('!');
        }
        return style.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected String setUnicodeStyle(String hex) {
        len = hex.length();
        style = new StringBuilder(len);
        allDefault = true;
        i = 0;
        while (i < len - 3) {
            if (hex.charAt(i) == '2' && hex.charAt(i + 1) == '0' && hex.charAt(i + 2) == '0' && (hex.charAt(i + 3) == 'e' || hex.charAt(i + 3) == 'f')) {
                style.append("ssss");
                allDefault = false;
            } else {
                style.append("!!!!");
            }
            i += 4;
        }
        if (!allDefault) ** GOTO lbl19
        return "";
lbl-1000:
        // 1 sources

        {
            style.append('!');
lbl19:
            // 2 sources

            ** while (style.length() < len)
        }
lbl20:
        // 1 sources

        return style.toString();
    }

    protected String stringFromHexAscii(String a, String encoding, int charSize, boolean isSiso, boolean checkHex) {
        String s;
        StringBuffer text;
        byte[] bytebuff;
        block15: {
            int i;
            int len = a.length();
            if (len % charSize != 0) {
                return null;
            }
            if (charSize < 4 && isSiso) {
                boolean dbcs = false;
                i = 0;
                while (i < len - 1) {
                    if (a.charAt(i) == '0' && a.charAt(i + 1) == 'e') {
                        dbcs = true;
                    } else if (a.charAt(i) == '0' && a.charAt(i + 1) == 'f') {
                        dbcs = false;
                    } else if (dbcs) {
                        i += 2;
                    }
                    i += 2;
                }
                if (dbcs) {
                    return null;
                }
            }
            bytebuff = new byte[len / 2];
            i = 0;
            while (i + 2 <= len) {
                int bb = Integer.parseInt(a.substring(i, i + 2), 16);
                bytebuff[i / 2] = (byte)bb;
                i += 2;
            }
            text = new StringBuffer();
            s = new String(bytebuff, encoding);
            if (s.length() != 0 || len == 0) break block15;
            return null;
        }
        try {
            text.append(s);
            int i = 0;
            while (i < bytebuff.length) {
                int sourceCharValue = bytebuff[i] & 0xFF;
                if (checkHex && this._hexSubsReverse.size() > 0 && this._hexSubsReverse.containsKey(sourceCharValue)) {
                    text.setCharAt(i, (char)this._hexSubsReverse.get(sourceCharValue).intValue());
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text.toString();
    }

    protected String getPasteTextForText(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text.length());
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') break;
            if (c == '\\' && i <= text.length() - 6 && text.charAt(i + 1) == 'u') {
                try {
                    c = (char)Integer.parseInt(text.substring(i + 2, i + 6), 16);
                    i += 5;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    protected String getPasteTextForUnicode(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text.length());
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') break;
            if (c == '\\' && i <= text.length() - 6 && text.charAt(i + 1) == 'u') {
                c = text.charAt(i + 2);
                i += 2;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    String getLabelText(int labelIndex) {
        int indexOfMnemonic;
        Object text = this._label[labelIndex].getText();
        if (text != null && (indexOfMnemonic = ((String)text).indexOf(38)) >= 0 && indexOfMnemonic + 1 < ((String)text).length()) {
            text = ((String)text).substring(0, indexOfMnemonic) + ((String)text).substring(indexOfMnemonic + 1);
        }
        return text;
    }

    String getLabelShortcut(int labelIndex) {
        int indexOfMnemonic;
        String text = this._label[labelIndex].getText();
        if (text != null && (indexOfMnemonic = text.indexOf(38)) >= 0 && indexOfMnemonic + 1 < text.length()) {
            return LpexResources.message("key.alt") + "+" + Character.toLowerCase(text.charAt(indexOfMnemonic + 1));
        }
        return null;
    }

    protected boolean textChanged(int index) {
        String s = this._editField[index].getEditText();
        if (s == null) {
            return false;
        }
        int i = 0;
        while (i < this._editField.length) {
            if (this._showEditField[i] && (i != index || this._editField[i]._isSosiEncoding)) {
                if (i == index) {
                    this._editField[i].cmd("set recording off");
                }
                this._editField[i].setEditText(s);
                if (i == index) {
                    this._editField[i].cmd("set recording on");
                }
            }
            ++i;
        }
        return true;
    }

    protected void positionChanged(int fieldIndex) {
        int newFieldPosition = this._editField[fieldIndex]._position;
        int firstSelected = this._editField[fieldIndex].getEditIndex(newFieldPosition);
        firstSelected = DisplayTextLayout.getClusterOffset(this._editField[0].getText(), firstSelected - 1) + 1;
        int i = 0;
        while (i < this._editField.length) {
            if (this._showEditField[i] && i != fieldIndex) {
                this._editField[i].setEditPosition(firstSelected);
            }
            ++i;
        }
    }

    protected void highlightChanged(int fieldIndex) {
        int fieldPosition = this._editField[fieldIndex]._position;
        int highlighted = this._editField[fieldIndex].getEditIndex(fieldPosition);
        highlighted = DisplayTextLayout.getClusterOffset(this._editField[0].getText(), highlighted - 1) + 1;
        int postHighlighted = DisplayTextLayout.getClusterOffsetNext(this._editField[0].getText(), highlighted - 1) + 1;
        int i = 0;
        while (i < this._editField.length) {
            if (this._showEditField[i]) {
                this._editField[i].setEditHighlight(highlighted, postHighlighted);
                this._editField[i]._lpexView._view.screen().show();
            }
            ++i;
        }
    }

    class EditField {
        int _index;
        LpexView _lpexView;
        LpexWindow _lpexWindow;
        String _encoding;
        boolean _isSosiEncoding;
        int _position;
        int _startHighlight;
        int _postHighlight;
        String _text;
        boolean _editable;

        EditField(int index) {
            this._index = index;
            this._lpexView = new LpexView(false);
            this._lpexWindow = new LpexWindow(EditLine.this, 2048);
            this._lpexWindow.setForceNoScrollBars(true);
            this._lpexView.setWindow(this._lpexWindow);
            this._lpexWindow.textWindow().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    e.widget = EditField.this._lpexWindow;
                    ((EditField)EditField.this).EditLine.this._commandLine.focusGained(e);
                }

                public void focusLost(FocusEvent e) {
                    e.widget = EditField.this._lpexWindow;
                    ((EditField)EditField.this).EditLine.this._commandLine.focusLost(e);
                }
            });
            this._lpexWindow.textWindow().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = EditLine.this.getLabelText(EditField.this._index);
                }

                public void getKeyboardShortcut(AccessibleEvent e) {
                    e.result = EditLine.this.getLabelShortcut(EditField.this._index);
                }
            });
            this._lpexView.addLpexViewListener(new LpexViewAdapter(){

                @Override
                public void showing(LpexView view) {
                    EditField.this.handleShowing(view);
                }

                @Override
                public void updateProfile(LpexView view) {
                    EditField.this.handleUpdateProfile(view);
                }
            });
            this.cmd("set updateProfile.baseProfile none");
            this.cmd("set updateProfile.palette white");
            this.cmd("set updateProfile.userActions");
            this.cmd("set updateProfile.userCommands");
            this.cmd("set updateProfile.userKeyActions a-backSpace.secondary undo a-i blockLowerCase a-k blockUpperCase a-l selectAll a-u blockUnmark backSpace backSpace c-a selectAll c-backSpace deleteLine c-c copy c-delete truncate c-end end c-home top c-insert.secondary copy c-j findLastChange c-n findNext c-pageDown pageRight c-pageUp pageLeft c-s-z.secondary redo c-u findUp c-v paste c-x cut c-y redo c-z undo decimal enterDecimalSeparator delete delete down down end end enter enter escape esc f1 help home home insert toggleInsert left left numpadEnter enter right right s-delete.secondary cut s-enter nullAction s-insert.secondary paste s-tab backTab tab tab up up ");
            this.cmd("set updateProfile.userMouseActions " + editLineMouseActions);
            this.cmd("set updateProfile.userProfile");
            this.cmd("updateProfile");
            this.cmd("set statusLine off");
            this.cmd("set formatLine off");
            this.cmd("set messageLine off");
            this.cmd("set prefixArea off");
            this.cmd("set highlightCurrentLine off");
        }

        final void handleShowing(LpexView lpexView) {
            if (this._lpexWindow.textWindow().isFocusControl()) {
                int newPosition;
                boolean positionChanged;
                String newText = lpexView.elementText(1);
                boolean textChanged = !newText.equals(this._text);
                boolean validTextChange = false;
                if (this._index != 0 && textChanged) {
                    int i = 0;
                    while (i < newText.length()) {
                        if (EditLine.HEX.indexOf(newText.charAt(i)) < 0) {
                            lpexView.doDefaultCommand("undo discard");
                            this.setEditStyle();
                            LpexUtilities.beep();
                            return;
                        }
                        ++i;
                    }
                }
                if (textChanged) {
                    this._text = newText;
                    validTextChange = EditLine.this.textChanged(this._index);
                    lpexView.doDefaultCommand("undo check");
                }
                boolean bl = positionChanged = (newPosition = lpexView.queryInt("position")) != this._position;
                if (positionChanged) {
                    this._position = newPosition;
                    EditLine.this.positionChanged(this._index);
                }
                if (validTextChange || positionChanged && !textChanged) {
                    EditLine.this.highlightChanged(this._index);
                }
            }
        }

        final void handleUpdateProfile(LpexView lpexView) {
            lpexView.doDefaultCommand("set commandLine off");
            this.setEditable(this._editable);
            this.setEditStyle();
            lpexView.defineAction("enter", new LpexAction(){

                @Override
                public void doAction(LpexView view) {
                    EditLine.this.handleOk();
                }

                @Override
                public boolean available(LpexView view) {
                    return true;
                }
            });
            lpexView.defineAction("esc", new LpexAction(){

                @Override
                public void doAction(LpexView view) {
                    ((EditField)EditField.this).EditLine.this._commandLine._lpexWindow.textWindowRequestFocus();
                }

                @Override
                public boolean available(LpexView view) {
                    return true;
                }
            });
            lpexView.defineAction("right", new LpexAction(){

                @Override
                public void doAction(LpexView view) {
                    view.doDefaultAction(175);
                    int lineLen = view.queryInt("length");
                    if (view.queryInt("position") > lineLen + 1) {
                        view.doDefaultCommand("set position " + (lineLen + 1));
                    }
                }

                @Override
                public boolean available(LpexView view) {
                    return true;
                }
            });
            lpexView.defineAction("down", new LpexAction(){

                @Override
                public void doAction(LpexView view) {
                    int newIndex = EditField.this._index + 1;
                    while (newIndex < ((EditField)EditField.this).EditLine.this._editField.length && !((EditField)EditField.this).EditLine.this._showEditField[newIndex]) {
                        ++newIndex;
                    }
                    if (newIndex >= ((EditField)EditField.this).EditLine.this._editField.length) {
                        newIndex = 0;
                    }
                    ((EditField)EditField.this).EditLine.this._editField[newIndex]._lpexWindow.textWindow().setFocus();
                }

                @Override
                public boolean available(LpexView view) {
                    return true;
                }
            });
            lpexView.defineAction("up", new LpexAction(){

                @Override
                public void doAction(LpexView view) {
                    int newIndex = EditField.this._index == 0 ? ((EditField)EditField.this).EditLine.this._editField.length - 1 : EditField.this._index - 1;
                    while (newIndex > 0 && !((EditField)EditField.this).EditLine.this._showEditField[newIndex]) {
                        --newIndex;
                    }
                    ((EditField)EditField.this).EditLine.this._editField[newIndex]._lpexWindow.textWindow().setFocus();
                }

                @Override
                public boolean available(LpexView view) {
                    return true;
                }
            });
            lpexView.defineAction("delete", new LpexAction(){

                @Override
                public void doAction(LpexView view) {
                    view.doDefaultCommand(new LpexDocumentLocation(1, EditField.this._startHighlight), "deleteText " + (EditField.this._postHighlight - EditField.this._startHighlight));
                }

                @Override
                public boolean available(LpexView view) {
                    return !view.queryOn("readonly");
                }
            });
            lpexView.defineAction("paste", new LpexAction(){

                @Override
                public void doAction(LpexView view) {
                    if (EditField.this._index == 0) {
                        String pasteText = EditLine.this.getPasteTextForText(LpexUtilities.getClipboardContents());
                        ActionUtilities.doPasteAction(view._view, pasteText);
                    } else if (EditField.this._index == 1) {
                        String pasteText = EditLine.this.getPasteTextForUnicode(LpexUtilities.getClipboardContents());
                        ActionUtilities.doPasteAction(view._view, pasteText);
                    } else {
                        view.doDefaultAction(153);
                    }
                }

                @Override
                public boolean available(LpexView view) {
                    return view.defaultActionAvailable(153);
                }
            });
            lpexView.defineAction("selectAll", new LpexAction(){

                @Override
                public void doAction(LpexView view) {
                    View v = view._view;
                    v.block().clear();
                    v.documentPosition().top();
                    v.block().set(1, v);
                    v.documentPosition().bottom();
                    v.block().set(1, v);
                }

                @Override
                public boolean available(LpexView view) {
                    return view.defaultActionAvailable(37);
                }
            });
            lpexView.defineAction("tab", new LpexAction(){

                @Override
                public void doAction(LpexView view) {
                    if (EditField.this._index == 0 && view.queryInt("position") <= view.queryInt("length")) {
                        view.doDefaultAction(129);
                        int lastPosition = view.queryInt("length") + 1;
                        if (view.queryInt("position") > lastPosition) {
                            view.doDefaultCommand("set position " + lastPosition);
                        }
                    } else {
                        view.doAction(view.actionId("down"));
                    }
                }

                @Override
                public boolean available(LpexView view) {
                    return true;
                }
            });
            lpexView.defineAction("backTab", new LpexAction(){

                @Override
                public void doAction(LpexView view) {
                    if (EditField.this._index == 0 && view.queryInt("position") > 1) {
                        view.doDefaultAction(166);
                    } else {
                        view.doAction(view.actionId("up"));
                    }
                }

                @Override
                public boolean available(LpexView view) {
                    return true;
                }
            });
            this.setPopup();
        }

        void setPopup() {
            if (EditLine.this._commandLine._lpexWindow.getLpexView().nls().isIgnoringBidiMarks()) {
                this.cmd("set popup popup.insertLrm insertLtrMark popup.insertRlm insertRtlMark");
            } else {
                this.cmd("set popup");
            }
        }

        void setVisible(boolean visible) {
            this._lpexWindow.setVisible(visible);
        }

        void setText(String text) {
            this._text = text;
            boolean readonly = this._lpexView.queryOn("readonly");
            if (readonly) {
                this.cmd("set readonly off");
            }
            int position = this._lpexView.queryInt("position");
            int scroll = this._lpexView.queryInt("scroll");
            this.cmd("set text " + text);
            int elements = this._lpexView.queryInt("elements");
            if (elements > 1) {
                LpexDocumentLocation loc = new LpexDocumentLocation(2, 1);
                int i = elements - 1;
                while (i > 0) {
                    this._lpexView.doDefaultCommand(loc, "delete");
                    --i;
                }
                this._text = this._lpexView.elementText(1);
            }
            this.cmd("set position " + Math.min(position, this._lpexView.queryInt("length") + 1));
            this.cmd("set scroll " + scroll);
            if (readonly) {
                this.cmd("set readonly on");
            }
        }

        String getText() {
            return this._lpexView.elementText(1);
        }

        void setPosition(int position) {
            if (this._position != (position = Math.min(position, this._lpexView.queryInt("length") + 1))) {
                this._position = position;
                this.cmd("set position " + this._position);
            }
        }

        void setEditable(boolean editable) {
            this._editable = editable;
            if (this._lpexView.queryOn("readonly") == editable) {
                this.cmd("set readonly " + (editable ? "off" : "on"));
            }
            String style = editable ? LpexView.globalQuery("current.updateProfile.paletteAttributes.default.white") : LpexView.globalQuery("current.updateProfile.paletteAttributes.default.gray");
            this.cmd("set styleAttributes.default " + style);
            this.cmd("set styleAttributes.s " + (editable ? EditLine.CONTROL_STYLE : EditLine.CONTROL_STYLE_RO));
        }

        final void cmd(String lpexCommand) {
            this._lpexView.doDefaultCommand(lpexCommand);
        }

        void dispose() {
            if (this._lpexView != null) {
                this._lpexView.dispose();
                this._lpexView = null;
            }
        }

        void setEditStyle() {
            String text = this._lpexView.elementText(1);
            int len = text.length();
            View view = this._lpexView._view;
            int emphasisLength = this._postHighlight - this._startHighlight;
            if (emphasisLength < 0 || this._postHighlight - 1 > len) {
                emphasisLength = 0;
            }
            view.documentPosition().setEmphasisPosition(this._startHighlight);
            view.documentPosition().setEmphasisLength(emphasisLength);
            this.setElementStyle();
            int scroll = view.screen().scroll();
            int startHilite = this._startHighlight <= len ? this._startHighlight : len;
            LpexDocumentLocation loc = new LpexDocumentLocation(1, startHilite);
            int startPixelPosition = this._lpexView.queryInt("pixelPosition", loc);
            if (startPixelPosition - scroll < 0) {
                view.screen().setScroll(startPixelPosition);
            } else {
                loc.position = 1 + (this._postHighlight - 1 < len ? this._postHighlight - 1 : len);
                int endPixelPosition = this._lpexView.queryInt("pixelPosition", loc);
                int width = view.screen().textAreaWidth();
                if (width > 0 && endPixelPosition - scroll > width) {
                    view.screen().setScroll(endPixelPosition - width);
                }
            }
        }

        void setElementStyle() {
            String newStyle;
            if (this._index == 1) {
                String newStyle2 = EditLine.this.setUnicodeStyle(this._lpexView.elementText(1));
                if (!newStyle2.equals(this._lpexView.elementStyle(1))) {
                    this._lpexView.setElementStyle(1, newStyle2);
                }
            } else if (this._isSosiEncoding && !(newStyle = EditLine.this.setSosiStyle(this._lpexView.elementText(1))).equals(this._lpexView.elementStyle(1))) {
                this._lpexView.setElementStyle(1, newStyle);
            }
        }

        void setEncoding(String characterEncoding) {
        }

        void setEditId(String id) {
            this._lpexWindow.setData("ID", id);
            LpexUtilities.setHelp((Control)this._lpexWindow.textWindow(), "com.ibm.lpex." + id);
        }

        void setEditText(String text) {
            this.setText(text);
        }

        String getEditText() {
            return this.getText();
        }

        int getEditIndex(int position) {
            return position;
        }

        void setEditHighlight(int start, int after) {
            this._startHighlight = start;
            this._postHighlight = after;
            this.setEditStyle();
        }

        void setEditPosition(int position) {
            this.setPosition(position);
        }
    }

    final class EditFieldAsciiHex
    extends EditField {
        private String _textString;
        private boolean _isUnicodeEncoding;

        EditFieldAsciiHex(int index) {
            super(index);
        }

        @Override
        void setPopup() {
            this.cmd("set popup");
        }

        @Override
        void setEncoding(String characterEncoding) {
            this._encoding = characterEncoding;
            this._isSosiEncoding = LpexNls.isSosiEncoding(this._encoding);
            this._isUnicodeEncoding = "UnicodeLittleUnmarked".equals(this._encoding);
        }

        @Override
        void setEditText(String textString) {
            this._textString = textString;
            this.setText(EditLine.this.hexAscii(textString, this._encoding, this._index == 3));
        }

        @Override
        String getEditText() {
            this._textString = EditLine.this.stringFromHexAscii(this.getText(), this._encoding, this._isUnicodeEncoding ? 4 : 2, this._isSosiEncoding, this._index == 3);
            return this._textString;
        }

        @Override
        int getEditIndex(int position) {
            int encodingOffset = (position - 1) / 2;
            return LpexNls.indexFromEncodingIndex(this._textString, encodingOffset, this._encoding, 0) + 1;
        }

        @Override
        void setEditHighlight(int start, int after) {
            int len = this._lpexView.queryInt("length");
            this._startHighlight = LpexNls.encodingCharIndex(this._textString, start - 1, this._encoding, 0) * 2 + 1;
            this._postHighlight = this._startHighlight < len ? LpexNls.encodingIndex(this._textString, after - 1, this._encoding, 0) * 2 + 1 : this._startHighlight;
            this.setEditStyle();
        }

        @Override
        void setEditPosition(int position) {
            position = LpexNls.encodingCharIndex(this._textString, position - 1, this._encoding, 0) * 2 + 1;
            this.setPosition(position);
        }
    }

    final class EditFieldUnicodeHex
    extends EditField {
        EditFieldUnicodeHex(int index) {
            super(index);
        }

        @Override
        void setPopup() {
            this.cmd("set popup");
        }

        @Override
        void setEditText(String t) {
            this.setText(EditLine.this.hexUnicode(t));
        }

        @Override
        String getEditText() {
            return EditLine.this.stringFromHexUnicode(this.getText());
        }

        @Override
        int getEditIndex(int position) {
            return (position - 1) / 4 + 1;
        }

        @Override
        void setEditHighlight(int start, int after) {
            this._startHighlight = (start - 1) * 4 + 1;
            this._postHighlight = (after - 1) * 4 + 1;
            this.setEditStyle();
        }

        @Override
        void setEditPosition(int position) {
            this.setPosition((position - 1) * 4 + 1);
        }
    }

    final class EditLineLayout
    extends Layout {
        EditLineLayout() {
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean flushCache) {
            int linePreferredHeight = EditLine.this._editField[0]._lpexWindow.computeSize((int)-1, (int)-1, (boolean)flushCache).y;
            int fieldsCount = 0;
            int i = 0;
            while (i < EditLine.this._editField.length) {
                if (EditLine.this._showEditField[i]) {
                    ++fieldsCount;
                    int labelPreferredHeight = EditLine.this._label[i].computeSize((int)-1, (int)-1, (boolean)flushCache).y;
                    if (linePreferredHeight < labelPreferredHeight) {
                        linePreferredHeight = labelPreferredHeight;
                    }
                }
                ++i;
            }
            int height = (linePreferredHeight + 1) * fieldsCount + 1;
            int width = 1000;
            return new Point(width, height);
        }

        protected void layout(Composite parent, boolean flushCache) {
            Rectangle parentRect = parent.getClientArea();
            int lineHeight = EditLine.this._editField[0]._lpexWindow.computeSize((int)-1, (int)-1, (boolean)flushCache).y;
            int labelsWidth = 0;
            int labelsHeight = 0;
            int i = 0;
            while (i < EditLine.this._editField.length) {
                if (EditLine.this._showEditField[i]) {
                    Point labelSize = EditLine.this._label[i].computeSize(-1, -1);
                    if (labelsHeight < labelSize.y) {
                        labelsHeight = labelSize.y;
                    }
                    if (lineHeight < labelsHeight) {
                        lineHeight = labelsHeight;
                    }
                    if (labelsWidth < labelSize.x) {
                        labelsWidth = labelSize.x;
                    }
                }
                ++i;
            }
            int lpexWidth = parentRect.width - 11 - labelsWidth;
            int labelY = (lineHeight - labelsHeight) / 2;
            EditLine.this._label[0].setBounds(5, 1 + labelY, labelsWidth, labelsHeight);
            EditLine.this._editField[0]._lpexWindow.setBounds(10 + labelsWidth, 1, lpexWidth, lineHeight);
            EditLine.this._label[1].setBounds(5, 2 + lineHeight + labelY, labelsWidth, labelsHeight);
            EditLine.this._editField[1]._lpexWindow.setBounds(10 + labelsWidth, 2 + lineHeight, lpexWidth, lineHeight);
            int labelBoundsY = 3 + lineHeight * 2 + labelY;
            int fieldBoundsY = 3 + lineHeight * 2;
            if (EditLine.this._showEditField[2]) {
                EditLine.this._label[2].setBounds(5, labelBoundsY, labelsWidth, labelsHeight);
                EditLine.this._editField[2]._lpexWindow.setBounds(10 + labelsWidth, fieldBoundsY, lpexWidth, lineHeight);
                labelBoundsY += 1 + lineHeight;
                fieldBoundsY += 1 + lineHeight;
            }
            if (EditLine.this._showEditField[3]) {
                EditLine.this._label[3].setBounds(5, labelBoundsY, labelsWidth, labelsHeight);
                EditLine.this._editField[3]._lpexWindow.setBounds(10 + labelsWidth, fieldBoundsY, lpexWidth, lineHeight);
            }
        }
    }
}

