/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Block;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexDocumentSectionListener;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.View;

final class DocumentSectionListenerList
extends List {
    DocumentSectionListenerList(Document document) {
    }

    void addListener(LpexDocumentSectionListener listener) {
        if (this.find(listener) == null) {
            this.addAfter(null, new ListenerNode(listener));
        }
    }

    void removeListener(LpexDocumentSectionListener listener) {
        ListenerNode node;
        if (listener != null && (node = this.find(listener)) != null) {
            this.remove(node);
        }
    }

    boolean addLines(LpexView lpexView, int lineNeeded) {
        boolean blockInView;
        ListenerNode firstNode = (ListenerNode)this.first();
        if (firstNode == null) {
            return true;
        }
        View view = lpexView._view;
        int linesBeforeStart = lpexView.linesBeforeStart();
        int currentLine = lpexView.queryInt("line");
        int currentPosition = view.documentPosition().position();
        int cursorRow = view.screen().cursorRow();
        int emphasisLength = view.documentPosition().emphasisLength();
        String blockType = null;
        int blockTopLine = 0;
        int blockTopPosition = 0;
        int blockBottomLine = 0;
        int blockBottomPosition = 0;
        Block block = view.block();
        boolean bl = blockInView = block.view() == view;
        if (blockInView) {
            blockType = lpexView.query("block.type");
            blockTopLine = lpexView.lineOfElement(lpexView.queryInt("block.topElement") - linesBeforeStart) + linesBeforeStart;
            blockBottomLine = lpexView.lineOfElement(lpexView.queryInt("block.bottomElement") - linesBeforeStart) + linesBeforeStart;
            blockTopPosition = block.topPosition();
            blockBottomPosition = block.bottomPosition();
        }
        boolean sameEnvironment = true;
        boolean done = false;
        this.beginScanning();
        ListenerNode node = firstNode;
        while (node != null && !done) {
            done = node.listener().addLines(lpexView, lineNeeded);
            node = (ListenerNode)node.next();
        }
        this.endScanning();
        linesBeforeStart = lpexView.linesBeforeStart();
        if (currentLine != lpexView.queryInt("line")) {
            int currentElement = lpexView.elementOfLine(currentLine - linesBeforeStart);
            if (currentElement != 0) {
                if (blockInView && block.view() != view) {
                    int topElement = lpexView.elementOfLine(blockTopLine - linesBeforeStart);
                    int bottomElement = lpexView.elementOfLine(blockBottomLine - linesBeforeStart);
                    if (topElement != 0 && bottomElement != 0) {
                        if (topElement == currentElement && blockTopPosition == currentPosition) {
                            lpexView.jump(bottomElement, blockBottomPosition);
                            lpexView.doDefaultCommand("block set " + blockType);
                            lpexView.jump(topElement, blockTopPosition);
                        } else {
                            lpexView.jump(topElement, blockTopPosition);
                            lpexView.doDefaultCommand("block set " + blockType);
                            lpexView.jump(bottomElement, blockBottomPosition);
                        }
                        lpexView.doDefaultCommand("block set");
                    }
                }
                lpexView.jump(currentElement, currentPosition);
                view.screen().setCursorRow(cursorRow);
                view.documentPosition().setEmphasisLength(emphasisLength);
                view.screen().build();
                view.screen().verticalScrollBar().forceUpdate();
            } else {
                sameEnvironment = false;
                view.screen().build();
                view.screen().verticalScrollBar().update();
            }
        }
        return sameEnvironment;
    }

    ListenerNode find(LpexDocumentSectionListener listener) {
        ListenerNode node = (ListenerNode)this.first();
        while (node != null) {
            if (node.listener() == listener) {
                return node;
            }
            node = (ListenerNode)node.next();
        }
        return null;
    }

    private static class ListenerNode
    extends ListNode {
        private LpexDocumentSectionListener _listener;

        ListenerNode(LpexDocumentSectionListener listener) {
            this._listener = listener;
        }

        LpexDocumentSectionListener listener() {
            return this._listener;
        }
    }
}

