/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.ClassLoaderList;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.DocumentListenerList;
import com.ibm.lpex.core.DocumentSectionListenerList;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.FileEndingEolParameter;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.SaveCommand;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.SequenceNumbersParameter;
import com.ibm.lpex.core.SourceCcsidParameter;
import com.ibm.lpex.core.Undo;
import com.ibm.lpex.core.UpdateProfileCommand;
import com.ibm.lpex.core.View;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.util.HashMap;
import java.util.HashSet;

final class Document {
    private static int _lastDocId;
    private static final Object _lockObject;
    private int _id;
    private String _name;
    private String _sourceName;
    static Document _firstDocument;
    Document _next;
    View _firstView;
    ElementList _elementList;
    private int _linesBeforeStart;
    private int _linesAfterEnd;
    private DocumentSectionListenerList _documentSectionListenerList;
    private boolean _triggeringDocumentSectionListeners;
    private DocumentListenerList _documentListenerList;
    private int _suspendDocListenerCount;
    private boolean _sendingDocListenerNotifications;
    private DocumentListenerList _documentAdjustListenerList;
    private boolean _batchingSeqNumberReplaced;
    private HashSet<Element> _batchElements = new HashSet();
    private LpexView _batchLpexView;
    private Undo _undo;
    private SequenceNumbersParameter.Settings _sequenceNumbersSettings;
    private SaveCommand.Settings _saveCommandSettings;
    private int _maintainBidiMarks = 2;
    private int _useSourceColumns = 2;
    String _sourceEncodingParm;
    String _sourceEncoding;
    boolean _sourceMbcs;
    boolean _sourceSosi;
    boolean _sourceArabic;
    boolean _sourceHebrew;
    private int _multipleViewsParm = 2;
    private String _extensionsClasspath;
    private ClassLoader _extensionsClassLoader;
    int _sourceCcsidParm;
    boolean _useDefaultSourceCcsid = true;
    boolean _sourceCcsidVisualBidi;
    boolean _visual;
    private int _enterArabicDigits = 2;
    private static String _platformEOLString;
    private static int _platformEOL;
    private int _defaultEOL = 0;
    private int _fileEndingEolParm = 2;
    private String _fileEncoding;
    private boolean _detectFileEncoding;
    private byte[] _bom;
    private HashMap<String, String> _parserProperties = new HashMap(5);
    private HashMap<String, String> _userParameters = new HashMap(5);
    private int _ignoreSequenceNumbersCount;
    static final int RESEQUENCE_FAILED = 0;
    static final int RESEQUENCE_NONE = 1;
    static final int RESEQUENCE_OK = 2;

    static {
        _lockObject = new Object();
        _platformEOLString = System.getProperty("line.separator");
        _platformEOL = "\r\n".equals(_platformEOLString) ? 768 : ("\r".equals(_platformEOLString) ? 256 : 512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document(String name, String fileEncoding, LpexView lpexView, boolean updateProfile) {
        Object object = _lockObject;
        synchronized (object) {
            this._id = ++_lastDocId;
            this._next = _firstDocument;
            _firstDocument = this;
        }
        CommandHandler.setStatus(null);
        this.setName(name);
        View view = new View(lpexView, this, updateProfile);
        this.elementList().addAfter(view, null, new Element(this));
        this.setFileEncoding(fileEncoding);
        if (this.name() != null) {
            this.load(view);
        }
        int sourceCcsid = SourceCcsidParameter.getParameter().currentValue(view);
        this._sourceCcsidVisualBidi = LpexNls.isVisualBidiCcsid(sourceCcsid);
        if (updateProfile) {
            view.updateProfile();
        }
    }

    HashMap<String, String> parserProperties() {
        return this._parserProperties;
    }

    HashMap<String, String> userParameters() {
        return this._userParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Document prevDocument = null;
        Document document = _firstDocument;
        while (document != null) {
            if (document == this) {
                if (prevDocument == null) {
                    Object object = _lockObject;
                    synchronized (object) {
                        _firstDocument = this._next;
                        break;
                    }
                }
                prevDocument._next = this._next;
                break;
            }
            prevDocument = document;
            document = document._next;
        }
        this._parserProperties.clear();
        this._userParameters.clear();
    }

    private void setFileEncoding(String fileEncoding) {
        this.setFileEncoding(fileEncoding, true);
    }

    void setFileEncoding(String fileEncoding, boolean resetSourceEncoding) {
        String oldFileEncoding = this._fileEncoding;
        this._detectFileEncoding = false;
        if (fileEncoding == null) {
            this._fileEncoding = null;
        } else if (fileEncoding.length() == 0) {
            this._fileEncoding = null;
            this._detectFileEncoding = true;
        } else if (LpexNls.isValidEncoding(fileEncoding)) {
            this._fileEncoding = (fileEncoding = LpexNls.canonicalEncoding(fileEncoding)).equals(LpexNls.getNativeEncoding()) ? null : fileEncoding;
        } else {
            CommandHandler.setStatus("file.incorrectEncoding");
        }
        if (!(oldFileEncoding == null && this._fileEncoding == null || oldFileEncoding != null && oldFileEncoding.equals(this._fileEncoding) || !resetSourceEncoding)) {
            LpexNls.fileEncodingChanged(this);
        }
    }

    String fileEncoding() {
        return this._fileEncoding;
    }

    byte[] bom() {
        return this._bom;
    }

    int id() {
        return this._id;
    }

    void setName(String name) {
        View view = this._firstView;
        while (view != null) {
            if (view.listenerList().renaming()) {
                return;
            }
            view = view._next;
        }
        this._name = name;
        view = this._firstView;
        while (view != null) {
            view.listenerList().renamed();
            view = view._next;
        }
    }

    String name() {
        return this._name;
    }

    private String baseName() {
        int i;
        String baseName = this.name();
        if (baseName != null && (i = baseName.lastIndexOf(System.getProperty("file.separator"))) >= 0 && i < baseName.length() - 1) {
            baseName = baseName.substring(i + 1);
        }
        return baseName;
    }

    private String nameExtension() {
        String extension = this.name();
        if (extension != null) {
            int i = extension.lastIndexOf(46);
            extension = i >= 0 ? extension.substring(i + 1) : null;
        }
        return extension;
    }

    void setSourceName(String sourceName) {
        View view = this._firstView;
        while (view != null) {
            if (view.listenerList().renaming()) {
                return;
            }
            view = view._next;
        }
        this._sourceName = sourceName;
        view = this._firstView;
        while (view != null) {
            view.listenerList().renamed();
            view = view._next;
        }
    }

    String sourceName() {
        return this._sourceName;
    }

    String getAssociatedParserName(View view) {
        String extension;
        String parserName = null;
        UpdateProfileCommand.ParserAssociationParameter parm = UpdateProfileCommand.ParserAssociationParameter.getParameter();
        Object baseName = this.baseName();
        if (baseName != null) {
            if (((String)baseName).indexOf(46) == -1) {
                baseName = (String)baseName + ".";
            }
            parserName = parm.currentValue(view, "parserAssociation." + (String)baseName);
        }
        if ((parserName == null || parserName.length() == 0) && (extension = this.nameExtension()) != null) {
            parserName = parm.currentValue(view, "parserAssociation." + extension);
        }
        return parserName;
    }

    private boolean loadFromInput(View view, Object input) {
        boolean success;
        View v = this._firstView;
        while (v != null) {
            v.setReadonly(false);
            v.parsePendingList().setParsing(false);
            v = v._next;
        }
        this.undo().setRecording(false);
        this.undo().clear();
        ElementList elementList = this.elementList();
        int sequenceNumbersNumColumn = elementList.sequenceNumbersNumColumn();
        int sequenceNumbersNumWidth = elementList.sequenceNumbersNumWidth();
        int sequenceNumbersTextColumn = elementList.sequenceNumbersTextColumn();
        int sequenceNumbersTextWidth = elementList.sequenceNumbersTextWidth();
        elementList.setSequenceNumbers(view, 1, 0, 1, 0);
        elementList.clear(view);
        boolean bl = success = input instanceof String ? this.loadLines(view, (String)input) : this.loadLines(view, (Reader)input);
        if (elementList.count() == 0) {
            elementList.addAfter(view, null, new Element(this));
        }
        elementList.setSequenceNumbers(view, sequenceNumbersNumColumn, sequenceNumbersNumWidth, sequenceNumbersTextColumn, sequenceNumbersTextWidth);
        this.resetUserActionElements();
        this.undo().setRecording(true);
        View v2 = this._firstView;
        while (v2 != null) {
            if (v2.updateProfileIssued()) {
                v2.updateProfile();
            }
            v2 = v2._next;
        }
        return success;
    }

    private boolean loadLines(View view, Reader reader) {
        if (reader == null) {
            return true;
        }
        boolean success = true;
        BufferedReader bufferedReader = null;
        try {
            try {
                String elementText;
                ElementList elementList = this.elementList();
                Element lastElement = null;
                bufferedReader = new BufferedReader(reader);
                boolean firstLine = true;
                while ((elementText = bufferedReader.readLine()) != null) {
                    if (firstLine) {
                        if (elementText.length() > 0 && elementText.charAt(0) == '\ufeff' && (this._bom != null || LpexNls.maySaveBom(this._fileEncoding))) {
                            elementText = elementText.substring(1);
                            if (this._bom == null) {
                                this._bom = new byte[0];
                            }
                        }
                        firstLine = false;
                    }
                    Element newElement = new Element(this, elementText);
                    elementList.addAfter(view, lastElement, newElement);
                    lastElement = newElement;
                }
            }
            catch (Exception e) {
                success = false;
                if (!(reader instanceof StringReader)) {
                    view.setLpexMessageText("file.errorReading", this.name());
                    if (e instanceof MalformedInputException) {
                        CommandHandler.setStatus("file.incorrectEncoding");
                    } else {
                        CommandHandler.setStatus("file.errorReading");
                    }
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return success;
    }

    private boolean loadLines(View view, String text) {
        this._defaultEOL = _platformEOL;
        if (text == null) {
            return true;
        }
        ElementList elementList = this.elementList();
        Element lastElement = null;
        int len = text.length();
        int eol = 0;
        int start = 0;
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '\r') {
                eol = i + 1 < len && text.charAt(i + 1) == '\n' ? 768 : 256;
            } else if (c == '\n') {
                eol = 512;
            }
            if (eol != 0) {
                Element newElement = new Element(this, text.substring(start, i));
                if (start == 0) {
                    if (eol != this._defaultEOL) {
                        this._defaultEOL = eol;
                    }
                } else if (eol != this._defaultEOL) {
                    newElement.setEOL(eol);
                }
                elementList.addAfter(view, lastElement, newElement);
                lastElement = newElement;
                if (eol == 768) {
                    ++i;
                }
                start = i + 1;
                eol = 0;
            }
            ++i;
        }
        if (start < len) {
            elementList.addAfter(view, lastElement, new Element(this, text.substring(start, len)));
        } else if (start != 0 && !FileEndingEolParameter.getParameter().currentValue(view)) {
            elementList.addAfter(view, lastElement, new Element(this));
        }
        return true;
    }

    void load(View view) {
        InputStreamReader reader = null;
        if (this.name() != null) {
            try {
                File f = new File(this.name());
                if (this._detectFileEncoding) {
                    this._bom = LpexNls.getBom(f);
                    String encoding = null;
                    if (this.isXmlDocument(view)) {
                        encoding = LpexNls.getXmlEncoding(f, this._bom);
                    } else if (this._bom != null) {
                        encoding = LpexNls.getBomEncoding(this._bom);
                    }
                    this.setFileEncoding(encoding);
                }
                FileInputStream fis = new FileInputStream(f);
                reader = this._fileEncoding == null ? new InputStreamReader((InputStream)fis, Charset.defaultCharset()) : new InputStreamReader((InputStream)fis, this._fileEncoding);
            }
            catch (FileNotFoundException e) {
                CommandHandler.setStatus("file.notFound");
            }
            catch (UnsupportedEncodingException e) {
                CommandHandler.setStatus("file.incorrectEncoding");
            }
            catch (Exception e) {
                CommandHandler.setStatus("file.errorReading");
            }
            if (reader == null) {
                view.setLpexMessageText("file.created", this.name());
            }
        }
        this.loadFromInput(view, reader);
    }

    private boolean isXmlDocument(View view) {
        String parserName = this.getAssociatedParserName(view);
        return "xml".equals(parserName) || "xsl".equals(parserName);
    }

    void load(View view, String fileEncoding) {
        CommandHandler.setStatus(null);
        if (fileEncoding != null) {
            view.document().setFileEncoding(fileEncoding);
        }
        this.load(view);
    }

    boolean load(View view, Reader reader) {
        if (reader instanceof InputStreamReader) {
            this.setFileEncoding(((InputStreamReader)reader).getEncoding());
        }
        return this.loadFromInput(view, reader);
    }

    void setText(View view, String text) {
        this.loadFromInput(view, text);
    }

    boolean saveToWriter(Writer writer) {
        boolean usingSourceColumns = LpexNls.usingSourceColumns(this);
        boolean isSmartLogical = this._firstView.nls().isSmartLogical();
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(writer);
                boolean first = true;
                Element element = this.elementList().first();
                while (element != null) {
                    if (!element.show()) {
                        String text;
                        if (!first) {
                            bufferedWriter.newLine();
                        }
                        if ((text = this.elementList().fullText(element, usingSourceColumns, isSmartLogical)).length() != 0) {
                            bufferedWriter.write(text, 0, text.length());
                        }
                        first = false;
                    }
                    element = element.next();
                }
            }
            catch (Exception e) {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    String text() {
        StringWriter stringWriter = new StringWriter();
        this.saveToWriter(stringWriter);
        return stringWriter.toString();
    }

    ElementList elementList() {
        if (this._elementList == null) {
            this._elementList = new ElementList(this);
        }
        return this._elementList;
    }

    Undo undo() {
        if (this._undo == null) {
            this._undo = new Undo(this);
        }
        return this._undo;
    }

    void resetUserActionElements() {
        View view = this._firstView;
        while (view != null) {
            view.resetUserActionElement();
            view = view._next;
        }
    }

    void verifyUserActionElements(Element element) {
        View view = this._firstView;
        while (view != null) {
            view.verifyUserActionElement(element);
            view = view._next;
        }
    }

    void elementRemoved(View view, Element element) {
        if (this._sendingDocListenerNotifications && !this._documentListenerList.empty() && !element.show()) {
            this.triggerTextListeners(view, true, false, 3, element, 0, 1);
        }
        View v = this._firstView;
        while (v != null) {
            v.elementRemoved(element);
            v = v._next;
        }
    }

    void elementInserted(View view, Element element, boolean undoElement) {
        View v = this._firstView;
        while (v != null) {
            v.elementInserted(element, undoElement);
            v = v._next;
        }
        if (this._sendingDocListenerNotifications && !this._documentListenerList.empty() && !element.show()) {
            this.triggerTextListeners(view, true, false, 5, element, 0, 1);
        }
    }

    void parse() {
        View view = this._firstView;
        while (view != null) {
            view.ensureIsParsed();
            view = view._next;
        }
    }

    void addParsePending(Element element, int type) {
        View view = this._firstView;
        while (view != null) {
            view.parsePendingList().add(element, type);
            view = view._next;
        }
    }

    void setVisibleElementOrdinalsInvalid() {
        View view = this._firstView;
        while (view != null) {
            view.setVisibleElementOrdinalsInvalid();
            view = view._next;
        }
    }

    static void screenShow() {
        Document document = _firstDocument;
        while (document != null) {
            Document.screenShow(document);
            document = document._next;
        }
    }

    static void screenShow(Document document) {
        if (document != null) {
            View view = document._firstView;
            while (view != null) {
                view.screen().show();
                view = view._next;
            }
        }
    }

    static void screenShow(LpexWindow lpexWindow) {
        LpexView lpexView;
        if (lpexWindow != null && (lpexView = lpexWindow.getLpexView()) != null) {
            lpexView._view.screen().show();
        }
    }

    static void screenShow(Screen screen) {
        if (screen != null) {
            screen.show();
        }
    }

    static void screenShow(View view) {
        if (view != null) {
            Document document = view.document();
            View v = document._firstView;
            while (v != null) {
                if (v == view || v.screen()._needsScreenShow) {
                    v.screen().show();
                }
                v = v._next;
            }
        }
    }

    SequenceNumbersParameter.Settings sequenceNumbersSettings() {
        if (this._sequenceNumbersSettings == null) {
            this._sequenceNumbersSettings = new SequenceNumbersParameter.Settings();
        }
        return this._sequenceNumbersSettings;
    }

    SaveCommand.Settings saveCommandSettings() {
        if (this._saveCommandSettings == null) {
            this._saveCommandSettings = new SaveCommand.Settings();
        }
        return this._saveCommandSettings;
    }

    int maintainBidiMarks() {
        return this._maintainBidiMarks;
    }

    void setMaintainBidiMarks(int value) {
        this._maintainBidiMarks = value;
    }

    int useSourceColumns() {
        return this._useSourceColumns;
    }

    void setUseSourceColumns(int value) {
        this._useSourceColumns = value;
    }

    void useSourceColumnsChanged() {
        Element element = this.elementList().first();
        while (element != null) {
            View view = this._firstView;
            while (view != null) {
                element.elementView(view).resetDisplayText();
                view = view._next;
            }
            element = element.next();
        }
    }

    void sourceEncodingChanged() {
        this.useSourceColumnsChanged();
    }

    void sourceCcsidChanged() {
        int sourceCcsid = SourceCcsidParameter.getParameter().currentValue(this._firstView);
        this._sourceCcsidVisualBidi = LpexNls.isVisualBidiCcsid(sourceCcsid);
        if (LpexNls.usingSourceColumns(this)) {
            this.useSourceColumnsChanged();
        }
    }

    boolean visual() {
        return this._visual;
    }

    void setVisual(boolean visual) {
        this._visual = visual;
    }

    int enterArabicDigits() {
        return this._enterArabicDigits;
    }

    void setEnterArabicDigits(int value) {
        this._enterArabicDigits = value;
    }

    void setFileEndingEol(int fileEndingEolParm) {
        this._fileEndingEolParm = fileEndingEolParm;
    }

    int fileEndingEol() {
        return this._fileEndingEolParm;
    }

    void setMultipleViewsParm(int multipleViewsParm) {
        this._multipleViewsParm = multipleViewsParm;
    }

    int multipleViewsParm() {
        return this._multipleViewsParm;
    }

    void setExtensionsClasspath(String extensionsClasspath) {
        this._extensionsClasspath = extensionsClasspath;
        this._extensionsClassLoader = null;
    }

    String extensionsClasspath() {
        return this._extensionsClasspath;
    }

    ClassLoader extensionsClassLoader() {
        if (this._extensionsClassLoader == null) {
            this._extensionsClassLoader = ClassLoaderList.getClassLoader(this._extensionsClasspath);
        }
        return this._extensionsClassLoader;
    }

    boolean readonly() {
        View view = this._firstView;
        while (view != null) {
            if (!view.readonly()) {
                return false;
            }
            view = view._next;
        }
        return true;
    }

    int resequence(View view) {
        int start = 100;
        int increment = 100;
        int count = this.linesCount();
        int maxSequenceNumber = this.elementList().maxSequenceNumber();
        while (increment > 0 && start + increment * (count - 1) >= maxSequenceNumber) {
            start /= 2;
            increment /= 2;
        }
        return this.resequence(view, start, increment);
    }

    int resequence(View view, int start, int increment) {
        if (start <= 0 || increment <= 0) {
            return 0;
        }
        int maxSequenceNumber = this.elementList().maxSequenceNumber();
        int sequenceNumber = start;
        int i = 0;
        while (i < this.linesBeforeStart()) {
            if (sequenceNumber > maxSequenceNumber) {
                return 0;
            }
            sequenceNumber += increment;
            ++i;
        }
        int firstSequenceNumber = sequenceNumber;
        int restOfLinesCount = this.elementList().nonShowCount() + this.linesAfterEnd();
        while (i < restOfLinesCount) {
            if (sequenceNumber > maxSequenceNumber) {
                return 0;
            }
            sequenceNumber += increment;
            ++i;
        }
        boolean notifyDocListeners = false;
        boolean notifyDocAdjustListeners = false;
        if (this._elementList.sequenceNumbersNumWidth() != 0) {
            notifyDocListeners = this._sendingDocListenerNotifications && !this._documentListenerList.empty();
            notifyDocAdjustListeners = this._documentAdjustListenerList != null && !this._documentAdjustListenerList.empty();
        }
        boolean notify = notifyDocListeners || notifyDocAdjustListeners;
        LpexView lpexView = view.lpexView();
        int numWidth = this._elementList.sequenceNumbersNumWidth();
        boolean first = true;
        sequenceNumber = firstSequenceNumber;
        Element element = this._elementList.first();
        while (element != null) {
            if (!element.show()) {
                if (element.setSequenceNumber(sequenceNumber)) {
                    if (notify) {
                        if (first) {
                            if (notifyDocListeners) {
                                this._documentListenerList.documentChanged(lpexView, 6, 0, 0, 0);
                            }
                            if (notifyDocAdjustListeners) {
                                this._documentAdjustListenerList.documentChanged(lpexView, 6, 0, 0, 0);
                            }
                            this._elementList.validateNonShowOrdinals();
                        }
                        int line = element.nonShowOrdinal();
                        int position = this._elementList.sequenceNumbersNumColumn(element);
                        if (notifyDocListeners) {
                            this._documentListenerList.documentChanged(lpexView, 1, line, position, numWidth);
                        }
                        if (notifyDocAdjustListeners) {
                            this._documentAdjustListenerList.documentChanged(lpexView, 1, line, position, numWidth);
                        }
                    }
                    first = false;
                }
                sequenceNumber += increment;
            }
            element = element.next();
        }
        if (!first) {
            if (notifyDocListeners) {
                this._documentListenerList.documentChanged(lpexView, 7, 0, 0, 0);
            }
            if (notifyDocAdjustListeners) {
                this._documentAdjustListenerList.documentChanged(lpexView, 7, 0, 0, 0);
            }
        }
        this.elementList().setSequenceNumbersValid(true);
        return first ? 1 : 2;
    }

    boolean ignoreSequenceNumbers() {
        return this._ignoreSequenceNumbersCount > 0;
    }

    void setIgnoreSequenceNumbers() {
        ++this._ignoreSequenceNumbersCount;
    }

    void resetIgnoreSequenceNumbers() {
        if (this._ignoreSequenceNumbersCount > 0) {
            --this._ignoreSequenceNumbersCount;
        }
    }

    DocumentListenerList documentListenerList() {
        if (this._documentListenerList == null) {
            this._documentListenerList = new DocumentListenerList(this);
            this._sendingDocListenerNotifications = this._suspendDocListenerCount == 0;
        }
        return this._documentListenerList;
    }

    DocumentListenerList documentAdjustListenerList() {
        if (this._documentAdjustListenerList == null) {
            this._documentAdjustListenerList = new DocumentListenerList(this);
        }
        return this._documentAdjustListenerList;
    }

    void sendDocumentListenerNotifications(boolean send) {
        if (send) {
            if (--this._suspendDocListenerCount <= 0) {
                this._suspendDocListenerCount = 0;
                this._sendingDocListenerNotifications = this._documentListenerList != null;
            }
        } else {
            ++this._suspendDocListenerCount;
            this._sendingDocListenerNotifications = false;
        }
    }

    void setDocumentListenerInsertingText(boolean insertingText) {
        if (this._documentListenerList != null && !this._documentListenerList.empty()) {
            this._documentListenerList.setInsertingText(insertingText);
        }
    }

    void textRemoved(View view, Element element, int position, int count) {
        if (this._sendingDocListenerNotifications && !this._documentListenerList.empty()) {
            this.triggerTextListeners(view, true, false, 0, element, position, count);
        }
    }

    void textReplaced(View view, Element element, int position, int count) {
        if (this._sendingDocListenerNotifications && !this._documentListenerList.empty()) {
            this.triggerTextListeners(view, true, false, 1, element, position, count);
        }
    }

    void textInserted(View view, Element element, int position, int count) {
        if (this._sendingDocListenerNotifications && !this._documentListenerList.empty()) {
            this.triggerTextListeners(view, true, false, 2, element, position, count);
        }
    }

    void elementReplaced(View view, Element element) {
        if (this._sendingDocListenerNotifications && !this._documentListenerList.empty()) {
            this.triggerTextListeners(view, true, false, 4, element, 0, 1);
        }
    }

    void elementAdjusted(View view, Element element) {
        if (this._documentAdjustListenerList != null && !this._documentAdjustListenerList.empty()) {
            this._documentAdjustListenerList.documentChanged(view.lpexView(), 4, this._elementList.nonShowOrdinalOf(element), 0, 1);
        }
    }

    void elementReplacedAndAdjusted(View view, Element element) {
        if (!(this._sendingDocListenerNotifications && !this._documentListenerList.empty() || this._documentAdjustListenerList != null && !this._documentAdjustListenerList.empty())) {
            return;
        }
        this.triggerTextListeners(view, this._sendingDocListenerNotifications, this._documentAdjustListenerList != null, 4, element, 0, 1);
    }

    void batchSeqNumberReplaced(View view) {
        this._batchLpexView = view.lpexView();
        this._batchingSeqNumberReplaced = true;
    }

    void sendBatchSeqNumberReplaced() {
        if (!this._batchElements.isEmpty()) {
            for (Element element : this._batchElements) {
                this._documentListenerList.documentChanged(this._batchLpexView, 1, this._elementList.nonShowOrdinalOf(element), this._elementList.sequenceNumbersNumColumn(element), this._elementList.sequenceNumbersNumWidth());
            }
            this._batchElements.clear();
        }
        this._batchingSeqNumberReplaced = false;
    }

    void seqNumberReplaced(View view, Element element) {
        if (this._sendingDocListenerNotifications && this._elementList.sequenceNumbersNumWidth() != 0) {
            if (this._batchingSeqNumberReplaced) {
                this._batchElements.add(element);
            } else {
                this._documentListenerList.documentChanged(view.lpexView(), 1, this._elementList.nonShowOrdinalOf(element), this._elementList.sequenceNumbersNumColumn(element), this._elementList.sequenceNumbersNumWidth());
            }
        }
    }

    void seqNumberAdjusted(View view, Element element) {
        if (this._documentAdjustListenerList != null && !this._documentAdjustListenerList.empty()) {
            this._documentAdjustListenerList.documentChanged(view.lpexView(), 1, this._elementList.nonShowOrdinalOf(element), this._elementList.sequenceNumbersNumColumn(element), this._elementList.sequenceNumbersNumWidth());
        }
    }

    void seqTextReplaced(View view, Element element) {
        if (this._sendingDocListenerNotifications && this._elementList.sequenceNumbersTextWidth() != 0) {
            this._documentListenerList.documentChanged(view.lpexView(), 1, this._elementList.nonShowOrdinalOf(element), this._elementList.sequenceNumbersTextColumn(element), this._elementList.sequenceNumbersTextWidth());
        }
    }

    void seqTextAdjusted(View view, Element element) {
        if (this._documentAdjustListenerList != null && !this._documentAdjustListenerList.empty()) {
            this._documentAdjustListenerList.documentChanged(view.lpexView(), 1, this._elementList.nonShowOrdinalOf(element), this._elementList.sequenceNumbersTextColumn(element), this._elementList.sequenceNumbersTextWidth());
        }
    }

    void startChanges(View view) {
        if (this._sendingDocListenerNotifications) {
            this._documentListenerList.documentChanged(view.lpexView(), 6, 0, 0, 0);
        }
    }

    void endChanges(View view) {
        if (this._sendingDocListenerNotifications) {
            this._documentListenerList.documentChanged(view.lpexView(), 7, 0, 0, 0);
        }
    }

    private void triggerTextListeners(View view, boolean docListeners, boolean docAdjustListeners, int type, Element element, int position, int count) {
        if (position != 0 && this._elementList.sequenceNumbersWidth() != 0) {
            int sequenceNumbersColumn = this._elementList.sequenceNumbersColumn();
            if (sequenceNumbersColumn == 1) {
                position += this._elementList.sequenceNumbersWidth();
            } else {
                String text = element.text();
                if (LpexNls.usingSourceColumns(this) || this._firstView.nls().isSmartLogical()) {
                    type = 4;
                    position = 0;
                    count = 1;
                } else if (position >= sequenceNumbersColumn) {
                    position += this._elementList.sequenceNumbersWidth();
                } else if (position + count > sequenceNumbersColumn) {
                    if (type == 1) {
                        count += this._elementList.sequenceNumbersWidth();
                    } else {
                        type = 4;
                        position = 0;
                        count = 1;
                    }
                } else if (type == 2) {
                    if (text.length() < sequenceNumbersColumn) {
                        type = 1;
                        count = sequenceNumbersColumn - position;
                    } else {
                        type = 4;
                        position = 0;
                        count = 1;
                    }
                }
            }
        }
        LpexView lpexView = view.lpexView();
        int lineNumber = this._elementList.nonShowOrdinalOf(element);
        if (docListeners) {
            this._documentListenerList.documentChanged(lpexView, type, lineNumber, position, count);
        }
        if (docAdjustListeners) {
            this._documentAdjustListenerList.documentChanged(lpexView, type, lineNumber, position, count);
        }
    }

    DocumentSectionListenerList documentSectionListenerList() {
        if (this._documentSectionListenerList == null) {
            this._documentSectionListenerList = new DocumentSectionListenerList(this);
        }
        return this._documentSectionListenerList;
    }

    boolean triggerDocumentSectionListeners(LpexView lpexView, int neededLine) {
        boolean sameEnvironment = true;
        if (!this._triggeringDocumentSectionListeners) {
            this._triggeringDocumentSectionListeners = true;
            if (this._documentSectionListenerList != null) {
                sameEnvironment = this._documentSectionListenerList.addLines(lpexView, neededLine);
            }
            this._triggeringDocumentSectionListeners = false;
        }
        return sameEnvironment;
    }

    boolean triggeringDocumentSectionListeners() {
        return this._triggeringDocumentSectionListeners;
    }

    boolean setLinesOutsideDocumentSection(View view, int linesBeforeStart, int linesAfterEnd) {
        boolean changed;
        if (linesBeforeStart < 0) {
            linesBeforeStart = 0;
        }
        if (linesAfterEnd < 0) {
            linesAfterEnd = 0;
        }
        boolean bl = changed = linesBeforeStart != this._linesBeforeStart || linesAfterEnd != this._linesAfterEnd;
        if (changed) {
            if (this._firstView._next != null) {
                return false;
            }
            this._linesBeforeStart = linesBeforeStart;
            this._linesAfterEnd = linesAfterEnd;
            if (this.elementList().sequenceNumbersNumWidth() > 0) {
                this.resequence(view);
            }
        }
        return true;
    }

    int linesBeforeStart() {
        return this._linesBeforeStart;
    }

    int linesAfterEnd() {
        return this._linesAfterEnd;
    }

    int linesCount() {
        return this.linesBeforeStart() + this.elementList().nonShowCount() + this.linesAfterEnd();
    }
}

