/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.ParameterIntegerOnly;
import com.ibm.lpex.core.View;

final class DisplayPositionParameter
extends ParameterIntegerOnly {
    private static DisplayPositionParameter _parameter;

    static DisplayPositionParameter getParameter() {
        if (_parameter == null) {
            _parameter = new DisplayPositionParameter();
        }
        return _parameter;
    }

    private DisplayPositionParameter() {
        super("displayPosition");
    }

    @Override
    boolean setValue(View view, String qualifier, int value) {
        Element element;
        if (value <= 0) {
            return CommandHandler.invalidParameter(view, String.valueOf(value), "set " + this.name());
        }
        if (view != null && (element = view.documentPosition().element()) != null) {
            int position = view.positionFromDisplayPosition(element.elementView(view), value);
            view.documentPosition().jump(element, position);
        }
        return true;
    }

    @Override
    boolean isQueryAvailable(View view, LpexDocumentLocation documentLocation, String qualifier) {
        return view != null && documentLocation != null && view.document().elementList().elementAt(documentLocation.element) != null;
    }

    @Override
    int value(View view, LpexDocumentLocation documentLocation, String qualifier) {
        Element element;
        if (view != null && documentLocation != null && (element = view.document().elementList().elementAt(documentLocation.element)) != null) {
            return view.displayColumn(element.elementView(view), documentLocation.position);
        }
        return 0;
    }
}

