/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.LpexInternalUtilities;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.ProfileHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;

final class DefaultProfile
implements ProfileHandler {
    private static Properties _properties = new Properties();
    private static boolean _loaded;
    private static String _fileName;
    private static String _lpexVersion;
    private static final Object _lockObject;

    static {
        _lockObject = new Object();
    }

    DefaultProfile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String name() {
        if (_fileName == null) {
            Object object = _lockObject;
            synchronized (object) {
                _fileName = LpexInternalUtilities.getUserHomeDirectory() + File.separator + "Profile.properties";
            }
        }
        return _fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setName(String name) {
        if (name != null && (name = name.trim()).length() == 0) {
            name = null;
        }
        if (name != null) {
            File profile;
            block8: {
                try {
                    profile = new File(name);
                    if (!profile.isDirectory() && (!profile.exists() || profile.canWrite())) break block8;
                    return false;
                }
                catch (Exception x) {
                    return false;
                }
            }
            name = profile.getCanonicalPath();
        }
        Object object = _lockObject;
        synchronized (object) {
            _fileName = name;
            _properties.clear();
            _loaded = false;
        }
        Profile.profileChanged();
        return true;
    }

    private void load() {
        if (!_loaded) {
            DefaultProfile.loadFromFile(this.name());
        }
    }

    @Override
    public boolean importProfile(String fileName) {
        boolean success = DefaultProfile.loadFromFile(fileName);
        if (success) {
            this.save();
            Profile.profileChanged();
        }
        return success;
    }

    private static boolean loadFromFile(String fileName) {
        _loaded = true;
        if (fileName == null) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream fileInputStream = new FileInputStream(fileName);){
                _properties.load(fileInputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void save() {
        this.exportProfile(this.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exportProfile(String fileName) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(fileName);){
                Object object = _lockObject;
                synchronized (object) {
                    if (_lpexVersion == null) {
                        _lpexVersion = LpexUtilities.getVersion();
                    }
                    _properties.store(fileOutputStream, "LPEX profile - " + _lpexVersion);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetProfile() {
        Object object = _lockObject;
        synchronized (object) {
            _properties.clear();
            _loaded = true;
        }
        this.save();
        Profile.profileChanged();
    }

    @Override
    public String getString(String key) {
        this.load();
        return _properties.getProperty(key);
    }

    @Override
    public void putString(String key, String value) {
        if (value == null || value.length() == 0) {
            this.remove(key);
            return;
        }
        this.load();
        _properties.put(key, value);
        this.save();
    }

    @Override
    public void remove(String key) {
        this.load();
        _properties.remove(key);
        this.save();
    }

    @Override
    public void flush() {
    }

    @Override
    public String getKeys() {
        this.load();
        StringBuilder keys = new StringBuilder(576);
        Enumeration<?> propertyNames = _properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            if (keys.length() != 0) {
                keys.append(' ');
            }
            keys.append(propertyNames.nextElement());
        }
        return keys.toString();
    }
}

