/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.ParameterIntegerDefault;
import com.ibm.lpex.core.ParameterOnOffDefault;
import com.ibm.lpex.core.Parameters;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.View;

final class CursorParameters {
    private static final int BLINK_TIME = 1;
    private static final int KEEP_VISIBLE = 2;
    private static final int WIDTH = 3;
    private static TableNode[] _parameters = new TableNode[]{new TableNode("blinkTime", 1), new TableNode("keepVisible", 2), new TableNode("width", 3)};

    static {
        TableNode.sort(_parameters);
    }

    CursorParameters() {
    }

    static Parameter getParameter(String parameter) {
        TableNode p = TableNode.binarySearch(_parameters, Parameters.getParameterString(parameter));
        if (p != null) {
            switch (p.id()) {
                case 1: {
                    return BlinkTimeParameter.getParameter();
                }
                case 2: {
                    return KeepVisibleParameter.getParameter();
                }
                case 3: {
                    return WidthParameter.getParameter();
                }
            }
        }
        return null;
    }

    static final class BlinkTimeParameter
    extends ParameterIntegerDefault {
        private static BlinkTimeParameter _parameter;

        static BlinkTimeParameter getParameter() {
            if (_parameter == null) {
                _parameter = new BlinkTimeParameter();
            }
            return _parameter;
        }

        private BlinkTimeParameter() {
            super("cursor.blinkTime", 500);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean isAcceptableValue(int value) {
            return value == 0 || value >= 200 && value <= 1200;
        }

        @Override
        boolean setValue(View view, int value, boolean useDefaultValue) {
            if (view != null) {
                boolean changed = view._cursorBlinkTimeParm != value;
                view._cursorBlinkTimeParm = value;
                view._useDefaultCursorBlinkTime = useDefaultValue;
                if (changed) {
                    this.currentValueChanged(view);
                }
            }
            return true;
        }

        @Override
        void currentValueChanged(View view) {
            view.cursorBlinkTimeChanged();
        }

        @Override
        boolean useDefaultValue(View view) {
            return view != null ? view._useDefaultCursorBlinkTime : true;
        }

        @Override
        int value(View view) {
            return view != null ? view._cursorBlinkTimeParm : 0;
        }
    }

    static final class KeepVisibleParameter
    extends ParameterOnOffDefault {
        private static KeepVisibleParameter _parameter;

        static KeepVisibleParameter getParameter() {
            if (_parameter == null) {
                _parameter = new KeepVisibleParameter();
            }
            return _parameter;
        }

        private KeepVisibleParameter() {
            super("cursor.keepVisible", true);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.screen().setKeepVisibleParm(value);
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.screen().keepVisibleParm() : 2;
        }
    }

    static final class WidthParameter
    extends ParameterIntegerDefault {
        private static WidthParameter _parameter;

        static WidthParameter getParameter() {
            if (_parameter == null) {
                _parameter = new WidthParameter();
            }
            return _parameter;
        }

        private WidthParameter() {
            super("cursor.width", 2);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean isAcceptableValue(int value) {
            return value > 0 && value <= 20;
        }

        @Override
        boolean setValue(View view, int value, boolean useDefaultValue) {
            if (view != null) {
                boolean changed = view._cursorWidthParm != value;
                view._cursorWidthParm = value;
                view._useDefaultCursorWidth = useDefaultValue;
                if (changed) {
                    this.currentValueChanged(view);
                }
            }
            return true;
        }

        @Override
        void currentValueChanged(View view) {
            view.cursorWidthChanged();
        }

        @Override
        boolean useDefaultValue(View view) {
            return view != null ? view._useDefaultCursorWidth : true;
        }

        @Override
        int value(View view) {
            return view != null ? view._cursorWidthParm : 0;
        }
    }
}

