/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;

public class BlockTypeResetter {
    public boolean isPending = false;

    public void setBlockTypeToCharacter(LpexView view) {
        this.isPending = true;
        BlockTypeResetter.changeBlockType(view, "character");
    }

    public boolean isPending() {
        return this.isPending;
    }

    public void resetBlockTypeToStream(LpexView lpexView) {
        if (this.isPending()) {
            BlockTypeResetter.changeBlockType(lpexView, "stream");
            this.isPending = false;
        }
    }

    private static void changeBlockType(LpexView lpexView, String blockMode) {
        int startPosition;
        int startElement;
        int topElement = lpexView.queryInt("block.topElement");
        int topPosition = lpexView.queryInt("block.topPosition");
        int bottomElement = lpexView.queryInt("block.bottomElement");
        int bottomPosition = lpexView.queryInt("block.bottomPosition");
        int currentElement = lpexView.currentElement();
        int currentPosition = lpexView.currentPosition();
        if (currentElement == bottomElement && currentPosition == bottomPosition) {
            startElement = topElement;
            startPosition = topPosition;
        } else if (currentElement == topElement && currentPosition == topPosition) {
            startElement = bottomElement;
            startPosition = bottomPosition;
        } else {
            lpexView.doCommand("block clear");
            lpexView.doCommand("screenShow view");
            return;
        }
        lpexView.doCommand("block clear");
        lpexView.jump(startElement, startPosition);
        lpexView.doCommand("block set " + blockMode);
        LpexDocumentLocation loc = new LpexDocumentLocation(bottomElement, 1);
        if (!lpexView.queryOn("visible", loc)) {
            boolean done = false;
            while (--loc.element >= 1) {
                if (!lpexView.queryOn("visible", loc)) continue;
                lpexView.doCommand(loc, "set expanded on");
                done = true;
                break;
            }
            if (!done) {
                lpexView.doCommand("set topExpanded on");
            }
        }
        lpexView.jump(currentElement, currentPosition);
        lpexView.doCommand("block set");
        lpexView.doCommand("screenShow view");
    }
}

