/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.ActionHandler;
import com.ibm.lpex.core.BlockCommand;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.CommandLine;
import com.ibm.lpex.core.CompareCommand;
import com.ibm.lpex.core.DisplayTextLayout;
import com.ibm.lpex.core.DocumentPosition;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.FindTextCommand;
import com.ibm.lpex.core.InputCommand;
import com.ibm.lpex.core.KeyRecorder;
import com.ibm.lpex.core.KillRing;
import com.ibm.lpex.core.LocateCommand;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexMatch;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.MarkList;
import com.ibm.lpex.core.MessageLine;
import com.ibm.lpex.core.MessageLineParameter;
import com.ibm.lpex.core.PrefixAreaTextParameter;
import com.ibm.lpex.core.ProcessPrefixCommand;
import com.ibm.lpex.core.SaveCommand;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.SetCommand;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.TabsParameter;
import com.ibm.lpex.core.View;
import com.ibm.lpex.core.WordActions;
import java.text.DecimalFormatSymbols;

final class ActionUtilities {
    private static final TableNode[] _actions = new TableNode[]{new TableNode("appendToActionArgument", 30), new TableNode("backSpace", 31), new TableNode("backSpaceInLine", 32), new TableNode("blockCopy", 33), new TableNode("blockDelete", 34), new TableNode("blockFill", 35), new TableNode("blockLowerCase", 36), new TableNode("blockMarkAll", 37), new TableNode("blockMarkAllEclipse", 216), new TableNode("blockMarkBottom", 38), new TableNode("blockMarkCharacter", 39), new TableNode("blockMarkDown", 40), new TableNode("blockMarkElement", 41), new TableNode("blockMarkElementAtMouse", 42), new TableNode("blockMarkEnd", 43), new TableNode("blockMarkHome", 44), new TableNode("blockMarkLeft", 45), new TableNode("blockMarkNextWord", 46), new TableNode("blockMarkPageDown", 47), new TableNode("blockMarkPageLeft", 48), new TableNode("blockMarkPageRight", 49), new TableNode("blockMarkPageUp", 50), new TableNode("blockMarkPrevWord", 51), new TableNode("blockMarkRectangle", 52), new TableNode("blockMarkRectangleAtMouse", 53), new TableNode("blockMarkRight", 54), new TableNode("blockMarkToMouse", 55), new TableNode("blockMarkTop", 56), new TableNode("blockMarkUp", 57), new TableNode("blockMarkWord", 58), new TableNode("blockMarkWordAtMouse", 59), new TableNode("blockMove", 60), new TableNode("blockOverlay", 61), new TableNode("blockShiftLeft", 62), new TableNode("blockShiftRight", 63), new TableNode("blockUnmark", 64), new TableNode("blockUpperCase", 65), new TableNode("bottom", 66), new TableNode("capitalizeWord", 67), new TableNode("clearPrefix", 68), new TableNode("commandLine", 69), new TableNode("compare", 70), new TableNode("compareAllBlanks", 71), new TableNode("compareCase", 72), new TableNode("compareClear", 73), new TableNode("compareComments", 74), new TableNode("compareLeadingBlanks", 75), new TableNode("compareNext", 76), new TableNode("comparePrevious", 77), new TableNode("compareRefresh", 78), new TableNode("compareSequenceNumbers", 79), new TableNode("compareTrailingBlanks", 80), new TableNode("contextEnd", 81), new TableNode("contextHome", 82), new TableNode("copy", 83), new TableNode("cursorToMouse", 84), new TableNode("cut", 85), new TableNode("delete", 86), new TableNode("deleteBlankLines", 87), new TableNode("deleteInLine", 88), new TableNode("deleteLine", 89), new TableNode("deleteNextWord", 90), new TableNode("deletePrevWord", 91), new TableNode("deleteToLineStart", 92), new TableNode("deleteWhiteSpace", 93), new TableNode("down", 94), new TableNode("duplicateLine", 95), new TableNode("eclipseCopy", 4), new TableNode("eclipseCut", 3), new TableNode("eclipseDelete", 6), new TableNode("eclipsePaste", 5), new TableNode("eclipseRedo", 2), new TableNode("eclipseUndo", 1), new TableNode("end", 96), new TableNode("enterDecimalSeparator", 97), new TableNode("excludeSelection", 98), new TableNode("execCommand", 99), new TableNode("expandHideAtMouse", 100), new TableNode("filterOverflow", 101), new TableNode("filterSelection", 102), new TableNode("find", 103), new TableNode("findAndReplace", 104), new TableNode("findAndReplaceNext", 105), new TableNode("findAndReplaceUp", 106), new TableNode("findBlockEnd", 107), new TableNode("findBlockStart", 108), new TableNode("findLastChange", 109), new TableNode("findMark", 110), new TableNode("findMatch", 111), new TableNode("findNext", 112), new TableNode("findQuickMark", 113), new TableNode("findSelection", 114), new TableNode("findUp", 115), new TableNode("get", 116), new TableNode("help", 117), new TableNode("hexEditLine", 118), new TableNode("home", 119), new TableNode("indentText", 120), new TableNode("insertDecimalSeparator", 121), new TableNode("insertFileName", 122), new TableNode("insertLeftBrace", 123), new TableNode("insertLtrMark", 124), new TableNode("insertNot", 125), new TableNode("insertRightBrace", 126), new TableNode("insertRtlMark", 127), new TableNode("insertTab", 128), new TableNode("insertToTab", 129), new TableNode("join", 130), new TableNode("keyRecorderPlay", 131), new TableNode("keyRecorderStart", 132), new TableNode("keyRecorderStop", 133), new TableNode("killLine", 134), new TableNode("killRegion", 135), new TableNode("left", 136), new TableNode("locateLine", 137), new TableNode("locateSequenceLine", 138), new TableNode("lowerCaseRegion", 139), new TableNode("lowerCaseWord", 140), new TableNode("match", 141), new TableNode("nameMark", 142), new TableNode("newLine", 143), new TableNode("nextTabStop", 144), new TableNode("nextWord", 145), new TableNode("nullAction", 146), new TableNode("oneSpace", 147), new TableNode("openLine", 148), new TableNode("pageDown", 149), new TableNode("pageLeft", 150), new TableNode("pageRight", 151), new TableNode("pageUp", 152), new TableNode("paste", 153), new TableNode("pasteOverlay", 154), new TableNode("pendingCommand", 155), new TableNode("popupAtCursor", 156), new TableNode("popupAtMouse", 157), new TableNode("preferences", 158), new TableNode("prefixBackSpace", 159), new TableNode("prefixDelete", 160), new TableNode("prefixEnd", 161), new TableNode("prefixHome", 162), new TableNode("prefixLeft", 163), new TableNode("prefixRight", 164), new TableNode("prefixTruncate", 165), new TableNode("prevTabStop", 166), new TableNode("prevWord", 167), new TableNode("print", 168), new TableNode("printCompare", 169), new TableNode("processPrefix", 170), new TableNode("redo", 171), new TableNode("reload", 172), new TableNode("rename", 173), new TableNode("restorePrefix", 174), new TableNode("right", 175), new TableNode("save", 176), new TableNode("saveAs", 177), new TableNode("saveToWriter", 178), new TableNode("scrollBottom", 179), new TableNode("scrollCenter", 180), new TableNode("scrollDown", 181), new TableNode("scrollMessageLeft", 182), new TableNode("scrollMessageRight", 183), new TableNode("scrollTop", 184), new TableNode("scrollUp", 185), new TableNode("setActionArgument", 186), new TableNode("setParser", 187), new TableNode("setQuickMark", 188), new TableNode("setQuickMarkAll", 189), new TableNode("setQuickMarkWord", 190), new TableNode("showAll", 191), new TableNode("split", 192), new TableNode("splitAndShift", 193), new TableNode("splitLine", 194), new TableNode("textWindow", 195), new TableNode("toggleCaseSensitive", 196), new TableNode("toggleInsert", 197), new TableNode("toggleKeyRecording", 198), new TableNode("toggleRegularExpression", 199), new TableNode("top", 200), new TableNode("transposeCharacters", 201), new TableNode("transposeLines", 202), new TableNode("transposeWords", 203), new TableNode("truncate", 204), new TableNode("undo", 205), new TableNode("up", 206), new TableNode("upperCaseRegion", 207), new TableNode("upperCaseWord", 208), new TableNode("visualEditLine", 209), new TableNode("windowBottom", 210), new TableNode("windowTop", 211), new TableNode("wordEnd", 212), new TableNode("wordStart", 213), new TableNode("yank", 214), new TableNode("yankPrevious", 215)};

    static {
        TableNode.sort(_actions);
    }

    ActionUtilities() {
    }

    static int defaultActionId(String actionName) {
        TableNode tableNode = TableNode.binarySearch(_actions, actionName);
        return tableNode != null ? tableNode.id() : 0;
    }

    static String defaultActionName(int actionId) {
        TableNode tableNode = TableNode.sequentialSearch(_actions, actionId);
        return tableNode != null ? tableNode.string() : "nullAction";
    }

    static String defaultActions() {
        StringBuilder actions = new StringBuilder(2560);
        int i = 0;
        while (i < _actions.length) {
            if (i != 0) {
                actions.append(' ');
            }
            actions.append(_actions[i].string());
            ++i;
        }
        return actions.toString();
    }

    static boolean defaultActionAvailable(View view, int actionId) {
        switch (actionId) {
            case 0: {
                return false;
            }
            case 31: 
            case 32: 
            case 86: 
            case 88: {
                Element element = view.documentPosition().element();
                return element != null && !view.readonly() && (!element.show() && !view.markList().protect(element) || view.block().view() == view && view.block().type() == 1 && view.block().anythingUnprotectedSelected());
            }
            case 92: 
            case 93: 
            case 97: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 134: 
            case 147: 
            case 201: 
            case 204: {
                Element element = view.documentPosition().element();
                return element != null && !view.readonly() && !element.show() && !view.markList().protect(element);
            }
            case 33: {
                Element element = view.documentPosition().element();
                return element != null && !view.readonly() && view.block().anythingSelected() && !view.markList().insertElementProtect(element);
            }
            case 34: 
            case 35: 
            case 36: 
            case 65: {
                return view.block().view() == view && !view.readonly() && view.block().anythingUnprotectedSelected();
            }
            case 7: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 99: 
            case 111: 
            case 141: 
            case 216: {
                return view.documentPosition().element() != null;
            }
            case 60: {
                return view.documentPosition().element() != null && !view.readonly() && view.block().anythingSelected() && !view.block().view().readonly();
            }
            case 61: {
                Element element = view.documentPosition().element();
                return element != null && !view.readonly() && !element.show() && view.block().anythingSelected() && (view.block().type() == 3 || view.block().type() == 4 || view.block().type() == 2 && view.block().topElement() == view.block().bottomElement()) && !view.markList().protect(element);
            }
            case 62: 
            case 63: {
                return view.block().view() == view && !view.readonly() && view.block().anythingUnprotectedSelected() && (view.block().type() == 3 || view.block().type() == 4 || view.block().type() == 2 && view.block().topElement() == view.block().bottomElement());
            }
            case 64: 
            case 107: 
            case 108: {
                return view.block().view() == view && view.block().anythingSelected();
            }
            case 67: {
                Element element = view.documentPosition().element();
                return element != null && !view.readonly();
            }
            case 4: 
            case 83: {
                if (ActionHandler.activeContext(view) == 4) {
                    return true;
                }
                return view.block().view() == view && view.block().anythingSelected();
            }
            case 69: {
                return !view.vi() && view.window() != null;
            }
            case 73: 
            case 76: 
            case 77: 
            case 78: {
                return view.compareSession();
            }
            case 3: 
            case 85: {
                if (ActionHandler.activeContext(view) == 4) {
                    return true;
                }
                return view.block().view() == view && !view.readonly() && view.block().anythingSelected() && !view.block().anythingProtectedSelected();
            }
            case 87: 
            case 90: 
            case 91: 
            case 140: 
            case 202: 
            case 203: 
            case 208: {
                return !view.readonly() && view.documentPosition().element() != null;
            }
            case 89: {
                Element element = view.documentPosition().element();
                return element != null && !view.readonly() && !view.markList().protect(element);
            }
            case 95: {
                Element element = view.documentPosition().element();
                return element != null && !view.readonly() && !element.show();
            }
            case 98: 
            case 102: 
            case 114: {
                return view.block().view() == view && view.block().topElement() == view.block().bottomElement() && view.block().anythingSelected();
            }
            case 103: {
                return view.window() != null;
            }
            case 104: {
                return view.window() != null && !view.readonly();
            }
            case 105: 
            case 106: {
                if (view.readonly()) {
                    return false;
                }
                String findText = FindTextCommand.findTextParameter().currentValue(view);
                return findText != null && findText.length() != 0;
            }
            case 109: {
                return view.document().undo().jumpAvailable();
            }
            case 110: {
                return view.markList().namedMarks();
            }
            case 112: 
            case 115: {
                String findText = FindTextCommand.findTextParameter().currentValue(view);
                return findText != null && findText.length() != 0;
            }
            case 113: {
                return view.markList().find("@QUICK") != null;
            }
            case 116: {
                if (view.readonly()) {
                    return false;
                }
                Element element = view.documentPosition().element();
                if (element != null) {
                    return element.show() ? !view.markList().insertElementProtect(element) : !view.markList().protect(element);
                }
                return true;
            }
            case 118: {
                return view.documentPosition().element() != null && view.window() != null;
            }
            case 130: {
                Element element = view.documentPosition().element();
                if (element == null) {
                    return false;
                }
                Element element2 = element.nextVisibleNonShow(view);
                return element2 != null && !view.readonly() && !element.show() && !element2.show() && !view.markList().protect(element) && !view.markList().protect(element2);
            }
            case 131: {
                return !KeyRecorder.keyRecorder().recording() && KeyRecorder.keyRecorder().anythingRecorded();
            }
            case 132: {
                return !KeyRecorder.keyRecorder().recording();
            }
            case 133: {
                return KeyRecorder.keyRecorder().recording();
            }
            case 135: 
            case 139: 
            case 207: {
                return !view.readonly() && view.documentPosition().element() != null && view.markList().find("@QUICK") != null;
            }
            case 143: {
                Element element = view.documentPosition().element();
                return element != null && element.next() != null;
            }
            case 148: 
            case 192: 
            case 193: 
            case 194: {
                Element element = view.documentPosition().element();
                return element != null && !view.readonly() && !view.markList().insertElementProtect(element);
            }
            case 5: 
            case 153: {
                if (ActionHandler.activeContext(view) == 4) {
                    return LpexUtilities.isTextInClipboard();
                }
                Element element = view.documentPosition().element();
                return element != null && !view.readonly() && !view.markList().insertElementProtect(element) && LpexUtilities.isTextInClipboard();
            }
            case 154: {
                Element element = view.documentPosition().element();
                return element != null && !view.readonly() && !element.show() && !view.markList().protect(element) && LpexUtilities.isTextInClipboard();
            }
            case 155: {
                return view.screen().pendingElement() != null;
            }
            case 10: 
            case 168: {
                return ActionHandler.defaultPrintActionAvailable();
            }
            case 169: {
                return view.compareSession() && ActionHandler.defaultPrintActionAvailable();
            }
            case 2: 
            case 171: {
                return !view.readonly() && view.document().undo().redoAvailable();
            }
            case 172: {
                return view.document().name() != null && view.document().name().length() > 0;
            }
            case 182: {
                return MessageLineParameter.getParameter().currentValue(view) && ((MessageLine)view.window().messageLine()).scrollLeftAvailable();
            }
            case 183: {
                return MessageLineParameter.getParameter().currentValue(view) && ((MessageLine)view.window().messageLine()).scrollRightAvailable();
            }
            case 191: {
                return view.includedClasses() != -1L || view.excludedClasses() != 0L;
            }
            case 195: {
                return view.window() != null;
            }
            case 1: 
            case 205: {
                return !view.readonly() && view.document().undo().undoAvailable();
            }
            case 209: {
                return view.documentPosition().element() != null && view.window() != null && (view.document()._sourceHebrew || view.document()._sourceArabic);
            }
            case 214: {
                return !view.readonly() && KillRing.killStringAvailable();
            }
            case 215: {
                return !view.readonly() && KillRing.killStringAvailable() && view.document().undo().lastChangeWasYank();
            }
        }
        return true;
    }

    static boolean defaultActionCheckable(int actionId) {
        switch (actionId) {
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 79: 
            case 80: {
                return true;
            }
        }
        return false;
    }

    static boolean defaultActionChecked(View view, int actionId) {
        switch (actionId) {
            case 71: {
                return CompareCommand.ignoreAllBlanksParameter().currentValue(view);
            }
            case 72: {
                return CompareCommand.ignoreCaseParameter().currentValue(view);
            }
            case 74: {
                return CompareCommand.ignoreCommentsParameter().currentValue(view);
            }
            case 75: {
                return CompareCommand.ignoreLeadingBlanksParameter().currentValue(view);
            }
            case 79: {
                return CompareCommand.ignoreSequenceNumbersParameter().currentValue(view);
            }
            case 80: {
                return CompareCommand.ignoreTrailingBlanksParameter().currentValue(view);
            }
        }
        return false;
    }

    static int doDefaultAction(View view, int actionId) {
        boolean reverse;
        boolean isCommandLine;
        boolean bl = isCommandLine = ActionHandler.activeContext(view) == 4;
        if (isCommandLine) {
            switch (actionId) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 37: 
                case 149: 
                case 152: {
                    return 0;
                }
            }
        }
        int rc = 3;
        Element element = view.documentPosition().element();
        int position = view.documentPosition().position();
        int repeat = view.actionHandler().repeat();
        boolean bl2 = reverse = repeat < 0;
        if (reverse) {
            repeat = -repeat;
        }
        block3 : switch (actionId) {
            case 30: {
                view.actionHandler().doDefaultActionAppendToActionArgument();
                break;
            }
            case 31: {
                if (repeat > 1) {
                    view.document().resetUserActionElements();
                }
                if (!reverse) {
                    String deleteText = view.backSpace(repeat);
                    if (deleteText.length() <= 1) break;
                    KillRing.prefaceKillString(view, deleteText);
                    break;
                }
                String deleteText = view.delete(repeat);
                if (deleteText.length() <= 1) break;
                KillRing.appendKillString(view, deleteText);
                break;
            }
            case 32: {
                if (element == null) break;
                if (!reverse) {
                    if (position == 1) {
                        repeat = 0;
                    } else {
                        max = position - 1;
                        if (repeat > max) {
                            repeat = max;
                        }
                    }
                } else if (position > element.length()) {
                    repeat = 0;
                } else {
                    max = element.length() - position + 1;
                    if (repeat > max) {
                        repeat = max;
                    }
                }
                if (repeat > 1) {
                    view.document().resetUserActionElements();
                }
                if (!reverse) {
                    String deleteText = view.backSpace(repeat);
                    if (deleteText.length() <= 1) break;
                    KillRing.prefaceKillString(view, deleteText);
                    break;
                }
                String deleteText = view.delete(repeat);
                if (deleteText.length() <= 1) break;
                KillRing.appendKillString(view, deleteText);
                break;
            }
            case 33: {
                if (reverse || element == null || !view.changeAllowed()) break;
                int i = 0;
                while (i < repeat) {
                    view.block().copy(view);
                    ++i;
                }
                break;
            }
            case 34: {
                if (view.block().view() != view) break;
                view.block().delete();
                break;
            }
            case 35: {
                if (view.block().view() != view || !view.block().anythingUnprotectedSelected() || !view.changeAllowed()) break;
                CommandHandler.setStatus(null);
                String label = LpexResources.message("commandLine.fillCharacter");
                InputCommand.doCommand(view, LpexStringTokenizer.addQuotes(label) + " " + LpexStringTokenizer.addQuotes("block fill "));
                break;
            }
            case 36: {
                if (view.block().view() != view || !view.changeAllowed()) break;
                view.block().lowerCase();
                break;
            }
            case 7: 
            case 37: {
                DocumentPosition documentPosition = view.documentPosition();
                Element originalElement = documentPosition.element();
                int originalPosition = documentPosition.position();
                int originalRow = view.screen().cursorRow();
                view.block().clear();
                documentPosition.top();
                view.block().set(2, view);
                documentPosition.bottom();
                view.block().set(2, view);
                documentPosition.jump(originalElement, originalPosition);
                view.screen().setCursorRow(originalRow);
                break;
            }
            case 216: {
                DocumentPosition documentPosition = view.documentPosition();
                view.block().clear();
                documentPosition.top();
                view.block().set(1, view);
                documentPosition.bottom();
                view.block().set(1, view);
                break;
            }
            case 38: {
                view.block().set(view);
                view.documentPosition().bottom();
                view.block().set(view);
                break;
            }
            case 39: {
                view.block().set(2, view);
                break;
            }
            case 40: {
                if (view.block().view() == null || view.block().view() == view) {
                    rc = 1;
                }
                view.block().set(view);
                int i = 0;
                while (i < repeat) {
                    if (!reverse) {
                        view.documentPosition().down();
                    } else {
                        view.documentPosition().up();
                    }
                    view.block().set(view);
                    ++i;
                }
                break;
            }
            case 41: {
                view.block().set(4, view);
                break;
            }
            case 42: {
                view.block().clear();
                view.actionHandler().setDocumentPositionToMouse(true);
                view.block().set(4, view);
                break;
            }
            case 43: {
                view.block().set(view);
                view.documentPosition().end();
                view.block().set(view);
                break;
            }
            case 44: {
                view.block().set(view);
                view.documentPosition().home();
                view.block().set(view);
                break;
            }
            case 45: {
                rc = ActionUtilities.doBlockMarkCharAction(view, repeat, reverse);
                break;
            }
            case 46: {
                WordActions.doBlockMarkWordAction(view, repeat, !reverse);
                break;
            }
            case 47: {
                view.block().set(view);
                int i = 0;
                while (i < repeat) {
                    if (reverse) {
                        view.documentPosition().pageUp();
                    } else {
                        view.documentPosition().pageDown();
                    }
                    view.block().set(view);
                    ++i;
                }
                break;
            }
            case 48: {
                if (element == null) break;
                if (view.block().type() == 4 || view.block().view() != view) {
                    view.block().clear();
                }
                if (view.block().type() == 0 && BlockCommand.DefaultTypeParameter.getParameter().currentValue(view) == 4) {
                    view.block().set(1, view);
                } else {
                    view.block().set(view);
                }
                int i = 0;
                while (i < repeat) {
                    if (!reverse) {
                        view.documentPosition().positionPageLeft();
                    } else {
                        view.documentPosition().positionPageRight();
                    }
                    view.block().set(view);
                    ++i;
                }
                break;
            }
            case 49: {
                if (element == null) break;
                if (view.block().type() == 4 || view.block().view() != view) {
                    view.block().clear();
                }
                if (view.block().type() == 0 && BlockCommand.DefaultTypeParameter.getParameter().currentValue(view) == 4) {
                    view.block().set(1, view);
                } else {
                    view.block().set(view);
                }
                int i = 0;
                while (i < repeat) {
                    if (reverse) {
                        view.documentPosition().positionPageLeft();
                    } else {
                        view.documentPosition().positionPageRight();
                    }
                    view.block().set(view);
                    ++i;
                }
                break;
            }
            case 50: {
                view.block().set(view);
                int i = 0;
                while (i < repeat) {
                    if (!reverse) {
                        view.documentPosition().pageUp();
                    } else {
                        view.documentPosition().pageDown();
                    }
                    view.block().set(view);
                    ++i;
                }
                break;
            }
            case 51: {
                WordActions.doBlockMarkWordAction(view, repeat, reverse);
                break;
            }
            case 52: {
                view.block().set(3, view);
                break;
            }
            case 53: {
                view.block().clear();
                view.actionHandler().setDocumentPositionToMouse(true);
                view.block().set(3, view);
                break;
            }
            case 54: {
                rc = ActionUtilities.doBlockMarkCharAction(view, repeat, !reverse);
                break;
            }
            case 55: {
                if (view.block().view() == null || view.block().view() == view) {
                    rc = 1;
                }
                view.block().set(view);
                view.actionHandler().setDocumentPositionToMouse(false);
                view.block().set(view);
                break;
            }
            case 56: {
                view.block().set(view);
                view.documentPosition().top();
                view.block().set(view);
                break;
            }
            case 57: {
                if (view.block().view() == null || view.block().view() == view) {
                    rc = 1;
                }
                view.block().set(view);
                int i = 0;
                while (i < repeat) {
                    if (!reverse) {
                        view.documentPosition().up();
                    } else {
                        view.documentPosition().down();
                    }
                    view.block().set(view);
                    ++i;
                }
                break;
            }
            case 58: {
                view.block().clear();
                view.documentPosition().right();
                view.documentPosition().prevWord();
                if (BlockCommand.DefaultTypeParameter.getParameter().currentValue(view) == 4) {
                    view.block().set(1, view);
                } else {
                    view.block().set(view);
                }
                if (view.block().type() == 1) {
                    view.documentPosition().nextWordEnd(1);
                } else {
                    view.documentPosition().nextWordEnd();
                }
                view.block().set(view);
                if (!view.documentPosition().above(element, position) && (view.block().type() != 1 || !view.documentPosition().equals(element, position))) break;
                view.block().clear();
                view.documentPosition().jump(element, position);
                break;
            }
            case 59: {
                view.actionHandler().setDocumentPositionToMouse(true);
                view.actionHandler().doAction(58);
                break;
            }
            case 60: {
                if (element == null || !view.changeAllowed()) break;
                view.block().move(view);
                break;
            }
            case 61: {
                if (element == null || !view.changeAllowed()) break;
                view.block().overlay(view);
                break;
            }
            case 62: {
                BlockCommand.doCommand(view, "shift left " + view.actionHandler().repeat());
                break;
            }
            case 63: {
                BlockCommand.doCommand(view, "shift right " + view.actionHandler().repeat());
                break;
            }
            case 64: {
                if (view.block().view() != view) break;
                view.block().clear();
                break;
            }
            case 65: {
                if (view.block().view() != view || !view.changeAllowed()) break;
                view.block().upperCase();
                break;
            }
            case 66: {
                ActionUtilities.doDefaultAction(view, 188);
                view.documentPosition().documentBottom();
                break;
            }
            case 67: {
                if (element == null || !view.changeAllowed()) break;
                view.document().resetUserActionElements();
                if (!reverse) {
                    boolean moveToNextWord = true;
                    if (!element.show()) {
                        char c;
                        String text = element.text();
                        if (position >= 1 && position <= text.length() && (c = text.charAt(position - 1)) != ' ' && c != '\t') {
                            moveToNextWord = false;
                        }
                    }
                    if (moveToNextWord && !view.documentPosition().nextWord()) {
                        repeat = 0;
                    }
                }
                int i = 0;
                while (i < repeat) {
                    if (reverse) {
                        if (view.documentPosition().prevWord()) {
                            view.toTitleCase();
                        } else {
                            repeat = 0;
                        }
                    } else {
                        view.toTitleCase();
                        if (!view.documentPosition().nextWord()) {
                            repeat = 0;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 68: {
                element = view.document().elementList().first();
                while (element != null) {
                    element.elementView(view).setPrefixText(null);
                    element = element.next();
                }
                break;
            }
            case 69: {
                if (view.vi() || view.window() == null) break;
                CommandLine commandLine = (CommandLine)view.window().commandLine();
                commandLine.setForceVisible(true);
                commandLine.setMode(0);
                view.window().commandLineRequestFocus();
                break;
            }
            case 70: {
                CompareCommand.doCommand(view, "prompt");
                break;
            }
            case 71: {
                CompareCommand.IgnoreAllBlanksParameter p = CompareCommand.ignoreAllBlanksParameter();
                p.setValue(view, p.currentValue(view) ? 0 : 1);
                CompareCommand.compareRefresh(view);
                break;
            }
            case 72: {
                CompareCommand.IgnoreCaseParameter p = CompareCommand.ignoreCaseParameter();
                p.setValue(view, p.currentValue(view) ? 0 : 1);
                CompareCommand.compareRefresh(view);
                break;
            }
            case 73: {
                CompareCommand.doCommand(view, "clear");
                break;
            }
            case 74: {
                CompareCommand.IgnoreCommentsParameter p = CompareCommand.ignoreCommentsParameter();
                p.setValue(view, p.currentValue(view) ? 0 : 1);
                CompareCommand.compareRefresh(view);
                break;
            }
            case 75: {
                CompareCommand.IgnoreLeadingBlanksParameter p = CompareCommand.ignoreLeadingBlanksParameter();
                p.setValue(view, p.currentValue(view) ? 0 : 1);
                CompareCommand.compareRefresh(view);
                break;
            }
            case 76: {
                int i = 0;
                while (i < repeat) {
                    CompareCommand.doCommand(view, reverse ? "previous" : "next");
                    ++i;
                }
                break;
            }
            case 77: {
                int i = 0;
                while (i < repeat) {
                    CompareCommand.doCommand(view, reverse ? "next" : "previous");
                    ++i;
                }
                break;
            }
            case 78: {
                CompareCommand.compareRefresh(view);
                break;
            }
            case 79: {
                CompareCommand.IgnoreSequenceNumbersParameter p = CompareCommand.ignoreSequenceNumbersParameter();
                p.setValue(view, p.currentValue(view) ? 0 : 1);
                CompareCommand.compareRefresh(view);
                break;
            }
            case 80: {
                CompareCommand.IgnoreTrailingBlanksParameter p = CompareCommand.ignoreTrailingBlanksParameter();
                p.setValue(view, p.currentValue(view) ? 0 : 1);
                CompareCommand.compareRefresh(view);
                break;
            }
            case 81: {
                if (element == null) break;
                view.setInPrefix(false);
                String text = element.text();
                int i = text.length() - 1;
                while (i >= 0 && (text.charAt(i) == ' ' || text.charAt(i) == '\t')) {
                    --i;
                }
                if (++i == text.length() || view.documentPosition().position() == i + 1) {
                    view.documentPosition().end();
                    break;
                }
                view.documentPosition().jump(i + 1);
                break;
            }
            case 82: {
                if (element == null) break;
                view.setInPrefix(false);
                String text = element.text();
                int i = 0;
                while (i < text.length() && (text.charAt(i) == ' ' || text.charAt(i) == '\t')) {
                    ++i;
                }
                if (++i == 1 || view.documentPosition().position() == i) {
                    view.documentPosition().home();
                    break;
                }
                view.screen().setScroll(0);
                view.documentPosition().jump(i);
                break;
            }
            case 4: 
            case 83: {
                if (view.block().view() != view) break;
                view.block().copyToClipboard();
                break;
            }
            case 84: {
                view.actionHandler().setDocumentPositionToMouse(true);
                break;
            }
            case 3: 
            case 85: {
                if (view.block().view() != view || !view.changeAllowed()) break;
                view.block().cutToClipboard();
                break;
            }
            case 86: {
                if (repeat > 1) {
                    view.document().resetUserActionElements();
                }
                if (!reverse) {
                    String deleteText = view.delete(repeat);
                    if (deleteText.length() <= 1) break;
                    KillRing.appendKillString(view, deleteText);
                    break;
                }
                String deleteText = view.backSpace(repeat);
                if (deleteText.length() <= 1) break;
                KillRing.prefaceKillString(view, deleteText);
                break;
            }
            case 88: {
                if (element == null) break;
                if (!reverse) {
                    if (position > element.length()) {
                        repeat = 0;
                    } else {
                        max = element.length() - position + 1;
                        if (repeat > max) {
                            repeat = max;
                        }
                    }
                } else if (position == 1) {
                    repeat = 0;
                } else {
                    max = position - 1;
                    if (repeat > max) {
                        repeat = max;
                    }
                }
                if (repeat > 1) {
                    view.document().resetUserActionElements();
                }
                if (!reverse) {
                    String deleteText = view.delete(repeat);
                    if (deleteText.length() <= 1) break;
                    KillRing.appendKillString(view, deleteText);
                    break;
                }
                String deleteText = view.backSpace(repeat);
                if (deleteText.length() <= 1) break;
                KillRing.prefaceKillString(view, deleteText);
                break;
            }
            case 87: {
                if (element == null || !view.changeAllowed()) break;
                boolean solitaryBlankLine = false;
                if (!element.show() && element.text().trim().length() == 0) {
                    solitaryBlankLine = true;
                    Element prevElement = element.prevVisibleNonShow(view);
                    while (prevElement != null && prevElement.text().trim().length() == 0 && !view.markList().protect(prevElement)) {
                        solitaryBlankLine = false;
                        view.deleteElement(prevElement);
                        prevElement = element.prevVisibleNonShow(view);
                    }
                }
                Element nextElement = element.nextVisibleNonShow(view);
                while (nextElement != null && nextElement.text().trim().length() == 0 && !view.markList().protect(nextElement)) {
                    solitaryBlankLine = false;
                    view.deleteElement(nextElement);
                    nextElement = element.nextVisibleNonShow(view);
                }
                if (!solitaryBlankLine || view.markList().protect(element)) break;
                Element beforeFirst = element.prev();
                Element afterLast = element.next();
                view.deleteElement(element);
                ProcessPrefixCommand.coalesceExcludes(view, beforeFirst, afterLast);
                break;
            }
            case 89: {
                if (element == null || reverse) break;
                Element visibleBeforeFirst = element.prevVisible(view);
                Element beforeFirst = element.prev();
                Element afterLast = null;
                StringBuilder deleteText = new StringBuilder(160);
                int i = 0;
                while (i < repeat) {
                    element = view.documentPosition().element();
                    if (element == visibleBeforeFirst) break;
                    if (element != null && (element.show() || view.changeAllowed())) {
                        afterLast = element.next();
                        if (!element.show()) {
                            deleteText.append('\n').append(element.text());
                        }
                        view.deleteElement(element);
                    }
                    ++i;
                }
                KillRing.appendKillString(view, deleteText.toString());
                ProcessPrefixCommand.coalesceExcludes(view, beforeFirst, afterLast);
                break;
            }
            case 90: {
                if (element == null || !view.changeAllowed()) break;
                view.document().resetUserActionElements();
                if (element.show()) {
                    if (reverse) {
                        if ((element = element.prevVisibleNonShow(view)) != null) {
                            position = element.end();
                        }
                    } else {
                        element = element.nextVisibleNonShow(view);
                        position = 1;
                    }
                    view.documentPosition().jump(element, position);
                }
                int i = 0;
                while (i < repeat) {
                    if (reverse) {
                        if (!view.documentPosition().prevWord()) {
                            repeat = 0;
                        }
                    } else if (!view.documentPosition().nextWordEnd(1)) {
                        repeat = 0;
                    }
                    ++i;
                }
                String deleteText = view.deleteText(element, position, view.documentPosition().element(), view.documentPosition().position());
                if (reverse) {
                    KillRing.prefaceKillString(view, deleteText);
                    break;
                }
                KillRing.appendKillString(view, deleteText);
                break;
            }
            case 91: {
                if (element == null || !view.changeAllowed()) break;
                view.document().resetUserActionElements();
                if (element.show()) {
                    if (!reverse) {
                        if ((element = element.prevVisibleNonShow(view)) != null) {
                            position = element.end();
                        }
                    } else {
                        element = element.nextVisibleNonShow(view);
                        position = 1;
                    }
                    view.documentPosition().jump(element, position);
                }
                int i = 0;
                while (i < repeat) {
                    if (!reverse) {
                        if (!view.documentPosition().prevWord()) {
                            repeat = 0;
                        }
                    } else if (!view.documentPosition().nextWordEnd(1)) {
                        repeat = 0;
                    }
                    ++i;
                }
                String deleteText = view.deleteText(element, position, view.documentPosition().element(), view.documentPosition().position());
                if (!reverse) {
                    KillRing.prefaceKillString(view, deleteText);
                    break;
                }
                KillRing.appendKillString(view, deleteText);
                break;
            }
            case 92: {
                if (element == null || element.show() || view.markList().protect(element) || !view.changeAllowed()) break;
                String deleteText = null;
                if (position > 1 && element.length() >= position) {
                    deleteText = view.deleteText(element, 1, position - 1);
                }
                KillRing.prefaceKillString(view, deleteText);
                break;
            }
            case 93: {
                String text;
                if (element == null || element.show() || view.markList().protect(element) || !view.changeAllowed() || (text = element.text()).length() <= 0) break;
                if (position > text.length()) {
                    position = text.length() + 1;
                    view.documentPosition().end();
                }
                while (position > 1) {
                    char c = text.charAt(position - 2);
                    if (c != ' ' && c != '\t') break;
                    --position;
                }
                int len = 0;
                while (position + len <= text.length()) {
                    char c = text.charAt(position + len - 1);
                    if (c != ' ' && c != '\t') break;
                    ++len;
                }
                if (len <= 0) break;
                view.deleteText(element, position, len);
                break;
            }
            case 94: {
                if (reverse) {
                    view.documentPosition().up(repeat);
                } else {
                    view.documentPosition().down(repeat);
                }
                rc = 1;
                break;
            }
            case 95: {
                if (element == null || element.show() || view.markList().protect(element) || !view.changeAllowed()) break;
                String text = "\n" + element.text();
                int originalPosition = view.documentPosition().position();
                view.documentPosition().end();
                view.setIgnoreFields();
                int i = 0;
                while (i < repeat) {
                    view.insertText(text);
                    ++i;
                }
                view.resetIgnoreFields();
                Element duplicatedElement = element.nextNonShow();
                view.documentPosition().jump(duplicatedElement, originalPosition, true, false);
                break;
            }
            case 96: {
                view.documentPosition().end();
                break;
            }
            case 98: {
                String findText = view.block().selectedText();
                if (findText == null) break;
                int index = findText.indexOf(10);
                if (index != -1) {
                    findText = findText.substring(0, index);
                }
                if (findText.length() == 0) break;
                FindTextCommand.FindTextParameter ft = FindTextCommand.findTextParameter();
                FindTextCommand.RegularExpressionParameter regex = FindTextCommand.regularExpressionParameter();
                String oldFindText = ft.value(view);
                int oldRegex = regex.value(view);
                ft.setValue(view, findText);
                regex.setValue(view, 0);
                FindTextCommand.doCommand(view, "exclude all");
                regex.setValue(view, oldRegex);
                ft.setValue(view, oldFindText);
                break;
            }
            case 99: {
                String text;
                if (element == null || (text = element.text()).length() == 0) break;
                view.commandHandler().doCommand(text);
                break;
            }
            case 100: {
                if (view.actionHandler().mouseInTopExpandHideHeader()) {
                    view.setTopExpanded(!view.topExpanded());
                    view.documentPosition().top();
                } else {
                    ElementView elementView;
                    view.actionHandler().setDocumentPositionToMouse(true);
                    element = view.documentPosition().element();
                    if (element != null && (elementView = element.elementView(view)).expandHideHeader()) {
                        elementView.setExpanded(!elementView.expanded());
                    }
                }
                Screen screen = view.screen();
                if (screen == null) break;
                screen.show();
                break;
            }
            case 102: {
                String findText = view.block().selectedText();
                if (findText == null) break;
                int index = findText.indexOf(10);
                if (index != -1) {
                    findText = findText.substring(0, index);
                }
                if (findText.length() == 0) break;
                FindTextCommand.FindTextParameter ft = FindTextCommand.findTextParameter();
                FindTextCommand.RegularExpressionParameter regex = FindTextCommand.regularExpressionParameter();
                ft.setDefaultValue(findText);
                regex.setDefaultValue(0);
                ft.setValue(view, findText);
                regex.setValue(view, 0);
                FindTextCommand.doCommand(view, "all", "filterSelection");
                view.screen().show();
                break;
            }
            case 101: {
                ElementList elementList = view.document().elementList();
                int textLimit = elementList.textLimit();
                if (textLimit != 0) {
                    boolean usingSourceColumns = LpexNls.usingSourceColumns(view.document());
                    boolean isSmartLogical = view.nls().isSmartLogical();
                    boolean trim = SaveCommand.TrimParameter.getParameter().currentValue(view);
                    element = elementList.first();
                    while (element != null) {
                        if (!element.show()) {
                            if (elementList.saveLength(element, usingSourceColumns, isSmartLogical, trim) > textLimit) {
                                element.elementView(view).setClasses(0x2000000000000000L);
                            } else {
                                element.elementView(view).clearClasses(0x2000000000000000L);
                            }
                        }
                        element = element.next();
                    }
                } else {
                    element = elementList.first();
                    while (element != null) {
                        if (!element.show()) {
                            element.elementView(view).clearClasses(0x2000000000000000L);
                        }
                        element = element.next();
                    }
                }
                view.setIncludedClasses(0x2000000000000000L);
                view.setExcludedClasses(0L);
                break;
            }
            case 103: {
                if (view.window() == null) break;
                CommandLine commandLine = (CommandLine)view.window().commandLine();
                if (commandLine.getMode() == 1) {
                    String findText = FindTextCommand.findTextParameter().currentValue(view);
                    if (findText == null || findText.length() == 0) break;
                    view.commandHandler().doCommand("findText");
                    break;
                }
                commandLine.setForceVisible(true);
                commandLine.setMode(1);
                view.window().commandLineRequestFocus();
                break;
            }
            case 104: {
                if (view.window() == null || view.readonly()) break;
                CommandLine commandLine = (CommandLine)view.window().commandLine();
                if (commandLine.getMode() == 2) {
                    String findText = FindTextCommand.findTextParameter().currentValue(view);
                    if (findText == null || findText.length() == 0) break;
                    view.commandHandler().doCommand("findText");
                    break;
                }
                commandLine.setForceVisible(true);
                commandLine.setMode(2);
                view.window().commandLineRequestFocus();
                break;
            }
            case 105: {
                String findText = FindTextCommand.findTextParameter().currentValue(view);
                if (findText == null || findText.length() == 0 || !view.changeAllowed()) break;
                int i = 0;
                while (i < repeat) {
                    view.commandHandler().doCommand("findText " + (reverse ? "replace up" : "checkStart replace"));
                    ++i;
                }
                break;
            }
            case 106: {
                String findText = FindTextCommand.findTextParameter().currentValue(view);
                if (findText == null || findText.length() == 0 || !view.changeAllowed()) break;
                int i = 0;
                while (i < repeat) {
                    view.commandHandler().doCommand("findText " + (reverse ? "checkStart replace" : "replace up"));
                    ++i;
                }
                break;
            }
            case 107: {
                view.setInPrefix(false);
                view.documentPosition().blockBottom();
                if (view.window() == null) break;
                view.window().textWindowRequestFocus();
                break;
            }
            case 108: {
                view.setInPrefix(false);
                view.documentPosition().blockTop();
                if (view.window() == null) break;
                view.window().textWindowRequestFocus();
                break;
            }
            case 109: {
                view.setInPrefix(false);
                view.document().undo().jump(view);
                if (view.window() == null) break;
                view.window().textWindowRequestFocus();
                break;
            }
            case 110: {
                if (view.window() == null) break;
                CommandLine commandLine = (CommandLine)view.window().commandLine();
                commandLine.setForceVisible(true);
                commandLine.setMode(3);
                view.window().commandLineRequestFocus();
                break;
            }
            case 111: {
                view.ensureIsParsed();
                LpexDocumentLocation loc = view.lpexView().documentLocation();
                LpexDocumentLocation match = LpexMatch.match(view.lpexView(), loc, true);
                if (match == null || match.element == loc.element && match.position == loc.position) break;
                view.documentPosition().jump(match);
                break;
            }
            case 112: {
                String findText = FindTextCommand.findTextParameter().currentValue(view);
                if (findText == null || findText.length() == 0) break;
                int i = 0;
                while (i < repeat) {
                    view.commandHandler().doCommand("findText" + (reverse ? " up" : ""));
                    ++i;
                }
                break;
            }
            case 113: {
                view.setInPrefix(false);
                boolean prevQuickMark = view.markList().find("@QUICK") != null;
                DocumentPosition.Preserve preservedPosition1 = view.documentPosition().preserve();
                LocateCommand.doCommand(view, "mark @QUICK");
                DocumentPosition.Preserve preservedPosition2 = view.documentPosition().preserve();
                preservedPosition1.restore();
                SetCommand.doCommand(view, "mark.@QUICK");
                view.setLpexMessageText(prevQuickMark ? "mark.quickMarkSetPrev" : "mark.quickMarkSet");
                preservedPosition2.restore();
                view.documentPosition().disposePreserve(preservedPosition1);
                view.documentPosition().disposePreserve(preservedPosition2);
                if (view.window() == null) break;
                view.window().textWindowRequestFocus();
                break;
            }
            case 114: {
                String findText = view.block().selectedText();
                if (findText == null) break;
                int index = findText.indexOf(10);
                if (index != -1) {
                    findText = findText.substring(0, index);
                }
                if (findText.length() == 0) break;
                FindTextCommand.FindTextParameter ft = FindTextCommand.findTextParameter();
                FindTextCommand.RegularExpressionParameter regex = FindTextCommand.regularExpressionParameter();
                ft.setDefaultValue(findText);
                regex.setDefaultValue(0);
                ft.setValue(view, findText);
                regex.setValue(view, 0);
                int i = 0;
                while (i < repeat) {
                    view.commandHandler().doCommand("findText" + (reverse ? " up" : ""));
                    ++i;
                }
                break;
            }
            case 115: {
                String findText = FindTextCommand.findTextParameter().currentValue(view);
                if (findText == null || findText.length() == 0) break;
                int i = 0;
                while (i < repeat) {
                    view.commandHandler().doCommand("findText" + (reverse ? "" : " up"));
                    ++i;
                }
                break;
            }
            case 116: {
                boolean actionAvailable = true;
                if (element != null) {
                    if (element.show()) {
                        if (view.markList().insertElementProtect(element)) {
                            actionAvailable = false;
                        }
                    } else if (view.markList().protect(element)) {
                        actionAvailable = false;
                    }
                }
                if (!actionAvailable || !view.changeAllowed()) break;
                view.commandHandler().doCommand("get prompt \"" + view.document().name() + "\"");
                break;
            }
            case 117: {
                view.setLpexMessageText("action.notAvailable", "help");
                break;
            }
            case 118: {
                view.actionHandler().doDefaultActionHexEditLine();
                break;
            }
            case 119: {
                view.setInPrefix(false);
                view.documentPosition().home();
                break;
            }
            case 120: {
                int i;
                if (element == null || element.show() || view.markList().protect(element) || !view.changeAllowed()) break;
                int desiredIndentPosition = 1;
                String indentString = null;
                Element prevElement = element.prevNonShow();
                while (prevElement != null) {
                    String p = prevElement.text();
                    if (p.trim().length() > 0) {
                        i = 0;
                        while (p.charAt(i) == ' ' || p.charAt(i) == '\t') {
                            ++i;
                        }
                        indentString = p.substring(0, i);
                        desiredIndentPosition = view.displayColumn(prevElement.elementView(view), i + 1);
                        break;
                    }
                    prevElement = prevElement.prevNonShow();
                }
                String t = element.text();
                i = 0;
                while (i < t.length() && (t.charAt(i) == ' ' || t.charAt(i) == '\t')) {
                    ++i;
                }
                int indentPosition = view.displayColumn(element.elementView(view), i + 1);
                if (indentPosition == desiredIndentPosition) break;
                int savedDisplayPosition = view.displayColumn(element.elementView(view), position);
                if (i > 0) {
                    view.deleteText(element, 1, i);
                }
                if (desiredIndentPosition > 1) {
                    view.insertText(element, 1, indentString);
                }
                position = view.positionFromDisplayPosition(element.elementView(view), savedDisplayPosition);
                view.documentPosition().jump(position);
                break;
            }
            case 97: 
            case 121: {
                if (reverse || element == null || element.show() || view.markList().protect(element) || !view.changeAllowed()) break;
                char c = new DecimalFormatSymbols().getDecimalSeparator();
                int i = 0;
                while (i < repeat) {
                    view.receiveCharacter(c);
                    ++i;
                }
                break;
            }
            case 123: 
            case 125: 
            case 126: 
            case 128: {
                if (reverse || element == null || element.show() || view.markList().protect(element) || !view.changeAllowed()) break;
                String c = actionId == 123 ? "{" : (actionId == 125 ? "\u00ac" : (actionId == 126 ? "}" : (actionId == 128 ? "\t" : "")));
                int i = 0;
                while (i < repeat) {
                    view.insertText(c);
                    ++i;
                }
                break;
            }
            case 124: 
            case 127: {
                if (reverse || element == null || element.show() || view.markList().protect(element) || !view.changeAllowed()) break;
                String c = actionId == 124 ? "\u200e" : (actionId == 127 ? "\u200f" : "");
                boolean ignoreFields = view.nls().isIgnoringBidiMarks();
                if (ignoreFields) {
                    view.setIgnoreFields();
                }
                int i = 0;
                while (i < repeat) {
                    view.insertText(c);
                    ++i;
                }
                if (!ignoreFields) break;
                view.resetIgnoreFields();
                break;
            }
            case 122: {
                if (reverse) break;
                String text = view.document().name();
                if (element == null || element.show() || view.markList().protect(element) || text == null || text.length() <= 0 || !view.changeAllowed()) break;
                int i = 0;
                while (i < repeat) {
                    view.insertText(text);
                    ++i;
                }
                break;
            }
            case 129: {
                if (view.insertMode() && element != null && !element.show() && !view.markList().protect(element) && view.changeAllowed()) {
                    int displayPosition = view.displayColumn(element.elementView(view), position);
                    TabsParameter.Settings tabs = TabsParameter.getParameter().currentValue(view);
                    int tabStop = 1;
                    if (tabs._tabStops != null) {
                        int i = 0;
                        while (tabStop <= displayPosition && i < tabs._tabStops.length) {
                            tabStop = tabs._tabStops[i];
                            ++i;
                        }
                    }
                    if (tabStop <= displayPosition && tabs._tabIncrement > 0) {
                        while (tabStop <= displayPosition) {
                            tabStop += tabs._tabIncrement;
                        }
                    }
                    if (tabStop <= displayPosition) break;
                    int len = tabStop - displayPosition;
                    StringBuilder buffer = new StringBuilder(len);
                    int i = 0;
                    while (i < len) {
                        buffer.append(' ');
                        ++i;
                    }
                    view.insertText(buffer.toString());
                    break;
                }
                view.documentPosition().nextTabStop();
                break;
            }
            case 130: {
                if (reverse || element == null || element.show() || view.markList().protect(element) || !view.changeAllowed()) break;
                int i = 0;
                while (i < repeat) {
                    Element element2 = element.nextVisibleNonShow(view);
                    if (element2 != null && !element2.show() && !view.markList().protect(element2)) {
                        view.padTextTo(element, position);
                        view.joinElements(element, element2);
                    }
                    ++i;
                }
                break;
            }
            case 131: {
                if (reverse) break;
                int i = 0;
                while (i < repeat) {
                    KeyRecorder.keyRecorder().play(view);
                    ++i;
                }
                break;
            }
            case 132: {
                KeyRecorder.keyRecorder().setRecording(true);
                KeyRecorder.keyRecorder().clear();
                break;
            }
            case 133: {
                KeyRecorder.keyRecorder().setRecording(false);
                break;
            }
            case 134: {
                if (element == null || element.show() || view.markList().protect(element) || !view.changeAllowed()) break;
                view.document().resetUserActionElements();
                Object deleteText = "";
                String text = element.text();
                if (view.actionHandler().argument() == null || view.actionHandler().argument().length() == 0) {
                    if (text.length() >= position) {
                        deleteText = view.deleteText(element, position, text.length() - position + 1);
                    } else {
                        Element nextElement = element.nextVisibleNonShow(view);
                        if (nextElement != null && !view.markList().protect(nextElement)) {
                            view.padTextTo(element, position);
                            view.joinElements(element, nextElement);
                            deleteText = "\n";
                        }
                    }
                    KillRing.appendKillString(view, (String)deleteText);
                    break;
                }
                if (!reverse && repeat > 0) {
                    StringBuilder dt = new StringBuilder();
                    int i = 0;
                    while (i < repeat) {
                        Element nextElement;
                        text = element.text();
                        if (text.length() >= position) {
                            dt.append(view.deleteText(element, position, text.length() - position + 1));
                        }
                        if ((nextElement = element.nextVisibleNonShow(view)) == null || view.markList().protect(nextElement)) break;
                        view.padTextTo(element, position);
                        view.joinElements(element, nextElement);
                        dt.append("\n");
                        ++i;
                    }
                    deleteText = (String)deleteText + dt.toString();
                    KillRing.appendKillString(view, (String)deleteText);
                    break;
                }
                if (text != null && text.length() > 0 && position > 1) {
                    deleteText = view.deleteText(element, 1, position - 1);
                }
                int i = 0;
                while (i < repeat && element != null) {
                    Element prevElement = element.prevVisibleNonShow(view);
                    if (prevElement != null) {
                        text = prevElement.text();
                        deleteText = view.deleteText(prevElement, 1, text.length()) + "\n" + (String)deleteText;
                        view.joinElements(prevElement, element);
                    }
                    element = prevElement;
                    ++i;
                }
                KillRing.prefaceKillString(view, (String)deleteText);
                break;
            }
            case 135: {
                MarkList.Mark quickMark = view.markList().find("@QUICK");
                if (quickMark == null || element == null || !view.changeAllowed()) break;
                view.document().resetUserActionElements();
                Element quickMarkElement = quickMark.element1();
                int quickMarkPosition = quickMark.position1();
                boolean forward = view.documentPosition().above(quickMarkElement, quickMarkPosition);
                String deleteText = view.deleteText(element, position, quickMarkElement, quickMarkPosition);
                if (forward) {
                    KillRing.appendKillString(view, deleteText);
                    break;
                }
                KillRing.prefaceKillString(view, deleteText);
                break;
            }
            case 136: {
                if (!reverse) {
                    if (view.screen().currentPrefixArea() && repeat >= position) {
                        view.documentPosition().home();
                        view.setInPrefix(true);
                        view.documentPosition().prefixEnd();
                    } else {
                        view.documentPosition().arrowLeft(repeat);
                    }
                } else {
                    view.documentPosition().arrowRight(repeat);
                }
                rc = 1;
                break;
            }
            case 137: {
                String label = LpexResources.message("commandLine.lineNumber");
                InputCommand.doCommand(view, LpexStringTokenizer.addQuotes(label) + " " + LpexStringTokenizer.addQuotes("locate emphasis line "));
                break;
            }
            case 138: {
                if (view.document().elementList().sequenceNumbersNumWidth() > 0 && view.screen().currentPrefixArea() && PrefixAreaTextParameter.getParameter().currentValue(view) == 2) {
                    int n = 0;
                    if (element != null) {
                        if (element.show()) {
                            element = element.prevNonShow();
                        }
                        if (element != null) {
                            n = element.sequenceNumber();
                        }
                    }
                    Object sequenceNumber = String.valueOf(n);
                    int width = view.document().elementList().sequenceNumbersNumWidth();
                    while (((String)sequenceNumber).length() < width) {
                        sequenceNumber = "0" + (String)sequenceNumber;
                    }
                    while (((String)sequenceNumber).length() > width) {
                        sequenceNumber = ((String)sequenceNumber).substring(1);
                    }
                    String label = LpexResources.message("commandLine.sequenceNumber");
                    InputCommand.doCommand(view, LpexStringTokenizer.addQuotes(label) + " " + LpexStringTokenizer.addQuotes((String)sequenceNumber) + " " + LpexStringTokenizer.addQuotes("locate emphasis sequenceNumber "));
                    break;
                }
                String label = LpexResources.message("commandLine.lineNumber");
                InputCommand.doCommand(view, LpexStringTokenizer.addQuotes(label) + " " + LpexStringTokenizer.addQuotes("locate emphasis line "));
                break;
            }
            case 140: {
                if (element == null || !view.changeAllowed()) break;
                view.document().resetUserActionElements();
                if (!reverse) {
                    boolean moveToNextWord = true;
                    if (!element.show()) {
                        char c;
                        String text = element.text();
                        if (position >= 1 && position <= text.length() && (c = text.charAt(position - 1)) != ' ' && c != '\t') {
                            moveToNextWord = false;
                        }
                    }
                    if (moveToNextWord && !view.documentPosition().nextWord()) {
                        repeat = 0;
                    }
                }
                int i = 0;
                while (i < repeat) {
                    element = view.documentPosition().element();
                    position = view.documentPosition().position();
                    if (reverse) {
                        if (view.documentPosition().prevWord()) {
                            int wordLength = element == view.documentPosition().element() ? position - view.documentPosition().position() : view.documentPosition().element().length() - view.documentPosition().position() + 1;
                            view.changeCase(wordLength, false);
                        } else {
                            repeat = 0;
                        }
                    } else {
                        int wordLength = ElementList.nextWordEnd(element, position - 1) - position + 1;
                        view.changeCase(wordLength, false);
                        if (!view.documentPosition().nextWord()) {
                            repeat = 0;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 139: {
                MarkList.Mark quickMark = view.markList().find("@QUICK");
                if (quickMark == null || element == null || !view.changeAllowed()) break;
                view.document().resetUserActionElements();
                view.changeCase(element, position, quickMark.element1(), quickMark.position1(), false);
                break;
            }
            case 141: {
                view.ensureIsParsed();
                LpexDocumentLocation loc = view.lpexView().documentLocation();
                LpexDocumentLocation match = LpexMatch.match(view.lpexView(), loc, true);
                if (match == null || match.element == loc.element && match.position == loc.position) break;
                view.block().clear();
                view.block().set(2, view);
                view.commandHandler().doCommand(match, "block set");
                break;
            }
            case 142: {
                CommandHandler.setStatus(null);
                String label = LpexResources.message("commandLine.nameMark");
                InputCommand.doCommand(view, LpexStringTokenizer.addQuotes(label) + " " + LpexStringTokenizer.addQuotes("set mark."));
                break;
            }
            case 143: {
                if (reverse) {
                    view.documentPosition().up(repeat);
                } else {
                    view.documentPosition().down(repeat);
                }
                view.documentPosition().home();
                break;
            }
            case 144: {
                int i = 0;
                while (i < repeat) {
                    if (reverse) {
                        if (view.documentPosition().position() > 1) {
                            view.documentPosition().prevTabStop();
                        } else {
                            view.documentPosition().home();
                            if (view.screen().currentPrefixArea()) {
                                view.setInPrefix(true);
                                view.documentPosition().prefixHome();
                            }
                        }
                    } else {
                        view.documentPosition().nextTabStop();
                    }
                    ++i;
                }
                break;
            }
            case 145: {
                int i = 0;
                while (i < repeat) {
                    if (reverse) {
                        WordActions.prevWord(view, element, position);
                    } else {
                        WordActions.nextWord(view, element, position);
                    }
                    ++i;
                }
                break;
            }
            case 146: {
                break;
            }
            case 147: {
                if (element == null || element.show() || view.markList().protect(element) || !view.changeAllowed()) break;
                ActionUtilities.doDefaultAction(view, 93);
                view.insertText(" ");
                break;
            }
            case 148: {
                if (view.markList().insertElementProtect(element) || !view.changeAllowed()) break;
                int i = 0;
                while (i < repeat) {
                    if (reverse) {
                        view.documentPosition().home();
                    } else {
                        view.documentPosition().end();
                    }
                    view.splitElement();
                    ++i;
                }
                break;
            }
            case 149: {
                int i = 0;
                while (i < repeat) {
                    if (!reverse) {
                        view.documentPosition().pageDown();
                    } else {
                        view.documentPosition().pageUp();
                    }
                    ++i;
                }
                break;
            }
            case 150: {
                int i = 0;
                while (i < repeat) {
                    if (reverse) {
                        view.documentPosition().positionPageRight();
                    } else {
                        view.documentPosition().positionPageLeft();
                    }
                    ++i;
                }
                break;
            }
            case 151: {
                int i = 0;
                while (i < repeat) {
                    if (!reverse) {
                        view.documentPosition().positionPageRight();
                    } else {
                        view.documentPosition().positionPageLeft();
                    }
                    ++i;
                }
                break;
            }
            case 152: {
                int i = 0;
                while (i < repeat) {
                    if (reverse) {
                        view.documentPosition().pageDown();
                    } else {
                        view.documentPosition().pageUp();
                    }
                    ++i;
                }
                break;
            }
            case 155: {
                ProcessPrefixCommand.locatePendingCommand(view.lpexView());
                break;
            }
            case 156: {
                view.actionHandler().doDefaultActionPopupAtCursor();
                break;
            }
            case 157: {
                view.actionHandler().doDefaultActionPopupAtMouse();
                break;
            }
            case 5: 
            case 153: {
                ActionUtilities.doPasteAction(view, LpexUtilities.getClipboardContents());
                break;
            }
            case 154: {
                String text;
                if (element == null || !view.changeAllowed() || element.show() || view.markList().protect(element) || (text = LpexUtilities.getClipboardContents()) == null) break;
                if (text.indexOf(13) >= 0) {
                    text = text.replaceAll("\\r\\n|\\r", "\n");
                }
                view.setIgnoreFields();
                int initialCursorRow = view.screen().cursorRow();
                view.overlayRectangle(text);
                view.documentPosition().jump(element, position);
                view.screen().setCursorRow(initialCursorRow);
                view.resetIgnoreFields();
                break;
            }
            case 158: {
                view.actionHandler().doDefaultActionPreferences();
                break;
            }
            case 159: {
                if (reverse) {
                    view.deletePrefixText(repeat);
                    break;
                }
                position = view.documentPosition().prefixPosition();
                if (repeat > position) {
                    repeat = position;
                }
                if (position <= 1) break;
                view.documentPosition().prefixLeft(repeat);
                view.deletePrefixText(repeat);
                break;
            }
            case 160: {
                if (!reverse) {
                    view.deletePrefixText(repeat);
                    break;
                }
                position = view.documentPosition().prefixPosition();
                if (repeat > position) {
                    repeat = position;
                }
                if (position <= 1) break;
                view.documentPosition().prefixLeft(repeat);
                view.deletePrefixText(repeat);
                break;
            }
            case 161: {
                view.documentPosition().prefixEnd();
                break;
            }
            case 162: {
                view.documentPosition().prefixHome();
                break;
            }
            case 163: {
                if (element == null) break;
                if (!reverse) {
                    view.documentPosition().prefixLeft(repeat);
                    break;
                }
                if (element.elementView(view).prefixEnd() >= view.documentPosition().prefixPosition() + repeat) {
                    view.documentPosition().prefixRight(repeat);
                    break;
                }
                view.setInPrefix(false);
                view.documentPosition().home();
                break;
            }
            case 164: {
                if (element == null) break;
                if (reverse) {
                    view.documentPosition().prefixLeft(repeat);
                    break;
                }
                if (element.elementView(view).prefixEnd() >= view.documentPosition().prefixPosition() + repeat) {
                    view.documentPosition().prefixRight(repeat);
                    break;
                }
                view.setInPrefix(false);
                view.documentPosition().home();
                break;
            }
            case 165: {
                if (element == null) break;
                String text = element.elementView(view).prefixText();
                position = view.documentPosition().prefixPosition();
                if (text == null || text.length() < position) break;
                view.deletePrefixText(text.length() - position + 1);
                break;
            }
            case 166: {
                int i = 0;
                while (i < repeat) {
                    if (!reverse) {
                        if (view.documentPosition().position() > 1) {
                            view.documentPosition().prevTabStop();
                        } else {
                            view.documentPosition().home();
                            if (view.screen().currentPrefixArea()) {
                                view.setInPrefix(true);
                                view.documentPosition().prefixHome();
                            }
                        }
                    } else {
                        view.documentPosition().nextTabStop();
                    }
                    ++i;
                }
                break;
            }
            case 167: {
                int i = 0;
                while (i < repeat) {
                    if (!reverse) {
                        WordActions.prevWord(view, element, position);
                    } else {
                        WordActions.nextWord(view, element, position);
                    }
                    ++i;
                }
                break;
            }
            case 10: 
            case 168: {
                view.commandHandler().doCommand("print");
                break;
            }
            case 169: {
                view.commandHandler().doCommand("print compare");
                break;
            }
            case 170: {
                view.commandHandler().doCommand("processPrefix " + view.baseProfile());
                break;
            }
            case 2: 
            case 171: {
                if (!view.changeAllowed()) break;
                if (reverse) {
                    view.commandHandler().doCommand("undo " + repeat);
                    break;
                }
                view.commandHandler().doCommand("undo " + -repeat);
                break;
            }
            case 172: {
                view.commandHandler().doCommand("load");
                break;
            }
            case 173: {
                String name = view.document().name();
                CommandHandler.setStatus(null);
                String label = LpexResources.message("commandLine.fileName");
                InputCommand.doCommand(view, LpexStringTokenizer.addQuotes(label) + " " + LpexStringTokenizer.addQuotes(name) + " " + LpexStringTokenizer.addQuotes("set name "));
                break;
            }
            case 174: {
                ProcessPrefixCommand.restorePrefix(view);
                break;
            }
            case 175: {
                if (reverse) {
                    if (view.screen().currentPrefixArea() && repeat >= position) {
                        view.documentPosition().home();
                        view.setInPrefix(true);
                        view.documentPosition().prefixEnd();
                    } else {
                        view.documentPosition().arrowLeft(repeat);
                    }
                } else {
                    view.documentPosition().arrowRight(repeat);
                }
                rc = 1;
                break;
            }
            case 176: {
                view.commandHandler().doCommand("save");
                break;
            }
            case 177: {
                String name = view.document().name();
                if (name == null) {
                    view.commandHandler().doCommand("save prompt");
                    break;
                }
                view.commandHandler().doCommand("save prompt \"" + name + "\"");
                break;
            }
            case 178: {
                SaveCommand.saveToWriter(view);
                break;
            }
            case 179: {
                view.screen().setCursorRow(view.screen().rows());
                break;
            }
            case 180: {
                view.screen().setCursorRow((view.screen().rows() + 1) / 2);
                break;
            }
            case 181: {
                view.documentPosition().scrollDown(1);
                break;
            }
            case 182: {
                ((MessageLine)view.window().messageLine()).scrollLeft();
                break;
            }
            case 183: {
                ((MessageLine)view.window().messageLine()).scrollRight();
                break;
            }
            case 184: {
                view.screen().setCursorRow(1);
                break;
            }
            case 185: {
                view.documentPosition().scrollUp(1);
                break;
            }
            case 186: {
                view.actionHandler().doDefaultActionSetActionArgument();
                break;
            }
            case 187: {
                if (view.window() == null) break;
                CommandLine commandLine = (CommandLine)view.window().commandLine();
                commandLine.setForceVisible(true);
                commandLine.setMode(5);
                view.window().commandLineRequestFocus();
                break;
            }
            case 188: {
                SetCommand.doCommand(view, "mark.@QUICK");
                view.setLpexMessageText("mark.quickMarkSet");
                break;
            }
            case 189: {
                view.documentPosition().bottom();
                ActionUtilities.doDefaultAction(view, 188);
                view.documentPosition().top();
                break;
            }
            case 190: {
                DocumentPosition.Preserve preservedPosition = view.documentPosition().preserve();
                int i = 0;
                while (i < repeat) {
                    if (reverse) {
                        view.documentPosition().prevWord();
                    } else {
                        view.documentPosition().nextWordEnd(1);
                    }
                    ++i;
                }
                ActionUtilities.doDefaultAction(view, 188);
                preservedPosition.restore();
                view.documentPosition().disposePreserve(preservedPosition);
                break;
            }
            case 191: {
                view.setIncludedClasses(-1L);
                view.setExcludedClasses(0L);
                break;
            }
            case 192: {
                if (reverse || element == null || view.markList().insertElementProtect(element) || !view.changeAllowed()) break;
                int i = 0;
                while (i < repeat) {
                    view.splitElement();
                    view.documentPosition().jump(element, position);
                    ++i;
                }
                break;
            }
            case 193: {
                if (element == null || view.markList().insertElementProtect(element) || !view.changeAllowed()) break;
                view.splitElement();
                view.shiftElement(view.documentPosition().element(), position - 1, true);
                view.documentPosition().jump(element, position);
                break;
            }
            case 194: {
                if (reverse || element == null || view.markList().insertElementProtect(element) || !view.changeAllowed()) break;
                int i = 0;
                while (i < repeat) {
                    view.splitElement();
                    ++i;
                }
                break;
            }
            case 195: {
                if (view.window() == null) break;
                view.window().textWindowRequestFocus();
                break;
            }
            case 196: {
                FindTextCommand.AsisParameter p = FindTextCommand.asisParameter();
                boolean asis = !p.currentValue(view);
                p.setValue(view, asis ? 1 : 0);
                break;
            }
            case 197: {
                view.setInsertMode(!view.insertMode());
                break;
            }
            case 198: {
                KeyRecorder.keyRecorder().setRecording(!KeyRecorder.keyRecorder().recording());
                break;
            }
            case 199: {
                FindTextCommand.RegularExpressionParameter p = FindTextCommand.regularExpressionParameter();
                boolean regularExpression = !p.currentValue(view);
                p.setValue(view, regularExpression ? 1 : 0);
                break;
            }
            case 200: {
                ActionUtilities.doDefaultAction(view, 188);
                view.documentPosition().documentTop();
                break;
            }
            case 201: {
                if (element == null || element.show() || view.markList().protect(element) || !view.changeAllowed()) break;
                int i = 0;
                while (i < repeat) {
                    position = view.documentPosition().position();
                    if (reverse) {
                        --position;
                    }
                    if (position >= element.length()) {
                        position = element.end() - 1;
                    }
                    if (position > 1) {
                        String deleteText = view.deleteText(element, position - 1);
                        view.insertText(element, position, deleteText);
                        if (!reverse) {
                            ++position;
                        }
                        view.documentPosition().jump(element, position);
                    }
                    ++i;
                }
                break;
            }
            case 202: {
                if (element == null || !view.changeAllowed()) break;
                int i = 0;
                while (i < repeat) {
                    Element element2;
                    if (reverse && ((element = element.prevVisibleNonShow(view)) == null || view.markList().protect(element)) || (element2 = element.prevVisibleNonShow(view)) == null || view.markList().protect(element2)) break block3;
                    String deleteText = view.deleteText(element, 1, element.length());
                    String deleteText2 = view.deleteText(element2, 1, element2.length());
                    view.insertText(element2, 1, deleteText);
                    view.insertText(element, 1, deleteText2);
                    if (!reverse && ((element = element.nextVisibleNonShow(view)) == null || view.markList().protect(element))) break block3;
                    view.documentPosition().jump(element, 1);
                    ++i;
                }
                break;
            }
            case 203: {
                if (element == null || !view.changeAllowed()) break;
                int i = 0;
                while (i < repeat) {
                    element = view.documentPosition().element();
                    position = view.documentPosition().position();
                    if (element.show()) {
                        element = element.nextVisibleNonShow(view);
                        position = 1;
                    }
                    int firstWordLength = 0;
                    int secondWordLength = 0;
                    DocumentPosition.Preserve firstWordDocumentPosition = null;
                    DocumentPosition.Preserve secondWordDocumentPosition = null;
                    while (element != null) {
                        if ((position = ElementList.prevWord(element, position)) != 0) {
                            view.documentPosition().jump(element, position);
                            firstWordLength = ElementList.nextWordEnd(element, position - 1) - position + 1;
                            firstWordDocumentPosition = view.documentPosition().preserve();
                            break;
                        }
                        if ((element = element.prevVisibleNonShow(view)) == null) continue;
                        position = element.end();
                    }
                    while (element != null) {
                        int n = position = reverse ? ElementList.prevWord(element, position) : ElementList.nextWord(element, position);
                        if (position != 0) {
                            view.documentPosition().jump(element, position);
                            secondWordLength = ElementList.nextWordEnd(element, position - 1) - position + 1;
                            secondWordDocumentPosition = view.documentPosition().preserve();
                            break;
                        }
                        if (reverse) {
                            if ((element = element.prevVisibleNonShow(view)) == null) continue;
                            position = element.end();
                            continue;
                        }
                        element = element.nextVisibleNonShow(view);
                        position = 0;
                    }
                    if (firstWordLength != 0 && secondWordLength != 0 && firstWordDocumentPosition != null && secondWordDocumentPosition != null) {
                        firstWordDocumentPosition.restore();
                        String firstWord = view.deleteText(firstWordLength);
                        secondWordDocumentPosition.restore();
                        String secondWord = view.deleteText(secondWordLength);
                        firstWordDocumentPosition.restore();
                        view.insertText(secondWord);
                        secondWordDocumentPosition.restore();
                        view.insertText(firstWord);
                    }
                    if (firstWordDocumentPosition != null) {
                        view.documentPosition().disposePreserve(firstWordDocumentPosition);
                    }
                    if (secondWordDocumentPosition != null) {
                        view.documentPosition().disposePreserve(secondWordDocumentPosition);
                    }
                    ++i;
                }
                break;
            }
            case 204: {
                int len;
                if (element == null || element.show() || view.markList().protect(element) || !view.changeAllowed() || (len = element.length()) < position) break;
                view.deleteText(element, position, len - position + 1);
                break;
            }
            case 1: 
            case 205: {
                if (!view.changeAllowed()) break;
                if (!reverse) {
                    view.commandHandler().doCommand("undo " + repeat);
                    break;
                }
                view.commandHandler().doCommand("undo " + -repeat);
                break;
            }
            case 206: {
                if (reverse) {
                    view.documentPosition().down(repeat);
                } else {
                    view.documentPosition().up(repeat);
                }
                rc = 1;
                break;
            }
            case 208: {
                if (element == null || !view.changeAllowed()) break;
                view.document().resetUserActionElements();
                if (!reverse) {
                    boolean moveToNextWord = true;
                    if (!element.show()) {
                        char c;
                        String text = element.text();
                        if (position >= 1 && position <= text.length() && (c = text.charAt(position - 1)) != ' ' && c != '\t') {
                            moveToNextWord = false;
                        }
                    }
                    if (moveToNextWord && !view.documentPosition().nextWord()) {
                        repeat = 0;
                    }
                }
                int i = 0;
                while (i < repeat) {
                    element = view.documentPosition().element();
                    position = view.documentPosition().position();
                    if (reverse) {
                        if (view.documentPosition().prevWord()) {
                            int wordLength = element == view.documentPosition().element() ? position - view.documentPosition().position() : view.documentPosition().element().length() - view.documentPosition().position() + 1;
                            view.changeCase(wordLength, true);
                        } else {
                            repeat = 0;
                        }
                    } else {
                        int wordLength = ElementList.nextWordEnd(element, position - 1) - position + 1;
                        view.changeCase(wordLength, true);
                        if (!view.documentPosition().nextWord()) {
                            repeat = 0;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 207: {
                MarkList.Mark quickMark = view.markList().find("@QUICK");
                if (quickMark == null || element == null || !view.changeAllowed()) break;
                view.document().resetUserActionElements();
                view.changeCase(element, position, quickMark.element1(), quickMark.position1(), true);
                break;
            }
            case 209: {
                view.actionHandler().doDefaultActionVisualEditLine();
                break;
            }
            case 210: {
                view.documentPosition().windowBottom();
                break;
            }
            case 211: {
                view.documentPosition().windowTop();
                break;
            }
            case 212: {
                int nextWordStart;
                if (element == null) break;
                int prevWordStart = ElementList.prevWord(element, position);
                int prevWordEnd = 0;
                if (prevWordStart > 0 && (prevWordEnd = ElementList.nextWordEnd(element, prevWordStart)) + 1 >= position) {
                    view.documentPosition().jump(element, prevWordEnd + 1);
                    break;
                }
                int nextWordEnd = ElementList.nextWordEnd(element, position);
                if (nextWordEnd > 0 && (nextWordStart = ElementList.prevWord(element, nextWordEnd)) <= position) {
                    view.documentPosition().jump(element, nextWordEnd + 1);
                    break;
                }
                if (prevWordEnd == 0 && nextWordEnd == 0) break;
                if (nextWordEnd == 0) {
                    view.documentPosition().jump(element, prevWordEnd + 1);
                    break;
                }
                if (prevWordEnd == 0) {
                    view.documentPosition().jump(element, nextWordEnd + 1);
                    break;
                }
                if (position - prevWordEnd + 1 > nextWordEnd + 1 - position) {
                    view.documentPosition().jump(element, nextWordEnd + 1);
                    break;
                }
                view.documentPosition().jump(element, prevWordEnd + 1);
                break;
            }
            case 213: {
                int prevWordEnd;
                if (element == null) break;
                int prevWordStart = ElementList.prevWord(element, position);
                if (prevWordStart > 0 && (prevWordEnd = ElementList.nextWordEnd(element, prevWordStart)) + 1 >= position) {
                    view.documentPosition().jump(element, prevWordStart);
                    break;
                }
                int nextWordEnd = ElementList.nextWordEnd(element, position);
                int nextWordStart = 0;
                if (nextWordEnd > 0 && (nextWordStart = ElementList.prevWord(element, nextWordEnd)) <= position) {
                    view.documentPosition().jump(element, nextWordStart);
                    break;
                }
                if (prevWordStart == 0 && nextWordStart == 0) break;
                if (nextWordStart == 0) {
                    view.documentPosition().jump(element, prevWordStart);
                    break;
                }
                if (prevWordStart == 0) {
                    view.documentPosition().jump(element, nextWordStart);
                    break;
                }
                if (position - prevWordStart > nextWordStart - position) {
                    view.documentPosition().jump(element, nextWordStart);
                    break;
                }
                view.documentPosition().jump(element, prevWordStart);
                break;
            }
            case 214: {
                if (element == null || element.show() || !KillRing.killStringAvailable() || view.markList().protect(element) || !view.changeAllowed()) break;
                view.document().resetUserActionElements();
                view.setIgnoreFields();
                view.insertText(KillRing.currentKillString());
                DocumentPosition.Preserve preservedPosition = view.documentPosition().preserve();
                view.documentPosition().jump(element, position);
                ActionUtilities.doDefaultAction(view, 188);
                preservedPosition.restore();
                view.documentPosition().disposePreserve(preservedPosition);
                view.resetIgnoreFields();
                break;
            }
            case 215: {
                if (element == null || element.show() || !KillRing.killStringAvailable() || !view.document().undo().lastChangeWasYank() || view.markList().protect(element) || !view.changeAllowed()) break;
                view.document().undo().undo(view, 1, true, true);
                KillRing.previousKillString(repeat);
                ActionUtilities.doDefaultAction(view, 214);
                break;
            }
        }
        return rc;
    }

    static void doPasteAction(View view, String text) {
        boolean hasLines;
        if (text == null) {
            return;
        }
        Element element = view.documentPosition().element();
        int repeat = view.actionHandler().repeat();
        if (element == null || repeat < 0 || view.markList().insertElementProtect(element) || !view.changeAllowed()) {
            return;
        }
        boolean bl = hasLines = text.indexOf(13) >= 0 || text.indexOf(10) >= 0;
        if (hasLines) {
            view.document().resetUserActionElements();
            view.setIgnoreFields();
        } else if (view.autoCheck()) {
            view.document().undo().checkPoint(view);
        }
        view.tryToDeleteStreamBlock();
        int i = 0;
        while (i < repeat) {
            element = view.documentPosition().element();
            if (element.show()) {
                view.documentPosition().end();
                view.insertText("\n" + text);
            } else {
                view.insertText(text);
            }
            ++i;
        }
        if (hasLines) {
            view.resetIgnoreFields();
        } else if (view.autoCheck()) {
            view.document().undo().checkPoint(view);
        }
    }

    private static int doBlockMarkCharAction(View view, int count, boolean next) {
        int rc;
        DocumentPosition documentPosition = view.documentPosition();
        Element element = documentPosition.element();
        if (element == null) {
            return 0;
        }
        if (count == 1) {
            int position = documentPosition.position();
            if (next) {
                int positionNext = DisplayTextLayout.getClusterOffsetNext(element.text(), position - 1) + 1;
                if (positionNext - position > count) {
                    count = positionNext - position;
                }
            } else {
                int positionPrev = DisplayTextLayout.getClusterOffsetPrev(element.text(), position - 1) + 1;
                if (position - positionPrev > count) {
                    count = position - positionPrev;
                }
            }
        }
        if (view.block().view() != null && (view.block().view() != view || view.block().type() == 4)) {
            view.block().clear();
            rc = 3;
        } else {
            rc = 1;
        }
        if (view.block().type() == 0 && BlockCommand.DefaultTypeParameter.getParameter().currentValue(view) == 4) {
            view.block().set(1, view);
        } else {
            view.block().set(view);
        }
        int i = 0;
        while (i < count) {
            element = documentPosition.element();
            int position = documentPosition.position();
            if (!next) {
                if (position > 1) {
                    documentPosition.left();
                } else if (view.block().type() != 3) {
                    documentPosition.up();
                    if (documentPosition.element() != element) {
                        documentPosition.end();
                    }
                }
            } else if (view.block().type() == 3 || position < element.end()) {
                documentPosition.right();
            } else {
                documentPosition.down();
                if (documentPosition.element() != element) {
                    documentPosition.home();
                }
            }
            view.block().set(view);
            ++i;
        }
        return rc;
    }

    static int getKeyContext(String keyString) {
        int context = 0;
        while (keyString.startsWith("a-") || keyString.startsWith("c-") || keyString.startsWith("m-") || keyString.startsWith("s-") || keyString.startsWith("r-") || keyString.startsWith("A-") || keyString.startsWith("C-") || keyString.startsWith("M-") || keyString.startsWith("S-") || keyString.startsWith("R-")) {
            keyString = keyString.substring(2);
        }
        int indexOfDot = keyString.indexOf(46);
        keyString = indexOfDot >= 0 ? keyString.substring(indexOfDot + 1) : "";
        while (keyString.length() > 0) {
            String contextString;
            indexOfDot = keyString.indexOf(46);
            if (indexOfDot >= 0) {
                contextString = keyString.substring(0, indexOfDot);
                keyString = keyString.substring(indexOfDot + 1);
            } else {
                contextString = keyString;
                keyString = "";
            }
            if (contextString.length() <= 0 || contextString.equalsIgnoreCase("secondary")) continue;
            if (contextString.length() > 1) {
                return 0;
            }
            switch (contextString.charAt(0)) {
                case 'T': 
                case 't': {
                    context |= 1;
                    break;
                }
                case 'P': 
                case 'p': {
                    context |= 2;
                    break;
                }
                case 'C': 
                case 'c': {
                    context |= 4;
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        return context == 0 ? 1 : context;
    }

    static int[] getKeyModifiersArray(String keyString) {
        keyString = keyString.replace(',', ' ');
        LpexStringTokenizer st = new LpexStringTokenizer(keyString);
        int count = st.countTokens();
        int[] modifiersArray = new int[count];
        int i = 0;
        while (i < count) {
            modifiersArray[i] = ActionUtilities.getKeyModifiers(st.nextToken());
            ++i;
        }
        return modifiersArray;
    }

    private static int getKeyModifiers(String keyString) {
        int modifiers = 0;
        int i = 1;
        while (i < keyString.length() && keyString.charAt(i) == '-') {
            switch (keyString.charAt(i - 1)) {
                case 'A': 
                case 'a': {
                    modifiers |= ActionHandler.KEY_MOD_A;
                    break;
                }
                case 'C': 
                case 'c': {
                    modifiers |= ActionHandler.KEY_MOD_C;
                    break;
                }
                case 'S': 
                case 's': {
                    modifiers |= ActionHandler.KEY_MOD_S;
                    break;
                }
                case 'R': 
                case 'r': {
                    modifiers |= ActionHandler.KEY_MOD_R;
                    break;
                }
                case 'M': 
                case 'm': {
                    modifiers |= ActionHandler.KEY_MOD_M;
                    break;
                }
                default: {
                    return modifiers;
                }
            }
            i += 2;
        }
        return modifiers;
    }

    static boolean getSecondary(String keyString) {
        while (keyString.startsWith("a-") || keyString.startsWith("c-") || keyString.startsWith("m-") || keyString.startsWith("s-") || keyString.startsWith("r-") || keyString.startsWith("A-") || keyString.startsWith("C-") || keyString.startsWith("M-") || keyString.startsWith("S-") || keyString.startsWith("R-")) {
            keyString = keyString.substring(2);
        }
        int indexOfDot = keyString.indexOf(46);
        keyString = indexOfDot >= 0 ? keyString.substring(indexOfDot + 1) : "";
        while (keyString.length() > 0) {
            String contextString;
            indexOfDot = keyString.indexOf(46);
            if (indexOfDot >= 0) {
                contextString = keyString.substring(0, indexOfDot);
                keyString = keyString.substring(indexOfDot + 1);
            } else {
                contextString = keyString;
                keyString = "";
            }
            if (!contextString.equalsIgnoreCase("secondary")) continue;
            return true;
        }
        return false;
    }

    static int getMouseContext(String mouseEvent) {
        int context = 0;
        int indexOfDot = mouseEvent.indexOf(46);
        indexOfDot = (mouseEvent = indexOfDot >= 0 ? mouseEvent.substring(indexOfDot + 1) : "").indexOf(46);
        if (indexOfDot >= 0) {
            try {
                Integer.parseInt(mouseEvent.substring(0, indexOfDot));
                mouseEvent = mouseEvent.substring(indexOfDot + 1);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (mouseEvent.length() > 0) {
            try {
                Integer.parseInt(mouseEvent);
                mouseEvent = "";
            }
            catch (NumberFormatException numberFormatException) {}
        }
        while (mouseEvent.length() > 0) {
            String contextString;
            indexOfDot = mouseEvent.indexOf(46);
            if (indexOfDot >= 0) {
                contextString = mouseEvent.substring(0, indexOfDot);
                mouseEvent = mouseEvent.substring(indexOfDot + 1);
            } else {
                contextString = mouseEvent;
                mouseEvent = "";
            }
            if (contextString.length() <= 0) continue;
            if (contextString.length() > 1) {
                return 0;
            }
            switch (contextString.charAt(0)) {
                case 'T': 
                case 't': {
                    context |= 1;
                    break;
                }
                case 'P': 
                case 'p': {
                    context |= 2;
                    break;
                }
                case 'E': 
                case 'e': {
                    context |= 8;
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        return context == 0 ? 1 : context;
    }

    static int getMouseModifiers(String mouseEvent) {
        int modifiers = 0;
        int i = 1;
        while (i < mouseEvent.length() && mouseEvent.charAt(i) == '-') {
            switch (mouseEvent.charAt(i - 1)) {
                case '1': {
                    modifiers |= 0x80000;
                    break;
                }
                case '2': {
                    modifiers |= 0x100000;
                    break;
                }
                case '3': {
                    modifiers |= 0x200000;
                    break;
                }
                case 'A': 
                case 'a': {
                    modifiers |= ActionHandler.KEY_MOD_A;
                    break;
                }
                case 'C': 
                case 'c': {
                    modifiers |= ActionHandler.KEY_MOD_C;
                    break;
                }
                case 'M': 
                case 'm': {
                    modifiers |= ActionHandler.KEY_MOD_M;
                    break;
                }
                case 'R': 
                case 'r': {
                    modifiers |= ActionHandler.KEY_MOD_R;
                    break;
                }
                case 'S': 
                case 's': {
                    modifiers |= ActionHandler.KEY_MOD_S;
                    break;
                }
            }
            i += 2;
        }
        return modifiers;
    }

    static int getMouseClickCount(String mouseEvent) {
        int clickCount = 0;
        int indexOfDot = mouseEvent.indexOf(46);
        if (indexOfDot >= 0) {
            if ((indexOfDot = (mouseEvent = mouseEvent.substring(indexOfDot + 1)).indexOf(46)) >= 0) {
                mouseEvent = mouseEvent.substring(0, indexOfDot);
            }
            if (mouseEvent.length() > 0) {
                try {
                    clickCount = Integer.parseInt(mouseEvent);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return clickCount;
    }
}

