/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.ContentProvider;
import com.ibm.lpex.alef.preferences.LabelProvider;
import com.ibm.lpex.alef.preferences.LpexBooleanFieldEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.WhitespaceCharacterMapping;
import com.ibm.lpex.alef.preferences.WhitespaceCharacterMappingDialog;
import com.ibm.lpex.alef.preferences.WhitespaceCharacterUtil;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;

public class WhitespaceCharPreferencePage
extends LpexFieldEditorPreferencePage {
    private String _initialShowWhitespaceChar;
    private String _initialMappingTable;
    private LpexBooleanFieldEditor _showWhitespaceCharCheckBox;
    private TableViewer mappingList;
    private Button addButton;
    private Button delButton;
    private Button editButton;
    List<WhitespaceCharacterMapping> mappingItemlist;
    private static String[] mappingTableColumnsHeaders = new String[]{LpexResources.message("preferences.mappingtable.whitespace"), LpexResources.message("preferences.mappingtable.substituteChar")};

    public WhitespaceCharPreferencePage() {
        super(LpexResources.message("preferences.tabsTitle"), 1);
    }

    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "whitespace_page");
        this._showWhitespaceCharCheckBox = new LpexBooleanFieldEditor(parent, "preferences.showWhitespaceChar");
        this.addField((FieldEditor)this._showWhitespaceCharCheckBox);
        this._showWhitespaceCharCheckBox.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (WhitespaceCharPreferencePage.this._showWhitespaceCharCheckBox.getBooleanValue()) {
                    WhitespaceCharPreferencePage.this.mappingList.getTable().setEnabled(true);
                    WhitespaceCharPreferencePage.this.addButton.setEnabled(true);
                    if (WhitespaceCharPreferencePage.this.mappingList.getTable().getSelection().length > 0) {
                        WhitespaceCharPreferencePage.this.delButton.setEnabled(true);
                        WhitespaceCharPreferencePage.this.editButton.setEnabled(true);
                    }
                } else {
                    WhitespaceCharPreferencePage.this.mappingList.getTable().setEnabled(false);
                    WhitespaceCharPreferencePage.this.addButton.setEnabled(false);
                    WhitespaceCharPreferencePage.this.delButton.setEnabled(false);
                    WhitespaceCharPreferencePage.this.editButton.setEnabled(false);
                }
            }
        });
        this._initialShowWhitespaceChar = WhitespaceCharPreferencePage.getDefaultValue("showWhitespaceChar");
        this._initialMappingTable = WhitespaceCharPreferencePage.getDefaultValue("whitespaceCharMapping");
        Label tableTitle = new Label(parent, 0);
        tableTitle.setText(LpexResources.message("preferences.WhitespaceCharMappingTableTitle"));
        tableTitle.setLayoutData((Object)new GridData(768));
        Composite compMappingList = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        compMappingList.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        compMappingList.setLayout((Layout)layout);
        this.mappingList = new TableViewer(compMappingList, 68356);
        GridData gd2 = new GridData(1072);
        gd2.heightHint = 300;
        this.mappingList.getTable().setLayoutData((Object)gd2);
        int i = 0;
        while (i < mappingTableColumnsHeaders.length) {
            TableColumn col = new TableColumn(this.mappingList.getTable(), 0x1000000);
            col.setText(mappingTableColumnsHeaders[i]);
            col.setWidth(200);
            ++i;
        }
        this.mappingList.getTable().setHeaderVisible(true);
        this.mappingList.getTable().setLinesVisible(true);
        this.mappingList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof WhitespaceCharacterMapping) {
                    WhitespaceCharacterMapping mapping = (WhitespaceCharacterMapping)element;
                    switch (columnIndex) {
                        case 0: {
                            return WhitespaceCharacterUtil.getWhitespaceName(mapping.getOriginal()) + " ( " + WhitespaceCharacterUtil.getCharHexValue(mapping.getOriginal()) + " )";
                        }
                        case 1: {
                            return String.valueOf(mapping.getSubstitute()) + " ( " + WhitespaceCharacterUtil.getCharHexValue(mapping.getSubstitute()) + " )";
                        }
                    }
                }
                return "";
            }
        });
        this.mappingList.setContentProvider((IContentProvider)new ContentProvider((StructuredViewer)this.mappingList, null));
        this.mappingList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)WhitespaceCharPreferencePage.this.mappingList.getSelection();
                Iterator elements = selection.iterator();
                if (elements.hasNext()) {
                    WhitespaceCharPreferencePage.this.delButton.setEnabled(true);
                    WhitespaceCharPreferencePage.this.editButton.setEnabled(true);
                } else {
                    WhitespaceCharPreferencePage.this.delButton.setEnabled(false);
                    WhitespaceCharPreferencePage.this.editButton.setEnabled(false);
                }
            }
        });
        Composite tableButtons = new Composite(compMappingList, 0);
        tableButtons.setLayout((Layout)new GridLayout(1, true));
        tableButtons.setLayoutData((Object)new GridData(2));
        this.addButton = new Button(tableButtons, 0);
        this.addButton.setText(LpexResources.message("preferences.mappingtable.add_button"));
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WhitespaceCharacterMappingDialog addDialog = new WhitespaceCharacterMappingDialog(WhitespaceCharPreferencePage.this.getShell());
                addDialog.setUnexpectedMappingList(WhitespaceCharPreferencePage.this.getExistWhitespaceChar());
                if (addDialog.open() == 0) {
                    WhitespaceCharacterMapping mapping = addDialog.getWhitespaceCharacterMapping();
                    WhitespaceCharPreferencePage.this.mappingItemlist.add(mapping);
                    WhitespaceCharPreferencePage.this.mappingList.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editButton = new Button(tableButtons, 0);
        this.editButton.setText(LpexResources.message("preferences.mappingtable.edit_button"));
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WhitespaceCharacterMappingDialog editDialog = new WhitespaceCharacterMappingDialog(WhitespaceCharPreferencePage.this.getShell());
                IStructuredSelection selection = (IStructuredSelection)WhitespaceCharPreferencePage.this.mappingList.getSelection();
                Iterator elements = selection.iterator();
                if (!elements.hasNext()) {
                    return;
                }
                WhitespaceCharacterMapping originalMapping = (WhitespaceCharacterMapping)elements.next();
                editDialog.init(originalMapping);
                List<WhitespaceCharacterMapping> unexpectedList = WhitespaceCharPreferencePage.this.getExistWhitespaceChar();
                unexpectedList.remove(originalMapping);
                editDialog.setUnexpectedMappingList(unexpectedList);
                if (editDialog.open() == 0) {
                    WhitespaceCharacterMapping newMapping = editDialog.getWhitespaceCharacterMapping();
                    int index = WhitespaceCharPreferencePage.this.mappingItemlist.indexOf(originalMapping);
                    WhitespaceCharPreferencePage.this.mappingItemlist.remove(originalMapping);
                    WhitespaceCharPreferencePage.this.mappingItemlist.add(index, newMapping);
                    WhitespaceCharPreferencePage.this.mappingList.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.delButton = new Button(tableButtons, 0);
        this.delButton.setText(LpexResources.message("preferences.mappingtable.delete_button"));
        this.delButton.setLayoutData((Object)new GridData(768));
        this.delButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)WhitespaceCharPreferencePage.this.mappingList.getSelection();
                Iterator elements = selection.iterator();
                if (!elements.hasNext()) {
                    return;
                }
                WhitespaceCharacterMapping originalMapping = (WhitespaceCharacterMapping)elements.next();
                WhitespaceCharPreferencePage.this.mappingItemlist.remove(originalMapping);
                WhitespaceCharPreferencePage.this.mappingList.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.delButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.updateSettings(this._initialMappingTable, this._initialShowWhitespaceChar);
        return parent;
    }

    protected void createFieldEditors() {
    }

    public boolean performOk() {
        boolean update = WhitespaceCharPreferencePage.updateDefaultValue("showWhitespaceChar", this._showWhitespaceCharCheckBox.getOnOffValue());
        if (update |= WhitespaceCharPreferencePage.updateDefaultValue("whitespaceCharMapping", WhitespaceCharacterUtil.buildWhitespaceCharMappingTableString((List)this.mappingList.getInput()))) {
            LpexView.doGlobalCommand("screenShow");
        }
        return true;
    }

    protected void performDefaults() {
        String showWhitespaceChar = LpexView.globalQuery("install.showWhitespaceChar");
        String mappingTable = LpexView.globalQuery("install.whitespaceCharMapping");
        this.updateSettings(mappingTable, showWhitespaceChar);
        super.performDefaults();
    }

    protected void setDefaultMapping() {
        this.mappingItemlist.clear();
        for (WhitespaceCharacterMapping wcm : WhitespaceCharacterUtil.defaultMappingList) {
            this.mappingItemlist.add(wcm);
        }
        this.mappingList.refresh();
    }

    @Override
    protected void performReset() {
        this.updateSettings(this._initialMappingTable, this._initialShowWhitespaceChar);
    }

    private void updateSettings(String mappingTable, String showWhitespaceChar) {
        this._showWhitespaceCharCheckBox.setSelected("on".equals(showWhitespaceChar));
        this.mappingItemlist = WhitespaceCharacterUtil.parseWhitespaceCharMappingTable(mappingTable);
        this.mappingList.setInput(this.mappingItemlist);
    }

    private List<WhitespaceCharacterMapping> getExistWhitespaceChar() {
        List input = (List)this.mappingList.getInput();
        ArrayList<WhitespaceCharacterMapping> list = new ArrayList<WhitespaceCharacterMapping>(input);
        return list;
    }
}

