/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexTableItem;
import com.ibm.lpex.alef.preferences.TablePreferencePage;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class UserMouseActionsPreferencePage
extends TablePreferencePage {
    private static final String[] _valueTableNames = new String[]{LpexResources.message("preferences.userMouseActionsTableMouseEvent"), LpexResources.message("preferences.userMouseActionsTableAction")};
    private static final String[] _valueNames = new String[]{LpexResources.message("preferences.userMouseActionsMouseEvent"), LpexResources.message("preferences.userMouseActionsAction")};
    private static final int[] _valueWeights = new int[]{50, 50};

    public UserMouseActionsPreferencePage() {
        super(false, true);
    }

    @Override
    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "userMouseActions_page");
        return super.createContents(parent);
    }

    @Override
    protected String[] getValueTableNames() {
        return _valueTableNames;
    }

    @Override
    protected String[] getValueNames() {
        return _valueNames;
    }

    @Override
    protected int[] getValueWeights() {
        return _valueWeights;
    }

    @Override
    protected String[] getValue2Options() {
        return LpexView.globalQuery("defaultActions").split(" ");
    }

    @Override
    protected Vector<LpexTableItem> initialize() {
        return this.updateSettings(LpexView.globalQuery("current.updateProfile.userMouseActions"));
    }

    @Override
    protected Vector<LpexTableItem> initializeDefaults() {
        return this.updateSettings(LpexView.globalQuery("install.updateProfile.userMouseActions"));
    }

    private Vector<LpexTableItem> updateSettings(String userMouseActions) {
        Vector<LpexTableItem> items = new Vector<LpexTableItem>();
        if (userMouseActions != null) {
            StringTokenizer st = new StringTokenizer(userMouseActions);
            while (st.hasMoreTokens()) {
                String mouseEvent = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                items.addElement(new LpexTableItem(mouseEvent, st.nextToken()));
            }
        }
        return items;
    }

    public boolean performOk() {
        Vector<LpexTableItem> items = this.getItems();
        StringBuilder newUserMouseActions = new StringBuilder();
        int i = 0;
        while (i < items.size()) {
            LpexTableItem pi = items.elementAt(i);
            if (newUserMouseActions.length() != 0) {
                newUserMouseActions.append(' ');
            }
            newUserMouseActions.append(pi.value1());
            newUserMouseActions.append(' ');
            newUserMouseActions.append(pi.value2());
            ++i;
        }
        if (LpexFieldEditorPreferencePage.updateDefaultValue("updateProfile.userMouseActions", newUserMouseActions.toString())) {
            LpexView.doGlobalCommand("updateProfile all");
        }
        return true;
    }
}

