/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.preferences.ContentProvider;
import com.ibm.lpex.alef.preferences.LabelProvider;
import com.ibm.lpex.alef.preferences.LpexTableItem;
import com.ibm.lpex.core.LpexResources;
import java.util.Vector;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

abstract class TablePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private int[] _valueWeights;
    private TableViewer _itemsList;
    private Button _setButton;
    private Button _deleteButton;
    private Text _value1TextField;
    private boolean _showValue1Info;
    private Text _value1Info;
    private boolean _isValue2Combo;
    private Text _value2TextField;
    private Combo _value2Combo;
    private boolean _updatingTextFields;
    private boolean _updatingTableSelection;
    private Vector<LpexTableItem> _items;
    private Vector<LpexTableItem> _initialItems;

    public TablePreferencePage() {
    }

    public TablePreferencePage(boolean showValue1Info, boolean isValue2Combo) {
        this._showValue1Info = showValue1Info;
        this._isValue2Combo = isValue2Combo;
    }

    protected Control createContents(Composite ancestor) {
        String[] valueTableNames = this.getValueTableNames();
        String[] valueNames = this.getValueNames();
        this._valueWeights = this.getValueWeights();
        this._items = this.initialize();
        this._initialItems = new Vector<LpexTableItem>(this._items);
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        this._itemsList = new TableViewer(parent, 67584);
        Table table = this._itemsList.getTable();
        GridData gd = new GridData(1808);
        gd.heightHint = table.getItemHeight() * 15;
        table.setLayoutData((Object)gd);
        this._itemsList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof LpexTableItem && e2 instanceof LpexTableItem) {
                    String left = ((LpexTableItem)e1).value1();
                    String right = ((LpexTableItem)e2).value1();
                    return left.compareTo(right);
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(valueTableNames[0]);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(valueTableNames[1]);
        this.setTableLayout();
        table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TablePreferencePage.this.setTableLayout();
            }
        });
        this._itemsList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._itemsList.setContentProvider((IContentProvider)new ContentProvider((StructuredViewer)this._itemsList, this._items));
        this._itemsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                TablePreferencePage.this.tableSelectionChanged();
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(8));
        buttons.setLayout((Layout)new GridLayout());
        this._setButton = new Button(buttons, 8);
        this._setButton.setLayoutData((Object)new GridData(768));
        this._setButton.setText(LpexResources.message("preferences.set"));
        this._setButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                TablePreferencePage.this.setPressed();
            }
        });
        this._deleteButton = new Button(buttons, 8);
        this._deleteButton.setLayoutData((Object)new GridData(768));
        this._deleteButton.setText(LpexResources.message("preferences.delete"));
        this._deleteButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TablePreferencePage.this.deletePressed();
            }
        });
        Composite fieldsContainer = new Composite(parent, 0);
        fieldsContainer.setLayoutData((Object)new GridData(1808));
        GridLayout jreLayout = new GridLayout();
        jreLayout.numColumns = this._showValue1Info ? 3 : 2;
        fieldsContainer.setLayout((Layout)jreLayout);
        Label l = new Label(fieldsContainer, 0);
        l.setText(valueNames[0]);
        l.setLayoutData((Object)new GridData());
        this._value1TextField = new Text(fieldsContainer, 2048);
        int textWidthHint = 0;
        if (this._showValue1Info) {
            GC gc = new GC((Drawable)this._value1TextField);
            textWidthHint = gc.stringExtent((String)"123456789012").x;
            gc.dispose();
            gd = new GridData();
            gd.widthHint = textWidthHint;
            this._value1TextField.setLayoutData((Object)gd);
        } else {
            this._value1TextField.setLayoutData((Object)new GridData(768));
        }
        this._value1TextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TablePreferencePage.this.value1Modified();
            }
        });
        this._value1TextField.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 16 && TablePreferencePage.this._value1Info != null && TablePreferencePage.this._value1Info.getText().length() == 0) {
                    if (TablePreferencePage.this._isValue2Combo) {
                        TablePreferencePage.this._value2Combo.setFocus();
                    } else {
                        TablePreferencePage.this._value2TextField.setFocus();
                    }
                    event.doit = false;
                }
            }
        });
        if (this._showValue1Info) {
            this._value1Info = new Text(fieldsContainer, 12);
            this._value1Info.setLayoutData((Object)new GridData(768));
        }
        l = new Label(fieldsContainer, 0);
        l.setText(valueNames[1]);
        l.setLayoutData((Object)new GridData());
        if (this._isValue2Combo) {
            this._value2Combo = new Combo(fieldsContainer, 2052);
            this._value2Combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TablePreferencePage.this.value2Modified();
                }
            });
            this._value2Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TablePreferencePage.this.value2ListSelectionModified();
                }
            });
            this.setValue2Options();
        } else {
            this._value2TextField = new Text(fieldsContainer, 2048);
            this._value2TextField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TablePreferencePage.this.value2Modified();
                }
            });
        }
        if (this._showValue1Info) {
            if (!this._isValue2Combo) {
                gd = new GridData();
                gd.widthHint = textWidthHint;
                this._value2TextField.setLayoutData((Object)gd);
            }
        } else if (this._isValue2Combo) {
            this._value2Combo.setLayoutData((Object)new GridData(768));
        } else {
            this._value2TextField.setLayoutData((Object)new GridData(768));
        }
        if (this._isValue2Combo) {
            this._value2Combo.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 8 && TablePreferencePage.this._value1Info != null && TablePreferencePage.this._value1Info.getText().length() == 0) {
                        TablePreferencePage.this._value1TextField.setFocus();
                        event.doit = false;
                    }
                }
            });
        } else {
            this._value2TextField.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 8 && TablePreferencePage.this._value1Info != null && TablePreferencePage.this._value1Info.getText().length() == 0) {
                        TablePreferencePage.this._value1TextField.setFocus();
                        event.doit = false;
                    }
                }
            });
        }
        this._itemsList.setInput(this._items);
        this.enableButtons();
        return parent;
    }

    private void setTableLayout() {
        TableLayout tableLayout = new TableLayout();
        this._itemsList.getTable().setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(this._valueWeights[0]));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(this._valueWeights[1]));
    }

    public void init(IWorkbench workbench) {
    }

    protected abstract String[] getValueTableNames();

    protected abstract String[] getValueNames();

    protected abstract int[] getValueWeights();

    protected Text value1TextField() {
        return this._value1TextField;
    }

    protected String getValue2() {
        return this._isValue2Combo ? this._value2Combo.getText() : this._value2TextField.getText();
    }

    private void setValue2(String value2) {
        if (this._isValue2Combo) {
            this._value2Combo.setText(value2);
        } else {
            this._value2TextField.setText(value2);
        }
    }

    protected Text value1Info() {
        return this._value1Info;
    }

    private void enableButtons() {
        this.enableSetButton();
        this._deleteButton.setEnabled(!this._itemsList.getSelection().isEmpty());
    }

    private void enableSetButton() {
        this._setButton.setEnabled(this._value1TextField.getText().trim().length() != 0 && this.isValid());
    }

    public void setValid(boolean b) {
        super.setValid(b);
        this.enableSetButton();
    }

    private void setPressed() {
        this.doSetPressed(this._value1TextField.getText().trim(), this.getValue2().trim());
    }

    protected void doSetPressed(String value1, String value2) {
        if (value1 == null || value1.length() == 0) {
            return;
        }
        int index = this.indexOf(value1);
        if (index >= 0) {
            if (value2 == null || value2.length() == 0) {
                this._items.removeElementAt(index);
                this._itemsList.refresh();
            } else {
                this._items.setElementAt(new LpexTableItem(value1, value2), index);
                this._itemsList.refresh();
                this.selectItem(value1);
            }
        } else if (value2 != null && value2.length() > 0) {
            this._items.addElement(new LpexTableItem(value1, value2));
            this._itemsList.refresh();
            this.selectItem(value1);
        }
    }

    private void deletePressed() {
        IStructuredSelection selection = (IStructuredSelection)this._itemsList.getSelection();
        for (Object o : selection) {
            this._items.remove(o);
            this._itemsList.remove(o);
        }
    }

    protected void contributeButtons(Composite buttonBar) {
        ++((GridLayout)buttonBar.getLayout()).numColumns;
        Button resetButton = new Button(buttonBar, 8);
        resetButton.setFont(buttonBar.getFont());
        resetButton.setText(LpexResources.message("preferences.reset"));
        GridData data = new GridData(256);
        data.widthHint = Math.max(this.convertHorizontalDLUsToPixels(61), resetButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        resetButton.setLayoutData((Object)data);
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TablePreferencePage.this.performReset();
            }
        });
    }

    protected void performDefaults() {
        this._value1TextField.setText("");
        this.setValue2("");
        this._items = this.initializeDefaults();
        this._itemsList.setInput(this._items);
    }

    protected void performReset() {
        this._value1TextField.setText("");
        this.setValue2("");
        this._items = new Vector<LpexTableItem>(this._initialItems);
        this._itemsList.setInput(this._items);
    }

    protected abstract Vector<LpexTableItem> initialize();

    protected abstract Vector<LpexTableItem> initializeDefaults();

    protected String[] getValue2Options() {
        return null;
    }

    protected void setValue2Options() {
        this._value2Combo.removeAll();
        String[] value2Options = this.getValue2Options();
        if (value2Options != null) {
            int i = 0;
            while (i < value2Options.length) {
                this._value2Combo.add(value2Options[i]);
                ++i;
            }
        }
    }

    protected Vector<LpexTableItem> getItems() {
        return this._items;
    }

    private void tableSelectionChanged() {
        if (!this._updatingTableSelection) {
            this._updatingTextFields = true;
            IStructuredSelection selection = (IStructuredSelection)this._itemsList.getSelection();
            for (Object o : selection) {
                String value1 = ((LpexTableItem)o).value1();
                String value2 = ((LpexTableItem)o).value2();
                this._value1TextField.setText(value1);
                this.setValue2(value2);
                this.tableSelectionModified(value1, value2);
            }
            this._updatingTextFields = false;
            this.enableButtons();
        }
    }

    protected void tableSelectionModified(String newValue1, String newValue2) {
    }

    protected void value1Modified() {
        if (!this._updatingTextFields) {
            this.selectItem(this._value1TextField.getText().trim());
        }
    }

    protected void value2Modified() {
    }

    protected void value2ListSelectionModified() {
    }

    protected void selectItem(String value1) {
        this._updatingTableSelection = true;
        int index = this.indexOf(value1);
        if (index == -1) {
            this._itemsList.getTable().deselectAll();
        } else {
            Object oldSelection;
            Object newSelection = this.elementOf(value1);
            if (newSelection != (oldSelection = ((IStructuredSelection)this._itemsList.getSelection()).getFirstElement())) {
                this._itemsList.setSelection((ISelection)new StructuredSelection(newSelection), true);
            }
        }
        this.enableButtons();
        this._updatingTableSelection = false;
    }

    private int indexOf(String value1) {
        int index = -1;
        int i = 0;
        while (i < this._items.size()) {
            String currentValue1 = this._items.elementAt(i).value1();
            if (currentValue1.equals(value1)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private Object elementOf(String value1) {
        LpexTableItem object = null;
        int i = 0;
        while (i < this._items.size()) {
            String currentValue1 = this._items.elementAt(i).value1();
            if (currentValue1.equals(value1)) {
                object = this._items.elementAt(i);
                break;
            }
            ++i;
        }
        return object;
    }
}

