/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.ColorEditor;
import com.ibm.lpex.alef.preferences.ParsersPreferencePage;
import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexCommonParser;
import com.ibm.lpex.core.LpexPaletteAttributes;
import com.ibm.lpex.core.LpexParser;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class ParserStylesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private String _defaultParserName;
    private Combo _parserCombo;
    private List _stylesList;
    private Label _fgLabel;
    private ColorEditor _fgColorEditor;
    private Label _bgLabel;
    private ColorEditor _bgColorEditor;
    private Label _efLabel;
    private ColorEditor _efColorEditor;
    private Button _underlineCheckBox;
    private Button _squiggleCheckBox;
    private Button _strikeoutCheckBox;
    private Button _outlineCheckBox;
    private Label _previewLabel;
    private LpexView _lpexView;
    private Button _resetButton;
    private LpexCommonParser _parser;
    ArrayList<String> _initialStyleAttributes;
    ArrayList<String> _currentStyleAttributes;
    private String _parserStyles;
    private char _lastStyleCharacter;
    String _currentBackgroundColor;

    protected Control createContents(Composite ancestor) {
        Utilities.setHelp((Control)ancestor, "parserStyles_page");
        Composite parent = new Composite(ancestor, 0);
        parent.setLayout((Layout)new GridLayout());
        Label l = new Label(parent, 0);
        l.setText(LpexResources.message("preferences.parsers.parser"));
        this._parserCombo = new Combo(parent, 2052);
        this._parserCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParserStylesPreferencePage.this.parserComboTextChanged();
            }
        });
        l = new Label(parent, 0);
        l.setText(LpexResources.message("preferences.parsers.styles"));
        Composite editorComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 8;
        editorComposite.setLayout((Layout)layout);
        editorComposite.setLayoutData((Object)new GridData(768));
        this._stylesList = new List(editorComposite, 2564);
        GridData gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.heightHint = this._stylesList.getItemHeight() * 8;
        this._stylesList.setLayoutData((Object)gd);
        this._stylesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ParserStylesPreferencePage.this.styleSelectionChanged();
            }
        });
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 10;
        layout.numColumns = 4;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        SelectionListener attributesListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ParserStylesPreferencePage.this.attributesChanged(e);
            }
        };
        this._fgLabel = new Label(stylesComposite, 16384);
        this._fgLabel.setText(LpexResources.message("preferences.parsers.foreground"));
        this._fgColorEditor = new ColorEditor(stylesComposite);
        Button fgColorButton = this._fgColorEditor.getButton();
        fgColorButton.addSelectionListener(attributesListener);
        fgColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.nameForeground");
            }

            public void getHelp(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.roleForeground");
            }
        });
        fgColorButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                if (!ParserStylesPreferencePage.this._fgColorEditor.getButton().getEnabled()) {
                    e.result = LpexResources.message("accessible.valueNone");
                } else {
                    RGB c = ParserStylesPreferencePage.this._fgColorEditor.getColorValue();
                    e.result = "R " + c.red + ", G " + c.green + ", B " + c.blue;
                }
            }
        });
        this._bgLabel = new Label(stylesComposite, 16384);
        this._bgLabel.setText(LpexResources.message("preferences.parsers.background"));
        this._bgColorEditor = new ColorEditor(stylesComposite);
        Button bgColorButton = this._bgColorEditor.getButton();
        bgColorButton.addSelectionListener(attributesListener);
        bgColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.nameBackground");
            }

            public void getHelp(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.roleBackground");
            }
        });
        bgColorButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                if (!ParserStylesPreferencePage.this._bgColorEditor.getButton().getEnabled()) {
                    e.result = LpexResources.message("accessible.valueNone");
                } else {
                    RGB c = ParserStylesPreferencePage.this._bgColorEditor.getColorValue();
                    e.result = "R " + c.red + ", G " + c.green + ", B " + c.blue;
                }
            }
        });
        this._efLabel = new Label(stylesComposite, 16384);
        this._efLabel.setText(LpexResources.message("pref.parsers.effects"));
        this._efColorEditor = new ColorEditor(stylesComposite);
        Button efColorButton = this._efColorEditor.getButton();
        gd = new GridData();
        gd.horizontalSpan = 3;
        efColorButton.setLayoutData((Object)gd);
        efColorButton.addSelectionListener(attributesListener);
        efColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LpexResources.message("acc.nameEffects");
            }

            public void getHelp(AccessibleEvent e) {
                e.result = LpexResources.message("acc.roleEffects");
            }
        });
        efColorButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                if (!ParserStylesPreferencePage.this._efColorEditor.getButton().getEnabled()) {
                    e.result = LpexResources.message("accessible.valueNone");
                } else {
                    RGB c = ParserStylesPreferencePage.this._efColorEditor.getColorValue();
                    e.result = "R " + c.red + ", G " + c.green + ", B " + c.blue;
                }
            }
        });
        this._underlineCheckBox = new Button(stylesComposite, 32);
        this._underlineCheckBox.setText(LpexResources.message("preferences.parsers.underline"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalIndent = 10;
        this._underlineCheckBox.setLayoutData((Object)gd);
        this._underlineCheckBox.addSelectionListener(attributesListener);
        this._squiggleCheckBox = new Button(stylesComposite, 32);
        this._squiggleCheckBox.setText(LpexResources.message("preferences.parsers.squiggle"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalIndent = 10;
        this._squiggleCheckBox.setLayoutData((Object)gd);
        this._squiggleCheckBox.addSelectionListener(attributesListener);
        this._strikeoutCheckBox = new Button(stylesComposite, 32);
        this._strikeoutCheckBox.setText(LpexResources.message("preferences.parsers.strikeout"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this._strikeoutCheckBox.setLayoutData((Object)gd);
        this._strikeoutCheckBox.addSelectionListener(attributesListener);
        this._outlineCheckBox = new Button(stylesComposite, 32);
        this._outlineCheckBox.setText(LpexResources.message("preferences.parsers.outline"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this._outlineCheckBox.setLayoutData((Object)gd);
        this._outlineCheckBox.addSelectionListener(attributesListener);
        this._previewLabel = new Label(parent, 0);
        this._previewLabel.setLayoutData((Object)new GridData(768));
        Composite lpex = new Composite(parent, 0);
        gd = new GridData(1808);
        gd.widthHint = 50;
        lpex.setLayoutData((Object)gd);
        lpex.setLayout((Layout)new FillLayout());
        this.createLpexPreview(lpex);
        this.initializeParsersList();
        return parent;
    }

    private void createLpexPreview(Composite parent) {
        LpexWindow lpexWindow = new LpexWindow(parent, 2048);
        this._lpexView = new LpexView(false);
        this._lpexView.setWindow(lpexWindow);
        this._lpexView.setBlockInstance(this._lpexView);
        this._lpexView.addThemeChangeListener();
        this._lpexView.addLpexViewListener(new LpexViewAdapter(){

            @Override
            public void showing(LpexView view) {
                if (view.window().textWindow().isFocusControl()) {
                    ParserStylesPreferencePage.this.setStyleSelectionFromPreview(false);
                }
            }

            @Override
            public void updateProfile(LpexView view) {
                ParserStylesPreferencePage.this.handleUpdateProfile(view);
            }
        });
        lpexWindow.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ParserStylesPreferencePage.this._lpexView != null) {
                    ParserStylesPreferencePage.this._lpexView.dispose();
                    ParserStylesPreferencePage.this._lpexView = null;
                }
            }
        });
        lpexWindow.textWindow().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ParserStylesPreferencePage.this.getLabelText(ParserStylesPreferencePage.this._previewLabel);
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = ParserStylesPreferencePage.this.getLabelShortcut(ParserStylesPreferencePage.this._previewLabel);
            }
        });
        this._lpexView.doDefaultCommand("set updateProfile.userActions");
        this._lpexView.doDefaultCommand("set updateProfile.userCommands");
        this._lpexView.doDefaultCommand("set updateProfile.userKeyActions");
        this._lpexView.doDefaultCommand("set updateProfile.userMouseActions");
        this._lpexView.doDefaultCommand("set updateProfile.userProfile");
        this._lpexView.doDefaultCommand("updateProfile");
        this._lpexView.doDefaultCommand("set statusLine off");
        this._lpexView.doDefaultCommand("set formatLine off");
        this._lpexView.doDefaultCommand("set messageLine off");
        this._lpexView.doDefaultCommand("set highlightCurrentLine off");
    }

    String getLabelText(Label label) {
        int indexOfMnemonic;
        Object text = label.getText();
        if (text != null && (indexOfMnemonic = ((String)text).indexOf(38)) >= 0 && indexOfMnemonic + 1 < ((String)text).length()) {
            text = ((String)text).substring(0, indexOfMnemonic) + ((String)text).substring(indexOfMnemonic + 1);
        }
        return text;
    }

    String getLabelShortcut(Label label) {
        int indexOfMnemonic;
        String text = label.getText();
        if (text != null && (indexOfMnemonic = text.indexOf(38)) >= 0 && indexOfMnemonic + 1 < text.length()) {
            return LpexResources.message("key.alt") + "+" + Character.toLowerCase(text.charAt(indexOfMnemonic + 1));
        }
        return null;
    }

    private void handleUpdateProfile(LpexView lpexView) {
        this._parser = null;
        LpexParser lpexParser = lpexView.parser();
        if (lpexParser instanceof LpexCommonParser) {
            this._parser = (LpexCommonParser)lpexParser;
        }
        lpexView.doDefaultCommand("set commandLine off");
        lpexView.doDefaultCommand("set prefixArea off");
        lpexView.doDefaultCommand("set popup");
        lpexView.defineAction("commandLine", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("nextTab", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                if (ParserStylesPreferencePage.this._resetButton != null) {
                    ParserStylesPreferencePage.this._resetButton.setFocus();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("prevTab", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                if (ParserStylesPreferencePage.this._outlineCheckBox != null && ParserStylesPreferencePage.this._outlineCheckBox.isEnabled()) {
                    ParserStylesPreferencePage.this._outlineCheckBox.setFocus();
                } else {
                    ParserStylesPreferencePage.this._stylesList.setFocus();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.doCommand("set keyAction.tab nextTab");
        lpexView.doCommand("set keyAction.s-tab prevTab");
    }

    public void init(IWorkbench workbench) {
    }

    protected void contributeButtons(Composite buttonBar) {
        ++((GridLayout)buttonBar.getLayout()).numColumns;
        this._resetButton = new Button(buttonBar, 8);
        this._resetButton.setFont(buttonBar.getFont());
        this._resetButton.setText(LpexResources.message("preferences.reset"));
        GridData data = new GridData(256);
        data.widthHint = Math.max(this.convertHorizontalDLUsToPixels(61), this._resetButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this._resetButton.setLayoutData((Object)data);
        this._resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParserStylesPreferencePage.this.performReset();
            }
        });
    }

    protected void performDefaults() {
        ArrayList<String> installStyleAttributes = null;
        if (this._parser != null && this._parserStyles != null && (installStyleAttributes = this._parser.getInstallStyleAttributes()) != null) {
            int i = 0;
            while (i < this._parserStyles.length()) {
                char styleCharacter = this._parserStyles.charAt(i);
                String installAttributes = installStyleAttributes.get(i);
                this._lpexView.doDefaultCommand("set styleAttributes." + styleCharacter + (String)(installAttributes != null ? " " + installAttributes : ""));
                this._currentStyleAttributes.set(i, this._lpexView.query("styleAttributes." + styleCharacter));
                ++i;
            }
        }
        this._lpexView.doDefaultCommand("screenShow view");
        this.styleSelectionChanged();
    }

    protected void performReset() {
        if (this._parser != null && this._parserStyles != null && this._initialStyleAttributes != null) {
            int i = 0;
            while (i < this._parserStyles.length()) {
                char styleCharacter = this._parserStyles.charAt(i);
                String initialAttributes = this._initialStyleAttributes.get(i);
                this._lpexView.doDefaultCommand("set styleAttributes." + styleCharacter + (String)(initialAttributes != null ? " " + initialAttributes : ""));
                this._currentStyleAttributes.set(i, this._lpexView.query("styleAttributes." + styleCharacter));
                ++i;
            }
        }
        this._lpexView.doDefaultCommand("screenShow view");
        this.styleSelectionChanged();
    }

    public boolean performOk() {
        ArrayList<String> installStyleAttributes = null;
        if (this._parser != null && this._parserStyles != null) {
            installStyleAttributes = this._parser.getInstallStyleAttributes();
            boolean anySaved = false;
            if (installStyleAttributes != null) {
                int i = 0;
                while (i < this._parserStyles.length()) {
                    String installAttributes;
                    char styleCharacter = this._parserStyles.charAt(i);
                    String currentAttributes = this._currentStyleAttributes.get(i);
                    boolean changed = !currentAttributes.equals(installAttributes = installStyleAttributes.get(i));
                    this._parser.setProperty("style." + styleCharacter, changed ? currentAttributes : null);
                    if (changed) {
                        anySaved = true;
                    }
                    ++i;
                }
            }
            this._parser.setProperty("styles.backgroundColor", anySaved ? this._currentBackgroundColor : null);
        }
        LpexView.doGlobalCommand("updateProfile all");
        LpexView.doGlobalCommand("screenShow");
        return true;
    }

    private void initializeParsersList() {
        StringTokenizer st = new StringTokenizer(LpexView.globalQuery("current.updateProfile.parsers"));
        boolean first = true;
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            this._parserCombo.add(name);
            if (!first) continue;
            this._defaultParserName = name;
            first = false;
        }
        this.setParserSelection();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.setParserSelection()) {
            this.styleSelectionChanged();
        }
    }

    public void dispose() {
        ParsersPreferencePage.setLastParserSelected(null);
    }

    private boolean setParserSelection() {
        boolean parserChanged;
        String parserName = ParsersPreferencePage.getLastParserSelected();
        if (parserName == null) {
            parserName = this._defaultParserName;
        }
        boolean bl = parserChanged = !this.getParserComboText().equals(parserName);
        if (parserChanged) {
            this.setParserName(parserName);
        }
        return parserChanged;
    }

    private void parserComboTextChanged() {
        String newParserName = this.getParserComboText();
        if (newParserName.equals(this._lpexView.query("parser"))) {
            return;
        }
        ParsersPreferencePage.setLastParserSelected(newParserName);
        this._lpexView.doDefaultCommand("set updateProfile.parser " + newParserName);
        this._lpexView.setText("");
        this._stylesList.removeAll();
        this._parserStyles = null;
        this._initialStyleAttributes = null;
        this._currentStyleAttributes = null;
        if (this._parser != null) {
            this._parserStyles = this._parser.getStyles();
            if (this._parserStyles != null) {
                this._initialStyleAttributes = new ArrayList(this._parserStyles.length());
                this._currentStyleAttributes = new ArrayList(this._parserStyles.length());
                int i = 0;
                while (i < this._parserStyles.length()) {
                    char styleCharacter = this._parserStyles.charAt(i);
                    String styleName = this._parser.getStyleName(styleCharacter);
                    this._stylesList.add(styleName != null ? styleName : String.valueOf(styleCharacter));
                    String styleAttributes = this._lpexView.query("styleAttributes." + styleCharacter);
                    this._initialStyleAttributes.add(styleAttributes);
                    this._currentStyleAttributes.add(styleAttributes);
                    ++i;
                }
                this._currentBackgroundColor = LpexPaletteAttributes.background(this._lpexView);
            }
        }
        String sample = null;
        if (this._parser != null) {
            sample = this._parser.getProperty("sample");
        }
        if (sample != null) {
            this._previewLabel.setText(LpexResources.message("preferences.parsers.preview"));
            this._lpexView.doDefaultCommand("set text " + sample);
        } else {
            this._previewLabel.setText(LpexResources.message("preferences.parsers.noPreview"));
            this._lpexView.doDefaultCommand("set text \n\n\n\n\n\n\n\n\n");
        }
        this._lpexView.doDefaultCommand("undo clear");
        this._lpexView.doDefaultCommand("set parserProperty.view.errorMessages on");
        this._lpexView.doDefaultCommand("set parserProperty.view.useErrorStyle on");
        this._lpexView.doDefaultCommand("parse");
        this._lpexView.jump(1, 1);
        this._lastStyleCharacter = '\u0000';
        this._lpexView.doDefaultCommand("screenShow view");
        this.setStyleSelectionFromPreview(true);
    }

    private String getParserComboText() {
        return this._parserCombo.getText();
    }

    private void setParserName(String parserName) {
        this._parserCombo.setText(parserName != null ? parserName : "");
    }

    private void setStyleSelection(int index) {
        if (index >= 0) {
            this._stylesList.setSelection(index);
            this._stylesList.showSelection();
        } else {
            this._stylesList.deselectAll();
        }
        this.styleSelectionChanged();
    }

    private int getStyleSelection() {
        return this._stylesList.getSelectionIndex();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void styleSelectionChanged() {
        block14: {
            styleListIndex = this.getStyleSelection();
            if (styleListIndex < 0 || this._parserStyles == null) break block14;
            this._lastStyleCharacter = this._parserStyles.charAt(styleListIndex);
            styleAttributes = this._lpexView.query("styleAttributes." + this._lastStyleCharacter);
            if (styleAttributes == null) break block14;
            st = new StringTokenizer(styleAttributes);
            token = st.nextToken();
            colors = new int[9];
            effectsColorSpecified = false;
            underline = false;
            squiggle = false;
            strikeout = false;
            outline = false;
            try {
                i = 0;
                while (i < 9 && token != null) {
                    colors[i] = Integer.parseInt(token);
                    if (i > 5) {
                        effectsColorSpecified = true;
                    }
                    token = st.hasMoreTokens() != false ? st.nextToken() : null;
                    ++i;
                }
                ** GOTO lbl55
            }
            catch (NumberFormatException var11_12) {}
            if (true) ** GOTO lbl55
        }
        this._fgColorEditor.setEnabled(false);
        this._fgLabel.setEnabled(false);
        this._bgColorEditor.setEnabled(false);
        this._bgLabel.setEnabled(false);
        this._efColorEditor.setEnabled(false);
        this._efLabel.setEnabled(false);
        this._underlineCheckBox.setSelection(false);
        this._underlineCheckBox.setEnabled(false);
        this._squiggleCheckBox.setSelection(false);
        this._squiggleCheckBox.setEnabled(false);
        this._strikeoutCheckBox.setSelection(false);
        this._strikeoutCheckBox.setEnabled(false);
        this._outlineCheckBox.setSelection(false);
        this._outlineCheckBox.setEnabled(false);
        return;
        do {
            if (token.equals("underline")) {
                underline = true;
            } else if (token.equals("squiggle")) {
                squiggle = true;
            } else if (token.equals("strikeout")) {
                strikeout = true;
            } else if (token.equals("outline")) {
                outline = true;
            }
            v0 = token = st.hasMoreTokens() != false ? st.nextToken() : null;
lbl55:
            // 3 sources

        } while (token != null);
        this._fgColorEditor.setColorValue(new RGB(colors[0], colors[1], colors[2]));
        this._bgColorEditor.setColorValue(new RGB(colors[3], colors[4], colors[5]));
        if (effectsColorSpecified) {
            this._efColorEditor.setColorValue(new RGB(colors[6], colors[7], colors[8]));
        } else {
            this._efColorEditor.setColorValue(new RGB(colors[0], colors[1], colors[2]));
        }
        this._fgLabel.setEnabled(true);
        this._bgLabel.setEnabled(true);
        this._efLabel.setEnabled(true);
        this._underlineCheckBox.setEnabled(true);
        this._underlineCheckBox.setSelection(underline);
        this._squiggleCheckBox.setEnabled(true);
        this._squiggleCheckBox.setSelection(squiggle);
        this._strikeoutCheckBox.setEnabled(true);
        this._strikeoutCheckBox.setSelection(strikeout);
        this._outlineCheckBox.setEnabled(true);
        this._outlineCheckBox.setSelection(outline);
    }

    private void attributesChanged(SelectionEvent event) {
        RGB e;
        RGB f = this._fgColorEditor.getColorValue();
        RGB b = this._bgColorEditor.getColorValue();
        if (event.widget == this._fgColorEditor.getButton()) {
            e = f;
            this._efColorEditor.setColorValue(e);
        } else {
            e = this._efColorEditor.getColorValue();
        }
        boolean underline = this._underlineCheckBox.getSelection();
        boolean squiggle = this._squiggleCheckBox.getSelection();
        boolean strikeout = this._strikeoutCheckBox.getSelection();
        boolean outline = this._outlineCheckBox.getSelection();
        if (underline && event.widget == this._underlineCheckBox) {
            squiggle = false;
            this._squiggleCheckBox.setSelection(false);
        } else if (squiggle && event.widget == this._squiggleCheckBox) {
            underline = false;
            this._underlineCheckBox.setSelection(false);
        }
        StringBuilder att = new StringBuilder(64);
        att.append(f.red).append(' ').append(f.green).append(' ').append(f.blue).append(' ').append(b.red).append(' ').append(b.green).append(' ').append(b.blue);
        if (!e.equals((Object)f) && (underline || squiggle || strikeout || outline)) {
            att.append(' ').append(e.red).append(' ').append(e.green).append(' ').append(e.blue);
        }
        if (underline) {
            att.append(" underline");
        }
        if (squiggle) {
            att.append(" squiggle");
        }
        if (strikeout) {
            att.append(" strikeout");
        }
        if (outline) {
            att.append(" outline");
        }
        String attributes = att.toString();
        this._lpexView.doDefaultCommand("set styleAttributes." + this._lastStyleCharacter + " " + attributes);
        this._currentStyleAttributes.set(this._parserStyles.indexOf(this._lastStyleCharacter), attributes);
        this._lpexView.doDefaultCommand("screenShow view");
    }

    private void setStyleSelectionFromPreview(boolean force) {
        int position;
        String elementStyle;
        char currentStyleCharacter = '\u0000';
        int currentStyleIndex = -1;
        if (this._parserStyles != null && (elementStyle = this._lpexView.elementStyle(this._lpexView.currentElement())) != null && (position = this._lpexView.currentPosition()) > 0 && position <= elementStyle.length() && (currentStyleIndex = this._parserStyles.indexOf(currentStyleCharacter = elementStyle.charAt(position - 1))) < 0) {
            currentStyleCharacter = '\u0000';
        }
        if (force || currentStyleCharacter != this._lastStyleCharacter) {
            this.setStyleSelection(currentStyleIndex);
            this._lastStyleCharacter = currentStyleCharacter;
        }
    }
}

