/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexBooleanFieldEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexListEditor;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class LpexBasePreferencePage
extends LpexFieldEditorPreferencePage {
    private static final String[] _baseProfiles = new String[]{"brief", "eclipse", "emacs", "epm", "ispf", "lpex", "seu", "vi", "xedit"};
    private String _initialBaseProfile;
    private String _initialNoParser;
    private LpexListEditor _baseProfileList;
    private LpexBooleanFieldEditor _noParserCheckBox;

    public LpexBasePreferencePage() {
        super(LpexResources.message("preferences.rootTitle"), 1);
    }

    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "preferences");
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this._baseProfileList = new LpexListEditor(parent, "preferences.rootEditorProfile", _baseProfiles);
        new Label(parent, 0);
        this._noParserCheckBox = new LpexBooleanFieldEditor(parent, "preferences.rootNoParser");
        this.addField(this._baseProfileList);
        this.addField((FieldEditor)this._noParserCheckBox);
        this._initialBaseProfile = LpexView.globalQuery("current.updateProfile.baseProfile");
        this._initialNoParser = LpexView.globalQuery("current.updateProfile.noParser");
        this.updateSettings(this._initialBaseProfile, this._initialNoParser);
    }

    public boolean performOk() {
        boolean update = LpexBasePreferencePage.updateDefaultValue("updateProfile.baseProfile", this.getSelectedBaseProfile());
        if (update |= LpexBasePreferencePage.updateDefaultValue("updateProfile.noParser", this._noParserCheckBox.getOnOffValue())) {
            LpexView.doGlobalCommand("updateProfile all");
            LpexView.doGlobalCommand("screenShow");
        }
        return true;
    }

    protected void performDefaults() {
        this.updateSettings(LpexView.globalQuery("install.updateProfile.baseProfile"), LpexView.globalQuery("install.updateProfile.noParser"));
    }

    @Override
    protected void performReset() {
        this.updateSettings(this._initialBaseProfile, this._initialNoParser);
    }

    private void updateSettings(String baseProfile, String noParser) {
        int i = 0;
        while (i < _baseProfiles.length) {
            if (_baseProfiles[i].equals(baseProfile)) {
                this._baseProfileList.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this._noParserCheckBox.setSelected("on".equals(noParser));
    }

    private String getSelectedBaseProfile() {
        int index = this._baseProfileList.getSelectedIndex();
        return index >= 0 && index < _baseProfiles.length ? _baseProfiles[index] : "";
    }
}

