/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.ContentProvider;
import com.ibm.lpex.alef.preferences.HostCharacterMapping;
import com.ibm.lpex.alef.preferences.HostCharacterMappingDialog;
import com.ibm.lpex.alef.preferences.HostCharacterUtil;
import com.ibm.lpex.alef.preferences.LabelProvider;
import com.ibm.lpex.alef.preferences.LpexBooleanFieldEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;

public class HostCharPreferencePage
extends LpexFieldEditorPreferencePage {
    private String _initialShowHostChar;
    private String _initialMappingTable;
    private LpexBooleanFieldEditor _showHostCharCheckBox;
    private TableViewer mappingListTable;
    private Button addButton;
    private Button delButton;
    private Button editButton;
    List<HostCharacterMapping> mappingItemList;
    private static String[] mappingTableColumnsHeaders = new String[]{LpexResources.message("preferences.mappingtable.hostCodePage"), LpexResources.message("preferences.mappingtable.hostCodePoint"), LpexResources.message("preferences.mappingtable.substituteChar")};

    public HostCharPreferencePage() {
        super(LpexResources.message("preferences.tabsTitle"), 1);
    }

    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "hostChar_page");
        this._showHostCharCheckBox = new LpexBooleanFieldEditor(parent, "preferences.showHostChar");
        this.addField((FieldEditor)this._showHostCharCheckBox);
        this._showHostCharCheckBox.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (HostCharPreferencePage.this._showHostCharCheckBox.getBooleanValue()) {
                    if (HostCharPreferencePage.this.mappingListTable != null) {
                        HostCharPreferencePage.this.mappingListTable.getTable().setEnabled(true);
                        HostCharPreferencePage.this.addButton.setEnabled(true);
                        if (HostCharPreferencePage.this.mappingListTable.getTable().getSelection().length > 0) {
                            HostCharPreferencePage.this.delButton.setEnabled(true);
                            HostCharPreferencePage.this.editButton.setEnabled(true);
                        }
                    }
                } else if (HostCharPreferencePage.this.mappingListTable != null) {
                    HostCharPreferencePage.this.mappingListTable.getTable().setEnabled(false);
                    HostCharPreferencePage.this.addButton.setEnabled(false);
                    HostCharPreferencePage.this.delButton.setEnabled(false);
                    HostCharPreferencePage.this.editButton.setEnabled(false);
                }
            }
        });
        this._initialShowHostChar = HostCharPreferencePage.getDefaultValue("showHostChar");
        this._initialMappingTable = HostCharPreferencePage.getDefaultValue("hostCharMapping");
        Label tableTitle = new Label(parent, 0);
        tableTitle.setText(LpexResources.message("preferences.HostCharMappingTableTitle"));
        tableTitle.setLayoutData((Object)new GridData(768));
        Composite compMappingList = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        compMappingList.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        compMappingList.setLayout((Layout)layout);
        this.mappingListTable = new TableViewer(compMappingList, 68356);
        GridData gd2 = new GridData(1072);
        gd2.heightHint = 300;
        this.mappingListTable.getTable().setLayoutData((Object)gd2);
        int i = 0;
        while (i < mappingTableColumnsHeaders.length) {
            TableColumn col = new TableColumn(this.mappingListTable.getTable(), 0x1000000);
            col.setText(mappingTableColumnsHeaders[i]);
            col.setWidth(200);
            ++i;
        }
        this.mappingListTable.getTable().setHeaderVisible(true);
        this.mappingListTable.getTable().setLinesVisible(true);
        this.mappingListTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof HostCharacterMapping) {
                    HostCharacterMapping mapping = (HostCharacterMapping)element;
                    switch (columnIndex) {
                        case 0: {
                            return mapping.getCodePage();
                        }
                        case 1: {
                            return mapping.getCodePointString();
                        }
                        case 2: {
                            return String.valueOf(mapping.getSubstitute());
                        }
                    }
                }
                return "";
            }
        });
        this.mappingListTable.setContentProvider((IContentProvider)new ContentProvider((StructuredViewer)this.mappingListTable, null));
        this.mappingListTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)HostCharPreferencePage.this.mappingListTable.getSelection();
                Iterator elements = selection.iterator();
                if (elements.hasNext()) {
                    HostCharPreferencePage.this.delButton.setEnabled(true);
                    HostCharPreferencePage.this.editButton.setEnabled(true);
                } else {
                    HostCharPreferencePage.this.delButton.setEnabled(false);
                    HostCharPreferencePage.this.editButton.setEnabled(false);
                }
            }
        });
        Composite tableButtons = new Composite(compMappingList, 0);
        tableButtons.setLayout((Layout)new GridLayout(1, true));
        tableButtons.setLayoutData((Object)new GridData(2));
        this.addButton = new Button(tableButtons, 0);
        this.addButton.setText(LpexResources.message("preferences.mappingtable.add_button"));
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HostCharacterMappingDialog addDialog = new HostCharacterMappingDialog(HostCharPreferencePage.this.getShell());
                addDialog.setUnexpectedMappingList(HostCharPreferencePage.this.getExistMappingList());
                if (addDialog.open() == 0) {
                    HostCharacterMapping mapping = addDialog.getHostCharacterMapping();
                    HostCharPreferencePage.this.mappingItemList.add(mapping);
                    HostCharPreferencePage.this.mappingListTable.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editButton = new Button(tableButtons, 0);
        this.editButton.setText(LpexResources.message("preferences.mappingtable.edit_button"));
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HostCharacterMappingDialog editDialog = new HostCharacterMappingDialog(HostCharPreferencePage.this.getShell());
                IStructuredSelection selection = (IStructuredSelection)HostCharPreferencePage.this.mappingListTable.getSelection();
                Iterator elements = selection.iterator();
                if (!elements.hasNext()) {
                    return;
                }
                HostCharacterMapping originalMapping = (HostCharacterMapping)elements.next();
                editDialog.init(originalMapping);
                List<HostCharacterMapping> unexpectedList = HostCharPreferencePage.this.getExistMappingList();
                unexpectedList.remove(originalMapping);
                editDialog.setUnexpectedMappingList(unexpectedList);
                editDialog.setInEditDialog(true);
                if (editDialog.open() == 0) {
                    HostCharacterMapping newMapping = editDialog.getHostCharacterMapping();
                    int index = HostCharPreferencePage.this.mappingItemList.indexOf(originalMapping);
                    HostCharPreferencePage.this.mappingItemList.remove(originalMapping);
                    HostCharPreferencePage.this.mappingItemList.add(index, newMapping);
                    HostCharPreferencePage.this.mappingListTable.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.delButton = new Button(tableButtons, 0);
        this.delButton.setText(LpexResources.message("preferences.mappingtable.delete_button"));
        this.delButton.setLayoutData((Object)new GridData(768));
        this.delButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)HostCharPreferencePage.this.mappingListTable.getSelection();
                Iterator elements = selection.iterator();
                if (!elements.hasNext()) {
                    return;
                }
                HostCharacterMapping originalMapping = (HostCharacterMapping)elements.next();
                HostCharPreferencePage.this.mappingItemList.remove(originalMapping);
                HostCharPreferencePage.this.mappingListTable.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.delButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.updateSettings(this._initialMappingTable, this._initialShowHostChar);
        return parent;
    }

    protected void createFieldEditors() {
    }

    public boolean performOk() {
        boolean update = HostCharPreferencePage.updateDefaultValue("showHostChar", this._showHostCharCheckBox.getOnOffValue());
        if (update |= HostCharPreferencePage.updateDefaultValue("hostCharMapping", HostCharacterUtil.buildHostCharMappingListString((List)this.mappingListTable.getInput(), null))) {
            LpexView.doGlobalCommand("screenShow");
        }
        return true;
    }

    protected void performDefaults() {
        String showHostChar = LpexView.globalQuery("install.showHostChar");
        String mappingTable = LpexView.globalQuery("install.hostCharMapping");
        this.updateSettings(mappingTable, showHostChar);
        super.performDefaults();
    }

    protected void setDefaultMapping() {
        this.mappingItemList.clear();
        for (HostCharacterMapping wcm : HostCharacterUtil.defaultMappingList) {
            this.mappingItemList.add(wcm);
        }
        this.mappingListTable.refresh();
    }

    @Override
    protected void performReset() {
        this.updateSettings(this._initialMappingTable, this._initialShowHostChar);
    }

    private void updateSettings(String mappingTable, String showHostChar) {
        this._showHostCharCheckBox.setSelected("on".equals(showHostChar));
        this.mappingItemList = HostCharacterUtil.parseHostCharMappingString(mappingTable);
        this.mappingListTable.setInput(this.mappingItemList);
    }

    private List<HostCharacterMapping> getExistMappingList() {
        ArrayList<HostCharacterMapping> list = new ArrayList<HostCharacterMapping>((List)this.mappingListTable.getInput());
        return list;
    }
}

