/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexBooleanFieldEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexIntegerFieldEditor;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class ComparePreferencePage
extends LpexFieldEditorPreferencePage {
    private boolean _initialIgnoreCase;
    private boolean _initialIgnoreLeadingBlanks;
    private boolean _initialIgnoreTrailingBlanks;
    private boolean _initialIgnoreAllBlanks;
    private boolean _initialIgnoreSequenceNumbers;
    private boolean _initialIgnoreComments;
    private boolean _initialColumns;
    private String _initialStartColumn;
    private String _initialEndColumn;
    private LpexBooleanFieldEditor _ignoreCaseCheckBox;
    private LpexBooleanFieldEditor _ignoreLeadingBlanksCheckBox;
    private LpexBooleanFieldEditor _ignoreTrailingBlanksCheckBox;
    private LpexBooleanFieldEditor _ignoreAllBlanksCheckBox;
    private LpexBooleanFieldEditor _ignoreSequenceNumbersCheckBox;
    private LpexBooleanFieldEditor _ignoreCommentsCheckBox;
    private LpexBooleanFieldEditor _columnsCheckBox;
    private LpexIntegerFieldEditor _startColumnField;
    private LpexIntegerFieldEditor _endColumnField;

    public ComparePreferencePage() {
        super(LpexResources.message("preferences.compareTitle"), 1);
    }

    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "compare_page");
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        this._initialIgnoreCase = this.defaultSetting("compare.ignoreCase");
        this._initialIgnoreLeadingBlanks = this.defaultSetting("compare.ignoreLeadingBlanks");
        this._initialIgnoreTrailingBlanks = this.defaultSetting("compare.ignoreTrailingBlanks");
        this._initialIgnoreAllBlanks = this.defaultSetting("compare.ignoreAllBlanks");
        this._initialIgnoreSequenceNumbers = this.defaultSetting("compare.ignoreSequenceNumbers");
        this._initialIgnoreComments = this.defaultSetting("compare.ignoreComments");
        this._initialColumns = this.defaultSetting("compare.columns");
        this._initialStartColumn = ComparePreferencePage.getDefaultValue("compare.startColumn");
        this._initialEndColumn = ComparePreferencePage.getDefaultValue("compare.endColumn");
        Composite parent = this.getFieldEditorParent();
        this._ignoreLeadingBlanksCheckBox = new LpexBooleanFieldEditor(parent, "preferences.compareIgnoreLeadingBlanks", this._initialIgnoreLeadingBlanks);
        this._ignoreTrailingBlanksCheckBox = new LpexBooleanFieldEditor(parent, "preferences.compareIgnoreTrailingBlanks", this._initialIgnoreTrailingBlanks);
        this._ignoreAllBlanksCheckBox = new LpexBooleanFieldEditor(parent, "preferences.compareIgnoreAllBlanks", this._initialIgnoreAllBlanks);
        this._ignoreCaseCheckBox = new LpexBooleanFieldEditor(parent, "preferences.compareIgnoreCase", this._initialIgnoreCase);
        this._ignoreCommentsCheckBox = new LpexBooleanFieldEditor(parent, "preferences.compareIgnoreComments", this._initialIgnoreComments);
        this._ignoreSequenceNumbersCheckBox = new LpexBooleanFieldEditor(parent, "preferences.compareIgnoreSequenceNumbers", this._initialIgnoreSequenceNumbers);
        new Label(parent, 0);
        new Label(parent, 0);
        this._columnsCheckBox = new LpexBooleanFieldEditor(parent, "preferences.compareColumns", this._initialColumns);
        this._startColumnField = new LpexIntegerFieldEditor(parent, "preferences.compareStartColumn");
        this._startColumnField.setStringValue(this._initialStartColumn);
        this._endColumnField = new LpexIntegerFieldEditor(parent, "preferences.compareEndColumn");
        this._endColumnField.setStringValue(this._initialEndColumn);
        this.enableStartEndColumns();
        this.addField((FieldEditor)this._ignoreLeadingBlanksCheckBox);
        this.addField((FieldEditor)this._ignoreTrailingBlanksCheckBox);
        this.addField((FieldEditor)this._ignoreAllBlanksCheckBox);
        this.addField((FieldEditor)this._ignoreCaseCheckBox);
        this.addField((FieldEditor)this._ignoreCommentsCheckBox);
        this.addField((FieldEditor)this._ignoreSequenceNumbersCheckBox);
        this.addField((FieldEditor)this._columnsCheckBox);
        this.addField((FieldEditor)this._startColumnField);
        this.addField((FieldEditor)this._endColumnField);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this._columnsCheckBox) {
            this.enableStartEndColumns();
        }
        super.propertyChange(event);
    }

    private void enableStartEndColumns() {
        boolean columns = this._columnsCheckBox.getBooleanValue();
        if (this._startColumnField != null) {
            this._startColumnField.setEnabled(columns);
        }
        if (this._endColumnField != null) {
            this._endColumnField.setEnabled(columns);
        }
    }

    public boolean performOk() {
        boolean change = this.updateLpex(this._ignoreCaseCheckBox, "compare.ignoreCase") | this.updateLpex(this._ignoreLeadingBlanksCheckBox, "compare.ignoreLeadingBlanks") | this.updateLpex(this._ignoreTrailingBlanksCheckBox, "compare.ignoreTrailingBlanks") | this.updateLpex(this._ignoreAllBlanksCheckBox, "compare.ignoreAllBlanks") | this.updateLpex(this._ignoreSequenceNumbersCheckBox, "compare.ignoreSequenceNumbers") | this.updateLpex(this._ignoreCommentsCheckBox, "compare.ignoreComments") | this.updateLpex(this._columnsCheckBox, "compare.columns") | this.updateLpex(this._startColumnField, "compare.startColumn") | this.updateLpex(this._endColumnField, "compare.endColumn");
        if (change) {
            LpexView.doGlobalCommand("compare refresh");
            LpexView.doGlobalCommand("screenShow");
        }
        return true;
    }

    protected void performDefaults() {
        this._ignoreCaseCheckBox.setSelected(this.installSetting("compare.ignoreCase"));
        this._ignoreLeadingBlanksCheckBox.setSelected(this.installSetting("compare.ignoreLeadingBlanks"));
        this._ignoreTrailingBlanksCheckBox.setSelected(this.installSetting("compare.ignoreTrailingBlanks"));
        this._ignoreAllBlanksCheckBox.setSelected(this.installSetting("compare.ignoreAllBlanks"));
        this._ignoreSequenceNumbersCheckBox.setSelected(this.installSetting("compare.ignoreSequenceNumbers"));
        this._ignoreCommentsCheckBox.setSelected(this.installSetting("compare.ignoreComments"));
        this._columnsCheckBox.setSelected(this.installSetting("compare.columns"));
        this._startColumnField.setStringValue(LpexView.globalQuery("install.compare.startColumn"));
        this._endColumnField.setStringValue(LpexView.globalQuery("install.compare.endColumn"));
        super.performDefaults();
    }

    @Override
    protected void performReset() {
        this._ignoreCaseCheckBox.setSelected(this._initialIgnoreCase);
        this._ignoreLeadingBlanksCheckBox.setSelected(this._initialIgnoreLeadingBlanks);
        this._ignoreTrailingBlanksCheckBox.setSelected(this._initialIgnoreTrailingBlanks);
        this._ignoreAllBlanksCheckBox.setSelected(this._initialIgnoreAllBlanks);
        this._ignoreSequenceNumbersCheckBox.setSelected(this._initialIgnoreSequenceNumbers);
        this._ignoreCommentsCheckBox.setSelected(this._initialIgnoreComments);
        this._columnsCheckBox.setSelected(this._initialColumns);
        this._startColumnField.setStringValue(this._initialStartColumn);
        this._endColumnField.setStringValue(this._initialEndColumn);
    }

    private boolean defaultSetting(String parameter) {
        return "on".equals(ComparePreferencePage.getDefaultValue(parameter));
    }

    private boolean installSetting(String parameter) {
        return "on".equals(LpexView.globalQuery("install." + parameter));
    }

    private boolean updateLpex(LpexBooleanFieldEditor checkBox, String parameter) {
        return checkBox != null ? ComparePreferencePage.updateDefaultValue(parameter, checkBox.getBooleanValue() ? "on" : "off") : false;
    }

    private boolean updateLpex(LpexIntegerFieldEditor integerField, String parameter) {
        return integerField != null ? ComparePreferencePage.updateDefaultValue(parameter, integerField.getStringValue()) : false;
    }
}

