/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexBooleanFieldEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexListEditor;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class BlockPreferencePage
extends LpexFieldEditorPreferencePage {
    private static final String[] _blockTypes = new String[]{"character", "element", "rectangle", "stream"};
    private static String[] _blockTypeNames = new String[4];
    private int _initialBlockType;
    private String _initialDragAndDrop;
    private LpexListEditor _blockTypeList;
    private LpexBooleanFieldEditor _dragAndDropCheckBox;

    public BlockPreferencePage() {
        super(LpexResources.message("preferences.blockTitle"), 1);
    }

    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "block_page");
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        int i = 0;
        while (i < _blockTypeNames.length) {
            BlockPreferencePage._blockTypeNames[i] = LpexResources.message("blockType." + _blockTypes[i]);
            if (_blockTypeNames[i] == null) {
                BlockPreferencePage._blockTypeNames[i] = _blockTypes[i];
            }
            ++i;
        }
        this._blockTypeList = new LpexListEditor(parent, "preferences.blockDefaultType", _blockTypeNames);
        new Label(parent, 0);
        this._dragAndDropCheckBox = new LpexBooleanFieldEditor(parent, "pref.blockDnd");
        this.addField(this._blockTypeList);
        this.addField((FieldEditor)this._dragAndDropCheckBox);
        this._initialBlockType = this.blockTypeIndex(BlockPreferencePage.getDefaultValue("block.defaultType"));
        this._initialDragAndDrop = BlockPreferencePage.getDefaultValue("block.dragAndDrop");
        this.updateSettings(this._initialBlockType, this._initialDragAndDrop);
    }

    public boolean performOk() {
        int index = this._blockTypeList.getSelectedIndex();
        if (index >= 0 && index < _blockTypes.length) {
            BlockPreferencePage.updateDefaultValue("block.defaultType", _blockTypes[index]);
        }
        BlockPreferencePage.updateDefaultValue("block.dragAndDrop", this._dragAndDropCheckBox.getOnOffValue());
        return true;
    }

    protected void performDefaults() {
        this.updateSettings(this.blockTypeIndex(LpexView.globalQuery("install.block.defaultType")), LpexView.globalQuery("install.block.dragAndDrop"));
        super.performDefaults();
    }

    @Override
    protected void performReset() {
        this.updateSettings(this._initialBlockType, this._initialDragAndDrop);
    }

    private void updateSettings(int index, String dragAndDrop) {
        if (index != -1) {
            this._blockTypeList.setSelectedIndex(index);
        } else {
            this._blockTypeList.clearSelection();
        }
        this._dragAndDropCheckBox.setSelected("on".equals(dragAndDrop));
    }

    private int blockTypeIndex(String blockType) {
        int i = 0;
        while (i < _blockTypes.length) {
            if (_blockTypes[i].equals(blockType)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

