/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.contentassist;

import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.alef.contentassist.ContentAssistant;
import com.ibm.lpex.alef.contentassist.IContentAssistListener;
import com.ibm.lpex.alef.contentassist.IContextInformation;
import com.ibm.lpex.alef.contentassist.IContextInformationPresenter;
import com.ibm.lpex.alef.contentassist.IContextInformationValidator;
import com.ibm.lpex.alef.contentassist.PopupCloser;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexWindow;
import java.util.Stack;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class ContextInformationPopup
implements IContentAssistListener {
    private LpexTextViewer fViewer;
    private ContentAssistant fContentAssistant;
    private PopupCloser fPopupCloser = new PopupCloser();
    private Shell fContextSelectorShell;
    private Table fContextSelectorTable;
    private IContextInformation[] fContextSelectorInput;
    private Shell fContextInfoPopup;
    private StyledText fContextInfoText;
    private TextPresentation fTextPresentation;
    private Stack<ContextFrame> fContextFrameStack = new Stack();

    public ContextInformationPopup(ContentAssistant contentAssistant, ITextViewer viewer) {
        this.fContentAssistant = contentAssistant;
        this.fViewer = (LpexTextViewer)viewer;
    }

    public String showContextProposals(final boolean autoActivated) {
        final LpexWindow lpexWindow = this.fViewer.getLpexWindow();
        BusyIndicator.showWhile((Display)lpexWindow.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                int count;
                int position = ContextInformationPopup.this.fViewer.getSelectedRange().x;
                IContextInformation[] contexts = ContextInformationPopup.this.computeContextInformation(position);
                int n = count = contexts == null ? 0 : contexts.length;
                if (count == 1) {
                    ContextInformationPopup.this.internalShowContextInfo(contexts[0], position);
                } else if (count > 0) {
                    ContextInformationPopup.this.createContextSelector();
                    ContextInformationPopup.this.setContexts(contexts);
                    ContextInformationPopup.this.displayContextSelector();
                    ContextInformationPopup.this.hideContextInfoPopup();
                } else if (!autoActivated) {
                    lpexWindow.getDisplay().beep();
                }
            }
        });
        return this.getErrorMessage();
    }

    public void showContextInformation(final IContextInformation info, final int position) {
        LpexWindow lpexWindow = this.fViewer.getLpexWindow();
        BusyIndicator.showWhile((Display)lpexWindow.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ContextInformationPopup.this.internalShowContextInfo(info, position);
                ContextInformationPopup.this.hideContextSelector();
            }
        });
    }

    private void internalShowContextInfo(IContextInformation information, int offset) {
        IContextInformationValidator validator = this.fContentAssistant.getContextInformationValidator(this.fViewer, offset);
        if (validator != null) {
            ContextFrame current = new ContextFrame();
            current.fInformation = information;
            LpexDocumentLocation location = this.fViewer.getLpexView().documentLocation();
            current.fBeginOffset = offset;
            current.fBeginLocation = location;
            current.fLocation = location;
            current.fVisibleOffset = this.fViewer.getSelectedRange().x - (offset - current.fBeginOffset);
            current.fValidator = validator;
            current.fPresenter = this.fContentAssistant.getContextInformationPresenter(this.fViewer, offset);
            this.fContextFrameStack.push(current);
            this.internalShowContextFrame(current, this.fContextFrameStack.size() == 1);
        }
    }

    private void internalShowContextFrame(ContextFrame frame, boolean initial) {
        frame.fValidator.install(frame.fInformation, this.fViewer, frame.fLocation);
        if (frame.fPresenter != null) {
            if (this.fTextPresentation == null) {
                this.fTextPresentation = new TextPresentation();
            }
            frame.fPresenter.install(frame.fInformation, this.fViewer, frame.fBeginLocation);
            frame.fPresenter.updatePresentation(frame.fLocation, this.fTextPresentation);
        }
        this.createContextInfoPopup();
        this.fContextInfoText.setText(frame.fInformation.getInformationDisplayString());
        if (this.fTextPresentation != null) {
            TextPresentation.applyTextPresentation((TextPresentation)this.fTextPresentation, (StyledText)this.fContextInfoText);
        }
        this.resize();
        if (initial) {
            if (this.fContentAssistant.addContentAssistListener(this, 2)) {
                this.fContentAssistant.addToLayout(this, this.fContextInfoPopup, 2, frame.fVisibleOffset);
                this.fContextInfoPopup.setVisible(true);
            }
        } else {
            this.fContentAssistant.layout(2, frame.fVisibleOffset);
        }
    }

    private IContextInformation[] computeContextInformation(int position) {
        return this.fContentAssistant.computeContextInformation(this.fViewer, position);
    }

    private String getErrorMessage() {
        return this.fContentAssistant.getErrorMessage();
    }

    private void createContextInfoPopup() {
        if (LpexUtilities.okToUse((Widget)this.fContextInfoPopup)) {
            return;
        }
        LpexWindow control = this.fViewer.getLpexWindow();
        Display display = control.getDisplay();
        this.fContextInfoPopup = new Shell(control.getShell(), 16392);
        this.fContextInfoPopup.setBackground(display.getSystemColor(2));
        this.fContextInfoText = new StyledText((Composite)this.fContextInfoPopup, 10);
        Color c = this.fContentAssistant.getContextInformationPopupBackground();
        if (c == null) {
            c = display.getSystemColor(29);
        }
        this.fContextInfoText.setBackground(c);
        c = this.fContentAssistant.getContextInformationPopupForeground();
        if (c == null) {
            c = display.getSystemColor(28);
        }
        this.fContextInfoText.setForeground(c);
    }

    private void resize() {
        Point size = this.fContextInfoText.computeSize(-1, -1, true);
        size.x += 3;
        this.fContextInfoText.setSize(size);
        this.fContextInfoText.setLocation(1, 1);
        size.x += 2;
        size.y += 2;
        this.fContextInfoPopup.setSize(size);
    }

    private void hideContextInfoPopup() {
        if (LpexUtilities.okToUse((Widget)this.fContextInfoPopup)) {
            int size = this.fContextFrameStack.size();
            if (size > 0) {
                this.fContextFrameStack.pop();
                --size;
            }
            if (size > 0) {
                ContextFrame current = this.fContextFrameStack.peek();
                this.internalShowContextFrame(current, false);
            } else {
                this.fContentAssistant.removeContentAssistListener(this, 2);
                this.fContextInfoPopup.setVisible(false);
                this.fContextInfoPopup.dispose();
                this.fContextInfoPopup = null;
                if (this.fTextPresentation != null) {
                    this.fTextPresentation.clear();
                    this.fTextPresentation = null;
                }
            }
        }
    }

    private void createContextSelector() {
        if (LpexUtilities.okToUse((Widget)this.fContextSelectorShell)) {
            return;
        }
        LpexWindow control = this.fViewer.getLpexWindow();
        this.fContextSelectorShell = new Shell(control.getShell(), 16392);
        this.fContextSelectorTable = new Table((Composite)this.fContextSelectorShell, 768);
        int height = this.fContextSelectorTable.getItemHeight() * 10;
        this.fContextSelectorShell.setSize(302, height + 2);
        this.fContextSelectorTable.setSize(300, height);
        this.fContextSelectorTable.setLocation(1, 1);
        this.fContextSelectorShell.setBackground(control.getDisplay().getSystemColor(2));
        Color c = this.fContentAssistant.getContextSelectorBackground();
        if (c == null) {
            c = control.getDisplay().getSystemColor(29);
        }
        this.fContextSelectorTable.setBackground(c);
        c = this.fContentAssistant.getContextSelectorForeground();
        if (c == null) {
            c = control.getDisplay().getSystemColor(28);
        }
        this.fContextSelectorTable.setForeground(c);
        this.fContextSelectorTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ContextInformationPopup.this.insertSelectedContext();
                ContextInformationPopup.this.hideContextSelector();
            }
        });
        this.fPopupCloser.install(this.fContentAssistant, this.fContextSelectorTable);
        this.fContextSelectorTable.setHeaderVisible(false);
        this.fContentAssistant.addToLayout(this, this.fContextSelectorShell, 1, this.fContentAssistant.getSelectionOffset());
    }

    private void insertSelectedContext() {
        int i = this.fContextSelectorTable.getSelectionIndex();
        if (i < 0 || i >= this.fContextSelectorInput.length) {
            return;
        }
        int position = this.fViewer.getSelectedRange().x;
        this.internalShowContextInfo(this.fContextSelectorInput[i], position);
    }

    private void setContexts(IContextInformation[] contexts) {
        if (LpexUtilities.okToUse((Widget)this.fContextSelectorTable)) {
            this.fContextSelectorInput = contexts;
            this.fContextSelectorTable.setRedraw(false);
            this.fContextSelectorTable.removeAll();
            int i = 0;
            while (i < contexts.length) {
                IContextInformation t = contexts[i];
                TableItem item = new TableItem(this.fContextSelectorTable, 0);
                if (t.getImage() != null) {
                    item.setImage(t.getImage());
                }
                item.setText(t.getContextDisplayString());
                ++i;
            }
            this.fContextSelectorTable.select(0);
            this.fContextSelectorTable.setRedraw(true);
        }
    }

    private void displayContextSelector() {
        if (this.fContentAssistant.addContentAssistListener(this, 0)) {
            this.fContextSelectorShell.setVisible(true);
        }
    }

    private void hideContextSelector() {
        if (LpexUtilities.okToUse((Widget)this.fContextSelectorShell)) {
            this.fContentAssistant.removeContentAssistListener(this, 0);
            this.fPopupCloser.uninstall();
            this.fContextSelectorShell.setVisible(false);
            this.fContextSelectorShell.dispose();
            this.fContextSelectorShell = null;
        }
    }

    public boolean hasFocus() {
        if (LpexUtilities.okToUse((Widget)this.fContextSelectorShell)) {
            return this.fContextSelectorShell.isFocusControl() || this.fContextSelectorTable.isFocusControl();
        }
        return false;
    }

    public void hide() {
        this.hideContextSelector();
        this.hideContextInfoPopup();
    }

    public boolean isActive() {
        return LpexUtilities.okToUse((Widget)this.fContextInfoPopup) || LpexUtilities.okToUse((Widget)this.fContextSelectorShell);
    }

    @Override
    public boolean keyPressed(Event e) {
        if (LpexUtilities.okToUse((Widget)this.fContextSelectorShell)) {
            return this.contextSelectorKeyPressed(e);
        }
        if (LpexUtilities.okToUse((Widget)this.fContextInfoPopup)) {
            return this.contextInfoPopupKeyPressed(e);
        }
        return true;
    }

    private boolean contextSelectorKeyPressed(Event e) {
        char key = e.character;
        if (key == '\u0000') {
            int change;
            int visibleRows = this.fContextSelectorTable.getSize().y / this.fContextSelectorTable.getItemHeight() - 1;
            int selection = this.fContextSelectorTable.getSelectionIndex();
            switch (e.keyCode) {
                case 0x1000001: {
                    change = this.fContextSelectorTable.getSelectionIndex() > 0 ? -1 : 0;
                    break;
                }
                case 0x1000002: {
                    change = this.fContextSelectorTable.getSelectionIndex() < this.fContextSelectorTable.getItemCount() - 1 ? 1 : 0;
                    break;
                }
                case 0x1000006: {
                    change = visibleRows;
                    if (selection + change < this.fContextSelectorTable.getItemCount()) break;
                    change = this.fContextSelectorTable.getItemCount() - selection;
                    break;
                }
                case 0x1000005: {
                    change = -visibleRows;
                    if (selection + change >= 0) break;
                    change = -selection;
                    break;
                }
                case 0x1000007: {
                    change = -selection;
                    break;
                }
                case 0x1000008: {
                    change = this.fContextSelectorTable.getItemCount() - selection;
                    break;
                }
                case 131072: 
                case 262144: {
                    return true;
                }
                default: {
                    this.hideContextSelector();
                    return true;
                }
            }
            this.fContextSelectorTable.setSelection(selection + change);
            this.fContextSelectorTable.showSelection();
            e.doit = false;
            return false;
        }
        if (key == '\r') {
            this.insertSelectedContext();
            this.hideContextSelector();
            e.doit = false;
            return false;
        }
        if (key == '\t') {
            this.fContextSelectorShell.setFocus();
            e.doit = false;
            return false;
        }
        if (key == '\u001b') {
            this.hideContextSelector();
            e.doit = false;
            return false;
        }
        return true;
    }

    private boolean contextInfoPopupKeyPressed(Event e) {
        char key = e.character;
        if (key == '\u0000') {
            switch (e.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    this.validateContextInformation();
                    break;
                }
                case 131072: 
                case 262144: {
                    break;
                }
                default: {
                    this.hideContextInfoPopup();
                    break;
                }
            }
        } else {
            if (key == '\u001b') {
                this.hideContextInfoPopup();
                e.doit = false;
                return false;
            }
            this.validateContextInformation();
        }
        return true;
    }

    private void validateContextInformation() {
        this.fContextInfoPopup.getDisplay().asyncExec(new Runnable(){
            private ContextFrame fFrame;
            {
                this.fFrame = ContextInformationPopup.this.fContextFrameStack.peek();
            }

            @Override
            public void run() {
                if (LpexUtilities.okToUse((Widget)ContextInformationPopup.this.fContextInfoPopup) && this.fFrame == ContextInformationPopup.this.fContextFrameStack.peek()) {
                    LpexDocumentLocation location = ContextInformationPopup.this.fViewer.getLpexView().documentLocation();
                    if (this.fFrame.fValidator == null || !this.fFrame.fValidator.isContextInformationValid(location)) {
                        ContextInformationPopup.this.hideContextInfoPopup();
                    } else if (this.fFrame.fPresenter != null && this.fFrame.fPresenter.updatePresentation(location, ContextInformationPopup.this.fTextPresentation)) {
                        TextPresentation.applyTextPresentation((TextPresentation)ContextInformationPopup.this.fTextPresentation, (StyledText)ContextInformationPopup.this.fContextInfoText);
                        ContextInformationPopup.this.resize();
                    }
                }
            }
        });
    }

    static class ContextFrame {
        public int fBeginOffset;
        public LpexDocumentLocation fBeginLocation;
        public LpexDocumentLocation fLocation;
        public int fVisibleOffset;
        public IContextInformation fInformation;
        public IContextInformationValidator fValidator;
        public IContextInformationPresenter fPresenter;

        ContextFrame() {
        }
    }
}

