/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.alef.LpexTextEditor;
import com.ibm.lpex.alef.LpexTextSelection;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextSelectionNavigationLocation;

public class LpexTextSelectionNavigationLocation
extends TextSelectionNavigationLocation {
    private static int COUNTER = 1;
    private static Object counterLockForId = new Object();
    private final int id;
    private static final String TAG_TYPE = "selectionType";
    private static final String TAG_TOP_ELEMENT = "topElement";
    private static final String TAG_TOP_POSITION = "topPosition";
    private static final String TAG_BOTTOM_ELEMENT = "bottomElement";
    private static final String TAG_BOTTOM_POSITION = "bottomPosition";
    protected String fSelectionType;
    private Block fSavedBlock;
    private Block fBlock;
    static final boolean DEBUG_LOGGING = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LpexTextSelectionNavigationLocation(ITextEditor part, String selectionType, boolean initialize) {
        super(part, initialize);
        Object object = counterLockForId;
        synchronized (object) {
            this.id = COUNTER++;
        }
        if (initialize) {
            ITextEditor textEditor;
            ISelection s;
            ISelectionProvider provider = part == null ? null : part.getSelectionProvider();
            ISelection iSelection = s = provider == null ? null : provider.getSelection();
            if (s == null || s.isEmpty()) {
                return;
            }
            if (this.getEditorPart() instanceof ITextEditor && (textEditor = (ITextEditor)this.getEditorPart()) instanceof LpexTextEditor) {
                LpexView view = ((LpexTextEditor)textEditor).getLpexView();
                boolean blockInView = view.query("block.inview").equals("on");
                if (blockInView) {
                    this.fSelectionType = selectionType;
                    this.fBlock = new Block(view.queryInt("block.topElement"), view.queryInt("block.topPosition"), view.queryInt("block.bottomElement"), view.queryInt("block.bottomPosition"));
                    if (part != null && !part.isDirty()) {
                        this.fSavedBlock = new Block(this.fBlock);
                    }
                } else {
                    this.fSelectionType = "none";
                }
            }
        }
        this.logLpexNavigationEvent("Created");
    }

    public String toString() {
        return super.toString();
    }

    public void dispose() {
        this.fBlock = null;
        this.fSavedBlock = null;
        super.dispose();
    }

    public void releaseState() {
        this.fBlock = null;
        this.fSavedBlock = null;
        super.releaseState();
    }

    public boolean mergeInto(INavigationLocation location) {
        if (super.mergeInto(location)) {
            if (this.fBlock == null) {
                return true;
            }
            LpexTextSelectionNavigationLocation s = (LpexTextSelectionNavigationLocation)location;
            s.fSelectionType = this.fSelectionType;
            s.fBlock = this.fBlock;
            s.fSavedBlock = this.fSavedBlock;
        }
        this.logLpexNavigationEvent("mergeInto");
        return false;
    }

    public void restoreLocation() {
        if (this.fSelectionType == null || this.fSelectionType.isEmpty() || this.fSelectionType.equals("stream")) {
            super.restoreLocation();
        } else {
            IEditorPart part = this.getEditorPart();
            if (part instanceof LpexAbstractTextEditor) {
                LpexAbstractTextEditor editor = (LpexAbstractTextEditor)this.getEditorPart();
                if (this.fSelectionType.equals("none")) {
                    boolean blockActive;
                    LpexView v = editor.getActiveLpexView();
                    boolean blockInView = v.query("block.inview").equals("on");
                    boolean bl = blockActive = v.queryInt("block.topElement") > 0;
                    if (blockActive && !blockInView) {
                        editor.selectAndReveal(this.fSelectionType, this.fBlock);
                    } else {
                        super.restoreLocation();
                    }
                } else {
                    editor.selectAndReveal(this.fSelectionType, this.fBlock);
                }
            }
        }
        this.logLpexNavigationEvent("restoreLocation");
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        IEditorPart part = this.getEditorPart();
        if (part instanceof ITextEditor) {
            this.fSelectionType = memento.getString(TAG_TYPE);
            Integer te = memento.getInteger(TAG_TOP_ELEMENT);
            Integer tp = memento.getInteger(TAG_TOP_POSITION);
            Integer be = memento.getInteger(TAG_BOTTOM_ELEMENT);
            Integer bp = memento.getInteger(TAG_BOTTOM_POSITION);
            if (te != null && tp != null && be != null && bp != null) {
                this.fBlock = new Block(te, tp, be, bp);
            }
            if (this.fBlock != null && !part.isDirty()) {
                this.fSavedBlock = new Block(this.fBlock);
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.fSelectionType != null) {
            memento.putString(TAG_TYPE, this.fSelectionType);
        }
        if (this.fBlock != null) {
            memento.putInteger(TAG_TOP_ELEMENT, this.fBlock.topElement);
            memento.putInteger(TAG_TOP_POSITION, this.fBlock.topPosition);
            memento.putInteger(TAG_BOTTOM_ELEMENT, this.fBlock.bottomElement);
            memento.putInteger(TAG_BOTTOM_POSITION, this.fBlock.bottomPosition);
        }
    }

    public void partSaved(IEditorPart part) {
        super.partSaved(part);
        if (this.fBlock != null) {
            this.fSavedBlock = new Block(this.fBlock);
        }
    }

    public void update() {
        IEditorPart part = this.getEditorPart();
        if (part == null) {
            return;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return;
        }
        ISelectionProvider siteSelectionProvider = site.getSelectionProvider();
        if (siteSelectionProvider == null) {
            return;
        }
        try {
            super.update();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (part instanceof ITextEditor) {
            ISelection s;
            ITextEditor textEditor = (ITextEditor)this.getEditorPart();
            if (textEditor == null) {
                return;
            }
            ISelectionProvider selectionProvider = textEditor.getSelectionProvider();
            ISelection iSelection = s = selectionProvider == null ? null : selectionProvider.getSelection();
            if (s == null || s.isEmpty()) {
                return;
            }
            ITextSelection selection = (ITextSelection)s;
            if (selection.getOffset() == 0 && selection.getLength() == 0) {
                return;
            }
            if (textEditor instanceof LpexTextEditor) {
                LpexTextSelection lpexSel;
                LpexView lpexSelView;
                boolean blockInView;
                LpexView view = ((LpexTextEditor)textEditor).getLpexView();
                if (view == null) {
                    return;
                }
                String blockInViewValue = view.query("block.inview");
                boolean bl = blockInView = blockInViewValue == null ? false : blockInViewValue.equals("on");
                if (blockInView && selection instanceof LpexTextSelection && (lpexSelView = (lpexSel = (LpexTextSelection)selection).getLpexView()) != null) {
                    this.fSelectionType = lpexSelView.query("block.type");
                    this.fBlock = new Block(lpexSelView.queryInt("block.topElement"), lpexSelView.queryInt("block.topPosition"), lpexSelView.queryInt("block.bottomElement"), lpexSelView.queryInt("block.bottomPosition"));
                    if (!part.isDirty()) {
                        this.fSavedBlock = new Block(this.fBlock);
                    }
                }
            }
        }
        this.logLpexNavigationEvent("Update");
    }

    public void logLpexNavigationEvent(String message) {
    }

    public static final class Block {
        private int topElement = -1;
        private int topPosition = -1;
        private int bottomElement = -1;
        private int bottomPosition = -1;

        public Block(int ptopElement, int ptopPosition, int pbottomElement, int pbottomPosition) {
            this.topElement = ptopElement;
            this.topPosition = ptopPosition;
            this.bottomElement = pbottomElement;
            this.bottomPosition = pbottomPosition;
        }

        public Block(Block b) {
            this.topElement = b.topElement;
            this.topPosition = b.topPosition;
            this.bottomElement = b.bottomElement;
            this.bottomPosition = b.bottomPosition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.bottomElement;
            result = 31 * result + this.bottomPosition;
            result = 31 * result + this.topElement;
            result = 31 * result + this.topPosition;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Block) {
                Block other = (Block)obj;
                if (this.bottomElement != other.bottomElement) {
                    return false;
                }
                if (this.bottomPosition != other.bottomPosition) {
                    return false;
                }
                if (this.topElement != other.topElement) {
                    return false;
                }
                if (this.topPosition != other.topPosition) {
                    return false;
                }
            }
            return super.equals(obj);
        }

        public int getTopElement() {
            return this.topElement;
        }

        public int getTopPosition() {
            return this.topPosition;
        }

        public int getBottomElement() {
            return this.bottomElement;
        }

        public int getBottomPosition() {
            return this.bottomPosition;
        }
    }
}

