/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.EclipseProfile;
import com.ibm.lpex.alef.LpexPreload;
import com.ibm.lpex.alef.PluginClassLoader;
import com.ibm.lpex.alef.internal.LpexPreloadPriority;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class LpexPlugin
extends AbstractUIPlugin {
    private static LpexPlugin _lpexPlugin;
    private static ResourceBundle _resourceBundle;
    private static EclipseProfile _profile;
    private static final Object _lockObject;
    public static final String PLUGIN_ID = "com.ibm.lpex";

    static {
        _lockObject = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LpexPlugin() {
        Object object = _lockObject;
        synchronized (object) {
            if (_lpexPlugin == null) {
                _lpexPlugin = this;
                try {
                    _resourceBundle = ResourceBundle.getBundle("com.ibm.lpex.alef.PluginResources");
                }
                catch (MissingResourceException x) {
                    _resourceBundle = null;
                    LpexLog.log(x);
                }
            }
        }
    }

    public static LpexPlugin getDefault() {
        return _lpexPlugin;
    }

    public static ResourceBundle getResourceBundle() {
        return _resourceBundle;
    }

    public static String getResourceString(String key) {
        try {
            if (_resourceBundle != null) {
                return _resourceBundle.getString(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return key;
    }

    public static String getResourceLpexString(String key) {
        String value = LpexResources.message(_resourceBundle, key);
        return value == null ? key : value;
    }

    public static String getResourceLpexString(String key, String arg) {
        String value = LpexResources.message(_resourceBundle, key, arg);
        return value == null ? key : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        IPath homeDir = this.getStateLocation();
        LpexView.doGlobalCommand("set editorLog \"" + homeDir.append("Editor.log").toFile().getPath() + "\"");
        Object object = _lockObject;
        synchronized (object) {
            _profile = new EclipseProfile();
        }
        Properties associations = new Properties();
        associations.setProperty("install.updateProfile.parserAssociation.epf", "prop");
        associations.setProperty("install.updateProfile.parserAssociation.prefs", "prop");
        LpexView.extendInstallProfile(associations);
        this.handleExtensionsPreload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        Object object = _lockObject;
        synchronized (object) {
            try {
                if (_profile != null) {
                    _profile.dispose();
                }
            }
            finally {
                _profile = null;
                _lpexPlugin = null;
                super.stop(context);
            }
        }
    }

    private void handleExtensionsPreload() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.lpex.preload");
        ArrayList<LpexPreload> preloads = new ArrayList<LpexPreload>();
        int j = 0;
        while (j < elements.length) {
            if ("preload".equals(elements[j].getName())) {
                try {
                    Object execExt = elements[j].createExecutableExtension("class");
                    if (execExt instanceof LpexPreload) {
                        preloads.add((LpexPreload)execExt);
                        Bundle bundle = FrameworkUtil.getBundle(execExt.getClass());
                        if (bundle != null) {
                            LpexView.setClassLoader(new PluginClassLoader(bundle));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++j;
        }
        Collections.sort(preloads, new Comparator<LpexPreload>(){

            @Override
            public int compare(LpexPreload o1, LpexPreload o2) {
                if (o1 instanceof LpexPreloadPriority && o2 instanceof LpexPreloadPriority) {
                    return ((LpexPreloadPriority)((Object)o1)).getPriority() - ((LpexPreloadPriority)((Object)o2)).getPriority();
                }
                if (o1 instanceof LpexPreloadPriority) {
                    return -1;
                }
                if (o2 instanceof LpexPreloadPriority) {
                    return 1;
                }
                return 0;
            }
        });
        for (LpexPreload lpexPreload : preloads) {
            lpexPreload.preload();
        }
    }
}

