/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.Utilities;
import org.eclipse.ui.texteditor.TextNavigationAction;

final class LpexKeyBindingAction
extends TextNavigationAction {
    private LpexAbstractTextEditor _editor;
    private String _keyString;

    public LpexKeyBindingAction(LpexAbstractTextEditor editor, String keyString) {
        super(null, 1);
        this._editor = editor;
        this._keyString = keyString;
        this.setActionDefinitionId(keyString);
    }

    public void run() {
        int lpexActionId;
        LpexView lpexView = this._editor.getLpexView();
        if (lpexView == null) {
            return;
        }
        if (this._editor._traceCommands) {
            lpexView.doDefaultCommand("set messageText * commandId: " + this._keyString);
            lpexView.doDefaultCommand("screenShow view");
        }
        if ("vi".equals(lpexView.query("baseProfile"))) {
            Utilities.processLpexKey(lpexView, this._keyString);
            lpexView.doCommand("screenShow");
            return;
        }
        String query = "keyAction." + this._keyString;
        if (lpexView.queryOn("inPrefix")) {
            query = query + ".p";
        }
        if ((lpexActionId = lpexView.actionId(lpexView.query(query))) != 0) {
            if (lpexActionId == 30) {
                Object argument;
                int charIndex = this._keyString.lastIndexOf(45);
                if (charIndex < 0) {
                    charIndex = this._keyString.lastIndexOf(44);
                }
                int c = this._keyString.charAt(0);
                if (charIndex > 0) {
                    if (this._keyString.startsWith("minus", charIndex + 1)) {
                        c = 45;
                    } else if (charIndex < this._keyString.length() - 1) {
                        c = this._keyString.charAt(charIndex + 1);
                    }
                }
                argument = (String)((argument = lpexView.query("actionArgument")) == null ? "" : argument) + String.valueOf((char)c);
                lpexView.doCommand("set actionArgument " + (String)argument);
            } else {
                lpexView.triggerAction(lpexActionId, true);
            }
        }
    }
}

