/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexSourceViewer;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.texteditor.FocusedInformationPresenter;

class LpexFocusedInformationPresenter
extends FocusedInformationPresenter {
    LpexSourceViewer _viewer;
    private int _offset;

    public LpexFocusedInformationPresenter(ISourceViewer sourceViewer, SourceViewerConfiguration sourceViewerConfiguration) {
        super(sourceViewer, sourceViewerConfiguration);
        this._viewer = (LpexSourceViewer)sourceViewer;
        this.install((Control)this._viewer.getFirstLpexWindow().textWindow());
    }

    public void setOffset(int offset) {
        this._offset = offset;
        super.setOffset(offset);
    }

    protected void computeInformation() {
        Object info;
        int offset;
        int n = offset = this._offset < 0 ? this._viewer.getSelectedRange().x : this._offset;
        if (offset == -1) {
            return;
        }
        this._offset = -1;
        IInformationProvider provider = null;
        try {
            String contentType = TextUtilities.getContentType((IDocument)this._viewer.getDocument(), (String)this.getDocumentPartitioning(), (int)offset, (boolean)true);
            provider = this.getInformationProvider(contentType);
        }
        catch (BadLocationException contentType) {
            // empty catch block
        }
        if (provider == null) {
            return;
        }
        IRegion subject = provider.getSubject((ITextViewer)this._viewer, offset);
        if (subject == null) {
            return;
        }
        if (provider instanceof IInformationProviderExtension) {
            IInformationProviderExtension extension = (IInformationProviderExtension)provider;
            info = extension.getInformation2((ITextViewer)this._viewer, subject);
        } else {
            info = provider.getInformation((ITextViewer)this._viewer, subject);
        }
        if (provider instanceof IInformationProviderExtension2) {
            this.setCustomInformationControlCreator(((IInformationProviderExtension2)provider).getInformationPresenterControlCreator());
        } else {
            this.setCustomInformationControlCreator(null);
        }
        this.setInformation(info, this.computeArea(subject));
    }

    private Rectangle computeArea(IRegion region) {
        IRegion widgetRegion = this._viewer.modelRange2WidgetRange(region);
        int start = widgetRegion.getOffset();
        int end = widgetRegion.getOffset() + widgetRegion.getLength();
        if (end == start) {
            end = start + 1;
        }
        LpexView lpexView = this._viewer.getFirstLpexView();
        int rows = lpexView.queryInt("rows");
        int rowHeight = lpexView.queryInt("rowHeight");
        int prefixWidth = lpexView.queryInt("prefixAreaWidth") + lpexView.queryInt("expandHideAreaWidth");
        if (lpexView.query("prefixAreaMargin") != null) {
            prefixWidth += lpexView.queryInt("current.prefixAreaMargin");
        }
        int xAdjust = prefixWidth - lpexView.queryInt("scroll") - 2 * lpexView.queryInt("pixelPosition", new LpexDocumentLocation(1, 2));
        int upperLeftx = 0;
        int upperLefty = 0;
        int lowerRightx = 0;
        int lowerRighty = 0;
        int offset = start;
        while (offset < end) {
            int x = -1;
            int y = -1;
            LpexDocumentLocation loc = this._viewer.getLpexDocumentLocation(offset);
            int row = 1;
            while (row <= rows) {
                if (lpexView.elementOfRow(row) == loc.element) {
                    y = (row - 1) * rowHeight;
                    x = lpexView.queryInt("pixelPosition", loc) + xAdjust;
                    break;
                }
                ++row;
            }
            if (offset == start) {
                upperLeftx = lowerRightx = x;
                upperLefty = lowerRighty = y;
            } else if (x != -1 || y != -1) {
                if (upperLeftx > x) {
                    upperLeftx = x;
                }
                if (upperLefty > y) {
                    upperLefty = y;
                }
                if (lowerRightx < x) {
                    lowerRightx = x;
                }
                if (lowerRighty < y) {
                    lowerRighty = y;
                }
            }
            ++offset;
        }
        int width = (lowerRightx += this._viewer.getAverageCharWidth(this._viewer.getFirstLpexWindow())) - upperLeftx;
        int height = (lowerRighty += rowHeight) - upperLefty;
        return new Rectangle(upperLeftx, upperLefty, width, height);
    }
}

