/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.alef.LpexPlugin;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexViewListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.TextEditorAction;

public class LpexContextContributor
extends BasicTextEditorActionContributor {
    private LpexAbstractTextEditor _activeEditor;
    private LpexView _activeLpexView;
    private LpexEditorAction _firstAction;
    private static ResourceBundle _bundle = LpexPlugin.getResourceBundle();
    private LpexEditorAction _compareFileAction;
    private LpexEditorAction _startAction;
    private LpexEditorAction _stopAction;
    private LpexEditorAction _playAction;
    static final URL ICONS_URL = LpexPlugin.getDefault().getBundle().getEntry("/icons/full/");
    static final ImageDescriptor COMPARE_IMAGE_ENABLED;
    static final ImageDescriptor COMPARE_IMAGE_DISABLED;
    static final ImageDescriptor START_IMAGE_ENABLED;
    static final ImageDescriptor START_IMAGE_DISABLED;
    static final ImageDescriptor STOP_IMAGE_ENABLED;
    static final ImageDescriptor STOP_IMAGE_DISABLED;
    static final ImageDescriptor PLAY_IMAGE_ENABLED;
    static final ImageDescriptor PLAY_IMAGE_DISABLED;
    private LpexViewListener _lpexViewListener = new LpexViewAdapter(){

        @Override
        public void shown(LpexView lpexView) {
            LpexContextContributor.this.updateActions();
        }

        @Override
        public void updateProfile(LpexView lpexView) {
            LpexContextContributor.this.handleUpdateProfile(lpexView);
        }

        @Override
        public void disposed(LpexView lpexView) {
            LpexContextContributor.this.handleLpexViewDisposed();
        }
    };

    static {
        String prefix = "etool16/";
        COMPARE_IMAGE_ENABLED = LpexContextContributor.createImageDescriptor(prefix + "compare_co.png");
        START_IMAGE_ENABLED = LpexContextContributor.createImageDescriptor(prefix + "start_exec.png");
        STOP_IMAGE_ENABLED = LpexContextContributor.createImageDescriptor(prefix + "stop_exec.png");
        PLAY_IMAGE_ENABLED = LpexContextContributor.createImageDescriptor(prefix + "play_exec.png");
        prefix = "dtool16/";
        COMPARE_IMAGE_DISABLED = LpexContextContributor.createImageDescriptor(prefix + "compare_co.png");
        START_IMAGE_DISABLED = LpexContextContributor.createImageDescriptor(prefix + "start_exec.png");
        STOP_IMAGE_DISABLED = LpexContextContributor.createImageDescriptor(prefix + "stop_exec.png");
        PLAY_IMAGE_DISABLED = LpexContextContributor.createImageDescriptor(prefix + "play_exec.png");
    }

    private void handleUpdateProfile(LpexView lpexView) {
        this.updateLabels();
    }

    private void handleLpexViewDisposed() {
        this._activeLpexView = null;
    }

    protected void activeWindowChanged() {
        if (this._activeLpexView != null) {
            this._activeLpexView.removeLpexViewListener(this._lpexViewListener);
        }
        this._activeLpexView = null;
        if (this._activeEditor != null) {
            this._activeLpexView = this._activeEditor.getLpexView();
            if (this._activeLpexView != null) {
                this._activeLpexView.addLpexViewListener(this._lpexViewListener);
            }
        }
        this.updateLabels();
    }

    private static ImageDescriptor createImageDescriptor(String path) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(ICONS_URL, path));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void init(IActionBars bars) {
        this._compareFileAction = new LpexEditorAction(70, "popup.compareFile", "popup_compareFile_context", COMPARE_IMAGE_ENABLED, COMPARE_IMAGE_DISABLED);
        this._startAction = new LpexEditorAction(132, "start.", "menu_038", START_IMAGE_ENABLED, START_IMAGE_DISABLED);
        this._stopAction = new LpexEditorAction(133, "stop.", "menu_039", STOP_IMAGE_ENABLED, STOP_IMAGE_DISABLED);
        this._playAction = new LpexEditorAction(131, "play.", "menu_040", PLAY_IMAGE_ENABLED, PLAY_IMAGE_DISABLED);
        super.init(bars);
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager m = menu.findMenuUsingPath("file");
        if (m != null) {
            try {
                m.insertAfter("import.ext", (IAction)new LpexEditorAction(116, "get.", "menu_001"));
                m.insertAfter("import.ext", (IContributionItem)new Separator());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((m = menu.findMenuUsingPath("edit")) != null) {
            MenuManager mm;
            try {
                String FIND_ID = ActionFactory.FIND.getId();
                m.insertAfter(FIND_ID, (IAction)new LpexEditorAction(191, "showAll.", "popup_showAll_context"));
                mm = new MenuManager(LpexPlugin.getResourceString("findOtherMenu"), "lpex_findOther");
                mm.add((IAction)new LpexEditorAction(114, "findSelection.", "popup_findSelection_context"));
                mm.add((IAction)new LpexEditorAction(108, "findBlockStart.", "menu_006"));
                mm.add((IAction)new LpexEditorAction(107, "findBlockEnd.", "menu_007"));
                mm.add((IAction)new LpexEditorAction(109, "findLastChange.", "menu_008"));
                mm.add((IAction)new LpexEditorAction(113, "findQuickMark.", "menu_009"));
                mm.add((IAction)new LpexEditorAction(110, "findMark.", "menu_010"));
                m.insertAfter(FIND_ID, (IContributionItem)mm);
                m.insertAfter(FIND_ID, (IAction)new LpexEditorAction(115, "findUp.", "menu_003"));
                m.insertAfter(FIND_ID, (IAction)new LpexEditorAction(112, "findNext.", "menu_002"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            m.add((IContributionItem)new Separator());
            mm = new MenuManager(LpexPlugin.getResourceString("selectMenu"), "lpex_select");
            mm.add((IAction)new LpexEditorAction(41, "popup.blockMarkElement", "popup_blockMarkElement_context"));
            mm.add((IAction)new LpexEditorAction(39, "popup.blockMarkCharacter", "popup_blockMarkCharacter_context"));
            mm.add((IAction)new LpexEditorAction(52, "popup.blockMarkRectangle", "popup_blockMarkRectangle_context"));
            m.add((IContributionItem)mm);
            mm = new MenuManager(LpexPlugin.getResourceString("selectedMenu"), "lpex_selected");
            mm.add((IAction)new LpexEditorAction(33, "popup.blockCopy", "popup_blockCopy_context"));
            mm.add((IAction)new LpexEditorAction(61, "popup.blockOverlay", "popup_blockOverlay_context"));
            mm.add((IAction)new LpexEditorAction(60, "popup.blockMove", "popup_blockMove_context"));
            mm.add((IAction)new LpexEditorAction(34, "popup.blockDelete", "popup_blockDelete_context"));
            mm.add((IAction)new LpexEditorAction(65, "popup.blockUpperCase", "popup_blockUpperCase_context"));
            mm.add((IAction)new LpexEditorAction(36, "popup.blockLowerCase", "popup_blockLowerCase_context"));
            mm.add((IAction)new LpexEditorAction(62, "popup.blockShiftLeft", "popup_blockShiftLeft_context"));
            mm.add((IAction)new LpexEditorAction(63, "popup.blockShiftRight", "popup_blockShiftRight_context"));
            mm.add((IContributionItem)new Separator());
            mm.add((IAction)new LpexEditorAction(102, "popup.filterSelection", "popup_filterSelection_context"));
            mm.add((IAction)new LpexEditorAction(98, "popup.excludeSelection", "popup_excludeSelection_context"));
            mm.add((IAction)new LpexEditorAction(35, "popup.blockFill", "popup_blockFill_context"));
            m.add((IContributionItem)mm);
            m.add((IAction)new LpexEditorAction(64, "blockUnmark.", "popup_blockUnmark_context"));
            m.add((IContributionItem)new Separator());
            mm = new MenuManager(LpexPlugin.getResourceString("markMenu"), "lpex_mark");
            mm.add((IAction)new LpexEditorAction(188, "setQuickMark.", "menu_029"));
            mm.add((IAction)new LpexEditorAction(142, "nameMark.", "menu_030"));
            m.add((IContributionItem)mm);
            m.add((IAction)this._compareFileAction);
            mm = new MenuManager(LpexPlugin.getResourceString("recorderMenu"), "lpex_recorder");
            mm.add((IAction)this._startAction);
            mm.add((IAction)this._stopAction);
            mm.add((IAction)this._playAction);
            m.add((IContributionItem)mm);
            m.add((IContributionItem)new Separator());
        }
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("lpex"));
        LpexEditorAction action = new LpexEditorAction(205, "undo.", "tool_001");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
        tbm.add((IAction)action);
        action = new LpexEditorAction(171, "redo.", "tool_002");
        action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
        tbm.add((IAction)action);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._startAction);
        tbm.add((IAction)this._stopAction);
        tbm.add((IAction)this._playAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._compareFileAction);
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        super.setActiveEditor(targetEditor);
        this.doSetActiveEditor(targetEditor);
    }

    private void doSetActiveEditor(IEditorPart targetEditor) {
        IActionBars actionBars;
        if (this._activeLpexView != null) {
            this._activeLpexView.removeLpexViewListener(this._lpexViewListener);
        }
        this._activeEditor = null;
        this._activeLpexView = null;
        if (targetEditor instanceof LpexAbstractTextEditor) {
            this._activeEditor = (LpexAbstractTextEditor)targetEditor;
            this._activeLpexView = this._activeEditor.getLpexView();
            if (this._activeLpexView != null) {
                this._activeLpexView.addLpexViewListener(this._lpexViewListener);
            }
        }
        if ((actionBars = this.getActionBars()) != null) {
            actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(this._activeEditor, IDEActionFactory.BOOKMARK.getId()));
            actionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), this.getAction(this._activeEditor, IDEActionFactory.ADD_TASK.getId()));
        }
        this.updateEditor();
        this.updateActions();
        if (this._activeLpexView != null) {
            this.getStandardDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LpexContextContributor.this.updateLabels();
                }
            });
        }
    }

    private Display getStandardDisplay() {
        Display display = Display.getCurrent();
        return display != null ? display : Display.getDefault();
    }

    public void dispose() {
        this.doSetActiveEditor(null);
        LpexEditorAction action = this._firstAction;
        while (action != null) {
            action.dispose();
            LpexEditorAction oldaction = action;
            action = action.next();
            oldaction._next = null;
        }
        this._firstAction = null;
        this._compareFileAction = null;
        this._startAction = null;
        this._stopAction = null;
        this._playAction = null;
        this._activeEditor = null;
        this._activeLpexView = null;
        this._lpexViewListener = null;
        super.dispose();
    }

    private void updateEditor() {
        LpexEditorAction action = this._firstAction;
        while (action != null) {
            action.setEditor(this._activeEditor);
            action = action.next();
        }
    }

    private void updateLabels() {
        if (this._activeEditor != null) {
            LpexEditorAction action = this._firstAction;
            while (action != null) {
                action.showAccelerator();
                action = action.next();
            }
        }
    }

    private void updateActions() {
        LpexView lpexView = this._activeEditor != null ? this._activeEditor.getLpexView() : null;
        LpexEditorAction action = this._firstAction;
        while (action != null) {
            action.update(lpexView);
            action = action.next();
        }
        action = this.getAction(this._activeEditor, IDEActionFactory.BOOKMARK.getId());
        if (action != null && action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if ((action = this.getAction(this._activeEditor, IDEActionFactory.ADD_TASK.getId())) != null && action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private final class LpexEditorAction
    extends TextEditorAction {
        private LpexEditorAction _next;
        private int _actionId;

        public LpexEditorAction(int actionId, String prefix, String helpId, ImageDescriptor iconEnabled, ImageDescriptor iconDisabled) {
            super(_bundle, prefix, null);
            this._actionId = -1;
            this._actionId = actionId;
            if (iconEnabled != null) {
                this.setImageDescriptor(iconEnabled);
                this.setDisabledImageDescriptor(iconDisabled);
            }
            this.setHelpContextId("com.ibm.lpex." + helpId);
            this._next = LpexContextContributor.this._firstAction;
            LpexContextContributor.this._firstAction = this;
            if (prefix.startsWith("popup.")) {
                this.setText(LpexResources.message(prefix));
                String description = LpexResources.message(prefix + ".description");
                this.setToolTipText(description);
                this.setDescription(description);
            }
        }

        public void dispose() {
            this.setHelpListener(null);
            this.clearListeners();
        }

        public LpexEditorAction(int actionId, String prefix, String helpId) {
            this(actionId, prefix, helpId, null, null);
        }

        LpexEditorAction next() {
            return this._next;
        }

        void showAccelerator() {
            LpexAbstractTextEditor editor = (LpexAbstractTextEditor)this.getTextEditor();
            if (editor != null) {
                this.setActionDefinitionId(editor.getActionAccelerator(this._actionId));
            }
            this.firePropertyChange("text", null, this.getText());
        }

        public void update() {
            LpexAbstractTextEditor editor = (LpexAbstractTextEditor)this.getTextEditor();
            LpexView lpexView = editor != null ? editor.getLpexView() : null;
            this.update(lpexView);
        }

        void update(LpexView lpexView) {
            this.setEnabled(lpexView != null && lpexView.actionAvailable(this._actionId));
        }

        public void run() {
            LpexView lpexView;
            LpexAbstractTextEditor editor = (LpexAbstractTextEditor)this.getTextEditor();
            LpexView lpexView2 = lpexView = editor != null ? editor.getLpexView() : null;
            if (lpexView != null) {
                lpexView.triggerAction(this._actionId);
            }
        }
    }
}

