/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.AnnotationColumn;
import com.ibm.lpex.alef.DocumentAdapter;
import com.ibm.lpex.alef.LineNumberColumn;
import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.alef.LpexAddMarkerAction;
import com.ibm.lpex.alef.LpexAddTaskAction;
import com.ibm.lpex.alef.LpexAnnotationRulerColumn;
import com.ibm.lpex.alef.LpexCompositeRuler;
import com.ibm.lpex.alef.LpexLineChangeHover;
import com.ibm.lpex.alef.LpexLineNumberChangeRulerColumn;
import com.ibm.lpex.alef.LpexOverviewRuler;
import com.ibm.lpex.alef.LpexSourceViewer;
import com.ibm.lpex.alef.LpexStatusTextEditor;
import com.ibm.lpex.alef.TaskMarkerRulerAction;
import com.ibm.lpex.core.LpexCommonParser;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexMultiWindow;
import com.ibm.lpex.core.LpexParser;
import com.ibm.lpex.core.LpexView;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.ITextEditorHelpContextIds;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.BooleanPreferenceToggleAction;
import org.eclipse.ui.internal.texteditor.FocusedInformationPresenter;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChangeEncodingAction;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.MarkerRulerAction;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.rulers.IColumnSupport;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;

public abstract class LpexAbstractDecoratedTextEditor
extends LpexStatusTextEditor {
    private static final String OVERVIEW_RULER = "overviewRuler";
    private MarkerAnnotationPreferences fAnnotationPreferences;
    private IOverviewRuler fOverviewRuler;
    protected IAnnotationAccess fAnnotationAccess;
    protected SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    private FocusedInformationPresenter fInformationPresenter;
    private LpexLineNumberChangeRulerColumn fLineNumberRulerColumn;
    private LineNumberColumn fLineColumn;
    private IDocumentProvider fImplicitDocumentProvider;
    private Object fGotoMarkerAdapter = new GotoMarkerAdapter();
    private boolean fIsEditingDerivedFileAllowed = true;
    private boolean fIsDerivedStateValidated;

    private IVerticalRuler internalGetVerticalRuler() {
        return this.getVerticalRuler();
    }

    public LpexAbstractDecoratedTextEditor() {
        this.fAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.initializeEditor();
    }

    protected void initializeEditor() {
        this.setPreferenceStore(EditorsUI.getPreferenceStore());
    }

    @Override
    public void dispose() {
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.dispose();
            this.fSourceViewerDecorationSupport = null;
        }
        this.fAnnotationAccess = null;
        this.fAnnotationPreferences = null;
        this.fLineNumberRulerColumn = null;
        this.fLineColumn = null;
        super.dispose();
    }

    @Override
    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        LpexSourceViewer viewer = new LpexSourceViewer(parent, this, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport(viewer);
        return viewer;
    }

    protected ISharedTextColors getSharedColors() {
        ISharedTextColors sharedColors = EditorsUI.getSharedTextColors();
        return sharedColors;
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        LpexOverviewRuler ruler = new LpexOverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
        for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
            if (!preference.contributesToHeader()) continue;
            ruler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        return ruler;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        Iterator e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        RulerColumnDescriptor lineNumberColumnDescriptor;
        if (this._partBeingForcedClose) {
            return;
        }
        super.createPartControl(parent);
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.install(this.getPreferenceStore());
        }
        IColumnSupport columnSupport = (IColumnSupport)this.getAdapter(IColumnSupport.class);
        if (this.isLineNumberRulerVisible() && (lineNumberColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("com.ibm.lpex.columns.linenumbers")) != null) {
            columnSupport.setColumnVisible(lineNumberColumnDescriptor, true);
        }
        if (this.isPrefQuickDiffAlwaysOn()) {
            this.showChangeInformation(true);
        }
        if (!this.isRangeIndicatorEnabled()) {
            this.getSourceViewer().removeRangeIndication();
            this.getSourceViewer().setRangeIndicator(null);
        }
    }

    protected boolean isOverviewRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean(OVERVIEW_RULER) : false;
    }

    @Override
    public void showChangeInformation(boolean show) {
        if (show == this.isChangeInformationShowing()) {
            return;
        }
        IColumnSupport columnSupport = (IColumnSupport)this.getAdapter(IColumnSupport.class);
        if (show && this.fLineColumn == null) {
            RulerColumnDescriptor lineNumberColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("com.ibm.lpex.columns.linenumbers");
            if (lineNumberColumnDescriptor != null) {
                columnSupport.setColumnVisible(lineNumberColumnDescriptor, true);
            }
        } else if (!show && this.fLineColumn != null && !this.isLineNumberRulerVisible()) {
            columnSupport.setColumnVisible(this.fLineColumn.getDescriptor(), false);
            this.fLineColumn = null;
        }
    }

    @Override
    public boolean isChangeInformationShowing() {
        return this.fLineColumn != null && this.fLineColumn.isShowingChangeInformation();
    }

    @Override
    public void showRevisionInformation(RevisionInformation info, String quickDiffProviderId) {
        this.showChangeInformation(true);
        if (this.fLineColumn != null) {
            this.fLineColumn.showRevisionInformation(info, quickDiffProviderId);
        }
    }

    protected boolean isLineNumberRulerVisible() {
        return false;
    }

    private boolean isRangeIndicatorEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store == null ? true : store.getBoolean("show_range_indicator");
    }

    protected boolean isPrefQuickDiffAlwaysOn() {
        boolean setting;
        IPreferenceStore store = this.getPreferenceStore();
        boolean bl = setting = store != null ? store.getBoolean("quickdiff.quickDiff") : false;
        return setting && this.isEditorInputModifiable();
    }

    protected void initializeLineNumberRulerColumn(LpexLineNumberChangeRulerColumn rulerColumn) {
        if (this.fLineColumn != null) {
            this.fLineColumn.initializeLineNumberRulerColumn(rulerColumn);
        }
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        this.fLineNumberRulerColumn = new LpexLineNumberChangeRulerColumn(this.getSharedColors());
        this.fLineNumberRulerColumn.setHover((IAnnotationHover)this.createChangeHover());
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fLineNumberRulerColumn;
    }

    protected LineChangeHover createChangeHover() {
        return new LpexLineChangeHover();
    }

    @Override
    protected IVerticalRuler createVerticalRuler() {
        return this.createCompositeRuler();
    }

    protected CompositeRuler createCompositeRuler() {
        return new LpexCompositeRuler();
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler ruler) {
        return new LpexAnnotationRulerColumn(12, this.getAnnotationAccess());
    }

    @Override
    protected final IColumnSupport createColumnSupport() {
        return new LpexAbstractTextEditor.ColumnSupport(this, RulerColumnRegistry.getDefault()){

            @Override
            protected void initializeColumn(IContributedRulerColumn column) {
                super.initializeColumn(column);
                RulerColumnDescriptor descriptor = column.getDescriptor();
                IVerticalRuler ruler = LpexAbstractDecoratedTextEditor.this.internalGetVerticalRuler();
                if (ruler instanceof LpexCompositeRuler) {
                    if ("com.ibm.lpex.columns.annotations".equals(descriptor.getId())) {
                        ((AnnotationColumn)column).setDelegate(LpexAbstractDecoratedTextEditor.this.createAnnotationRulerColumn((LpexCompositeRuler)ruler));
                    } else if ("com.ibm.lpex.columns.linenumbers".equals(descriptor.getId())) {
                        LpexAbstractDecoratedTextEditor.this.fLineColumn = (LineNumberColumn)column;
                        LpexAbstractDecoratedTextEditor.this.fLineColumn.setForwarder(new LineNumberColumn.ICompatibilityForwarder(){

                            @Override
                            public IVerticalRulerColumn createLineNumberRulerColumn() {
                                return LpexAbstractDecoratedTextEditor.this.createLineNumberRulerColumn();
                            }

                            @Override
                            public boolean isQuickDiffEnabled() {
                                return LpexAbstractDecoratedTextEditor.this.isPrefQuickDiffAlwaysOn();
                            }

                            @Override
                            public boolean isLineNumberRulerVisible() {
                                return LpexAbstractDecoratedTextEditor.this.isLineNumberRulerVisible();
                            }
                        });
                    }
                }
            }

            @Override
            public void dispose() {
                LpexAbstractDecoratedTextEditor.this.fLineColumn = null;
                super.dispose();
            }
        };
    }

    @Override
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            LpexSourceViewer sourceViewer = (LpexSourceViewer)this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            String property = event.getProperty();
            if (this.fSourceViewerDecorationSupport != null && this.fOverviewRuler != null && OVERVIEW_RULER.equals(property)) {
                if (this.isOverviewRulerVisible()) {
                    this.showOverviewRuler();
                } else {
                    this.hideOverviewRuler();
                }
                return;
            }
            if ("quickdiff.quickDiff".equals(property)) {
                this.showChangeInformation(this.isPrefQuickDiffAlwaysOn());
            }
            if ("show_range_indicator".equals(property)) {
                if (this.isRangeIndicatorEnabled()) {
                    sourceViewer.setRangeIndicator(this.getRangeIndicator());
                } else {
                    sourceViewer.removeRangeIndication();
                    sourceViewer.setRangeIndicator(null);
                }
            }
            HyperlinkDetectorDescriptor[] descriptor = EditorsUI.getHyperlinkDetectorRegistry().getHyperlinkDetectorDescriptors();
            int i = 0;
            while (i < descriptor.length) {
                if (descriptor[i].getId().equals(property) || (descriptor[i].getId() + "_stateMask").equals(property)) {
                    IHyperlinkDetector[] detectors = this.getSourceViewerConfiguration().getHyperlinkDetectors((ISourceViewer)sourceViewer);
                    int stateMask = this.getSourceViewerConfiguration().getHyperlinkStateMask((ISourceViewer)sourceViewer);
                    sourceViewer.setHyperlinkDetectors(detectors, stateMask);
                    return;
                }
                ++i;
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    protected void showOverviewRuler() {
        if (this.fOverviewRuler != null) {
            ((LpexSourceViewer)this.getSourceViewer()).showAnnotationsOverview(true);
            this.fSourceViewerDecorationSupport.updateOverviewDecorations();
        }
    }

    protected void hideOverviewRuler() {
        this.fSourceViewerDecorationSupport.hideAnnotationOverview();
        ((LpexSourceViewer)this.getSourceViewer()).showAnnotationsOverview(false);
    }

    protected IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    protected IOverviewRuler getOverviewRuler() {
        if (this.fOverviewRuler == null) {
            this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        }
        return this.fOverviewRuler;
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    protected MarkerAnnotationPreferences getAnnotationPreferences() {
        return this.fAnnotationPreferences;
    }

    public void gotoMarker(IMarker marker) {
        String blockDefaultType;
        LpexView lpexView = this.getFirstLpexView();
        if (lpexView == null || marker == null) {
            return;
        }
        LpexDocumentLocation originalLocation = new LpexDocumentLocation(lpexView.documentLocation().element, lpexView.documentLocation().position);
        int charStart = MarkerUtilities.getCharStart((IMarker)marker);
        int charEnd = MarkerUtilities.getCharEnd((IMarker)marker);
        boolean lineMarker = charStart < 0 || charEnd < 0;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)model;
            Position pos = markerModel.getMarkerPosition(marker);
            if (pos != null && !pos.isDeleted()) {
                charStart = pos.getOffset();
                charEnd = pos.getOffset() + pos.getLength();
            }
            if (pos != null && pos.isDeleted()) {
                return;
            }
        }
        if ("element".equals(blockDefaultType = lpexView.query("current.block.defaultType"))) {
            blockDefaultType = "stream";
        }
        if (!lineMarker) {
            LpexSourceViewer lpexSourceViewer = (LpexSourceViewer)this.getSourceViewer();
            LpexDocumentLocation start = lpexSourceViewer.getLpexDocumentLocation(charStart);
            this.ensureVisible(lpexView, start.element);
            lpexView.jump(originalLocation);
            lpexView.doCommand("screenShow view");
            this.markInNavigationHistory();
            lpexView.jump(start.element, start.position);
            if (charEnd != charStart) {
                lpexView.doCommand("screenShow view");
                lpexView.doCommand("block clear");
                lpexView.doCommand("block set " + blockDefaultType);
                LpexDocumentLocation end = lpexSourceViewer.getLpexDocumentLocation(charEnd);
                this.ensureVisible(lpexView, end.element);
                if (!"stream".equals(blockDefaultType)) {
                    --end.position;
                }
                lpexView.jump(end.element, end.position);
                lpexView.doCommand("block set");
            }
            this.markInNavigationHistory();
        } else {
            int line;
            if (charStart >= 0) {
                try {
                    line = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOfOffset(charStart) + 1;
                }
                catch (BadLocationException e) {
                    return;
                }
            } else {
                line = MarkerUtilities.getLineNumber((IMarker)marker);
            }
            int element = lpexView.elementOfLine(line);
            if (element <= 0) {
                return;
            }
            this.ensureVisible(lpexView, element);
            lpexView.jump(originalLocation);
            lpexView.doCommand("screenShow view");
            this.markInNavigationHistory();
            lpexView.jump(element, 1);
            int len = lpexView.queryInt("length");
            if (len > 0) {
                lpexView.doCommand("block clear");
                lpexView.doCommand("block set " + blockDefaultType);
                if (!"stream".equals(blockDefaultType)) {
                    --len;
                }
                lpexView.jump(element, len + 1);
                lpexView.doCommand("block set");
            }
            this.markInNavigationHistory();
        }
        lpexView.doCommand("screenShow");
        LpexMultiWindow lpexMultiWindow = ((LpexSourceViewer)this.getSourceViewer()).getLpexMultiWindow();
        if (lpexMultiWindow.getMaximizedControl() != null && lpexMultiWindow.getMaximizedControl() != this.getFirstLpexWindow()) {
            lpexMultiWindow.setMaximizedControl(null);
        }
    }

    @Override
    public boolean isEditable() {
        if (!super.isEditable()) {
            return false;
        }
        return this.fIsEditingDerivedFileAllowed;
    }

    @Override
    public boolean validateEditorInputState() {
        if (!super.validateEditorInputState()) {
            return false;
        }
        return this.validateEditorInputDerived();
    }

    private boolean validateEditorInputDerived() {
        if (this.fIsDerivedStateValidated) {
            return this.fIsEditingDerivedFileAllowed;
        }
        if (this.getDocumentProvider() instanceof IDocumentProviderExtension) {
            boolean isDerivedStatus;
            IDocumentProviderExtension extension = (IDocumentProviderExtension)this.getDocumentProvider();
            IStatus status = extension.getStatus((Object)this.getEditorInput());
            String pluginId = status.getPlugin();
            boolean bl = isDerivedStatus = status.getCode() == 5 && ("org.eclipse.core.filebuffers".equals(pluginId) || "org.eclipse.ui.editors".equals(pluginId));
            if (!isDerivedStatus) {
                return true;
            }
        }
        String warnKey = "warn_if_input_derived";
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        if (!store.getBoolean("warn_if_input_derived")) {
            return true;
        }
        MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getSite().getShell(), (String)TextEditorMessages1.getString("AbstractDecoratedTextEditor_warning_derived_title"), (String)TextEditorMessages1.getString("AbstractDecoratedTextEditor_warning_derived_message"), (String)TextEditorMessages1.getString("AbstractDecoratedTextEditor_warning_derived_dontShowAgain"), (boolean)false, null, null);
        EditorsUI.getPreferenceStore().setValue("warn_if_input_derived", !toggleDialog.getToggleState());
        this.fIsDerivedStateValidated = true;
        this.fIsEditingDerivedFileAllowed = toggleDialog.getReturnCode() == 2;
        return this.fIsEditingDerivedFileAllowed;
    }

    @Override
    protected boolean isErrorStatus(IStatus status) {
        if (!super.isErrorStatus(status)) {
            return false;
        }
        if (!status.isMultiStatus()) {
            return !this.isReadOnlyLocalStatus(status);
        }
        IStatus[] childrenStatus = status.getChildren();
        int i = 0;
        while (i < childrenStatus.length) {
            if (childrenStatus[i].getSeverity() == 4 && !this.isReadOnlyLocalStatus(childrenStatus[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isReadOnlyLocalStatus(IStatus status) {
        return status.getCode() == 279;
    }

    @Override
    protected void createActions() {
        super.createActions();
        Object action = new LpexAddMarkerAction(TextEditorMessages.getResourceBundle(), "Editor.AddBookmark.", this, "org.eclipse.core.resources.bookmark", true);
        action.setHelpContextId(ITextEditorHelpContextIds.BOOKMARK_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.addBookmark");
        this.setAction(IDEActionFactory.BOOKMARK.getId(), (IAction)action);
        action = new LpexAddTaskAction(TextEditorMessages.getResourceBundle(), "Editor.AddTask.", this);
        action.setHelpContextId(ITextEditorHelpContextIds.ADD_TASK_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.addTask");
        this.setAction(IDEActionFactory.ADD_TASK.getId(), (IAction)action);
        action = new ChangeEncodingAction(TextEditorMessages.getResourceBundle(), "Editor.ChangeEncodingAction.", (ITextEditor)this);
        action.setHelpContextId("org.eclipse.ui.ChangeEncoding_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.changeEncoding");
        this.setAction("ChangeEncoding", (IAction)action);
        this.markAsPropertyDependentAction("ChangeEncoding", true);
        action = new ResourceAction(TextEditorMessages.getResourceBundle(), "Editor.ToggleQuickDiffAction.", 2){

            public void run() {
                LpexAbstractDecoratedTextEditor.this.toggleQuickDiffRuler();
            }
        };
        action.setActionDefinitionId("org.eclipse.quickdiff.toggle");
        this.setAction("QuickDiff.Toggle", (IAction)action);
        action = new ResourceAction(TextEditorMessages.getResourceBundle(), "Editor.HideRevisionInformationAction."){

            public void run() {
                if (LpexAbstractDecoratedTextEditor.this.fLineColumn != null) {
                    LpexAbstractDecoratedTextEditor.this.fLineColumn.hideRevisionInformation();
                }
            }
        };
        this.setAction("Revision.HideInfo", (IAction)action);
        action = new ResourceAction(TextEditorMessages.getResourceBundle(), "Editor.CycleRevisionRenderingAction."){

            public void run() {
                IRevisionRulerColumnExtension.RenderingMode[] modes = new IRevisionRulerColumnExtension.RenderingMode[]{IRevisionRulerColumnExtension.AGE, IRevisionRulerColumnExtension.AUTHOR, IRevisionRulerColumnExtension.AUTHOR_SHADED_BY_AGE};
                IPreferenceStore store = EditorsUI.getPreferenceStore();
                String current = store.getString("revisionRulerRenderingMode");
                int i = 0;
                while (i < modes.length) {
                    String mode = modes[i].name();
                    if (mode.equals(current)) {
                        int nextIndex = (i + 1) % modes.length;
                        IRevisionRulerColumnExtension.RenderingMode nextMode = modes[nextIndex];
                        store.setValue("revisionRulerRenderingMode", nextMode.name());
                    }
                    ++i;
                }
            }
        };
        action.setActionDefinitionId("org.eclipse.ui.editors.revisions.rendering.cycle");
        this.setAction("Revision.Rendering.Cycle", (IAction)action);
        action = new BooleanPreferenceToggleAction(TextEditorMessages.getResourceBundle(), "Editor.ToggleRevisionAuthorAction.", 2, EditorsUI.getPreferenceStore(), "revisionRulerShowAuthor");
        action.setActionDefinitionId("org.eclipse.ui.editors.revisions.author.toggle");
        this.setAction("Revision.ShowAuthor.Toggle", (IAction)action);
        action = new BooleanPreferenceToggleAction(TextEditorMessages.getResourceBundle(), "Editor.ToggleRevisionIdAction.", 2, EditorsUI.getPreferenceStore(), "revisionRulerShowRevision");
        action.setActionDefinitionId("org.eclipse.ui.editors.revisions.id.toggle");
        this.setAction("Revision.ShowId.Toggle", (IAction)action);
        action = new ResourceAction(TextEditorMessages.getResourceBundle(), "Editor.ShowChangeRulerInformation.", 1){

            public void run() {
                LpexAbstractDecoratedTextEditor.this.showChangeRulerInformation();
            }
        };
        action.setActionDefinitionId("org.eclipse.ui.edit.text.showChangeRulerInformation");
        this.setAction("ShowChangeRulerInformation", (IAction)action);
    }

    private void showChangeRulerInformation() {
        IVerticalRuler ruler = this.getVerticalRuler();
        if (!(ruler instanceof CompositeRuler) || this.fLineColumn == null) {
            return;
        }
        CompositeRuler compositeRuler = (CompositeRuler)ruler;
        int x = this.fLineColumn.getControl().getLocation().x;
        ISourceViewer sourceViewer = this.getSourceViewer();
        StyledText textWidget = sourceViewer.getTextWidget();
        int caretOffset = textWidget.getCaretOffset();
        int caretLine = textWidget.getLineAtOffset(caretOffset);
        int y = textWidget.getLinePixel(caretLine);
        compositeRuler.setLocationOfLastMouseButtonActivity(x, y);
        IAnnotationHover hover = this.fLineColumn.getHover();
        if (hover == null) {
            return;
        }
        int modelCaretOffset = LpexAbstractDecoratedTextEditor.widgetOffset2ModelOffset(sourceViewer, caretOffset);
        if (modelCaretOffset == -1) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        try {
            int line = document.getLineOfOffset(modelCaretOffset);
            if (this.fInformationPresenter == null) {
                this.fInformationPresenter = new FocusedInformationPresenter(sourceViewer, this.getSourceViewerConfiguration());
            }
            this.fInformationPresenter.openFocusedAnnotationHover(hover, line);
        }
        catch (BadLocationException e) {
            return;
        }
    }

    static void createRulerMarkerActions(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        MarkerRulerAction action = new MarkerRulerAction(TextEditorMessages.getResourceBundle(), "Editor.ManageBookmarks.", editor, rulerInfo, "org.eclipse.core.resources.bookmark", true);
        action.setHelpContextId(ITextEditorHelpContextIds.BOOKMARK_ACTION);
        editor.setAction("ManageBookmarks", (IAction)action);
        action = new TaskMarkerRulerAction(TextEditorMessages.getResourceBundle(), "Editor.ManageTasks.", editor, rulerInfo);
        action.setHelpContextId(ITextEditorHelpContextIds.ADD_TASK_ACTION);
        editor.setAction("ManageTasks", (IAction)action);
        editor.setAction("RulerDoubleClick", editor.getAction("ManageBookmarks"));
        editor.setAction("RulerClick", (IAction)new SelectMarkerRulerAction(TextEditorMessages.getResourceBundle(), "Editor.SelectMarker.", editor, rulerInfo));
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IGotoMarker.class.equals((Object)adapter)) {
            return this.fGotoMarkerAdapter;
        }
        if (IAnnotationAccess.class.equals((Object)adapter)) {
            return this.getAnnotationAccess();
        }
        if (IRevisionRulerColumn.class.equals((Object)adapter)) {
            return this.fLineNumberRulerColumn;
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected void setDocumentProvider(IEditorInput input) {
        this.fImplicitDocumentProvider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        IDocumentProvider provider = super.getDocumentProvider();
        if (provider instanceof ForwardingDocumentProvider) {
            ForwardingDocumentProvider forwarder = (ForwardingDocumentProvider)provider;
            forwarder.setParentProvider(this.fImplicitDocumentProvider);
        }
    }

    @Override
    public IDocumentProvider getDocumentProvider() {
        IDocumentProvider provider = super.getDocumentProvider();
        return provider == null ? this.fImplicitDocumentProvider : provider;
    }

    @Override
    protected void disposeDocumentProvider() {
        super.disposeDocumentProvider();
        this.fImplicitDocumentProvider = null;
    }

    @Override
    protected void doSetInput(IEditorInput input) throws CoreException {
        this.fIsDerivedStateValidated = false;
        this.fIsEditingDerivedFileAllowed = true;
        if (this.fLineColumn != null) {
            this.fLineColumn.hideRevisionInformation();
        }
        super.doSetInput(input);
        RulerColumnDescriptor lineNumberColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("com.ibm.lpex.columns.linenumbers");
        if (lineNumberColumnDescriptor != null) {
            IColumnSupport columnSupport = (IColumnSupport)this.getAdapter(IColumnSupport.class);
            columnSupport.setColumnVisible(lineNumberColumnDescriptor, this.isLineNumberRulerVisible() || this.isPrefQuickDiffAlwaysOn());
        }
    }

    @Override
    protected void performSaveAs(IProgressMonitor progressMonitor) {
        IFile initialFile = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            initialFile = ((IFileEditorInput)input).getFile();
        }
        this.performSaveAs(progressMonitor, initialFile);
    }

    @Override
    protected void performSaveAs(IProgressMonitor progressMonitor, String fileName) {
        IProject project;
        IResource inputResource;
        IFile initialFile = null;
        if (fileName != null && (inputResource = this.getInputResource()) != null && (project = inputResource.getProject()) != null) {
            initialFile = project.getFile(fileName);
        }
        this.performSaveAs(progressMonitor, initialFile);
    }

    protected void performSaveAs(IProgressMonitor progressMonitor, IFile original) {
        boolean success;
        block25: {
            Object newInput;
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            IDocumentProvider provider = this.getDocumentProvider();
            if (input instanceof IURIEditorInput && !(input instanceof IFileEditorInput)) {
                IFileStore fileStore;
                String msg;
                String title;
                MessageDialog overwriteDialog;
                String path;
                dialog = new FileDialog(shell, 8192);
                IPath oldPath = URIUtil.toPath((URI)((IURIEditorInput)input).getURI());
                if (oldPath != null) {
                    dialog.setFileName(oldPath.lastSegment());
                    dialog.setFilterPath(oldPath.toOSString());
                }
                if ((path = dialog.open()) == null) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    return;
                }
                File localFile = new File(path);
                if (localFile.exists() && (overwriteDialog = new MessageDialog(shell, title = TextEditorMessages1.getString("AbstractDecoratedTextEditor_saveAs_overwrite_title"), null, msg = MessageFormat.format(TextEditorMessages1.getString("AbstractDecoratedTextEditor_saveAs_overwrite_message"), path), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0 && progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                    return;
                }
                try {
                    fileStore = EFS.getStore((URI)localFile.toURI());
                }
                catch (CoreException ex) {
                    EditorsPlugin.log((IStatus)ex.getStatus());
                    String title2 = TextEditorMessages1.getString("AbstractDecoratedTextEditor_error_saveAs_title");
                    String msg2 = MessageFormat.format(TextEditorMessages1.getString("AbstractDecoratedTextEditor_error_saveAs_message"), ex.getMessage());
                    MessageDialog.openError((Shell)shell, (String)title2, (String)msg2);
                    return;
                }
                IFile file = this.getWorkspaceFile(fileStore);
                newInput = file != null ? new FileEditorInput(file) : new FileStoreEditorInput(fileStore);
            } else {
                dialog = new SaveAsDialog(shell);
                if (original != null) {
                    dialog.setOriginalFile(original);
                }
                dialog.create();
                if (provider.isDeleted((Object)input) && original != null) {
                    String message = MessageFormat.format(TextEditorMessages1.getString("AbstractDecoratedTextEditor_warning_saveAs_deleted"), original.getName());
                    dialog.setErrorMessage(null);
                    dialog.setMessage(message, 2);
                }
                if (dialog.open() == 1) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    return;
                }
                IPath filePath = dialog.getResult();
                if (filePath == null) {
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    return;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IFile file = workspace.getRoot().getFile(filePath);
                newInput = new FileEditorInput(file);
            }
            if (provider == null) {
                return;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange(newInput);
                    LpexView lpexView = this.getLpexView();
                    lpexView.doDefaultCommand("undo check");
                    lpexView.doCommand("parse");
                    lpexView.doDefaultCommand("undo resetChanges");
                    lpexView.doCommand("screenShow document");
                    provider.saveDocument(progressMonitor, newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        String title = TextEditorMessages1.getString("AbstractDecoratedTextEditor_error_saveAs_title");
                        String msg = MessageFormat.format(TextEditorMessages1.getString("AbstractDecoratedTextEditor_error_saveAs_message"), x.getMessage());
                        MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                    }
                    provider.changed(newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                provider.changed(newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
                throw throwable;
            }
            provider.changed(newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    private IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(fileStore.toURI());
        return files != null && files.length == 1 ? files[0] : null;
    }

    @Override
    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("debug"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("restore"));
        menu.add((IContributionItem)new Separator("add"));
        menu.add((IContributionItem)new Separator("rulers"));
        menu.add((IContributionItem)new Separator("group.rest"));
        super.rulerContextMenuAboutToShow(menu);
        if (this.isEditorInputModifiable()) {
            IAction quickdiffAction = this.getAction("QuickDiff.Toggle");
            quickdiffAction.setChecked(this.isChangeInformationShowing());
            menu.appendToGroup("rulers", quickdiffAction);
        }
        if (this.fLineColumn != null && this.fLineColumn.isShowingRevisionInformation()) {
            MenuManager revisionMenu = new MenuManager(TextEditorMessages1.getString("AbstractDecoratedTextEditor_revisions_menu"));
            menu.appendToGroup("rulers", (IContributionItem)revisionMenu);
            IAction hideRevisionInfoAction = this.getAction("Revision.HideInfo");
            revisionMenu.add(hideRevisionInfoAction);
            revisionMenu.add((IContributionItem)new Separator());
            String[] labels = new String[]{TextEditorMessages1.getString("AbstractDecoratedTextEditor_revision_colors_option_by_date"), TextEditorMessages1.getString("AbstractDecoratedTextEditor_revision_colors_option_by_author"), TextEditorMessages1.getString("AbstractDecoratedTextEditor_revision_colors_option_by_author_and_date")};
            IRevisionRulerColumnExtension.RenderingMode[] modes = new IRevisionRulerColumnExtension.RenderingMode[]{IRevisionRulerColumnExtension.AGE, IRevisionRulerColumnExtension.AUTHOR, IRevisionRulerColumnExtension.AUTHOR_SHADED_BY_AGE};
            final IPreferenceStore uiStore = EditorsUI.getPreferenceStore();
            String current = uiStore.getString("revisionRulerRenderingMode");
            int i = 0;
            while (i < modes.length) {
                final String mode = modes[i].name();
                Action action = new Action(labels[i], 8){

                    public void run() {
                        uiStore.setValue("revisionRulerRenderingMode", mode);
                    }
                };
                action.setChecked(mode.equals(current));
                revisionMenu.add((IAction)action);
                ++i;
            }
            revisionMenu.add((IContributionItem)new Separator());
            revisionMenu.add(this.getAction("Revision.ShowAuthor.Toggle"));
            revisionMenu.add(this.getAction("Revision.ShowId.Toggle"));
        }
    }

    private void toggleQuickDiffRuler() {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        boolean current = store.getBoolean("quickdiff.quickDiff");
        if (current == this.isChangeInformationShowing()) {
            store.setValue("quickdiff.quickDiff", !current);
        } else {
            this.showChangeInformation(current);
        }
    }

    static Map<String, Object> initialAttributes(ITextEditor textEditor) {
        int end;
        int start;
        int line;
        HashMap<String, Object> attributes = new HashMap<String, Object>(11);
        LpexAbstractDecoratedTextEditor editor = (LpexAbstractDecoratedTextEditor)textEditor;
        LpexView lpexView = editor.getFirstLpexView();
        if (lpexView == null) {
            return attributes;
        }
        LpexDocumentLocation loc = lpexView.documentLocation();
        if (loc.element == 0) {
            return attributes;
        }
        String label = null;
        int linesBeforeStart = lpexView.linesBeforeStart();
        if (lpexView.queryOn("block.inView") && (loc.position == lpexView.queryInt("block.bottomPosition") || loc.position == lpexView.queryInt("block.topPosition"))) {
            line = lpexView.lineOfElement(lpexView.queryInt("block.topElement") - linesBeforeStart);
            label = lpexView.query("block.text");
        } else {
            LpexParser parser = lpexView.parser();
            if (parser instanceof LpexCommonParser) {
                line = lpexView.lineOfElement(loc.element);
                label = LpexAbstractDecoratedTextEditor.getLabelProposal(((LpexCommonParser)parser).getToken(loc), 1);
            } else {
                line = lpexView.lineOfElement(loc.element);
            }
        }
        if (label == null) {
            label = LpexAbstractDecoratedTextEditor.getLabelProposal(lpexView.query("text"), loc.position);
        }
        if (label == null) {
            label = "";
        } else if (label.length() > 80) {
            label = label.substring(0, 80);
        }
        MarkerUtilities.setMessage(attributes, (String)label);
        MarkerUtilities.setLineNumber(attributes, (int)line);
        DocumentAdapter documentAdapter = ((LpexSourceViewer)editor.getSourceViewer()).getDocumentAdapter();
        if (lpexView.queryOn("block.inView")) {
            loc.element = lpexView.queryInt("block.topElement") - linesBeforeStart;
            loc.position = lpexView.queryInt("block.topPosition");
            start = documentAdapter.getDocOffset(loc);
            loc.element = lpexView.queryInt("block.bottomElement") - linesBeforeStart;
            loc.position = lpexView.queryInt("block.bottomPosition");
            if (!"stream".equals(lpexView.query("block.type"))) {
                ++loc.position;
            }
            end = documentAdapter.getDocOffset(loc);
        } else {
            end = start = documentAdapter.getDocOffset(loc);
        }
        MarkerUtilities.setCharStart(attributes, (int)start);
        MarkerUtilities.setCharEnd(attributes, (int)end);
        return attributes;
    }

    static String getLabelProposal(String text, int start) {
        if (text == null || text.length() == 0) {
            return null;
        }
        int s = start - 1;
        if (s >= text.length()) {
            s = text.length() - 1;
        }
        int e = s;
        while (s >= 0 && Character.isWhitespace(text.charAt(s))) {
            --s;
        }
        if (s < 0) {
            s = e;
            while (s < text.length() && Character.isWhitespace(text.charAt(s))) {
                ++s;
            }
            if (s >= text.length()) {
                return null;
            }
            e = s;
        } else {
            e = s + 1;
            while (s >= 0 && !Character.isWhitespace(text.charAt(s))) {
                --s;
            }
            ++s;
        }
        while (e < text.length() && !Character.isWhitespace(text.charAt(e))) {
            ++e;
        }
        return text.substring(s, e);
    }

    static boolean isValidCursor(ITextEditor textEditor) {
        LpexMultiWindow lpexMultiWindow;
        LpexAbstractDecoratedTextEditor editor = (LpexAbstractDecoratedTextEditor)textEditor;
        LpexSourceViewer lpexSourceViewer = (LpexSourceViewer)editor.getSourceViewer();
        if (lpexSourceViewer != null && (lpexMultiWindow = lpexSourceViewer.getLpexMultiWindow()) != null && lpexMultiWindow.getMaximizedControl() != null && lpexMultiWindow.getMaximizedControl() != editor.getFirstLpexWindow()) {
            return false;
        }
        LpexView lpexView = editor.getFirstLpexView();
        if (lpexView != null) {
            int element = lpexView.currentElement();
            return element != 0 && !lpexView.show(element);
        }
        return false;
    }

    private class GotoMarkerAdapter
    implements IGotoMarker {
        private GotoMarkerAdapter() {
        }

        public void gotoMarker(IMarker marker) {
            LpexAbstractDecoratedTextEditor.this.gotoMarker(marker);
        }
    }

    private static final class TextEditorMessages {
        private static ResourceBundle _bundle;

        private TextEditorMessages() {
        }

        public static ResourceBundle getResourceBundle() {
            if (_bundle == null) {
                _bundle = ResourceBundle.getBundle("org.eclipse.ui.texteditor.ConstructedTextEditorMessages");
            }
            return _bundle;
        }
    }

    private static final class TextEditorMessages1 {
        private static ResourceBundle _bundle;

        private TextEditorMessages1() {
        }

        public static String getString(String key) {
            try {
                if (TextEditorMessages1.getResourceBundle() != null) {
                    return _bundle.getString(key);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return "!" + key + "!";
        }

        private static ResourceBundle getResourceBundle() {
            if (_bundle == null) {
                _bundle = ResourceBundle.getBundle("org.eclipse.ui.texteditor.TextEditorMessages");
            }
            return _bundle;
        }
    }
}

