/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexPlugin;
import com.ibm.lpex.alef.LpexPreferenceFilter;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.ProfileHandler;
import com.ibm.lpex.core.Utilities;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

final class EclipseProfile
implements ProfileHandler {
    private static IPreferenceStore _preferenceStore;
    private static IPropertyChangeListener _listener;
    private static final Object _lockObject;

    static {
        _lockObject = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EclipseProfile() {
        Object object = _lockObject;
        synchronized (object) {
            _preferenceStore = LpexPlugin.getDefault().getPreferenceStore();
            _listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().startsWith("default.")) {
                        Utilities.profileChanged();
                        LpexView.doGlobalCommand("screenShow");
                    }
                }
            };
        }
        Utilities.setProfileHandler(this);
        this.addListener();
    }

    void dispose() {
        this.removeListener();
        Utilities.setProfileHandler(null);
    }

    private void addListener() {
        _preferenceStore.addPropertyChangeListener(_listener);
    }

    private void removeListener() {
        _preferenceStore.removePropertyChangeListener(_listener);
    }

    @Override
    public String name() {
        IPath homeDir = LpexPlugin.getDefault().getStateLocation().removeLastSegments(1);
        return homeDir.append("org.eclipse.core.runtime").append(".settings").append("com.ibm.lpex.prefs").toFile().getPath();
    }

    @Override
    public boolean setName(String name) {
        return true;
    }

    @Override
    public boolean importProfile(String fileName) {
        if (fileName == null) {
            return false;
        }
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode("com.ibm.lpex");
        if (instanceNode == null) {
            return false;
        }
        this.removeListener();
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream fileInputStream = new FileInputStream(fileName);){
                    IPreferencesService service = Platform.getPreferencesService();
                    service.applyPreferences((IEclipsePreferences)service.readPreferences((InputStream)fileInputStream), new IPreferenceFilter[]{new LpexPreferenceFilter()});
                    instanceNode.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.addListener();
                Utilities.profileChanged();
                return false;
            }
        }
        finally {
            this.addListener();
            Utilities.profileChanged();
        }
        return true;
    }

    @Override
    public boolean exportProfile(String fileName) {
        if (fileName == null) {
            return false;
        }
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode("com.ibm.lpex");
        if (instanceNode == null) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(fileName);){
                IPreferencesService service = Platform.getPreferencesService();
                service.exportPreferences(instanceNode, (OutputStream)fileOutputStream, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void resetProfile() {
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode("com.ibm.lpex");
        if (instanceNode != null) {
            this.removeListener();
            try {
                instanceNode.clear();
                instanceNode.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addListener();
            Utilities.profileChanged();
        }
    }

    @Override
    public String getString(String key) {
        String value = _preferenceStore.getString(key);
        if (value.length() == 0) {
            value = null;
        }
        return value;
    }

    @Override
    public void putString(String key, String value) {
        if (value == null || value.length() == 0) {
            this.remove(key);
            return;
        }
        this.removeListener();
        _preferenceStore.setValue(key, value);
        this.addListener();
    }

    @Override
    public void remove(String key) {
        this.removeListener();
        _preferenceStore.setToDefault(key);
        this.addListener();
    }

    @Override
    public void flush() {
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode("com.ibm.lpex");
        if (instanceNode != null) {
            try {
                instanceNode.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getKeys() {
        IEclipsePreferences[] nodes = null;
        if (_preferenceStore instanceof ScopedPreferenceStore) {
            nodes = ((ScopedPreferenceStore)_preferenceStore).getPreferenceNodes(true);
        } else {
            IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode("com.ibm.lpex");
            if (instanceNode != null) {
                nodes = new IEclipsePreferences[]{instanceNode};
            }
        }
        if (nodes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(400);
        int i = 0;
        while (i < nodes.length) {
            String[] keys = null;
            try {
                keys = nodes[i].keys();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (keys != null) {
                int j = 0;
                while (j < keys.length) {
                    sb.append(keys[j]).append(' ');
                    ++j;
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

