/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexAnnotationRulerColumn;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.rulers.AbstractContributedRulerColumn;

public final class AnnotationColumn
extends AbstractContributedRulerColumn
implements IVerticalRulerInfo,
IVerticalRulerInfoExtension {
    public static final String ID = "com.ibm.lpex.columns.annotations";
    private static final int VERTICAL_RULER_WIDTH = 12;
    private IVerticalRulerColumn fDelegate;
    private final MarkerAnnotationPreferences fAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
    private IPropertyChangeListener fPropertyListener;

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        this.initialize();
        Control control = this.fDelegate.createControl(parentRuler, parentControl);
        return control;
    }

    public Control getControl() {
        return this.fDelegate.getControl();
    }

    public int getWidth() {
        return this.fDelegate.getWidth();
    }

    public void redraw() {
        this.fDelegate.redraw();
    }

    public void setFont(Font font) {
        this.fDelegate.setFont(font);
    }

    public void setModel(IAnnotationModel model) {
        this.fDelegate.setModel(model);
    }

    public void columnRemoved() {
        if (this.fPropertyListener != null) {
            IPreferenceStore store = this.getPreferenceStore();
            if (store != null) {
                store.removePropertyChangeListener(this.fPropertyListener);
            }
            this.fPropertyListener = null;
        }
    }

    private void initialize() {
        IPreferenceStore store;
        if (this.fDelegate == null) {
            this.fDelegate = new LpexAnnotationRulerColumn(12, (IAnnotationAccess)new DefaultMarkerAnnotationAccess());
        }
        if ((store = this.getPreferenceStore()) != null && this.fDelegate instanceof LpexAnnotationRulerColumn) {
            final LpexAnnotationRulerColumn column = (LpexAnnotationRulerColumn)this.fDelegate;
            for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
                String key = preference.getVerticalRulerPreferenceKey();
                boolean showAnnotation = true;
                if (key != null && store.contains(key)) {
                    showAnnotation = store.getBoolean(key);
                }
                if (!showAnnotation) continue;
                column.addAnnotationType(preference.getAnnotationType());
            }
            column.addAnnotationType("org.eclipse.text.annotation.unknown");
            this.fPropertyListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    AnnotationPreference annotationPreference = AnnotationColumn.this.getVerticalRulerAnnotationPreference(property);
                    if (annotationPreference != null && event.getNewValue() instanceof Boolean) {
                        Object type = annotationPreference.getAnnotationType();
                        if (((Boolean)event.getNewValue()).booleanValue()) {
                            column.addAnnotationType(type);
                        } else {
                            column.removeAnnotationType(type);
                        }
                        column.redraw();
                    }
                }
            };
            store.addPropertyChangeListener(this.fPropertyListener);
        }
    }

    private AnnotationPreference getVerticalRulerAnnotationPreference(String preferenceKey) {
        if (preferenceKey == null) {
            return null;
        }
        for (AnnotationPreference info : this.fAnnotationPreferences.getAnnotationPreferences()) {
            if (info == null || !preferenceKey.equals(info.getVerticalRulerPreferenceKey())) continue;
            return info;
        }
        return null;
    }

    private IPreferenceStore getPreferenceStore() {
        return EditorsUI.getPreferenceStore();
    }

    public void setDelegate(IVerticalRulerColumn column) {
        Assert.isLegal((this.fDelegate == null ? 1 : 0) != 0);
        Assert.isLegal((column != null ? 1 : 0) != 0);
        this.fDelegate = column;
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            ((IVerticalRulerInfoExtension)this.fDelegate).addVerticalRulerListener(listener);
        }
    }

    public IAnnotationHover getHover() {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            return ((IVerticalRulerInfoExtension)this.fDelegate).getHover();
        }
        return null;
    }

    public IAnnotationModel getModel() {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            return ((IVerticalRulerInfoExtension)this.fDelegate).getModel();
        }
        return null;
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            ((IVerticalRulerInfoExtension)this.fDelegate).removeVerticalRulerListener(listener);
        }
    }

    public int getLineOfLastMouseButtonActivity() {
        if (this.fDelegate instanceof IVerticalRulerInfo) {
            ((IVerticalRulerInfo)this.fDelegate).getLineOfLastMouseButtonActivity();
        }
        return -1;
    }

    public int toDocumentLineNumber(int y_coordinate) {
        if (this.fDelegate instanceof IVerticalRulerInfo) {
            ((IVerticalRulerInfo)this.fDelegate).toDocumentLineNumber(y_coordinate);
        }
        return -1;
    }
}

