/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.rdz.license;

import com.ibm.cic.install.info.ILocation;
import com.ibm.cic.install.info.IPackage;
import com.ibm.cic.install.info.InstallInfoUtils;
import com.ibm.cic.licensing.common.LicenseCheck;
import com.ibm.etools.rdz.license.RDzLicensePlugin;
import com.ibm.etools.rdz.license.RDzLicenseResources;
import com.ibm.etools.rdz.license.RDzProductRegistrationCallback;
import com.ibm.ftt.common.logging.LogUtil;
import com.ibm.ftt.common.tracing.Trace;
import com.ibm.ftt.configurations.registration.AbstractProductRegistrationInfo;
import com.ibm.ftt.configurations.registration.IProductRegistrationCallback;
import com.ibm.ftt.configurations.registration.IProductRegistrationInfo;
import com.ibm.ftt.configurations.registration.IVUValidationStatus;
import com.ibm.ftt.configurations.registration.ProductRegistrationStore;
import com.ibm.idz.system.util.ProductUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RDzLicenseRequest {
    public static final String COPY_RIGHT = "  Licensed Materials - Property of IBM, 5724-T07, Copyright IBM Corp. 2013, 2025 All rights reserved.  US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String PACKAGE_IDENTIFIER_RDz = "com.ibm.developer.zos.v170";
    protected static final String VU_CHECK_ROUTINE_RDZ = "com.ibm.etools.zos.server.rdz.VUChecker";
    protected static final String REGISTRATION_API_VERSION = "1.0";
    protected static final String PRODUCT_API_VERSION_CLIENT = "productAPIVersionClient";
    protected static final String PRODUCT_API_VERSION_HOST = "productAPIVersionHost";
    protected static boolean REGISTERED = false;
    protected static Map<String, IPackage> INSTALLED_OFFERINGS = new HashMap<String, IPackage>();
    static final int ONE_DAY = 86400000;
    static final String LAST_NOTIFIED = "lastNotified";
    static final String NOTIFY_OPTION = "notifyOption";
    static final int NOTIFY_ALWAYS = 0;
    static final int NOTIFY_TOMORROW = 1;
    static final String[] IDZ_EE_PIDS = new String[]{"5755-AB1", "5755-AB5", "5755-A01", "5755-A05", "5655-AC6", "5755-AC5", "5655-AC5"};
    static final Set<String> EEHosts = new HashSet<String>();

    public static boolean getRDzLicense(Plugin plugin, String componentID, String version, boolean quiet) throws CoreException {
        IVUValidationStatus status;
        boolean isIDzDebugCA;
        if (Boolean.getBoolean("com.ibm.cic.licensing.bypass.license.checking.internal.only")) {
            LogUtil.log((int)2, (String)"You are currently running IDz in Debug Mode with licensing disabled. This configuration is intended strictly for internal use only.", (String)"com.ibm.etools.rdz.license");
            return true;
        }
        final String internalUseOnly_msgText = "ComponentID: " + componentID + ", Version: " + version + ", Quiet: " + quiet;
        String licenseDisplay = System.getProperty("rdzLicenseCheckDisplay");
        if (licenseDisplay != null) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"RDz License Request", (String)internalUseOnly_msgText);
                }
            });
        }
        boolean bl = isIDzDebugCA = ProductUtils.containsIDzProduct() || ProductUtils.containsOEMProduct() || ProductUtils.containsDebugProduct();
        if (isIDzDebugCA && RDzLicenseRequest.getVULicense(plugin)) {
            return true;
        }
        if (RDzLicenseRequest.isMacAarch64()) {
            Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)"You are using a Mac aarch64 machine.");
            return true;
        }
        if (RDzLicenseRequest.getPPALicense(plugin, componentID, version, quiet)) {
            return true;
        }
        if (isIDzDebugCA && (status = RDzLicenseRequest.getVUStatus(PACKAGE_IDENTIFIER_RDz)) != null && status.isValid() && RDzLicenseRequest.isVULicenseExpired(status.getRange(), status.getExpiry())) {
            RDzLicenseRequest.processVUExpired();
        }
        if (!quiet) {
            RDzLicenseRequest.processLicenseFailure(null);
        }
        return false;
    }

    private static boolean isMacAarch64() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        return osName.contains("mac") && osArch.equals("aarch64");
    }

    protected static boolean getVULicense(Plugin plugin) {
        IVUValidationStatus status;
        if (!REGISTERED) {
            RDzLicenseRequest.registerProduct();
        }
        if ((status = RDzLicenseRequest.getVUStatus(PACKAGE_IDENTIFIER_RDz)) == null) {
            Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)"No VU status found");
            return false;
        }
        Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)RDzLicenseRequest.printVUValidationStatus(status));
        if (!status.isValid()) {
            Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)("No valid VU license found: " + status.getMessageId()));
            return false;
        }
        if (!RDzLicenseRequest.isVULicenseExpired(status.getRange(), status.getExpiry())) {
            return true;
        }
        Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)"VU expiration is outside the specified limits");
        return false;
    }

    public static boolean getVULicense() {
        IVUValidationStatus status;
        if (!REGISTERED) {
            RDzLicenseRequest.registerProduct();
        }
        if ((status = RDzLicenseRequest.getVUStatus(PACKAGE_IDENTIFIER_RDz)) == null) {
            Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)"No VU status found");
            return false;
        }
        Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)RDzLicenseRequest.printVUValidationStatus(status));
        if (!status.isValid()) {
            Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)("No valid VU license found: " + status.getMessageId()));
            return false;
        }
        if (!RDzLicenseRequest.isVULicenseExpired(status.getRange(), status.getExpiry())) {
            return true;
        }
        Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)"VU expiration is outside the specified limits");
        return false;
    }

    protected static IVUValidationStatus getVUStatus(String productID) {
        return ProductRegistrationStore.getVUValidationStatus((String)productID);
    }

    protected static boolean isVULicenseExpired(long interval, long upperLimit) {
        Date expiring = new Date(upperLimit);
        long oneDay = 86400000L;
        long fuzzyInterval = interval + oneDay / 12L + oneDay / 2L;
        long currentTime = System.currentTimeMillis();
        if (currentTime < upperLimit && currentTime > upperLimit - fuzzyInterval) {
            long remainingTime = upperLimit - currentTime;
            double percentRemaining = (double)remainingTime / (double)interval;
            if (percentRemaining < 0.1 || remainingTime < oneDay) {
                Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)("VU expiration is within the specified limits but will expire soon: " + String.valueOf(expiring)));
                RDzLicenseRequest.processVUExpirationWarning(remainingTime);
            } else {
                Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)("VU expiration is within the acceptable range: Expiration: " + String.valueOf(expiring) + " Range: " + (double)interval / (double)oneDay + " days."));
            }
            return false;
        }
        if (currentTime >= upperLimit) {
            Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)("VU license expired on " + String.valueOf(expiring)));
        } else if (currentTime <= upperLimit - fuzzyInterval) {
            Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)("Current time is outside the acceptable range: Current Time: " + String.valueOf(new Date(currentTime)) + " Expiration: " + String.valueOf(expiring) + " Range: " + (double)interval / (double)oneDay + " days."));
        }
        return true;
    }

    public static void registerProduct() {
        Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)"Registering RDz for VU license checking");
        IProductRegistrationInfo productInfo = RDzLicenseRequest.getProductRegistrationInfo(PACKAGE_IDENTIFIER_RDz);
        RDzProductRegistrationCallback callback = new RDzProductRegistrationCallback();
        ProductRegistrationStore.registerProduct((IProductRegistrationInfo)productInfo, (IProductRegistrationCallback)callback);
        REGISTERED = true;
    }

    protected static IProductRegistrationInfo getProductRegistrationInfo(String packageId) {
        AbstractProductRegistrationInfo registrationInfo = new AbstractProductRegistrationInfo();
        RDzLicenseRequest.loadInstalledOfferings();
        IPackage pkg = INSTALLED_OFFERINGS.get(packageId);
        switch (packageId.toLowerCase()) {
            case "com.ibm.developer.zos.v170": {
                registrationInfo.setAPIVersion(REGISTRATION_API_VERSION);
                registrationInfo.setProductId(PACKAGE_IDENTIFIER_RDz);
                if (pkg == null) {
                    Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)("Unable to obtain package info for " + packageId + ".  Using default values"));
                    registrationInfo.setProductName(RDzLicenseResources.PRODUCT_NAME);
                    registrationInfo.setProductVersion(17);
                    registrationInfo.setProductRelease(0);
                    registrationInfo.setProductModification(0);
                    registrationInfo.setProductQualifier("idz170");
                } else {
                    Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)("Using cic package info for " + packageId));
                    registrationInfo.setProductName(pkg.getName());
                    registrationInfo.setProductVersion(pkg.getVersion().getMajor());
                    registrationInfo.setProductRelease(pkg.getVersion().getMinor());
                    registrationInfo.setProductModification(pkg.getVersion().getMicro());
                    registrationInfo.setProductQualifier(pkg.getVersion().getQualifier());
                }
                registrationInfo.setVUCheckRoutineName(VU_CHECK_ROUTINE_RDZ);
                registrationInfo.setProperty(PRODUCT_API_VERSION_CLIENT, "2.0");
                registrationInfo.setSMFSelection(RDzLicenseRequest.getSMFSelection());
                registrationInfo.setUUIDSelection(RDzLicenseRequest.getUUIDSelection());
                registrationInfo.setCRCSelection(RDzLicenseRequest.getCRCSelection());
                registrationInfo.setProperty("identifyVUCheck", "1");
                Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)RDzLicenseRequest.printRegistrationInfo((IProductRegistrationInfo)registrationInfo));
                break;
            }
            default: {
                Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)("Invalid package ID" + packageId));
            }
        }
        return registrationInfo;
    }

    protected static void loadInstalledOfferings() {
        String loc = System.getProperty("cic.appDataLocation");
        if (loc != null && INSTALLED_OFFERINGS.isEmpty()) {
            try {
                InstallInfoUtils.getInstallInfo();
                ILocation location = InstallInfoUtils.getCurrentLocation();
                IPackage[] iPackageArray = location.getPackages();
                int n = iPackageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackage pkg = iPackageArray[n2];
                    if ("offering".equals(pkg.getKind())) {
                        INSTALLED_OFFERINGS.put(pkg.getId(), pkg);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                String msg = "Exception thrown when obtaining Installation Manager data";
                LogUtil.log((int)4, (String)("[RDzLicenseRequest#loadInstalledOfferings] " + msg), (String)"com.ibm.etools.rdz.license", (Throwable)e);
            }
        }
    }

    static String printRegistrationInfo(IProductRegistrationInfo registrationInfo) {
        Object result = "\nProductResgistraionInfo";
        result = (String)result + "\n     API:                 " + registrationInfo.getAPIVersion();
        result = (String)result + "\n     Id:                  " + registrationInfo.getProductId();
        result = (String)result + "\n     Name:                " + registrationInfo.getProductName();
        result = (String)result + "\n     Version:             " + registrationInfo.getProductVersion();
        result = (String)result + "\n     Release:             " + registrationInfo.getProductRelease();
        result = (String)result + "\n     Modification:        " + registrationInfo.getProductModification();
        result = (String)result + "\n     Qualifier:           " + registrationInfo.getProductQualifier();
        result = (String)result + "\n     VUCheck:             " + registrationInfo.getVUCheckRoutineName();
        result = (String)result + "\n     ClientIP:            " + registrationInfo.getClientIP();
        result = (String)result + "\n     ClientHostname:      " + registrationInfo.getClientHostname();
        result = (String)result + "\n     UserId:              " + registrationInfo.getUserId();
        result = (String)result + "\n     SMFSelection:        " + registrationInfo.getSMFSelection();
        result = (String)result + "\n     UUIDSelection:       " + registrationInfo.getUUIDSelection();
        result = (String)result + "\n     CRCSelection:        " + registrationInfo.getCRCSelection();
        result = (String)result + "\n     Properties:          " + String.valueOf(registrationInfo.getPropertyKeys());
        return result;
    }

    static String printVUValidationStatus(IVUValidationStatus status) {
        Object result = "\nIVUValidationStatus";
        if (status == null) {
            result = (String)result + "\n     null";
        } else {
            result = (String)result + "\n     API:          " + status.getAPIVersion();
            result = (String)result + "\n     Expiry:       " + status.getExpiry();
            result = (String)result + "\n     MessageId:    " + status.getMessageId();
            result = (String)result + "\n     Range:        " + status.getRange();
            Set keys = status.getPropertyKeys();
            result = (String)result + "\n     Properties:   ";
            for (String key : keys) {
                result = (String)result + "\n                   " + key + ":     " + status.getPropertyValue(key);
            }
        }
        return result;
    }

    protected static boolean getPPALicense(Plugin plugin, String componentID, String version, boolean quiet) throws CoreException {
        boolean gotLicense = LicenseCheck.requestLicense((Plugin)plugin, (String)componentID, (String)version, (boolean)true);
        Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)("License request for ComponentID: " + componentID + ", Version: " + version + ", Quiet: " + quiet + ", License obtained = " + gotLicense));
        return gotLicense;
    }

    protected static void processLicenseFailure(CoreException e) throws CoreException {
        final String msgTitle = RDzLicenseResources.RDZ_LICENSE_ERROR_TITLE;
        final String msgText = RDzLicenseResources.RDZ_LICENSE_ERROR_GENERIC;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    Shell shell = window.getShell();
                    MessageDialog.openError((Shell)shell, (String)msgTitle, (String)msgText);
                } else {
                    LogUtil.log((int)4, (String)("[RDzLicenseRequest#processLicenseFailure] " + msgText), (String)"com.ibm.etools.rdz.license");
                }
            }
        });
        if (e == null) {
            e = new CoreException((IStatus)new Status(4, "com.ibm.etools.rdz.license", msgText));
        }
        throw new CoreException(e.getStatus());
    }

    protected static void processVUExpirationWarning(long expiration) {
        final long currentTime = System.currentTimeMillis();
        final IPreferenceStore store = RDzLicensePlugin.getDefault().getPreferenceStore();
        final int notifyOption = store.getInt(NOTIFY_OPTION);
        long lastNotified = store.getLong(LAST_NOTIFIED);
        if (currentTime > lastNotified + 86400000L || notifyOption == 0) {
            long days = expiration / 86400000L;
            long hours = expiration / 3600000L - days * 24L;
            expiration /= 86400000L;
            Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)("The VU license will expire in " + days + " days and " + hours + " hours."));
            final String msgTitle = RDzLicenseResources.RDZ_LICENSE_EXPIRING_TITLE;
            final String msgText = NLS.bind((String)RDzLicenseResources.RDZ_LICENSE_EXPIRING_DETAILS, (Object[])new Object[]{days, hours});
            final String msgDoNotShow = RDzLicenseResources.RDZ_LICENSE_EXPIRING_DO_NOT_SHOW;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null) {
                        Shell shell = window.getShell();
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openWarning((Shell)shell, (String)msgTitle, (String)msgText, (String)msgDoNotShow, (notifyOption == 1 ? 1 : 0) != 0, (IPreferenceStore)store, (String)RDzLicenseRequest.NOTIFY_OPTION);
                        if (dialog.getToggleState()) {
                            store.setValue(RDzLicenseRequest.NOTIFY_OPTION, 1);
                        } else {
                            store.setValue(RDzLicenseRequest.NOTIFY_OPTION, 0);
                        }
                        store.setValue(RDzLicenseRequest.LAST_NOTIFIED, currentTime);
                        store.needsSaving();
                    } else {
                        LogUtil.log((int)2, (String)("[RDzLicenseRequest#processVUExpirationWarning] " + msgText), (String)"com.ibm.etools.rdz.license");
                    }
                }
            });
        }
    }

    protected static void processVUExpired() {
        Trace.trace((Object)((Object)RDzLicensePlugin.getDefault()), (String)"com.ibm.etools.rdz.license", (int)1, (String)"VU license has expired");
        final String msgTitle = RDzLicenseResources.RDZ_LICENSE_EXPIRED_TITLE;
        final String msgText = RDzLicenseResources.RDZ_LICENSE_EXPIRED_MSG;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    Shell shell = window.getShell();
                    MessageDialog.openWarning((Shell)shell, (String)msgTitle, (String)msgText);
                } else {
                    LogUtil.log((int)2, (String)("[RDzLicenseRequest#processVUExpired] " + msgText), (String)"com.ibm.etools.rdz.license");
                }
            }
        });
    }

    protected static String[] getSMFSelection() {
        ArrayList<String> selectionList = new ArrayList<String>();
        selectionList.add("ProductName");
        selectionList.add("ProductVersion");
        selectionList.add("ProductRelease");
        selectionList.add("ProductModification");
        selectionList.add("zexplIP");
        selectionList.add("zexplHostname");
        selectionList.add("zexplUserid");
        selectionList.add(PRODUCT_API_VERSION_CLIENT);
        selectionList.add("zexplAPIVersionClient");
        selectionList.add("zexplAPIVersionHost");
        selectionList.add(PRODUCT_API_VERSION_HOST);
        selectionList.add("returnCode");
        return selectionList.toArray(new String[selectionList.size()]);
    }

    protected static String[] getUUIDSelection() {
        ArrayList<String> selectionList = new ArrayList<String>();
        selectionList.add("zexplUUID");
        selectionList.add("ProductVersion");
        selectionList.add("ProductRelease");
        return selectionList.toArray(new String[selectionList.size()]);
    }

    protected static String[] getCRCSelection() {
        ArrayList<String> selectionList = new ArrayList<String>();
        selectionList.add("productId");
        selectionList.add("ProductName");
        selectionList.add("ProductVersion");
        selectionList.add("ProductRelease");
        selectionList.add("ProductModification");
        selectionList.add("ProductQualifier");
        selectionList.add("vuCheckRoutineName");
        selectionList.add(PRODUCT_API_VERSION_CLIENT);
        selectionList.add("zexplAPIVersionClient");
        selectionList.add("zexplAPIVersionHost");
        selectionList.add("SMFSelection");
        selectionList.add("UUIDSelection");
        selectionList.add("zexplUUID");
        selectionList.add("zexplIP");
        selectionList.add("zexplHostname");
        return selectionList.toArray(new String[selectionList.size()]);
    }

    static void addLicenseInfo(IConnectorService connectorService, IVUValidationStatus status) {
        EEHosts.remove(connectorService.getHost().getHostName());
        String[] stringArray = IDZ_EE_PIDS;
        int n = IDZ_EE_PIDS.length;
        int n2 = 0;
        while (n2 < n) {
            String eePid = stringArray[n2];
            if (eePid.equals(status.getPropertyValue("productId"))) {
                EEHosts.add(connectorService.getHost().getHostName());
            }
            ++n2;
        }
    }

    public static boolean isEELicense(String hostName) {
        return EEHosts.contains(hostName);
    }

    public static boolean isEELicense() {
        return EEHosts.size() > 0;
    }
}

