/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.idebug.engine;

import com.ibm.debug.daemon.internal.core.DaemonCore;
import com.ibm.debug.idebug.engine.EnginePlugin;
import com.ibm.debug.idebug.engine.EngineProcess;
import com.ibm.debug.pdt.core.IPDTDebuggerEngine;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class PiclEngineLauncher
implements IPDTDebuggerEngine {
    protected static final Vector<EngineProcess> _engines = new Vector();
    protected String _engineName = Platform.getOS().equals("win32") ? "irmtdbgc.exe" : "irmtdbgc";
    protected String _enginePath = null;

    public PiclEngineLauncher() {
        this.validateEnginePath();
    }

    public Iterator<EngineProcess> getRunningEngines() {
        return _engines == null ? null : _engines.iterator();
    }

    public URL getInstallDirectory() {
        if (this._enginePath != null && Path.EMPTY.isValidPath(this._enginePath)) {
            Path installRoot = new Path(this._enginePath);
            if (installRoot.lastSegment().equals(this._engineName)) {
                installRoot = installRoot.removeLastSegments(1);
            }
            if (installRoot.lastSegment().toLowerCase().equals("bin")) {
                installRoot = installRoot.removeLastSegments(1);
            }
            try {
                return new File(installRoot.toOSString()).toURI().toURL();
            }
            catch (Exception e) {
                EnginePlugin.logError(e);
            }
        }
        return null;
    }

    protected void validateEnginePath() {
        File engine = EnginePlugin.getDefault().findEngineFile(this._engineName);
        try {
            if (engine != null) {
                this._enginePath = engine.getCanonicalPath();
            }
        }
        catch (Exception e) {
            EnginePlugin.logError(e);
            this._enginePath = null;
        }
    }

    public boolean launchEngine(int key, String[] environment) {
        return this.launchEngine(key, environment, null);
    }

    public boolean launchEngine(int key, String[] environment, String commandLineOptions) {
        this.validateEnginePath();
        if (this._enginePath == null) {
            return false;
        }
        String command = this.getCommand(key, commandLineOptions);
        EnginePlugin.logText("Command = >" + command);
        try {
            EngineProcess process = new EngineProcess(Runtime.getRuntime().exec(command, environment));
            _engines.add(process);
        }
        catch (Exception e) {
            String msg = "Problem occurred when executing the command: " + command;
            EnginePlugin.logError(e, msg);
            return false;
        }
        return true;
    }

    protected String getCommand(int key, String commandLineOptions) {
        StringBuilder command = new StringBuilder();
        String sep = " ";
        boolean isWin = Platform.getOS().equals("win32");
        if (isWin) {
            command.append("cmd.exe /C \"\"").append(this._enginePath).append("\"");
        } else {
            command.append(this._enginePath);
        }
        command.append(sep).append("-qhost=");
        command.append("localhost");
        command.append(":").append(Integer.toString(DaemonCore.getCurrentPort()));
        if (key >= 1) {
            command.append(sep).append("-startupKey=").append(Integer.toString(key));
        }
        if (commandLineOptions != null) {
            command.append(sep).append(commandLineOptions);
        }
        if (isWin) {
            command.append('\"');
        }
        return command.toString();
    }
}

