/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.idebug.engine;

import com.ibm.debug.idebug.engine.EngineConstants;
import com.ibm.debug.idebug.engine.EnginePlugin;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

public class PiclEngineFileLocator {
    private static final Object fSearchPathLock = new Object();
    private static String[] engineSearchPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PiclEngineFileLocator() {
        Object object = fSearchPathLock;
        synchronized (object) {
            if (engineSearchPath == null) {
                engineSearchPath = this.buildEngineSearchPath();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File findFile(String filename) {
        Object object = fSearchPathLock;
        synchronized (object) {
            block9: {
                if (engineSearchPath != null) break block9;
                return null;
            }
            int i = 0;
            while (i < engineSearchPath.length) {
                String path = engineSearchPath[i];
                if (path != null) {
                    File file = new File(path + File.separatorChar + filename);
                    try {
                        if (file.exists() && file.isFile()) {
                            return file;
                        }
                    }
                    catch (Exception e) {
                        EnginePlugin.logError(e);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSearchPath() {
        Object object = fSearchPathLock;
        synchronized (object) {
            return Arrays.copyOf(engineSearchPath, engineSearchPath.length);
        }
    }

    protected String[] buildEngineSearchPath() {
        String envPath;
        Map env;
        Path partialFragmentPath;
        URL fragmentURL;
        Bundle engineBundle;
        URL installURL;
        String[] searchPaths = null;
        ArrayList<String> paths = new ArrayList<String>();
        Location installLocation = Platform.getInstallLocation();
        URL uRL = installURL = installLocation != null ? installLocation.getURL() : null;
        if (installURL != null) {
            StringBuffer temp = new StringBuffer(installURL.getPath());
            temp.append(File.separator).append(EngineConstants.RELATIVE_ENGINE_INSTALL_PATH);
            Path installPath = new Path(temp.toString());
            paths.add(installPath.toOSString());
        }
        if ((engineBundle = Platform.getBundle((String)"com.ibm.debug.idebug.engine")) != null && (fragmentURL = FileLocator.find((Bundle)engineBundle, (IPath)(partialFragmentPath = new Path(EngineConstants.FRAGMENT_ENGINE_PATH)), null)) != null) {
            try {
                URL localURL = FileLocator.toFileURL((URL)fragmentURL);
                Path fragmentPath = new Path(localURL.getPath());
                paths.add(fragmentPath.toOSString());
            }
            catch (Exception e) {
                EnginePlugin.logError(e);
            }
        }
        if ((env = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironment()) != null && env.containsKey("PATH") && (envPath = (String)env.get("PATH")) != null) {
            paths.addAll(Arrays.asList(envPath.split(File.pathSeparator)));
        }
        if (!Platform.getOS().equals("win32")) {
            paths.add("/usr/bin");
            paths.add("/bin");
        }
        searchPaths = paths.toArray(new String[paths.size()]);
        return searchPaths;
    }
}

