/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.idebug.engine;

import com.ibm.debug.idebug.engine.PiclEngineFileLocator;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class EnginePlugin
extends Plugin {
    private static final Object lock = new Object();
    private static EnginePlugin plugin = null;
    private ResourceBundle resourceBundle = null;
    private PiclEngineFileLocator engineFileLocator = null;
    private static boolean fLogging = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnginePlugin() {
        Object object = lock;
        synchronized (object) {
            plugin = this;
        }
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.debug.idebug.engine.EnginePluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        this.engineFileLocator = new PiclEngineFileLocator();
    }

    public static EnginePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = EnginePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public File findEngineFile(String filename) {
        return this.engineFileLocator.findFile(filename);
    }

    public static final void logError(Exception e) {
        EnginePlugin.logError(e, null);
    }

    public static final void logError(Exception e, String msg) {
        String exMsg = e.getMessage() != null ? e.getMessage() : e.toString();
        String errMsg = msg == null ? exMsg : msg;
        Status status = new Status(4, "com.ibm.debug.idebug.engine", 0, errMsg, (Throwable)e);
        ILog logFile = EnginePlugin.getDefault().getLog();
        logFile.log((IStatus)status);
    }

    public void start(BundleContext context) throws Exception {
        String test;
        super.start(context);
        if (this.isDebugging() && (test = Platform.getDebugOption((String)"com.ibm.debug.idebug.engine/debug/logging")) != null) {
            fLogging = test.equalsIgnoreCase("true");
        }
    }

    public static void logText(String text) {
        if (fLogging) {
            if (text == null) {
                return;
            }
            ILog pluginLog = EnginePlugin.getDefault().getLog();
            Status status = new Status(1, "com.ibm.debug.idebug.engine", text);
            pluginLog.log((IStatus)status);
        }
    }
}

