/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.migrator;

import com.ibm.debug.internal.epdc.ERepGetExceptions;
import com.ibm.debug.pdt.internal.core.IDebuggerProfileMigrator;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ModelPackageAccessHelper;
import com.ibm.debug.pdt.migrator.MigratorUtils;
import java.io.IOException;
import java.io.ObjectInputStream;

public class DebugEngineProfile20050502Converter
extends DebugEngine.GlobalProfile
implements IDebuggerProfileMigrator {
    static final int VERSION = 20050502;
    private com.ibm.debug.internal.pdt.model.DebuggeeException[] fOldExceptionInfo;

    public DebugEngineProfile20050502Converter() {
        super(20050502);
    }

    public boolean restoreFromOldProfile(DebugModelObject restoreTo, String profileName, int restoreFlags) throws Exception {
        this.read(MigratorUtils.toOldProfileName1(profileName));
        return this.restore((DebugEngine)restoreTo, restoreFlags);
    }

    protected void readObjects(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.fOldExceptionInfo = (com.ibm.debug.internal.pdt.model.DebuggeeException[])in.readObject();
        this.fAllEntryBreakpointsEnabled = in.readBoolean();
        this.fDateBreakpointsEnabled = in.readBoolean();
        this.fEntryBreakpointsAutoSetInstalled = in.readBoolean();
        this.fDefaultMemoryRep = in.readInt();
    }

    protected boolean restoreExceptions(DebugEngine to) {
        if (this.fOldExceptionInfo == null || this.fOldExceptionInfo.length == 0) {
            return true;
        }
        boolean eok = true;
        DebuggeeException[] newExceptions = new DebuggeeException[this.fOldExceptionInfo.length];
        int i = 0;
        while (i < this.fOldExceptionInfo.length) {
            com.ibm.debug.internal.pdt.model.DebuggeeException cur = this.fOldExceptionInfo[i];
            ERepGetExceptions rep = cur.getException();
            newExceptions[i] = ModelPackageAccessHelper.createDebuggeeException(cur.getCurrentState(), cur.getDefaultState(), cur.getPendingState(), rep.getExceptionStatus(), rep.getExceptionName(), to.getProcess());
            ++i;
        }
        ModelPackageAccessHelper.setEngineDebuggeeExceptions(to.getDebugEngine(), newExceptions);
        try {
            to.getDebugEngine().changeExceptionStatus();
        }
        catch (EngineRequestException e1) {
            eok = false;
        }
        return eok;
    }

    public void deleteAllSavedDebuggerProfiles() {
        MigratorUtils.deleteOldProfiles1();
    }
}

