/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.memory.traditional;

import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.ui.memory.internal.traditional.EBCDICRendering;
import com.ibm.debug.pdt.ui.memory.internal.traditional.IBMTraditionalLabels;
import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.traditional.IMemorySelection;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalMemoryByte;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingMessages;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.renderings.GoToAddressComposite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class HexCharUnifiedRendering
extends TraditionalRendering {
    public static final String PREFTEXTMODE = "textMode";
    static final String PANE_SPACING = "  ";
    private static int[] INVISIBLE_SASHFORM_WEIGHT;
    private static int[] VISIBLE_SASHFORM_WEIGHT;
    private static int PRINTER_X_MARGIN;
    private static int PRINTER_Y_MARGIN;
    private static final String RESET_BASE_ADDR_ID = "com.ibm.reset.base.address.action.id";
    private static final String CONTEXT_ID_UNIFIED_RENDERING = "com.ibm.debug.pdt.ui.memory.unified.rendering";
    private static final String MONITOR_MEMORY_ACTION_ID = "com.ibm.debug.pdt.ui.actions.mapstorage.menu";
    private static final String CHANGE_REPRESENTATION_ACTION_ID = "com.ibm.debug.pdt.ui.actions.ChangeRepresentation.menu";
    private static final String CHANGE_INDEX_RANGE_ACTION_ID = "com.ibm.debug.pdt.ui.actions.ChangeIndexRangeDelegate";
    private IContextActivation fContextActivation;
    SashForm fThisPage;
    protected GoToAddressComposite fGoToAddressComposite;
    protected Control fGoToAddressControl;

    static {
        int[] nArray = new int[3];
        nArray[0] = 10;
        INVISIBLE_SASHFORM_WEIGHT = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 9;
        nArray2[2] = 1;
        VISIBLE_SASHFORM_WEIGHT = nArray2;
        PRINTER_X_MARGIN = 10;
        PRINTER_Y_MARGIN = 10;
    }

    public HexCharUnifiedRendering(String id) {
        super(id);
    }

    public Control createControl(Composite parent) {
        Button cancelButton;
        this.allocateColors();
        this.fThisPage = new SashForm(parent, 512);
        this.fRendering = new EBCDICRendering((Composite)this.fThisPage, this);
        this.fGoToAddressComposite = new GoToAddressComposite();
        this.fGoToAddressControl = this.fGoToAddressComposite.createControl((Composite)this.fThisPage);
        this.fGoToAddressControl.setVisible(true);
        Button okButton = this.fGoToAddressComposite.getButton(0);
        if (okButton != null) {
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BigInteger baseAddress = HexCharUnifiedRendering.this.getRendering().getBigBaseAddress();
                    BigInteger selectedAddress = HexCharUnifiedRendering.this.getRendering().getCaretAddress();
                    BigInteger goToAddress = HexCharUnifiedRendering.this.fGoToAddressComposite.getGoToAddress(baseAddress, selectedAddress);
                    HexCharUnifiedRendering.this.getRendering().gotoAddress(goToAddress);
                }
            });
        }
        if ((cancelButton = this.fGoToAddressComposite.getButton(1)) != null) {
            cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    HexCharUnifiedRendering.this.fThisPage.setWeights(INVISIBLE_SASHFORM_WEIGHT);
                }
            });
        }
        Text expressionField = this.fGoToAddressComposite.getExpressionWidget();
        expressionField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                BigInteger baseAddress = HexCharUnifiedRendering.this.getRendering().getBigBaseAddress();
                BigInteger selectedAddress = HexCharUnifiedRendering.this.getRendering().getCaretAddress();
                BigInteger goToAddress = HexCharUnifiedRendering.this.fGoToAddressComposite.getGoToAddress(baseAddress, selectedAddress);
                HexCharUnifiedRendering.this.getRendering().gotoAddress(goToAddress);
            }
        });
        this.fThisPage.setWeights(INVISIBLE_SASHFORM_WEIGHT);
        IPreferenceStore prefStore = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
        int textMode = prefStore.getInt(PREFTEXTMODE);
        if (textMode == 0) {
            textMode = 100;
        }
        this.applyPreferences();
        this.fRendering.setTextMode(textMode);
        this.createMenus();
        this.getPopupMenuManager().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] items;
                String findText = TraditionalRenderingMessages.getString((String)"TraditionalRendering.TEXT");
                String resetBaseAddrName = TraditionalRenderingMessages.getString((String)"TraditionalRendering.RESET_TO_BASE_ADDRESS");
                MenuManager textMenuManager = null;
                IContributionItem[] iContributionItemArray = items = manager.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    if (item != null && item.getId() != null && (item.getId().equals(HexCharUnifiedRendering.MONITOR_MEMORY_ACTION_ID) || item.getId().equals(HexCharUnifiedRendering.CHANGE_REPRESENTATION_ACTION_ID) || item.getId().equals(HexCharUnifiedRendering.CHANGE_INDEX_RANGE_ACTION_ID))) {
                        manager.remove(item);
                    }
                    if (item instanceof MenuManager) {
                        if (((MenuManager)item).getMenuText().equals(findText)) {
                            textMenuManager = (MenuManager)item;
                        }
                    } else if (item instanceof ActionContributionItem && ((ActionContributionItem)item).getAction() != null && resetBaseAddrName.equals(((ActionContributionItem)item).getAction().getText())) {
                        ((ActionContributionItem)item).setId(HexCharUnifiedRendering.RESET_BASE_ADDR_ID);
                    }
                    ++n2;
                }
                Action newAction = new Action(IBMTraditionalLabels.EBCDICRendering_name, 8){

                    public void run() {
                        HexCharUnifiedRendering.this.fRendering.setTextMode(100);
                    }
                };
                newAction.setChecked(HexCharUnifiedRendering.this.fRendering.getTextMode() == 100);
                textMenuManager.add((IAction)newAction);
                Action gotoAddressAction = new Action(IBMTraditionalLabels.GoToAddressAction_name){

                    public void run() {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ((this).this).HexCharUnifiedRendering.this.fThisPage.setWeights(VISIBLE_SASHFORM_WEIGHT);
                                IMemorySelection selection = HexCharUnifiedRendering.this.fRendering.getSelection();
                                BigInteger startAddress = selection.getStart();
                                BigInteger endAddress = selection.getEnd();
                                int byteToRequest = 0;
                                if (endAddress == null) {
                                    startAddress = selection.getStartLow();
                                    byteToRequest = HexCharUnifiedRendering.this.fRendering.getBytesPerColumn();
                                } else {
                                    BigInteger bytesSelected = endAddress.subtract(startAddress);
                                    byteToRequest = bytesSelected.intValue();
                                }
                                TraditionalMemoryByte[] memoryBytesSelected = null;
                                try {
                                    if (startAddress != null) {
                                        memoryBytesSelected = HexCharUnifiedRendering.this.fRendering.getBytes(startAddress, byteToRequest);
                                    }
                                }
                                catch (DebugException debugException) {
                                    // empty catch block
                                }
                                if (memoryBytesSelected != null && memoryBytesSelected.length != 0) {
                                    int radix = HexCharUnifiedRendering.this.fRendering.getRadix();
                                    boolean isLittleEndian = HexCharUnifiedRendering.this.fRendering.isTargetLittleEndian();
                                    String thisColumnContents = HexCharUnifiedRendering.this.fRendering.getRadixText((MemoryByte[])memoryBytesSelected, radix, isLittleEndian);
                                    ((this).this).HexCharUnifiedRendering.this.fGoToAddressComposite.getExpressionWidget().setText(thisColumnContents);
                                    ((this).this).HexCharUnifiedRendering.this.fGoToAddressComposite.getExpressionWidget().setFocus();
                                } else {
                                    ((this).this).HexCharUnifiedRendering.this.fGoToAddressComposite.getExpressionWidget().setText("");
                                    ((this).this).HexCharUnifiedRendering.this.fGoToAddressComposite.getExpressionWidget().setFocus();
                                }
                            }
                        });
                    }
                };
                Action changeToAddressModeAction = new Action(IBMTraditionalLabels.DisplayMode_Hex_Name, 8){

                    public void run() {
                        HexCharUnifiedRendering.this.getRendering().setDisplayMode(0);
                    }
                };
                changeToAddressModeAction.setChecked(HexCharUnifiedRendering.this.getRendering().getDisplayMode() == 0);
                Action changeToOffsetModeAction = new Action(IBMTraditionalLabels.DisplayMode_Offset_Name, 8){

                    public void run() {
                        HexCharUnifiedRendering.this.getRendering().setDisplayMode(1);
                    }
                };
                changeToOffsetModeAction.setChecked(HexCharUnifiedRendering.this.getRendering().getDisplayMode() == 1);
                Action printAction = new Action(IBMTraditionalLabels.PrintActionName){

                    public void run() {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                HexCharUnifiedRendering.this.printMemory();
                            }
                        });
                    }
                };
                manager.insertAfter(HexCharUnifiedRendering.RESET_BASE_ADDR_ID, (IAction)gotoAddressAction);
                manager.insertBefore(HexCharUnifiedRendering.RESET_BASE_ADDR_ID, (IAction)printAction);
                MenuManager subMenuParent = new MenuManager(IBMTraditionalLabels.DisplayModeAction_name);
                subMenuParent.add((IAction)changeToAddressModeAction);
                subMenuParent.add((IAction)changeToOffsetModeAction);
                manager.add((IContributionItem)subMenuParent);
            }
        });
        this.getRendering().configureToolTipForPane();
        return this.fThisPage;
    }

    EBCDICRendering getRendering() {
        return (EBCDICRendering)this.fRendering;
    }

    void printMemory() {
        PrintDialog printDialog;
        PrinterData printerData;
        BigInteger startAddress = this.fRendering.getSelection().getStart();
        BigInteger endAddress = this.fRendering.getSelection().getEnd();
        if (endAddress == null) {
            startAddress = this.fRendering.getViewportStartAddress();
            endAddress = this.fRendering.getViewportEndAddress();
            if (startAddress == null || endAddress == null) {
                return;
            }
        }
        if ((printerData = (printDialog = new PrintDialog(PICLUtils.getShell())).open()) == null) {
            return;
        }
        Printer printer = new Printer(printerData);
        GC printerGC = new GC((Drawable)printer);
        int bytesPerColumn = this.fRendering.getBytesPerColumn();
        int columnCount = this.fRendering.getColumnCount();
        int bytesPerRow = bytesPerColumn * columnCount;
        BigInteger bytesSelected = endAddress.subtract(startAddress);
        int rowsSelected = bytesSelected.divide(BigInteger.valueOf(bytesPerRow)).intValue();
        if (rowsSelected * bytesPerRow < bytesSelected.intValue()) {
            ++rowsSelected;
        }
        int lineInPage = 0;
        int hightSoFar = PRINTER_Y_MARGIN;
        printer.startJob(this.getLabel());
        printer.startPage();
        int i = 0;
        while (i < rowsSelected) {
            BigInteger rowStartAddress = startAddress.add(BigInteger.valueOf(i * bytesPerRow));
            String thisRowContents = this.getMemoryRowContents(rowStartAddress);
            if (thisRowContents == null) {
                thisRowContents = " ";
            }
            if (hightSoFar >= printer.getClientArea().height) {
                printer.endPage();
                printer.startPage();
                lineInPage = 0;
                hightSoFar = PRINTER_Y_MARGIN;
            }
            hightSoFar = PRINTER_Y_MARGIN + lineInPage * printerGC.getFontMetrics().getHeight();
            printerGC.drawString(thisRowContents, PRINTER_X_MARGIN, hightSoFar);
            hightSoFar = PRINTER_Y_MARGIN + ++lineInPage * printerGC.getFontMetrics().getHeight();
            ++i;
        }
        printer.endPage();
        printer.endJob();
        printerGC.dispose();
        printer.dispose();
    }

    String getMemoryRowContents(BigInteger rowStartAdddress) {
        int radix = this.fRendering.getRadix();
        boolean isLittleEndian = this.fRendering.isTargetLittleEndian();
        int textMode = this.fRendering.getTextMode();
        int bytesPerColumn = this.fRendering.getBytesPerColumn();
        int columnCount = this.fRendering.getColumnCount();
        StringBuffer memoryContents = new StringBuffer();
        try {
            String thisColumnContents;
            TraditionalMemoryByte[] columnMemoryBytes;
            BigInteger cellAddress;
            long columnOffset;
            String rowStartingAddressString = this.fRendering.getAddressString(rowStartAdddress);
            memoryContents.append(rowStartingAddressString);
            memoryContents.append(PANE_SPACING);
            int j = 0;
            while (j < columnCount) {
                columnOffset = bytesPerColumn * j;
                cellAddress = rowStartAdddress.add(BigInteger.valueOf(columnOffset));
                columnMemoryBytes = this.fRendering.getBytes(cellAddress, bytesPerColumn);
                thisColumnContents = this.fRendering.getRadixText((MemoryByte[])columnMemoryBytes, radix, isLittleEndian);
                memoryContents.append(thisColumnContents);
                ++j;
            }
            memoryContents.append(PANE_SPACING);
            j = 0;
            while (j < columnCount) {
                columnOffset = bytesPerColumn * j;
                cellAddress = rowStartAdddress.add(BigInteger.valueOf(columnOffset));
                columnMemoryBytes = this.fRendering.getBytes(cellAddress, bytesPerColumn);
                thisColumnContents = this.fRendering.formatText((MemoryByte[])columnMemoryBytes, isLittleEndian, textMode);
                memoryContents.append(thisColumnContents);
                ++j;
            }
        }
        catch (DebugException e) {
            return null;
        }
        return memoryContents.toString();
    }

    public void firePropertyChangedEvent(PropertyChangeEvent event) {
        super.firePropertyChangedEvent(event);
    }

    public int getRowCount() {
        if (this.fRendering instanceof EBCDICRendering) {
            return ((EBCDICRendering)this.fRendering).getRowCount();
        }
        return 0;
    }

    public int getBytesPerLine() {
        return this.fRendering.getBytesPerColumn() * this.fRendering.getColumnCount();
    }

    public void activated() {
        super.activated();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IContextService contextService = (IContextService)workbench.getAdapter(IContextService.class);
        if (contextService == null) {
            return;
        }
        this.fContextActivation = contextService.activateContext(CONTEXT_ID_UNIFIED_RENDERING);
    }

    public void deactivated() {
        super.deactivated();
        if (this.fContextActivation == null) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IContextService contextService = (IContextService)workbench.getAdapter(IContextService.class);
        if (contextService == null) {
            return;
        }
        contextService.deactivateContext(this.fContextActivation);
    }
}

