/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.memory.internal.traditional;

import com.ibm.debug.pdt.ui.memory.internal.traditional.IHexCharUnifiedPaneInfo;
import com.ibm.debug.pdt.ui.memory.internal.traditional.TraditionalMemoryElement;
import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.traditional.Rendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalMemoryByte;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingMessages;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class TraditionalRenderingUtil {
    protected static void paintWithColorProvider(PaintEvent pe, IColorProvider colorProvider, Rendering fRendering, IHexCharUnifiedPaneInfo pane, Rectangle bounds) {
        GC gc = pe.gc;
        gc.setFont(fRendering.getFont());
        int cellHeight = pane.getPaneCellHeight();
        int cellWidth = pane.getPaneCellWidth();
        int row = bounds.height / cellHeight;
        int columns = fRendering.getColumnCount();
        gc.setForeground(fRendering.getTraditionalRendering().getColorBackground());
        gc.fillRectangle(columns * cellWidth, 0, bounds.width, bounds.height);
        try {
            BigInteger start = fRendering.getViewportStartAddress();
            int bytesPerCol = fRendering.getBytesPerColumn();
            TraditionalMemoryElement memoryElement = new TraditionalMemoryElement(fRendering.getTraditionalRendering());
            int i = 0;
            while (i < row) {
                int col = 0;
                while (col < columns) {
                    BigInteger cellAddress = start.add(BigInteger.valueOf((i * columns + col) * bytesPerCol));
                    TraditionalMemoryByte[] bytes = fRendering.getBytes(cellAddress, bytesPerCol);
                    memoryElement.setAddress(cellAddress);
                    memoryElement.setMemoryBytes(bytes);
                    Color foreGroundColor = colorProvider.getForeground((Object)memoryElement);
                    if (foreGroundColor == null) {
                        pane.applyCustomPaneColor(gc, bytes, col);
                    } else {
                        gc.setForeground(colorProvider.getForeground((Object)memoryElement));
                    }
                    if (fRendering.getSelection().isSelected(cellAddress)) {
                        gc.setBackground(fRendering.getTraditionalRendering().getColorSelection());
                    } else {
                        gc.setBackground(colorProvider.getBackground((Object)memoryElement));
                    }
                    gc.fillRectangle(cellWidth * col, cellHeight * i, cellWidth, cellHeight);
                    gc.drawText(pane.getPaneCellText((MemoryByte[])bytes), cellWidth * col + fRendering.getCellPadding(), cellHeight * i + fRendering.getCellPadding());
                    if (fRendering.isDebug()) {
                        gc.drawRectangle(cellWidth * col, cellHeight * i + fRendering.getCellPadding(), cellWidth, cellHeight);
                    }
                    ++col;
                }
                ++i;
            }
        }
        catch (Exception e) {
            fRendering.logError(TraditionalRenderingMessages.getString((String)"TraditionalRendering.FAILURE_PAINT"), e);
        }
    }
}

