/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.memory.internal.traditional;

import com.ibm.debug.pdt.ui.memory.internal.traditional.EBCDICRendering;
import com.ibm.debug.pdt.ui.memory.internal.traditional.IHexCharUnifiedPaneInfo;
import com.ibm.debug.pdt.ui.memory.internal.traditional.TraditionalRenderingUtil;
import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.traditional.Rendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TextPane;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalMemoryByte;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;

public class EBCDICTextPane
extends TextPane
implements IHexCharUnifiedPaneInfo {
    public EBCDICTextPane(Rendering parent) {
        super(parent);
    }

    protected KeyListener createKeyListener() {
        return new EBCDICTextPaneKeyListener(super.createKeyListener());
    }

    @Override
    public int getPaneCellWidth() {
        return super.getCellWidth();
    }

    @Override
    public int getPaneCellHeight() {
        return super.getCellHeight();
    }

    @Override
    public BigInteger getPaneViewportAddress(int col, int row) throws DebugException {
        return super.getViewportAddress(col, row);
    }

    @Override
    public void applyCustomPaneColor(GC gc, TraditionalMemoryByte[] bytes, int col) {
        super.applyCustomColor(gc, bytes, col);
    }

    protected void paint(PaintEvent pe) {
        IColorProvider colorProvider = (IColorProvider)Platform.getAdapterManager().getAdapter((Object)this, IColorProvider.class);
        if (colorProvider == null) {
            super.paint(pe);
        } else {
            this.refreshRendering();
            TraditionalRenderingUtil.paintWithColorProvider(pe, colorProvider, this.fRendering, this, this.getBounds());
        }
    }

    private void refreshRendering() {
        this.fRowCount = this.getBounds().height / this.getCellHeight();
        if (this.fRendering.isDirty()) {
            this.fRendering.refresh();
            this.fRendering.setDirty(false);
        }
    }

    @Override
    public String getPaneCellText(MemoryByte[] bytes) {
        return super.getCellText(bytes);
    }

    public void editCell(BigInteger address, int subCellPosition, char character) {
        if (this.fRendering instanceof EBCDICRendering) {
            ((EBCDICRendering)this.fRendering).setSubstituteMode(false);
            super.editCell(address, subCellPosition, character);
            ((EBCDICRendering)this.fRendering).setSubstituteMode(true);
        } else {
            super.editCell(address, subCellPosition, character);
        }
    }

    class EBCDICTextPaneKeyListener
    implements KeyListener {
        private KeyListener fKeyListener;

        public EBCDICTextPaneKeyListener(KeyListener parentKeyListener) {
            this.fKeyListener = parentKeyListener;
        }

        public void keyPressed(KeyEvent ke) {
            EBCDICTextPane.this.fOldSubCellCaretPosition = EBCDICTextPane.this.fSubCellCaretPosition;
            if ((ke.stateMask & 0x10000) == 0 && ((EBCDICRendering)EBCDICTextPane.this.fRendering).isValidCharacter(ke.character)) {
                if (EBCDICTextPane.this.fRendering.getSelection().hasSelection()) {
                    EBCDICTextPane.this.setCaretAddress(EBCDICTextPane.this.fRendering.getSelection().getLow());
                    EBCDICTextPane.this.fSubCellCaretPosition = 0;
                }
                EBCDICTextPane.this.editCell(EBCDICTextPane.this.fCaretAddress, EBCDICTextPane.this.fSubCellCaretPosition, ke.character);
                if (ke.keyCode != 131072 && ke.keyCode != 262144 && ke.keyCode != 0x400000) {
                    EBCDICTextPane.this.fRendering.getSelection().clear();
                }
            } else if ((ke.stateMask & 0x10000) == 0) {
                this.fKeyListener.keyPressed(ke);
            }
        }

        public void keyReleased(KeyEvent ke) {
            this.fKeyListener.keyReleased(ke);
        }
    }
}

