/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.memory.internal.traditional;

import com.ibm.debug.pdt.ui.memory.internal.traditional.EBCDICAddressPane;
import com.ibm.debug.pdt.ui.memory.internal.traditional.EBCDICDataPane;
import com.ibm.debug.pdt.ui.memory.internal.traditional.EBCDICTextPane;
import com.ibm.debug.pdt.ui.memory.internal.traditional.IBMTraditionalLabels;
import com.ibm.debug.pdt.ui.memory.internal.traditional.IHexCharUnifiedPaneInfo;
import com.ibm.debug.pdt.ui.memory.traditional.HexCharUnifiedRendering;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.traditional.AbstractPane;
import org.eclipse.cdt.debug.ui.memory.traditional.AddressPane;
import org.eclipse.cdt.debug.ui.memory.traditional.DataPane;
import org.eclipse.cdt.debug.ui.memory.traditional.IMemorySelection;
import org.eclipse.cdt.debug.ui.memory.traditional.Rendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TextPane;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EBCDICRendering
extends Rendering {
    public static final int TEXT_EBCDIC = 100;
    private int fDisplayMode = 0;
    private Label fToolTipLabel;
    private Shell fToolTipShell;
    private int fCurrentScrollPositionOverride = 0;
    private BigInteger fScrollBarStartAddr = BigInteger.valueOf(-1L);
    private static final int fCushionAmount = 4;
    private EBCDICDataPane fDataPane;
    private boolean fSubstituteMode = true;
    private static final char REPLACEMENTCHAR = '.';

    public EBCDICRendering(Composite parent, TraditionalRendering renderingParent) {
        super(parent, renderingParent);
        this.packColumns();
    }

    protected AddressPane createAddressPane() {
        return new EBCDICAddressPane(this);
    }

    protected DataPane createDataPane() {
        this.fDataPane = new EBCDICDataPane(this);
        return this.fDataPane;
    }

    protected TextPane createTextPane() {
        return new EBCDICTextPane(this);
    }

    protected String getCharacterSet(int mode) {
        if (mode == 100) {
            return DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.defaultEbcdicCodePage");
        }
        return super.getCharacterSet(mode);
    }

    public BigInteger getCaretAddress() {
        return super.getCaretAddress();
    }

    public String getAddressString(BigInteger address) {
        if (this.fDisplayMode == 0) {
            return super.getAddressString(address);
        }
        BigInteger offsetBaseAddress = this.getBigBaseAddress();
        BigInteger offset = address.subtract(offsetBaseAddress);
        StringBuffer addressString = new StringBuffer(offset.abs().toString(16).toUpperCase());
        if (offset.longValue() >= 0L) {
            addressString.insert(0, ' ');
        } else {
            addressString.insert(0, '-');
        }
        int chars = this.getAddressBytes() * 2 - addressString.length();
        while (chars > 0) {
            addressString.insert(1, '0');
            --chars;
        }
        return addressString.toString();
    }

    public void setTextMode(int mode) {
        super.setTextMode(mode);
        IPreferenceStore prefStore = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
        prefStore.setValue("textMode", mode);
    }

    public void setDisplayMode(int displayMode) {
        if (this.fDisplayMode != displayMode) {
            this.fDisplayMode = displayMode;
            this.layoutPanes();
        }
    }

    public int getDisplayMode() {
        return this.fDisplayMode;
    }

    public void gotoAddress(BigInteger address) {
        super.gotoAddress(address);
    }

    /*
     * Unable to fully structure code
     */
    private String formatText(MemoryByte[] memoryBytes, boolean isLittleEndian, int textMode, boolean substitute) {
        block7: {
            numberOfBytes = memoryBytes.length;
            rawBytes = new byte[numberOfBytes];
            formattedString = new StringBuilder();
            i = 0;
            while (i < numberOfBytes) {
                rawBytes[i] = memoryBytes[i].getValue();
                ++i;
            }
            try {
                formattedString.append(new String(rawBytes, this.getCharacterSet(textMode)));
                break block7;
            }
            catch (UnsupportedEncodingException e) {
                i = 0;
                ** while (i < numberOfBytes)
            }
lbl-1000:
            // 1 sources

            {
                formattedString.append(super.getPaddingCharacter());
                ++i;
                continue;
            }
        }
        if (substitute) {
            i = 0;
            while (i < formattedString.length()) {
                if (Character.isISOControl(formattedString.charAt(i))) {
                    formattedString.setCharAt(i, '.');
                }
                ++i;
            }
        }
        return formattedString.toString();
    }

    public String formatText(MemoryByte[] memoryBytes, boolean isLittleEndian, int textMode) {
        return this.formatText(memoryBytes, isLittleEndian, textMode, this.fSubstituteMode);
    }

    public boolean isCR(byte currentByte, String codePage) {
        try {
            String currentElement = new String(new byte[]{currentByte}, codePage);
            if (currentElement.equals("\r")) {
                return true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return false;
    }

    public boolean isLF(byte currentByte, String codePage) {
        try {
            String currentElement = new String(new byte[]{currentByte}, codePage);
            if (currentElement.equals("\n")) {
                return true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return false;
    }

    public void configureToolTipForPane() {
        this.fToolTipShell = new Shell(this.getDisplay().getActiveShell(), 16400);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 0;
        this.fToolTipShell.setLayout((Layout)gridLayout);
        this.fToolTipShell.setBackground(this.getDisplay().getSystemColor(29));
        this.fToolTipLabel = new Label((Composite)this.fToolTipShell, 64);
        this.fToolTipLabel.setForeground(this.getDisplay().getSystemColor(28));
        this.fToolTipLabel.setBackground(this.getDisplay().getSystemColor(29));
        GridData gridData = new GridData(4, 0x1000000, false, false);
        this.fToolTipLabel.setLayoutData((Object)gridData);
        this.fToolTipShell.pack();
        HoverListener hoverListener = new HoverListener();
        this.fBinaryPane.addMouseTrackListener((MouseTrackListener)hoverListener);
        this.fTextPane.addMouseTrackListener((MouseTrackListener)hoverListener);
    }

    protected void handleDownArrow() {
        super.handleDownArrow();
        this.fireTopAddressChangeEvent();
        this.fireSelectAddressChangeEvent();
    }

    protected void handleUpArrow() {
        super.handleUpArrow();
        this.fireTopAddressChangeEvent();
        this.fireSelectAddressChangeEvent();
    }

    protected void handlePageDown() {
        super.handlePageDown();
        this.fireTopAddressChangeEvent();
        this.fireSelectAddressChangeEvent();
    }

    protected void handlePageUp() {
        super.handlePageUp();
        this.fireTopAddressChangeEvent();
        this.fireSelectAddressChangeEvent();
    }

    private void layoutPanes() {
        this.packColumns();
        this.layout(true);
        this.redraw();
        this.redrawPanes();
    }

    public void fireTopAddressChangeEvent() {
        BigInteger topAddress = this.getViewportStartAddress();
        if (topAddress == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this.getTraditionalRendering(), "topAddress", null, (Object)topAddress);
        this.firePropertyChangedEvent(event);
    }

    public void fireSelectAddressChangeEvent() {
        IMemorySelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        BigInteger selectedAddress = selection.getStart();
        if (selectedAddress == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this.getTraditionalRendering(), "topAddress", null, (Object)selectedAddress);
        this.firePropertyChangedEvent(event);
    }

    public void firePropertyChangedEvent(PropertyChangeEvent event) {
        TraditionalRendering parent = this.getTraditionalRendering();
        if (parent instanceof HexCharUnifiedRendering) {
            ((HexCharUnifiedRendering)parent).firePropertyChangedEvent(event);
        }
    }

    private String getTipWithAddressAndOffset(BigInteger address) {
        int backupDisplayMode = this.fDisplayMode;
        this.fDisplayMode = 0;
        String addressString = this.getAddressString(address);
        this.fDisplayMode = 1;
        String offsetString = this.getAddressString(address);
        this.fDisplayMode = backupDisplayMode;
        StringBuilder result = new StringBuilder(IBMTraditionalLabels.Tooltip_Address);
        result.append(' ');
        result.append(addressString);
        result.append('\n');
        result.append(IBMTraditionalLabels.Tooltip_Offset);
        result.append(' ');
        result.append(offsetString);
        return result.toString();
    }

    public int getRowCount() {
        return super.getRowCount();
    }

    protected SelectionListener createVerticalBarSelectinListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                switch (event.detail) {
                    case 0x1000002: {
                        EBCDICRendering.this.handleDownArrow();
                        break;
                    }
                    case 0x1000006: {
                        EBCDICRendering.this.handlePageDown();
                        break;
                    }
                    case 0x1000001: {
                        EBCDICRendering.this.handleUpArrow();
                        break;
                    }
                    case 0x1000005: {
                        EBCDICRendering.this.handlePageUp();
                        break;
                    }
                    default: {
                        int unitsScrolled = EBCDICRendering.this.getVerticalBar().getSelection() - EBCDICRendering.this.fCurrentScrollPositionOverride;
                        if (unitsScrolled == 0) break;
                        long bytesScrolled = EBCDICRendering.this.getAddressableCellsPerRow() * unitsScrolled;
                        BigInteger newStartingAddress = EBCDICRendering.this.getViewportStartAddress().add(BigInteger.valueOf(bytesScrolled));
                        EBCDICRendering.this.setViewportStartAddress(newStartingAddress);
                        EBCDICRendering.this.ensureViewportAddressDisplayable();
                        if (EBCDICRendering.this.fAddressPane.isVisible()) {
                            EBCDICRendering.this.fAddressPane.redraw();
                        }
                        EBCDICRendering.this.redrawPanes();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        };
    }

    protected void setCurrentScrollSelection() {
        long addressOffsetFromScrollStart;
        long lineCountFromScrollStart;
        int scrollBarPosition;
        int visibleLinesCount = this.getRowCount();
        int cushionLinesCount = visibleLinesCount * 4;
        long cushionBytesAmount = this.getAddressableCellsPerRow() * cushionLinesCount;
        if (this.fScrollBarStartAddr.compareTo(BigInteger.ZERO) < 0) {
            if (visibleLinesCount == 0) {
                return;
            }
            this.fScrollBarStartAddr = this.getViewportStartAddress().subtract(BigInteger.valueOf(cushionBytesAmount));
            if (this.fScrollBarStartAddr.compareTo(this.getMemoryBlockStartAddress()) < 0) {
                this.fScrollBarStartAddr = this.getMemoryBlockStartAddress();
            }
        }
        if ((scrollBarPosition = Integer.parseInt(Long.toString(lineCountFromScrollStart = (addressOffsetFromScrollStart = this.getViewportStartAddress().subtract(this.fScrollBarStartAddr).longValue()) / (long)this.getAddressableCellsPerRow()))) > cushionLinesCount * 2 || scrollBarPosition <= 1) {
            this.fScrollBarStartAddr = this.getViewportStartAddress().subtract(BigInteger.valueOf(cushionBytesAmount));
            scrollBarPosition = cushionLinesCount;
        }
        this.fCurrentScrollPositionOverride = scrollBarPosition;
        this.getVerticalBar().setSelection(this.fCurrentScrollPositionOverride);
    }

    protected void redrawPanes() {
        super.redrawPanes();
        if (this.getRowCount() == 0) {
            return;
        }
        if (this.getVerticalBar() != null && !this.getVerticalBar().isDisposed() && this.getVerticalBar().getMaximum() != this.getRowCount() * 9 + 10) {
            this.getVerticalBar().setMaximum(this.getRowCount() * 9 + 10);
            this.setCurrentScrollSelection();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] eventsCreated = new DebugEvent[events.length];
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object source = event.getSource();
            eventsCreated[i] = source instanceof IDebugElement && ((IDebugElement)source).getDebugTarget() == this.getMemoryBlock().getDebugTarget() ? new DebugEvent((Object)this.getMemoryBlock(), event.getKind(), event.getDetail()) : events[i];
            ++i;
        }
        super.handleDebugEvents(eventsCreated);
    }

    public void setSubstituteMode(boolean isEditCellMode) {
        this.fSubstituteMode = isEditCellMode;
    }

    protected boolean isValidCharacter(char character) {
        return character < '\u00ff' && !Character.isISOControl(character);
    }

    class HoverListener
    extends MouseTrackAdapter {
        HoverListener() {
        }

        public void mouseExit(MouseEvent e) {
            EBCDICRendering.this.fToolTipShell.setVisible(false);
        }

        public void mouseHover(MouseEvent e) {
            try {
                Point hoverPoint = new Point(e.x, e.y);
                Control control = null;
                if (e.widget instanceof Control) {
                    control = (Control)e.widget;
                }
                if (control == null) {
                    return;
                }
                if (!(control instanceof AbstractPane) || !(control instanceof IHexCharUnifiedPaneInfo)) {
                    return;
                }
                int cellWidth = ((IHexCharUnifiedPaneInfo)control).getPaneCellWidth();
                int cellHight = ((IHexCharUnifiedPaneInfo)control).getPaneCellHeight();
                BigInteger address = ((IHexCharUnifiedPaneInfo)control).getPaneViewportAddress(e.x / cellWidth, e.y / cellHight);
                String tip = EBCDICRendering.this.getTipWithAddressAndOffset(address);
                hoverPoint = control.toDisplay(hoverPoint);
                EBCDICRendering.this.fToolTipLabel.setText(tip.toString());
                Rectangle shellBounds = EBCDICRendering.this.fToolTipShell.getBounds();
                shellBounds.x = hoverPoint.x;
                shellBounds.y = hoverPoint.y + 16;
                EBCDICRendering.this.fToolTipShell.setBounds(shellBounds);
                EBCDICRendering.this.fToolTipShell.pack();
                EBCDICRendering.this.fToolTipShell.setVisible(true);
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
    }
}

