/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xmlui.internal.parser;

import com.ibm.debug.xmlui.api.IXUIElement;
import com.ibm.debug.xmlui.api.XUIAttribute;
import com.ibm.debug.xmlui.api.XUIAttributeList;
import com.ibm.debug.xmlui.internal.parser.XUIAbstractAttributeElement;

public class XUILabel
extends XUIAbstractAttributeElement {
    private boolean fIsEditable = false;

    public XUILabel(IXUIElement parent) {
        super(parent);
    }

    public XUILabel(String id, String name, IXUIElement parent) {
        this(id, name, parent, false);
    }

    public XUILabel(String id, String name, IXUIElement parent, boolean isEditable) {
        super(id, "", parent);
        this.setName(name);
        this.fIsEditable = isEditable;
    }

    public void setEditable(boolean editable) {
        this.fIsEditable = editable;
    }

    public boolean isEditable() {
        return this.fIsEditable;
    }

    @Override
    public void setName(String name) {
        int newlineIndex = name.indexOf("\\n");
        StringBuffer sb = null;
        int startIndex = 0;
        while (newlineIndex > 0) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(name.substring(startIndex, newlineIndex));
            sb.append('\n');
            startIndex = newlineIndex + 2;
            newlineIndex = startIndex < name.length() ? name.indexOf("\\n", startIndex) : -1;
        }
        if (sb != null && startIndex < name.length()) {
            sb.append(name.substring(startIndex, name.length()));
        }
        String newName = sb != null ? sb.toString() : name;
        super.setName(newName);
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public boolean isSelected() {
        return this.isEditable();
    }

    @Override
    public XUIAttributeList getAttributes() {
        if (this.isEditable()) {
            XUIAttributeList attrList = new XUIAttributeList();
            String aName = this.getAttributeName();
            String aValue = this.getAttributeValue();
            XUIAttribute attr = new XUIAttribute(aName, aValue);
            attrList.addAttribute(attr);
            XUIAttributeList childrenAttributes = this.getChildrenAttributes();
            if (childrenAttributes.size() > 0) {
                attrList.addAttributeList(childrenAttributes);
            }
            return attrList;
        }
        return this.getChildrenAttributes();
    }
}

