/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xmlui.internal.parser;

import com.ibm.debug.xmlui.api.IXUIAttributeElement;
import com.ibm.debug.xmlui.api.IXUIContainer;
import com.ibm.debug.xmlui.api.IXUIElement;
import com.ibm.debug.xmlui.api.XUIAttribute;
import com.ibm.debug.xmlui.api.XUIAttributeList;
import com.ibm.debug.xmlui.internal.parser.XUIAbstractElement;
import org.eclipse.swt.widgets.Text;

public abstract class XUIAbstractAttributeElement
extends XUIAbstractElement
implements IXUIAttributeElement {
    public XUIAbstractAttributeElement(IXUIElement parent) {
        super(parent);
    }

    public XUIAbstractAttributeElement(String id, String name, IXUIElement parent) {
        super(id, name, parent);
    }

    protected String getLocalAttributeName() {
        String localAttributeName;
        String nameKey = this.getNameKey();
        String string = localAttributeName = nameKey != null ? nameKey : this.getName();
        if (localAttributeName != null) {
            localAttributeName = this.postfixAttribute(localAttributeName);
        }
        return localAttributeName;
    }

    private String postfixAttribute(String attributeName) {
        if (attributeName.endsWith(":")) {
            attributeName = attributeName.substring(0, attributeName.length() - 1);
        }
        if (attributeName.indexOf(32) > 0) {
            attributeName = attributeName.replace(' ', '_');
        }
        return attributeName;
    }

    @Override
    public String getAttributeName() {
        String id = this.getId();
        if (id != null) {
            return id;
        }
        IXUIAttributeElement attributeParent = this.findAttributeParent();
        String localAttributeName = this.getLocalAttributeName();
        if (attributeParent != null) {
            String parentAttributeName = attributeParent.getAttributeName();
            if (parentAttributeName != null) {
                if (localAttributeName == null || localAttributeName.length() == 0) {
                    return parentAttributeName;
                }
                return parentAttributeName + "." + localAttributeName;
            }
            return localAttributeName;
        }
        return localAttributeName;
    }

    protected IXUIAttributeElement findAttributeParent() {
        IXUIElement parent = this.getParent();
        while (parent != null && !(parent instanceof IXUIAttributeElement)) {
            parent = parent.getParent();
        }
        return parent != null ? (IXUIAttributeElement)parent : null;
    }

    @Override
    public String getAttributeValue() {
        Object data = this.getData();
        if (data instanceof Text) {
            return ((Text)data).getText();
        }
        return null;
    }

    @Override
    public XUIAttributeList getAttributes() {
        if (this instanceof IXUIContainer) {
            return this.getChildrenAttributes();
        }
        if (this.isSelected()) {
            XUIAttributeList attrList = new XUIAttributeList();
            String aName = this.getAttributeName();
            String aValue = this.getAttributeValue();
            XUIAttribute attr = new XUIAttribute(aName, aValue);
            attrList.addAttribute(attr);
            XUIAttributeList childrenAttributes = this.getChildrenAttributes();
            if (childrenAttributes.size() > 0) {
                attrList.addAttributeList(childrenAttributes);
            }
            return attrList;
        }
        return EMPTY_ATTRIBUTES;
    }
}

