/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.help.preferenceharvester;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class WARDeployer {
    public static final int BUFFER_SIZE = 8192;
    public static final String WAR_NAME = "help.war";

    public static void copyWarTo(File directory) throws IOException {
        int read;
        URL warURL = WARDeployer.getPluginWAR();
        if (warURL == null) {
            return;
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Can't create directory: " + directory.getAbsolutePath());
        }
        File destWAR = new File(directory, WAR_NAME);
        if (destWAR.exists()) {
            throw new IOException("WAR File exists: " + destWAR.getAbsolutePath());
        }
        if (!destWAR.createNewFile()) {
            throw new IOException("Can't create file: " + destWAR.getAbsolutePath());
        }
        InputStream in = warURL.openStream();
        FileOutputStream out = new FileOutputStream(destWAR);
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, read);
        }
        in.close();
        ((OutputStream)out).close();
        System.setProperty(WAR_NAME, directory.getAbsolutePath() + "/help.war");
    }

    private static URL getPluginWAR() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ccl.help.preferenceharvester.war");
        if (configs.length > 0) {
            IConfigurationElement config = configs[0];
            String location = config.getAttribute("location");
            String pluginID = config.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)pluginID);
            return bundle.getEntry(location);
        }
        return null;
    }
}

