/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.help.preferenceharvester;

import com.ibm.ut.help.common.prefs.Preferences;
import com.ibm.ut.help.common.web.ProxyUtil;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "com.ibm.ccl.help.preferenceharvester";
    public static Boolean isRCP = null;
    public static boolean LOG_WARN = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.ccl.help.preferenceharvester/debug/warn"));
    public static boolean LOG_INFO = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.ccl.help.preferenceharvester/debug/info"));
    private static Activator plugin;
    private IProxyChangeListener proxySyncListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void initialize() {
        try {
            this.monitorProxyChanges();
        }
        catch (Exception e) {
            Activator.logError("Exception starting preference harvester", e);
        }
    }

    private void monitorProxyChanges() {
        try {
            this.proxySyncListener = new IProxyChangeListener(){

                public void proxyInfoChanged(IProxyChangeEvent event) {
                    if ((Preferences.get((String)Activator.PLUGIN_ID, (String)"proxySync") == null || Preferences.get((String)Activator.PLUGIN_ID, (String)"proxySync").equalsIgnoreCase("true")) && event.getChangeType() != 3) {
                        return;
                    }
                }
            };
            ProxyUtil.addProxyChangeListener((IProxyChangeListener)this.proxySyncListener);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    public IProxyChangeListener getProxySyncListener() {
        return this.proxySyncListener;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        ProxyUtil.removeProxyChangeListener((IProxyChangeListener)this.proxySyncListener);
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void earlyStartup() {
    }

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, message, ex);
        Activator.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static synchronized void logWarning(String message) {
        Activator.logWarning(message, null);
    }

    public static synchronized void logWarning(String message, Throwable ex) {
        if (Activator.getDefault().isDebugging() && LOG_WARN) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, ex);
            Activator.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public static synchronized void logDebug(String message) {
        if (Activator.getDefault().isDebugging() && LOG_INFO) {
            if (message == null) {
                message = "";
            }
            Status status = new Status(1, PLUGIN_ID, message);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    public static synchronized void logStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            Activator.getDefault().getLog().log(status);
        } else if (status.getSeverity() == 2 && Activator.getDefault().isDebugging() && LOG_WARN) {
            Activator.getDefault().getLog().log(status);
        }
    }
}

