/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.views;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.ErrorMapElement;
import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.renderer.MemoryMapRenderer;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import java.io.File;
import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class MemoryMapLabelProvider
extends CompositeImageDescriptor
implements ITableLabelProvider,
IColorProvider {
    public static final String PREFIX = "memory_map.";
    private Image fChangedImage;
    private AbstractMemoryMapRendering fRendering;
    private MemoryMapRenderer fRenderTool;
    private boolean showType;

    public MemoryMapLabelProvider(AbstractMemoryMapRendering rendering, MemoryMapRenderer renderer) {
        this.fRendering = rendering;
        this.fRenderTool = renderer;
        this.showType = MemoryMapPlugin.getInstance().getPreferenceStore().getBoolean("com.ibm.debug.memorymap.showtypes");
    }

    public Image getImage(Object element) {
        if (element instanceof MemoryMap) {
            String elementType = ((MemoryMap)element).getType();
            if ("MAP".equals(elementType)) {
                return MemoryMapUtils.getImage("MEMORY_MAP_LAYOUT");
            }
            if (((MemoryMap)element).hasChanged()) {
                if (this.fChangedImage == null) {
                    this.fChangedImage = this.createImage();
                }
                return this.fChangedImage;
            }
            return MemoryMapUtils.getImage("MEMORY_MAP_ELEMENT");
        }
        if (element instanceof ErrorMapElement) {
            if ("MAP".equals(((ErrorMapElement)element).getType())) {
                return MemoryMapUtils.getImage("MEMORY_MAP_LAYOUT");
            }
            return MemoryMapUtils.getImage("MEMORY_MAP_ELEMENT");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof MapElement) {
            MapElement map = (MapElement)element;
            return this.getValueAsString(map);
        }
        return "";
    }

    protected String getValueAsString(MapElement map) {
        Object label = "";
        String type = "";
        if (this.showType) {
            type = map.getType();
        }
        if (map instanceof MemoryMap) {
            MemoryMap memoryMap = (MemoryMap)map;
            if (map.isPadding()) {
                label = type + "  " + memoryMap.getName();
            } else if (!memoryMap.hasChildren() || memoryMap.isBitmask()) {
                String stringRep = "";
                MemoryByte[] bytesToRender = null;
                try {
                    bytesToRender = memoryMap.getBytes();
                    stringRep = this.renderBytes(memoryMap.getType(), memoryMap.getDisplayType(), memoryMap.getAddress(), bytesToRender);
                }
                catch (Exception e) {
                    stringRep = MemoryMapUtils.getPaddedString();
                    MemoryMapPlugin.logException(e);
                }
                if (map.isBitmask()) {
                    label = stringRep;
                } else if (map.isBit()) {
                    if (bytesToRender != null) {
                        int bit_offset = memoryMap.getBitOffset();
                        stringRep = stringRep.substring(bit_offset, bit_offset + memoryMap.getLength());
                    } else {
                        stringRep = MemoryMapLabels.MemoryMapRenderer_No_Data;
                    }
                    label = stringRep;
                } else if (stringRep != null) {
                    label = stringRep;
                }
            }
        }
        return ((String)label).trim();
    }

    private String getFileAndFolder(String mappingFile) {
        String separator = File.separator;
        int index = mappingFile.lastIndexOf(separator, mappingFile.lastIndexOf(separator) - 1);
        mappingFile = mappingFile.substring(index + 1);
        return mappingFile;
    }

    public String renderBytes(String type, String displayType, BigInteger address, MemoryByte[] bytes) {
        return this.fRenderTool.getString(type + ":" + displayType, address, bytes, MemoryMapUtils.getPaddedString());
    }

    public void toggleShowType() {
        this.showType = !this.showType;
        MemoryMapPlugin.getInstance().getPreferenceStore().setValue("com.ibm.debug.memorymap.showtypes", this.showType);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected void drawCompositeImage(int width, int height) {
        Image baseElement = MemoryMapUtils.getImage("MEMORY_MAP_ELEMENT");
        Image changedElement = MemoryMapUtils.getImage("MEMORY_MAP_CHANGE");
        CompositeImageDescriptor.CachedImageDataProvider providerBase = this.createCachedImageDataProvider(baseElement);
        CompositeImageDescriptor.CachedImageDataProvider providerChanged = this.createCachedImageDataProvider(changedElement);
        int changeX = providerBase.getWidth() - providerChanged.getWidth();
        this.drawImage((ImageDataProvider)providerBase, -1, -1);
        this.drawImage((ImageDataProvider)providerChanged, changeX, 1);
    }

    protected Point getSize() {
        return new Point(MemoryMapUtils.getImage((String)"MEMORY_MAP_ELEMENT").getBounds().width, MemoryMapUtils.getImage((String)"MEMORY_MAP_ELEMENT").getBounds().height);
    }

    public Color getForeground(Object element) {
        if (element instanceof MemoryMap) {
            MemoryMap map = (MemoryMap)element;
            if (map.isORGParent()) {
                Color color = JFaceResources.getColorRegistry().get("com.ibm.debug.memorymap.org.field.color");
                if (color == null) {
                    JFaceResources.getColorRegistry().put("com.ibm.debug.memorymap.org.field.color", new RGB(79, 148, 205));
                    color = JFaceResources.getColorRegistry().get("com.ibm.debug.memorymap.org.field.color");
                }
                return color;
            }
            if (map.isMonitored()) {
                if (((MemoryMap)element).hasChanged()) {
                    return DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.changedDebugElement");
                }
                return DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.MemoryHistoryKnownColor");
            }
            return DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.MemoryHistoryUnknownColor");
        }
        if (element instanceof ErrorMapElement) {
            return JFaceResources.getColorRegistry().get("ERROR_COLOR");
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof MapElement) {
            if (columnIndex == 0 && ((MapElement)element).isORGParent()) {
                return MemoryMapUtils.getImage("ORG_ICON");
            }
            if (columnIndex == 0 && element instanceof MemoryMap && ((MapElement)element).isUnion()) {
                return MemoryMapUtils.getImage("UNION_ICON");
            }
            if (columnIndex == 0) {
                return this.getImage(element);
            }
        }
        return null;
    }

    protected String getName(MapElement element) {
        String type = this.showType ? element.getType() : "";
        String label = "";
        if (element instanceof ErrorMapElement) {
            label = ((ErrorMapElement)element).getLabel();
        } else {
            if (element.hasChildren()) {
                String mappingFile = element.getLayout().getMappingFile();
                if (element.isMap() && this.fRendering.getCurrentGroup() != null) {
                    Object[] binding = new String[]{type, element.getName(), this.fRendering.getCurrentGroup(), this.getFileAndFolder(mappingFile)};
                    label = NLS.bind((String)MemoryMapLabels.MemoryMap_2, (Object[])binding);
                } else {
                    label = element.getLayout() != element.getParent().getLayout() ? NLS.bind((String)MemoryMapLabels.memory_map_label_layout, (Object[])new String[]{type, element.getName(), this.getFileAndFolder(mappingFile)}) : (!element.isBitmask() ? NLS.bind((String)MemoryMapLabels.memory_map_label_structure, (Object[])new String[]{type, element.getName()}) : NLS.bind((String)MemoryMapLabels.ElementType, (Object[])new String[]{type, element.getName()}));
                }
                return label.trim();
            }
            label = NLS.bind((String)MemoryMapLabels.ElementType, (Object[])new String[]{type, element.getName()});
        }
        return label.trim();
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof MapElement) {
            if (columnIndex == 0) {
                return this.getName((MapElement)element);
            }
            if (columnIndex == 3) {
                return ((MapElement)element).getAddressInHexString();
            }
            if (columnIndex == 2) {
                if (MemoryMapPlugin.getInstance().getPreferenceStore().getString("com.ibm.debug.memorymap.off_mode") == "HEX") {
                    return NLS.bind((String)MemoryMapLabels.hex_string_prefix, (Object)BigInteger.valueOf(((MapElement)element).getOffset()).toString(16).toUpperCase());
                }
                return Integer.toString(((MapElement)element).getOffset());
            }
            if (element instanceof MemoryMap && columnIndex == 4) {
                return ((MemoryMap)element).getDescription();
            }
            return this.getValueAsString((MapElement)element);
        }
        return "";
    }
}

