/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.views;

import com.ibm.debug.memorymap.FillerMapElement;
import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapParent;
import com.ibm.debug.memorymap.MemoryMapRendering;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.memorymap.views.BasicDebugViewContentProvider;
import java.util.HashSet;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;

public class MemoryMapContentProvider
extends BasicDebugViewContentProvider
implements ITreeContentProvider {
    private MemoryMapRendering fRendering;
    private boolean fIsDisposed;

    public MemoryMapContentProvider(MemoryMapRendering rendering) {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fRendering = rendering;
        this.fIsDisposed = false;
    }

    @Override
    public Object[] doGetChildren(Object parentElement) {
        MapElement element = (MapElement)parentElement;
        Object[] children = null;
        if (!element.hasChildren()) {
            return new MemoryMap[0];
        }
        try {
            children = element.getChildren(true);
            if (!(element instanceof MemoryMapParent) && children.length == 0) {
                children = new MapElement[]{new FillerMapElement(element.getLayout(), element, MemoryMapLabels.MemoryMapConstants_6, null, element.getAddress(), new HashSet<String>())};
            }
        }
        catch (DebugException de) {
            if (!(element.getParent() instanceof MemoryMapParent)) {
                String field = "";
                Throwable throwable = de.getStatus().getException();
                if (throwable instanceof MemoryMapException) {
                    field = ((MemoryMapException)throwable).getField();
                }
                children = new MapElement[]{new FillerMapElement(element.getLayout(), element, NLS.bind((String)MemoryMapMessages.MemoryMapLayout_Failed_to_build_memory_map, (Object)field), de.getMessage(), element.getAddress(), element.getExplicitGroups())};
                element.addChild((MapElement)children[0]);
            }
            Throwable throwable = de.getStatus().getException();
            if (throwable instanceof MemoryMapException) {
                this.fRendering.handleMapError((MemoryMapException)throwable);
            }
            this.fRendering.handleDebugError(de);
        }
        return children;
    }

    public Object getParent(Object element) {
        return ((MapElement)element).getParent();
    }

    @Override
    public boolean hasChildren(Object element) {
        return ((MapElement)element).hasChildren();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    @Override
    public void dispose() {
        this.fIsDisposed = true;
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
    }

    @Override
    protected void doHandleDebugEvent(DebugEvent event) {
        if (event.getSource() instanceof IDebugElement) {
            IDebugElement src = (IDebugElement)event.getSource();
            switch (event.getKind()) {
                case 2: {
                    if (!(src instanceof IThread) || src.getDebugTarget() != this.fRendering.getMemoryBlock().getDebugTarget()) break;
                    if (this.fRendering.isVisible()) {
                        this.fRendering.setMonitored(true);
                    }
                    this.fRendering.refresh(true);
                    break;
                }
                case 16: {
                    if (!(src instanceof IMemoryBlock) || src != this.fRendering.getMemoryBlock()) break;
                    if (this.fRendering.isVisible()) {
                        this.fRendering.setMonitored(true);
                    }
                    this.fRendering.refresh(true);
                    break;
                }
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.fIsDisposed;
    }
}

