/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.views;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.ErrorMapElement;
import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMapPartitionElement;
import com.ibm.debug.memorymap.renderer.MemoryMapRenderer;
import com.ibm.debug.memorymap.views.MemoryMapLabelProvider;

public class FindDialogLabelProvider
extends MemoryMapLabelProvider {
    private static final String SPACE = " ";

    public FindDialogLabelProvider(AbstractMemoryMapRendering rendering) {
        super(rendering, new MemoryMapRenderer(rendering));
    }

    @Override
    public String getText(Object element) {
        if (element instanceof MapElement) {
            MapElement map = (MapElement)element;
            StringBuffer buf = new StringBuffer();
            if (map instanceof ErrorMapElement) {
                buf.append(this.getName(map));
            } else {
                buf.append(map.getName());
            }
            if (element instanceof MemoryMapPartitionElement) {
                buf.insert(0, SPACE);
                buf.insert(0, ((MemoryMapPartitionElement)element).getParent().getName());
            }
            return buf.toString();
        }
        return "";
    }

    public String getValue(MapElement element) {
        if (!element.hasChildren() || element.isBitmask()) {
            return this.getValueAsString(element);
        }
        return this.getName(element);
    }

    public String[] getAllLabels(Object element) {
        MapElement map = (MapElement)element;
        String description = map.getDescription();
        String groups = map.getGroups().toString();
        groups = groups.replaceAll("[\\]\\[]", "");
        return new String[]{this.getText(map), description, map.getParent().getPath(), groups};
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        MapElement map = (MapElement)element;
        switch (columnIndex) {
            case 0: {
                return this.getText(map);
            }
            case 1: {
                return map.getDescription();
            }
            case 3: {
                String groups = map.getGroups().toString();
                groups = groups.replaceAll("[\\]\\[]", "");
                return groups;
            }
            case 2: {
                return map.getParent().getPath();
            }
        }
        return "";
    }
}

