/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.views;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class BasicDebugViewContentProvider
implements IStructuredContentProvider,
IDebugEventSetListener {
    protected StructuredViewer fViewer;
    protected boolean fDisposed = false;

    public void dispose() {
        this.fDisposed = true;
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (StructuredViewer)viewer;
    }

    protected void refresh() {
        if (this.fViewer != null) {
            this.fViewer.refresh();
        }
    }

    protected void refresh(Object element) {
        if (this.fViewer != null) {
            this.fViewer.refresh(element);
        }
    }

    public Object[] getChildren(Object parent) {
        return this.doGetChildren(parent);
    }

    protected abstract void doHandleDebugEvent(DebugEvent var1);

    protected abstract Object[] doGetChildren(Object var1);

    public boolean hasChildren(Object item) {
        return this.doGetChildren(item).length > 0;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.fViewer == null || this.isDisposed()) {
            return;
        }
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Display display = ctrl.getDisplay();
            int i = 0;
            while (i < events.length) {
                final DebugEvent event = events[i];
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BasicDebugViewContentProvider.this.doHandleDebugEvent(event);
                    }
                });
                ++i;
            }
        }
    }
}

