/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.utils;

import com.ibm.debug.memorymap.ErrorMapElement;
import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapBuilder;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.utils.IDefaultMapSamplesLocation;
import com.ibm.debug.memorymap.utils.MapXMLParser;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.rsecommon.RSEUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MemoryMapUtils {
    private static ImageRegistry imageRegistry;
    private static HashMap<String, ImageDescriptor> imageDescriptors;
    private static final String OBJECT = "obj16/";
    private static final String ELCL16 = "elcl16/";
    public static final String DEFAULTMAPSAMPLESLOCATION = "com.ibm.debug.memorymap.defaultmapsampleslocation";
    public static IConfigurationElement[] fDefaultMapSampleLocations;
    private static URL ICON_BASE_URL;

    static {
        ICON_BASE_URL = null;
        ICON_BASE_URL = MemoryMapPlugin.getPluginBundle().getEntry("icons/full/");
    }

    public static Element openLayout(File file, String layoutType, int correctLength) throws MemoryMapException {
        Document fDOMLayout = null;
        try {
            fDOMLayout = MapXMLParser.getInstance().parseFile(file, true);
        }
        catch (SAXException e) {
            Path path = new Path(file.getAbsolutePath());
            Object message = NLS.bind((String)MemoryMapMessages.memory_map_utils_error_could_not_parse, (Object)path.lastSegment());
            if (e instanceof SAXParseException) {
                message = (String)message + " \n\n";
                message = (String)message + path.lastSegment() + ":" + ((SAXParseException)e).getLineNumber() + ": \n";
                message = (String)message + e.getMessage();
            }
            throw new MemoryMapException("", (String)message, path.toOSString(), 2);
        }
        catch (Exception e) {
            Path path = new Path(file.getAbsolutePath());
            StringBuffer message = new StringBuffer(NLS.bind((String)MemoryMapMessages.memory_map_utils_error_could_not_parse, (Object)path.lastSegment()));
            if (e.getMessage() != null) {
                message.append(" \n\n").append(e.getMessage());
            }
            throw new MemoryMapException("", message.toString(), path.toOSString(), 2);
        }
        if (fDOMLayout == null) {
            Path path = new Path(file.getAbsolutePath());
            throw new MemoryMapException("", NLS.bind((String)MemoryMapMessages.memory_map_utils_error_could_not_parse, (Object)path.lastSegment()), path.toOSString(), 2);
        }
        Element rootNode = fDOMLayout.getDocumentElement();
        if (rootNode == null) {
            Path path = new Path(file.getAbsolutePath());
            throw new MemoryMapException("", NLS.bind((String)MemoryMapMessages.memory_map_utils_error_malformed_file_parse, (Object)path.lastSegment()), path.toOSString(), 2);
        }
        NamedNodeMap attributes = rootNode.getAttributes();
        Node att = null;
        String nodeName = null;
        String nodeValue = null;
        String fLayoutHeader = null;
        int fLayoutLength = 0;
        Path path = new Path(file.getAbsolutePath());
        StringBuffer layout = new StringBuffer("<");
        layout.append(rootNode.getNodeName()).append(" ");
        int i = 0;
        while (i < attributes.getLength()) {
            att = attributes.item(i);
            nodeName = att.getNodeName();
            nodeValue = att.getNodeValue();
            layout.append(nodeName).append("=\"").append(nodeValue).append("\" ");
            if (nodeName.equals("Header")) {
                fLayoutHeader = nodeValue;
            } else if (nodeName.equals("length")) {
                try {
                    fLayoutLength = MemoryMapBuilder.parseInt(nodeValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        layout.append(">");
        if (fLayoutHeader == null) {
            StringBuffer message = new StringBuffer(NLS.bind((String)MemoryMapMessages.memory_map_utils_error_malformed_file_parse, (Object)path.lastSegment()));
            throw new MemoryMapException(layout.toString(), message.toString(), path.toOSString(), 2);
        }
        if (!MemoryMapUtils.isValidLength(layoutType, correctLength, fLayoutLength)) {
            StringBuffer message = new StringBuffer(NLS.bind((String)MemoryMapMessages.memory_map_error_insufficient_memory_allocation, (Object)path.lastSegment()));
            throw new MemoryMapException(layout.toString(), message.toString(), path.toOSString(), 2);
        }
        return rootNode;
    }

    public static String toURL(File file) throws MalformedURLException {
        Object path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = ((String)path).replace(File.separatorChar, '/');
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!((String)path).endsWith("/") && file.isDirectory()) {
            path = (String)path + "/";
        }
        URL url = new URL("file", "", (String)path);
        return url.toString();
    }

    public static Image getImage(String key) {
        if (imageRegistry == null) {
            MemoryMapUtils.initializeImageRegistry();
        }
        return MemoryMapUtils.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (imageDescriptors == null) {
            MemoryMapUtils.initializeImageRegistry();
        }
        return imageDescriptors.get(key);
    }

    public static ImageRegistry initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        imageDescriptors = new HashMap(30);
        MemoryMapUtils.declareImages();
        return imageRegistry;
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)MemoryMapUtils.makeIconFileURL(path));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        imageRegistry.put(key, desc);
        imageDescriptors.put(key, desc);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }

    private static void declareImages() {
        MemoryMapUtils.declareRegistryImage("ORG_ICON", "obj16/recursive_co.png");
        MemoryMapUtils.declareRegistryImage("UNION_ICON", "obj16/union.png");
        MemoryMapUtils.declareRegistryImage("MEMORY_MAP_LAYOUT", "obj16/memorymapping_obj.png");
        MemoryMapUtils.declareRegistryImage("MEMORY_MAP_ELEMENT", "obj16/genericvariable_obj.png");
        MemoryMapUtils.declareRegistryImage("MEMORY_MAP_CHANGE", "obj16/memorychanged_obj.png");
        MemoryMapUtils.declareRegistryImage("COPY_TO_CLIPBOARD", "elcl16/copyviewtoclipboard_tsk.png");
        MemoryMapUtils.declareRegistryImage("PRINT_MAP", "elcl16/printview_tsk.png");
        MemoryMapUtils.declareRegistryImage("COLLAPSE_ALL", "elcl16/collapseall.png");
    }

    public static boolean canEditGroupsOrDescriptions(MapElement[] maps) {
        int i = 0;
        while (i < maps.length) {
            IPreferenceStore preferenceStore;
            boolean export;
            boolean readOnly;
            String file = maps[i].getLayout().getMappingFile();
            boolean bl = readOnly = RSEUtils.isReadOnly((String)file) || !new File(file).canWrite();
            if (readOnly && (export = (preferenceStore = MemoryMapPlugin.getInstance().getPreferenceStore()).getBoolean("com.ibm.debug.memorymap.do_export"))) {
                String msg = NLS.bind((String)MemoryMapMessages.CannotEditMsg, (Object)MemoryMapUtils.getFileName(file));
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)MemoryMapLabels.CannotEditTitle, (String)msg);
                return false;
            }
            ++i;
        }
        return true;
    }

    public static MapElement findMapField(MapElement rootElement, String field) {
        if (!rootElement.isORGParent() && rootElement.getName().toUpperCase().equals(field.toUpperCase())) {
            return rootElement;
        }
        if (rootElement.hasChildren()) {
            try {
                MapElement[] children = rootElement.getChildren(false);
                int i = 0;
                while (i < children.length) {
                    MapElement child = MemoryMapUtils.findMapField(children[i], field);
                    if (child != null) {
                        return child;
                    }
                    ++i;
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isMixedEndianness(MemoryByte[] bytes) {
        boolean isBigEndian = bytes[0].isBigEndian();
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i].isBigEndian() != isBigEndian) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isValidLength(String layoutType, int correctLength, int actualLength) {
        if ("MAP".equals(layoutType)) {
            return actualLength > 0;
        }
        return actualLength > 0 && correctLength == actualLength;
    }

    public static List<MemoryMapLayout> getIdenticalLayouts(MemoryMapLayout[] layouts, MemoryMapLayout layout) {
        ArrayList<MemoryMapLayout> identicalLayouts = new ArrayList<MemoryMapLayout>();
        int j = 0;
        while (j < layouts.length) {
            Path otherLayoutPath;
            Path selectedLayoutPath = new Path(layout.getMappingFile());
            if (selectedLayoutPath.equals((Object)(otherLayoutPath = new Path(layouts[j].getMappingFile())))) {
                identicalLayouts.add(layouts[j]);
            }
            ++j;
        }
        return identicalLayouts;
    }

    public static String getFileName(String absolutePath) {
        String shortName = absolutePath;
        int index = MemoryMapUtils.getLastSeparator(absolutePath);
        if (index > 0 && index < absolutePath.length() - 1) {
            shortName = absolutePath.substring(index + 1);
        }
        return shortName;
    }

    public static String reconstructTag(Node node) {
        StringBuffer field = new StringBuffer("<");
        NamedNodeMap attributes = node.getAttributes();
        field.append(node.getNodeName()).append(" ");
        int k = 0;
        while (k < attributes.getLength()) {
            Node attribute = attributes.item(k);
            field.append(attribute.getNodeName()).append(" = \"");
            field.append(attribute.getNodeValue()).append("\" ");
            ++k;
        }
        field.append(">");
        return field.toString();
    }

    public static String getFolderName(String absolutePath) {
        int index = MemoryMapUtils.getLastSeparator(absolutePath);
        if (index >= 0 && index < absolutePath.length()) {
            return absolutePath.substring(0, index + 1);
        }
        return absolutePath;
    }

    private static int getLastSeparator(String absolutePath) {
        int index = absolutePath.lastIndexOf("/");
        if (index < 0) {
            index = absolutePath.lastIndexOf("\\");
        }
        return index;
    }

    public static void openError(DebugException e, String dialogTitle) {
        StringBuffer message = new StringBuffer();
        Throwable throwable = e.getStatus().getException();
        if (throwable instanceof MemoryMapException) {
            MemoryMapException mme = (MemoryMapException)throwable;
            message.append(mme.getMappingFile()).append(":\n\n");
            String field = mme.getField();
            if (field.length() != 0) {
                message.append(field).append("\n\n");
            }
        }
        message.append(e.getMessage());
        ErrorDialog.openError((Shell)CommonUtils.getShell(), (String)dialogTitle, null, (IStatus)new Status(4, "com.ibm.debug.memorymap", 0, message.toString(), null));
    }

    public static void openError(DebugException e) {
        MemoryMapUtils.openError(e, MemoryMapLabels.SaveMap_2);
    }

    public static MapElement[] getIdenticalElements(MapElement mapElement, MemoryMapLayout layout) {
        String name = null;
        name = mapElement instanceof MemoryMap && mapElement.isMap() ? ((MemoryMap)mapElement).getLayout().getReferenceName() : mapElement.getName();
        String type = null;
        if (mapElement instanceof MemoryMap) {
            type = ((MemoryMap)mapElement).getType();
        } else if (mapElement instanceof ErrorMapElement) {
            type = ((ErrorMapElement)mapElement).getType();
        }
        int length = mapElement instanceof MemoryMap && "MAP".equals(type) ? mapElement.getLayout().getReferenceLength() : mapElement.getLength();
        return layout.findElementsByAttributes(name, type, length, mapElement.getOffset());
    }

    public static String makeRelative(IPath childPath, IPath parentPath) {
        IPath parentFolder = parentPath.removeLastSegments(1);
        IPath childFolder = childPath.removeLastSegments(1);
        String filename = childPath.lastSegment();
        if (!parentFolder.equals((Object)childFolder)) {
            if (parentPath.getDevice() != null && !parentPath.getDevice().equals(childPath.getDevice())) {
                filename = childPath.toString();
            } else {
                String[] parentSegments = parentFolder.segments();
                String[] childSegments = childFolder.segments();
                int lastMatchIndex = 0;
                while (lastMatchIndex < parentSegments.length && lastMatchIndex < childSegments.length && childSegments[lastMatchIndex].equals(parentSegments[lastMatchIndex])) {
                    ++lastMatchIndex;
                }
                int i = lastMatchIndex;
                StringBuffer buffer = new StringBuffer();
                while (i < childSegments.length) {
                    buffer.append(childSegments[i]).append(File.separator);
                    ++i;
                }
                buffer.append(filename);
                if (!parentFolder.isPrefixOf(childFolder)) {
                    int j = parentSegments.length;
                    while (j > lastMatchIndex && j >= 0) {
                        buffer.insert(0, File.separator).insert(0, "..");
                        --j;
                    }
                }
                filename = buffer.toString();
            }
        }
        return filename;
    }

    public static String getDefaultMapLocation() {
        Path path;
        URL installURL;
        String defaultLocation = null;
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(DEFAULTMAPSAMPLESLOCATION);
        if (ep != null) {
            fDefaultMapSampleLocations = ep.getConfigurationElements();
        }
        if (fDefaultMapSampleLocations != null) {
            int i = 0;
            while (i < fDefaultMapSampleLocations.length) {
                try {
                    Object sampleClass = fDefaultMapSampleLocations[i].createExecutableExtension("class");
                    if (sampleClass instanceof IDefaultMapSamplesLocation) {
                        IDefaultMapSamplesLocation sampleLocator = (IDefaultMapSamplesLocation)sampleClass;
                        defaultLocation = sampleLocator.getDefaultMapSamplesLocation();
                        break;
                    }
                }
                catch (CoreException sampleClass) {
                    // empty catch block
                }
                ++i;
            }
        }
        if (defaultLocation != null) {
            return defaultLocation;
        }
        Location installLocation = Platform.getInstallLocation();
        URL uRL = installURL = installLocation != null ? installLocation.getURL() : null;
        if (installURL != null) {
            StringBuffer buf = new StringBuffer(installURL.getPath());
            buf.append(File.separator);
            buf.append("maps");
            Path installPath = new Path(buf.toString());
            defaultLocation = installPath.toOSString();
            File file = new File(defaultLocation);
            defaultLocation = file.exists() && file.canRead() ? file.getPath() : null;
        }
        if (defaultLocation != null) {
            return defaultLocation;
        }
        defaultLocation = System.getProperty("user.home");
        if (defaultLocation != null) {
            path = new Path(defaultLocation);
            File file = new File(defaultLocation = path.toOSString());
            defaultLocation = file.exists() && file.canRead() ? file.getPath() : null;
        }
        if (defaultLocation != null) {
            return defaultLocation;
        }
        path = new Path("/");
        return path.toOSString();
    }

    public static String getPaddedString() {
        return DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr");
    }
}

