/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.utils;

import com.ibm.debug.memorymap.MappingFileChangeListener;
import com.ibm.debug.memorymap.MemoryMapLayout;
import java.util.HashMap;
import java.util.HashSet;

public class MemoryMapRenderingMgr {
    private static HashMap<String, HashSet<MappingFileChangeListener>> fLayoutsToRenderings = new HashMap();

    public static void addRendering(String layoutPath, MappingFileChangeListener rendering) {
        HashSet<MappingFileChangeListener> renderings;
        if (rendering == null) {
            fLayoutsToRenderings.remove(layoutPath);
        }
        if ((renderings = fLayoutsToRenderings.get(layoutPath)) == null) {
            renderings = new HashSet();
        }
        renderings.add(rendering);
        fLayoutsToRenderings.put(layoutPath, renderings);
    }

    public static HashSet<MappingFileChangeListener> getRenderingsByFile(String layoutPath) {
        return fLayoutsToRenderings.get(layoutPath);
    }

    public static void removeRendering(String layoutPath, MappingFileChangeListener rendering) {
        HashSet<MappingFileChangeListener> renderings = fLayoutsToRenderings.get(layoutPath);
        if (renderings != null && renderings.remove(rendering) && renderings.size() == 0) {
            fLayoutsToRenderings.remove(layoutPath);
        }
    }

    public static void fireChangeEvent(MemoryMapLayout[] changedLayouts) {
        HashSet<MappingFileChangeListener> alreadyBuilt = new HashSet<MappingFileChangeListener>();
        int i = 0;
        while (i < changedLayouts.length) {
            MemoryMapLayout layout = changedLayouts[i];
            HashSet<MappingFileChangeListener> similarRenderings = fLayoutsToRenderings.get(layout.getMappingFile());
            for (MappingFileChangeListener listener : similarRenderings) {
                if (alreadyBuilt.contains(listener)) continue;
                listener.mappingFileChanged();
                alreadyBuilt.add(listener);
            }
            ++i;
        }
    }
}

