/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class MemoryMapFileWriter {
    public static final String VERSION = "<?xml version=\"1.0\"  ";
    private String fSaveFileName;
    private StringBuffer fOutputBuffer = new StringBuffer();
    private StringBuffer versionAndGroupBuffer = new StringBuffer();
    private String fEncoding;

    public MemoryMapFileWriter(File saveFile, String layoutHeader, String layoutDesc, int layoutLength, String encoding) {
        this.fSaveFileName = saveFile.getAbsolutePath();
        this.openMapFile(layoutHeader, layoutDesc, layoutLength, encoding);
        this.fEncoding = encoding;
    }

    public void writeGROUPTag(String groupName) {
        this.versionAndGroupBuffer.append("<");
        this.versionAndGroupBuffer.append("GROUP").append(" ");
        this.versionAndGroupBuffer.append("Name").append(" = \"").append(groupName).append("\" ></");
        this.versionAndGroupBuffer.append("GROUP").append(">\r\n");
    }

    public void closeFIELDTag(int numTabs) {
        int i = 0;
        while (i < numTabs) {
            this.fOutputBuffer.append("\t");
            ++i;
        }
        this.fOutputBuffer.append("</").append("FIELD").append(">\r\n").toString();
    }

    public void append(int numTabs, String string) {
        if (string != null) {
            int i = 0;
            while (i < numTabs) {
                this.fOutputBuffer.append("\t");
                ++i;
            }
            this.fOutputBuffer.append(string);
        }
    }

    public void closeMapFile() throws IOException {
        this.fOutputBuffer.append("</").append("LAYOUT").append(">\r\n");
        this.fOutputBuffer.insert(0, this.versionAndGroupBuffer.toString());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fSaveFileName), this.fEncoding != null ? this.fEncoding : Charset.defaultCharset().name()));
        writer.write(this.fOutputBuffer.toString());
        writer.close();
    }

    private void openMapFile(String layoutHeader, String layoutDesc, int layoutLength, String encoding) {
        this.versionAndGroupBuffer.append(VERSION);
        if (encoding != null && encoding.length() > 0) {
            this.versionAndGroupBuffer.append("encoding = \"").append(encoding).append("\" ");
        }
        this.versionAndGroupBuffer.append("?>\r\n");
        this.versionAndGroupBuffer.append("<");
        this.versionAndGroupBuffer.append("LAYOUT").append(" ");
        this.versionAndGroupBuffer.append("Header").append(" = \"").append(layoutHeader).append("\" ");
        if (layoutDesc != null) {
            this.versionAndGroupBuffer.append("description").append(" = \"").append(layoutDesc).append("\"  ");
        }
        this.versionAndGroupBuffer.append("length").append(" = \"").append(layoutLength).append("\" >\r\n");
    }
}

