/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class MemoryElementMapping {
    private Class<?> fMappedClass;
    private String fEngineID;
    private String fMapFile;
    private static boolean fRetrievedMemoryMapping;
    private static MemoryElementMapping[] fMemoryMappings;

    static {
        fMemoryMappings = new MemoryElementMapping[0];
    }

    public static MemoryElementMapping[] getMemoryElementMappings() {
        if (!fRetrievedMemoryMapping) {
            fRetrievedMemoryMapping = true;
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.memorymap.memoryMapElement");
            if (ep != null) {
                IConfigurationElement[] elements = ep.getConfigurationElements();
                ArrayList<MemoryElementMapping> mappings = new ArrayList<MemoryElementMapping>();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    try {
                        MemoryElementMapping mapping = new MemoryElementMapping();
                        mapping.fMappedClass = Class.forName(element.getAttribute("mappedClass"));
                        mapping.fMapFile = element.getAttribute("mapFile");
                        mapping.fEngineID = element.getAttribute("engineId");
                        String fullpath = MemoryElementMapping.getBundleResourcePath(Platform.getBundle((String)element.getContributor().getName()), mapping.fMapFile);
                        mapping.fMapFile = fullpath == null ? mapping.fMapFile : fullpath;
                        mappings.add(mapping);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    ++n2;
                }
                fMemoryMappings = mappings.toArray(new MemoryElementMapping[mappings.size()]);
            }
        }
        return fMemoryMappings;
    }

    private static String getBundleResourcePath(Bundle bun, String res) {
        if (bun != null) {
            String fileloc;
            IPath path = null;
            try {
                File bundleData = (File)FileLocator.getBundleFileLocation((Bundle)bun).orElseThrow(() -> new IOException("Unable to locate the bundle file: " + String.valueOf(bun)));
                path = Path.fromOSString((String)bundleData.getCanonicalPath());
            }
            catch (IOException e2) {
                return null;
            }
            URL url = bun.getResource(res);
            if (url != null && (fileloc = url.getPath()) != null) {
                return Path.fromPortableString((String)(path.toPortableString() + fileloc)).toPortableString();
            }
        }
        return null;
    }

    public Class<?> getMappedClass() {
        return this.fMappedClass;
    }

    public String getEngineID() {
        return this.fEngineID;
    }

    public String getMapFile() {
        return this.fMapFile;
    }
}

