/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.utils;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.rsecommon.DefaultEntityResolver;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MapXMLParser {
    protected static MapXMLParser instance;
    private DocumentBuilderFactory documentBuilderFactory;
    private static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private String fSchema;

    public static MapXMLParser getInstance() {
        if (instance == null) {
            instance = new MapXMLParser();
        }
        return instance;
    }

    public Document parseFile(File mapFile, boolean validate) throws SAXException, IOException, ParserConfigurationException {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = PDTCoreUtils.getSecureDocumentBuilderFactory();
            if (this.documentBuilderFactory == null) {
                return null;
            }
        }
        if (validate) {
            try {
                this.documentBuilderFactory.setValidating(true);
                this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, W3C_SCHEMA);
                this.documentBuilderFactory.setAttribute(SCHEMA_SOURCE, new InputSource(this.getSchema()));
            }
            catch (IllegalArgumentException e) {
                this.documentBuilderFactory.setValidating(false);
            }
        }
        DocumentBuilder docBuilder = this.documentBuilderFactory.newDocumentBuilder();
        docBuilder.setEntityResolver((EntityResolver)new DefaultEntityResolver());
        docBuilder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        Document domLayout = docBuilder.parse(mapFile);
        this.documentBuilderFactory.setValidating(false);
        return domLayout;
    }

    protected StringReader getSchema() {
        if (this.fSchema == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n").append("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n").append("<xsd:element name=\"LAYOUT\">\r\n").append("<xsd:complexType>\r\n").append("<xsd:sequence>\r\n").append("<xsd:element maxOccurs=\"unbounded\" minOccurs=\"0\" ref=\"GROUP\"/>\r\n").append("<xsd:choice minOccurs=\"1\" maxOccurs=\"unbounded\">").append("\t<xsd:element ref=\"FIELD\"/>\r\n").append("\t<xsd:element ref=\"ORG_GROUP\"/>\r\n").append("</xsd:choice>").append("</xsd:sequence>\r\n").append("<xsd:attribute name=\"Header\" type=\"xsd:string\" use=\"required\"/>\r\n").append("<xsd:attribute name=\"length\" type=\"xsd:string\" use=\"required\"/>\r\n").append("<xsd:attribute name=\"description\" type=\"xsd:string\" use=\"optional\"/>\r\n").append("</xsd:complexType>\r\n").append("</xsd:element>\r\n").append("<xsd:element name=\"ORG_GROUP\">").append("<xsd:complexType>\r\n").append("\t<xsd:sequence>\r\n").append("\t\t<xsd:choice minOccurs=\"1\" maxOccurs=\"unbounded\">").append("\t\t\t<xsd:element ref=\"FIELD\"/>\r\n").append("\t\t\t<xsd:element ref=\"ORG_GROUP\"/>\r\n").append("\t\t</xsd:choice>").append("\t</xsd:sequence>\r\n").append("\t<xsd:attribute name=\"Header\" type=\"xsd:string\" use=\"required\"/>\r\n").append("\t<xsd:attribute name=\"FIELD\" type=\"xsd:string\" use=\"required\"/>\r\n").append("<xsd:attribute name=\"Groups\" type=\"xsd:string\" use=\"optional\"/>\r\n").append("</xsd:complexType>\r\n").append("</xsd:element>\r\n").append("<xsd:element name=\"GROUP\">\r\n").append("<xsd:complexType>\r\n").append("<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\r\n").append("</xsd:complexType>\r\n").append("</xsd:element>\r\n").append("<xsd:element name=\"FIELD\">\r\n").append("<xsd:complexType>\r\n").append("<xsd:sequence>\r\n").append("<xsd:choice minOccurs=\"0\" maxOccurs=\"unbounded\">").append("<xsd:element ref=\"FIELD\"/>\r\n").append("<xsd:element ref=\"ORG_GROUP\"/>\r\n").append("</xsd:choice>").append("</xsd:sequence>\r\n").append("<xsd:attribute name=\"Header\" type=\"xsd:string\" use=\"required\"/>\r\n").append("\r\n").append("<xsd:attribute name=\"Type\" use=\"required\" >\r\n").append("   <xsd:simpleType>\r\n").append("<xsd:restriction base=\"xsd:string\">\r\n").append("<xsd:enumeration value=\"16_BIT_INT\"/>\r\n").append("<xsd:enumeration value=\"16_BIT_UINT\"/>\r\n").append("<xsd:enumeration value=\"16_BIT_HINT\"/>\r\n").append("<xsd:enumeration value=\"32_BIT_INT\"/>\r\n").append("<xsd:enumeration value=\"32_BIT_UINT\"/>\r\n").append("<xsd:enumeration value=\"32_BIT_HINT\"/>\r\n").append("<xsd:enumeration value=\"32_BIT_FLOAT\"/>\r\n").append("<xsd:enumeration value=\"UNION\"/>\r\n").append("<xsd:enumeration value=\"64_BIT_INT\"/>\r\n").append("<xsd:enumeration value=\"64_BIT_FLOAT\"/>\r\n").append("<xsd:enumeration value=\"CHARACTER\"/>\r\n").append("<xsd:enumeration value=\"HEX\"/>\r\n").append("<xsd:enumeration value=\"ASCII\"/>\r\n").append("<xsd:enumeration value=\"EBCDIC\"/>\r\n").append("<xsd:enumeration value=\"STRUCTURE\"/>\r\n").append("<xsd:enumeration value=\"PADDING\"/>\r\n").append("<xsd:enumeration value=\"BIT\"/>\r\n").append("<xsd:enumeration value=\"BITMASK\"/>\r\n").append("<xsd:enumeration value=\"MAP\"/>\r\n").append("       </xsd:restriction>\r\n").append("   </xsd:simpleType>\r\n").append("</xsd:attribute>\r\n").append("<xsd:attribute name=\"length\" type=\"xsd:string\" use=\"required\"/>\r\n").append("<xsd:attribute name=\"layout\" type=\"xsd:string\"  use=\"optional\"/>\r\n").append("<xsd:attribute name=\"filename\"  type=\"xsd:string\" use=\"optional\"/>\r\n").append("<xsd:attribute name=\"Groups\" type=\"xsd:string\" use=\"optional\"/>\r\n").append("<xsd:attribute name=\"description\" type=\"xsd:string\" use=\"optional\"/>\r\n").append("<xsd:attribute name=\"offset\" type=\"xsd:string\" use=\"optional\"/>\r\n").append("\t<xsd:attribute name=\"offset_mode\"  use=\"optional\">\r\n").append("  \t <xsd:simpleType>\r\n").append("\t\t\t<xsd:restriction base=\"xsd:string\">\r\n").append("\t\t\t\t<xsd:pattern value=\"relative|absolute\"/>\r\n").append("      \t</xsd:restriction>\r\n").append("   \t</xsd:simpleType>\r\n").append("</xsd:attribute>\r\n").append("</xsd:complexType>\r\n").append("</xsd:element>\r\n").append("</xsd:schema>");
            this.fSchema = buffer.toString();
        }
        return new StringReader(this.fSchema);
    }

    public void setSchema(String schema) {
        if (schema != null) {
            this.fSchema = schema;
        }
    }
}

