/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.utils;

import com.ibm.debug.memorymap.utils.MemoryElementMapping;
import com.ibm.debug.pdt.core.IAddressable;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IActionFilter;

public class MapMemoryElementActionFilter
implements IActionFilter {
    private String fEngineId;
    private Map<Class<?>, String> fMappingFileDictionary;
    public static final String IS_MAPPABLE = "isMappable";
    private static final String TRUE = "true";
    private static final String EMPTY = "";
    private static Map<String, MapMemoryElementActionFilter> filterCache = new HashMap<String, MapMemoryElementActionFilter>();

    static {
        filterCache.put(EMPTY, new MapMemoryElementActionFilter(EMPTY));
    }

    public static MapMemoryElementActionFilter getFilter(IAddressable element) {
        String engineId = MapMemoryElementActionFilter.getEngineId(element);
        MapMemoryElementActionFilter filter = filterCache.get(engineId);
        if (filter == null) {
            filter = new MapMemoryElementActionFilter(engineId);
            filterCache.put(engineId, filter);
        }
        return filter;
    }

    private static String getEngineId(IAddressable element) {
        PICLDebugTarget target = (PICLDebugTarget)element.getDebugTarget();
        if (target == null) {
            return EMPTY;
        }
        EPDC_EngineSession session = target.getEngineSession();
        if (session == null) {
            return EMPTY;
        }
        String key = session.getEngineLabel();
        return PDTCoreUtils.isEmpty((String)key) ? EMPTY : key;
    }

    private MapMemoryElementActionFilter(String engineId) {
        this.fEngineId = engineId;
        this.fMappingFileDictionary = this.createMappingFileDictionary();
    }

    private Map<Class<?>, String> createMappingFileDictionary() {
        if (PDTCoreUtils.isEmpty((String)this.fEngineId)) {
            return null;
        }
        HashMap mappingFileDictionary = new HashMap();
        MemoryElementMapping[] extensionMappings = MemoryElementMapping.getMemoryElementMappings();
        if (extensionMappings != null) {
            MemoryElementMapping[] memoryElementMappingArray = extensionMappings;
            int n = extensionMappings.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryElementMapping emap = memoryElementMappingArray[n2];
                if (this.fEngineId.equalsIgnoreCase(emap.getEngineID())) {
                    mappingFileDictionary.put(emap.getMappedClass(), emap.getMapFile());
                }
                ++n2;
            }
        }
        return mappingFileDictionary;
    }

    public boolean testAttribute(Object target, String name, String value) {
        IAddressable element;
        if (PDTCoreUtils.isEmpty((String)this.fEngineId) || !IS_MAPPABLE.equals(name) || this.fMappingFileDictionary == null) {
            return false;
        }
        if (target instanceof IAddressable && this.fEngineId.equals(MapMemoryElementActionFilter.getEngineId(element = (IAddressable)target))) {
            return !(this.isMappable(element) ^ TRUE.equals(value));
        }
        return false;
    }

    private boolean isMappable(IAddressable element) {
        if (this.fMappingFileDictionary == null) {
            return false;
        }
        for (Class<?> mappable : this.fMappingFileDictionary.keySet()) {
            if (!mappable.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    public String getMappingFileName(IAddressable element) {
        if (this.fEngineId.equals(MapMemoryElementActionFilter.getEngineId(element)) && this.fMappingFileDictionary != null) {
            for (Map.Entry<Class<?>, String> entry : this.fMappingFileDictionary.entrySet()) {
                if (!entry.getKey().isInstance(element)) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

